/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import ViolinStrings.Strings;

public final class Version {
    private Version() {
    }

    public static String asString() {
        if (Version.getPackage() == null) {
            return "unknown";
        }
        String string = Version.getPackage().getImplementationVendor();
        if (string == null) {
            string = "unknown";
        }
        return "Version " + Version.getMajorVersion() + "." + Version.getMinorVersion() + "." + Version.getMicroVersion() + "." + Version.getBuildVersion() + " (" + Version.getBuildTime() + ")" + "\nPlease report problems to " + string;
    }

    public static String getBuildTime() {
        if (Version.getPackage() == null) {
            return "unknown";
        }
        String string = Version.getPackage().getImplementationVersion();
        if (string == null) {
            return "unknown";
        }
        int n = string.indexOf(40);
        return string.substring(n + 1, string.length() - 1);
    }

    public static int getBuildVersion() {
        return Version.numbers()[3];
    }

    public static int getMajorVersion() {
        return Version.numbers()[0];
    }

    public static int getMicroVersion() {
        return Version.numbers()[2];
    }

    public static int getMinorVersion() {
        return Version.numbers()[1];
    }

    private static Package getPackage() {
        return Package.getPackage("cern.colt");
    }

    public static void main(String[] stringArray) {
        System.out.println(Version.asString());
    }

    private static int[] numbers() {
        int n = 4;
        int[] nArray = new int[n];
        if (Version.getPackage() == null) {
            return nArray;
        }
        String string = Version.getPackage().getImplementationVersion();
        if (string == null) {
            return nArray;
        }
        int n2 = string.indexOf(40);
        string = string.substring(0, n2);
        string = Strings.stripBlanks((String)string);
        string = Strings.translate((String)string, (String)".", (String)" ");
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = Integer.parseInt(Strings.word((String)string, (int)n3));
            ++n3;
        }
        return nArray;
    }
}

