/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.io.Serializable;
import net.ndmystko.analysis.evolution.Gene;

public class SimpleGene
extends Gene
implements Cloneable,
Serializable {
    private static final double DEFAULT_DECAY_CONST = 1.0;
    private double _dMin = 0.0;
    private double _dMax = 0.0;
    private double _dValue = 0.0;
    private double _dPrimitiveValue = 0.0;
    private double _dDecayConst = 0.0;

    public SimpleGene(double d, double d2) {
        this(d, d2, 1.0);
    }

    public SimpleGene(SimpleGene[] simpleGeneArray) {
        for (int i = 0; i < simpleGeneArray.length; ++i) {
            this._dPrimitiveValue += simpleGeneArray[i]._dPrimitiveValue;
        }
        this._dPrimitiveValue /= (double)simpleGeneArray.length;
        this._dMin = simpleGeneArray[0]._dMin;
        this._dMax = simpleGeneArray[0]._dMax;
        this._dDecayConst = simpleGeneArray[0]._dDecayConst;
        this._dValue = this._dPrimitiveValue * (this._dMax - this._dMin) + this._dMin;
    }

    public SimpleGene(double d, double d2, double d3) {
        this._dMin = d;
        this._dMax = d2;
        this._dDecayConst = d3;
    }

    public void randomize() {
        this._dPrimitiveValue = Math.random();
        this.calculateFinalValues();
    }

    public boolean equals(Gene gene) {
        return ((SimpleGene)gene)._dValue == this._dValue;
    }

    public void randomizeAround(Gene gene, double d, double d2) {
        this._dPrimitiveValue = this.primitiveRandomizeAround(((SimpleGene)gene)._dPrimitiveValue, d2);
        this.calculateFinalValues();
    }

    public void copy(Gene gene) {
        this._dPrimitiveValue = ((SimpleGene)gene)._dPrimitiveValue;
        this.calculateFinalValues();
    }

    public void mutate(double d) {
        this._dPrimitiveValue += this.primitiveDelta(this._dPrimitiveValue, d, this._dDecayConst);
        this.calculateFinalValues();
    }

    public double getValue() {
        return this._dValue;
    }

    public void setValue(double d) {
        this._dValue = d;
    }

    private void calculateFinalValues() {
        this._dValue = this._dMin + this._dPrimitiveValue * (this._dMax - this._dMin);
    }
}

