/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class Gene
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7642100550331376547L;
    protected static final double INITIAL_SIGMA = 0.35;
    private double _dSigmaDecaySpeed = 1.0;
    protected static final double ALMOST_ONE = 0.99999999;

    public abstract void randomize();

    public abstract void mutate(double var1);

    public abstract void randomizeAround(Gene var1, double var2, double var4);

    public abstract void copy(Gene var1);

    public abstract boolean equals(Gene var1);

    public double normalDistribution(double d) {
        return Gene.normalDistribution(d, 0.35);
    }

    public static double normalDistribution(double d, double d2) {
        return Gene.normalDistribution(d, 0.0, d2);
    }

    public static double normalDistribution(double d, double d2, double d3) {
        double d4 = d - d2;
        return Math.exp(-(d4 * d4) / (2.0 * d3 * d3)) / (d3 * Math.sqrt(Math.PI * 2));
    }

    protected double randomizeAround(double d, double d2, double d3, double d4) {
        double d5 = 0.35 * (d3 - d2) * Math.exp(-d4 * this._dSigmaDecaySpeed);
        double d6 = Math.max(d - 2.0 * d5, d2);
        double d7 = Math.min(d + 2.0 * d5, d3);
        double d8 = Gene.normalDistribution(0.0, d5);
        double d9 = 0.0;
        double d10 = 0.0;
        do {
            d9 = Math.random() * (d7 - d6) + d6;
            d10 = Math.random() * d8;
        } while (Gene.normalDistribution(d9 - d, d5) < d10);
        return d9;
    }

    public double primitiveRandomizeAround(double d, double d2) {
        return this.randomizeAround(d, 0.0, 0.99999999, d2);
    }

    protected double delta(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d3) / 2.0 * Math.random() * Math.exp(-d4 * d);
        if (Math.random() < 0.5) {
            d6 = -d6;
        }
        if (d5 + d6 < d3) {
            d6 = d3 - d5;
        }
        if (d5 + d6 > d2) {
            d6 = d2 - d5;
        }
        return d6;
    }

    protected double primitiveDelta(double d, double d2, double d3) {
        return this.delta(d2, 0.99999999, 0.0, d3, d);
    }

    public void setSigmaDecaySpeed(double d) {
        this._dSigmaDecaySpeed = d;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Cannot clone Gene class");
        }
        return object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._dSigmaDecaySpeed == 0.0) {
            this._dSigmaDecaySpeed = 1.0;
        }
    }
}

