/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.ndmystko.analysis.evolution.Chromosome;

public abstract class Evolution
extends Thread {
    public static final String EVOLUTION_PROGRESSED = "progress";
    public static final String EVOLUTION_FINISHED = "finished";
    public static final String BAD_POPULATION = "bad population";
    private Chromosome[] population;
    private Chromosome[] tempStorage;
    protected Chromosome bestChromosome;
    private double[] eval;
    protected double everMaxEval = 0.0;
    private double[] probability;
    private double[] distribuant;
    private int popSize;
    private int noOfGenerations;
    private int resultStep;
    private int t = 0;
    protected ActionListener listener;
    protected Boolean enough = new Boolean(false);

    public Evolution() {
        this.setPriority(1);
    }

    protected void setup(Chromosome[] chromosomeArray, int n, int n2) {
        this.population = chromosomeArray;
        this.popSize = chromosomeArray.length;
        this.eval = new double[chromosomeArray.length];
        this.noOfGenerations = n;
        this.resultStep = n2;
        this.bestChromosome = (Chromosome)chromosomeArray[0].clone();
        this.probability = new double[this.popSize];
        this.distribuant = new double[this.popSize];
        this.tempStorage = new Chromosome[this.popSize];
    }

    private void resetP() {
    }

    protected abstract String evalP(Chromosome[] var1, double[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findBest(Chromosome[] chromosomeArray, double[] dArray) {
        for (int i = 0; i < this.popSize; ++i) {
            if (!(dArray[i] > this.everMaxEval)) continue;
            this.everMaxEval = dArray[i];
            Chromosome chromosome = this.bestChromosome;
            synchronized (chromosome) {
                this.bestChromosome = (Chromosome)chromosomeArray[i].clone();
                continue;
            }
        }
    }

    private void selectP() {
        int n;
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < this.popSize; ++n2) {
            d += this.eval[n2];
        }
        for (n2 = 0; n2 < this.popSize; ++n2) {
            this.probability[n2] = this.eval[n2] / d;
        }
        for (n2 = 0; n2 < this.popSize; ++n2) {
            this.distribuant[n2] = 0.0;
            for (n = 0; n <= n2; ++n) {
                int n3 = n2;
                this.distribuant[n3] = this.distribuant[n3] + this.probability[n];
            }
        }
        for (n2 = 0; n2 < this.popSize; ++n2) {
            double d2 = Math.random();
            for (n = 0; n < this.popSize - 1 && this.distribuant[n] < d2; ++n) {
            }
            this.tempStorage[n2] = (Chromosome)this.population[n].clone();
        }
        System.arraycopy(this.tempStorage, 0, this.population, 0, this.popSize);
    }

    protected void changeP(Chromosome[] chromosomeArray, double d) {
        Chromosome.mutate(chromosomeArray, d);
        Chromosome.crossOver(chromosomeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        this.t = 0;
        this.resetP();
        String string = this.evalP(this.population, this.eval);
        if (string != null && this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 1001, string));
            return;
        }
        if (this.checkEval(this.eval)) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 1001, BAD_POPULATION));
            }
            return;
        }
        this.findBest(this.population, this.eval);
        do {
            ++this.t;
            this.selectP();
            double d = (double)this.t / (double)this.noOfGenerations;
            this.changeP(this.population, d);
            string = this.evalP(this.population, this.eval);
            if (string != null && this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 1001, string));
                return;
            }
            this.findBest(this.population, this.eval);
            Boolean bl2 = this.enough;
            synchronized (bl2) {
                bl = this.enough;
            }
            if (this.t % this.resultStep == 0 && this.listener != null) {
                if (!bl && this.t < this.noOfGenerations) {
                    this.listener.actionPerformed(new ActionEvent(this, 1001, EVOLUTION_PROGRESSED));
                } else {
                    this.listener.actionPerformed(new ActionEvent(this, 1001, EVOLUTION_FINISHED));
                }
            }
            this.yield();
        } while (this.t < this.noOfGenerations && !bl);
    }

    public int getProgress() {
        return (int)((double)this.t / (double)this.noOfGenerations * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chromosome getBestChromosome() {
        Chromosome chromosome = this.bestChromosome;
        synchronized (chromosome) {
            return (Chromosome)this.bestChromosome.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void okThatsEnough() {
        Boolean bl = this.enough;
        synchronized (bl) {
            this.enough = new Boolean(true);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener = null;
    }

    private boolean checkEval(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d == 0.0;
    }
}

