/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.io.Serializable;
import net.ndmystko.analysis.evolution.Gene;

public class Chromosome
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4626631363131790503L;
    protected static double PM = 0.2;
    protected static int _iRepeatMut = 1;
    protected static double PC = 0.6;
    protected static int _iRepeatCross = 1;
    protected static final double FRACTION_SURVIVE = 0.25;
    protected Gene[] genes;
    protected int noOfGenes;
    public static final int NONE = 0;
    public static final int EXTINCTION = 1;
    public static final int MUTATION = 2;
    public static final int CROSSOVER = 3;
    public static final int OTHER = 4;
    private int _iModifiedBy = 0;
    protected double _dFit = Double.NaN;

    public Chromosome(Gene[] geneArray) {
        this.genes = geneArray;
        this.noOfGenes = geneArray.length;
    }

    public Chromosome(Gene[] geneArray, int n, int n2) {
        this(geneArray);
        _iRepeatMut = n;
        _iRepeatCross = n2;
    }

    public Chromosome(Gene[] geneArray, double d, double d2, int n, int n2) {
        this(geneArray);
        PC = d;
        PM = d2;
        _iRepeatMut = n;
        _iRepeatCross = n2;
    }

    public Gene[] getGenes() {
        return this.genes;
    }

    public Gene getGene(int n) {
        return this.genes[n];
    }

    protected void setGene(int n, Gene gene) {
        this.genes[n] = gene;
    }

    public int getNoOfGenes() {
        return this.noOfGenes;
    }

    public void randomize() {
        for (int i = 0; i < this.noOfGenes; ++i) {
            this.genes[i].randomize();
        }
    }

    public void reset() {
        for (int i = 0; i < this.noOfGenes; ++i) {
            this.genes[i].randomize();
        }
    }

    public static void mutate(Chromosome[] chromosomeArray, double d) {
        for (int i = 0; i < chromosomeArray.length; ++i) {
            for (int j = 0; j < _iRepeatMut; ++j) {
                if (!(Math.random() < PM)) continue;
                int n = (int)Math.floor((double)chromosomeArray[i].getNoOfGenes() * Math.random());
                chromosomeArray[i].genes[n].mutate(d);
                chromosomeArray[i].setModified(2);
            }
        }
    }

    public static void crossOver(Chromosome[] chromosomeArray) {
        Chromosome chromosome = null;
        for (int i = 0; i < chromosomeArray.length; ++i) {
            for (int j = 0; j < _iRepeatCross; ++j) {
                if (!(Math.random() < PC)) continue;
                if (chromosome == null) {
                    chromosome = chromosomeArray[i];
                    continue;
                }
                int n = (int)Math.floor((double)chromosome.getNoOfGenes() * Math.random());
                Gene gene = chromosome.genes[n];
                chromosome.genes[n] = chromosomeArray[i].genes[n];
                chromosomeArray[i].genes[n] = gene;
                chromosomeArray[i].setModified(3);
                chromosome.setModified(3);
                chromosome = null;
            }
        }
    }

    public static void recreateFailedChromosome(Chromosome[] chromosomeArray, int n, double d) {
        if (Math.random() < PM / (PM + PC)) {
            int n2 = 0;
            while ((n2 = (int)Math.floor((double)chromosomeArray.length * Math.random())) == n) {
            }
            chromosomeArray[n] = (Chromosome)chromosomeArray[n2].clone();
            int n3 = (int)Math.floor((double)chromosomeArray[n].getNoOfGenes() * Math.random());
            chromosomeArray[n].genes[n3].mutate(d);
            chromosomeArray[n].setModified(2);
        } else {
            int n4 = 0;
            int n5 = 0;
            do {
                n4 = (int)Math.floor((double)chromosomeArray.length * Math.random());
                n5 = (int)Math.floor((double)chromosomeArray.length * Math.random());
            } while (n4 == n || n5 == n || n4 == n5);
            chromosomeArray[n] = (Chromosome)chromosomeArray[n4].clone();
            int n6 = (int)Math.floor((double)chromosomeArray[n].getNoOfGenes() * Math.random());
            chromosomeArray[n].genes[n6] = (Gene)chromosomeArray[n5].genes[n6].clone();
            chromosomeArray[n].setModified(3);
        }
    }

    public static void extinct(Chromosome[] chromosomeArray, Chromosome chromosome, double d, double d2) {
        int n = chromosomeArray.length;
        int n2 = chromosomeArray[0].getNoOfGenes();
        for (int i = 0; i < n; ++i) {
            if (Math.random() < 0.25) {
                chromosomeArray[i] = (Chromosome)chromosome.clone();
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                chromosomeArray[i].genes[j].randomizeAround(chromosome.genes[j], d, d2);
            }
            chromosomeArray[i].setModified(1);
        }
    }

    public boolean equals(Chromosome chromosome) {
        boolean bl = true;
        for (int i = 0; i < this.noOfGenes; ++i) {
            if (this.genes[i].equals(chromosome.genes[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public double getFit() {
        return this._dFit;
    }

    public void setFit(double d) {
        this._dFit = d;
    }

    public void setModified(int n) {
        this._dFit = Double.NaN;
        this._iModifiedBy = n;
    }

    public int getWhoModified() {
        return this._iModifiedBy;
    }

    public void resetWhoModified() {
        this._iModifiedBy = 0;
    }

    public boolean needsEvaluation() {
        return Double.isNaN(this._dFit);
    }

    public Object clone() {
        Chromosome chromosome = null;
        try {
            chromosome = (Chromosome)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        chromosome.genes = new Gene[this.genes.length];
        for (int i = 0; i < this.noOfGenes; ++i) {
            chromosome.genes[i] = (Gene)this.genes[i].clone();
        }
        return chromosome;
    }
}

