/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.analysis.evolution.Evolution;

public abstract class AdaptingEvolution
extends Evolution {
    private double[] difference;
    private double[] _adError;
    private int _iExtinctionStep = 50;
    private int _iExtinctionTreshold = 50;
    protected double adaptingMaxError = 0.0;
    protected double maxError = 0.0;
    protected int stepCount = 0;
    protected static final boolean DEBUG = false;
    protected int _iRecreationLimit = 50;
    public static final String POPULATION_FAILED = "Evolution cannot recreate failed chromosome";
    private double _dProgress = 0.0;
    private static Logger _logger = Logger.getLogger("net.ndmystko.analysis.evolution.AdaptingEvolution");

    protected String evalP(Chromosome[] chromosomeArray, double[] dArray) {
        int n;
        assert (this.stepCount > 0 || this.stepCount == 0 && this.maxError > 0.0 || this.stepCount == 0 && this.adaptingMaxError > 0.0);
        int n2 = chromosomeArray.length;
        if (this.difference == null) {
            this.difference = new double[n2];
            this._adError = new double[n2];
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (chromosomeArray[i].needsEvaluation()) {
                double d = this.calculateDifference(chromosomeArray[i]);
                if (Double.isNaN(d)) {
                    ++n3;
                    int n4 = 0;
                    do {
                        Chromosome.recreateFailedChromosome(chromosomeArray, i, this._dProgress);
                    } while (Double.isNaN(d = this.calculateDifference(chromosomeArray[i])) && ++n4 < this._iRecreationLimit);
                    if (Double.isNaN(d) && n4 == this._iRecreationLimit) {
                        return POPULATION_FAILED;
                    }
                }
                this.difference[i] = d;
                chromosomeArray[i].setFit(d);
            } else {
                this.difference[i] = chromosomeArray[i].getFit();
            }
            dArray[i] = this.adaptingMaxError - this.difference[i];
            if (!(dArray[i] < 0.0)) continue;
            dArray[i] = 0.0;
        }
        if (n3 > 0) {
            _logger.logp(Level.FINER, "net.ndmystko.analysis.evolution.AdaptingEvolution", "evalP", "Failed chromosomes: " + (double)n3 / (double)n2 * 100.0 + "% of population");
        }
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            d += this.difference[n];
        }
        if (this.adaptingMaxError < 2.5 * (d / (double)n2) && this.adaptingMaxError != this.maxError) {
            _logger.logp(Level.FINEST, "net.ndmystko.analysis.evolution.AdaptingEvolution", "evalP", "wrong adaptingMaxError");
            this.adaptingMaxError = 5.0 * (d / (double)n2);
            if (this.adaptingMaxError > this.maxError) {
                this.adaptingMaxError = this.maxError;
            }
            for (n = 0; n < n2; ++n) {
                dArray[n] = this.adaptingMaxError - this.difference[n];
                if (!(dArray[n] < 0.0)) continue;
                dArray[n] = 0.0;
            }
        }
        this.adaptingMaxError = 5.0 * (d / (double)n2);
        if (this.adaptingMaxError > this.maxError) {
            this.adaptingMaxError = this.maxError;
        }
        return null;
    }

    protected abstract double calculateDifference(Chromosome var1);

    protected void changeP(Chromosome[] chromosomeArray, double d) {
        this._dProgress = d;
        if (this.stepCount % this._iExtinctionStep == 0 && this.stepCount > this._iExtinctionTreshold) {
            double d2 = 1.0 - this.adaptingMaxError / this.maxError;
            Chromosome.extinct(chromosomeArray, this.bestChromosome, d2, d);
        } else {
            super.changeP(chromosomeArray, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findBest(Chromosome[] chromosomeArray, double[] dArray) {
        ++this.stepCount;
        int n = chromosomeArray.length;
        boolean bl = false;
        Chromosome chromosome = this.bestChromosome;
        synchronized (chromosome) {
            for (int i = 0; i < n; ++i) {
                double d = this.maxError - chromosomeArray[i].getFit();
                if (!(this.everMaxEval < d)) continue;
                this.everMaxEval = d;
                this.bestChromosome = (Chromosome)chromosomeArray[i].clone();
                bl = true;
            }
        }
    }

    public int getPopulationFit(double[] dArray) {
        double d = (this.maxError - this.difference[0]) / this.maxError * 100.0;
        for (int i = 0; i < this.difference.length; ++i) {
            this._adError[i] = (this.maxError - this.difference[i]) / this.maxError * 100.0;
            d = Math.min(d, this._adError[i]);
        }
        d = Math.floor(d);
        double d2 = (100.0 - d) / (double)dArray.length;
        for (int i = 0; i < this.difference.length; ++i) {
            int n;
            int n2 = n = (int)((this._adError[i] - d) / d2);
            dArray[n2] = dArray[n2] + 1.0;
        }
        return (int)d;
    }

    public double getAverageFit() {
        double d = 0.0;
        for (int i = 0; i < this.difference.length; ++i) {
            d = (this.maxError - this.difference[i]) / this.maxError * 100.0;
        }
        return d / (double)this.difference.length;
    }

    protected void setExtinctionStep(int n) {
        this._iExtinctionStep = n;
    }

    protected void setExtinctionTreshold(int n) {
        this._iExtinctionTreshold = n;
    }

    protected void setRecreationLimit(int n) {
        this._iRecreationLimit = n;
    }
}

