/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.util;

import java.io.Serializable;
import net.ndmystko.xrd.util.Distribution;

public class LognormalDistribution
extends Distribution
implements Serializable {
    private static final long serialVersionUID = 7819471290505624584L;
    private double _t;
    private int _iNoOfClasses;
    private int _iMaxNumberOfClasses;
    private double[] _adPopulation;

    public LognormalDistribution(double t, int iNumberOfClasses) {
        this(t, 0.9485 * Math.log(t) - 0.017, 0.1032 * Math.log(t) + 0.034, iNumberOfClasses, iNumberOfClasses);
    }

    public LognormalDistribution(double t, int iNumberOfClasses, int iMaxNumberOfClasses) {
        this(t, 0.9485 * Math.log(t) - 0.017, 0.1032 * Math.log(t) + 0.034, iNumberOfClasses, iMaxNumberOfClasses);
    }

    public LognormalDistribution(double t, double beta2, int iNumberOfClasses) {
        this(t, Math.log(t) - beta2 / 2.0, beta2, iNumberOfClasses, iNumberOfClasses);
    }

    public LognormalDistribution(double t, double alpha, double beta2, int iNumberOfClasses, int iMaxNumberOfClasses) {
        assert (iMaxNumberOfClasses >= iNumberOfClasses);
        this._adPopulation = new double[iMaxNumberOfClasses + 1];
        this._iMaxNumberOfClasses = iMaxNumberOfClasses;
        this.recalcDistribution(t, alpha, beta2, iNumberOfClasses);
    }

    public void recalcDistribution(double t, int iNumberOfClasses) {
        this.recalcDistribution(t, 0.9485 * Math.log(t) - 0.017, 0.1032 * Math.log(t) + 0.034, iNumberOfClasses);
    }

    public void recalcDistribution(double t, double beta2, int iNumberOfClasses) {
        this.recalcDistribution(t, Math.log(t) - beta2 / 2.0, beta2, iNumberOfClasses);
    }

    private void recalcDistribution(double t, double alpha, double beta2, int iNumberOfClasses) {
        if (iNumberOfClasses > this._iMaxNumberOfClasses) {
            throw new IllegalArgumentException("Attempt to recalculate distribution for noOfClasses(" + iNumberOfClasses + ") higher than maxNoOfClasses (" + this._iMaxNumberOfClasses + ")");
        }
        this._iNoOfClasses = iNumberOfClasses;
        double sum = 0.0;
        int i = 1;
        while (i < this._iNoOfClasses + 1) {
            this._adPopulation[i] = Math.sqrt(Math.PI * 2) / ((double)i * Math.sqrt(beta2)) * Math.exp(-Math.pow(Math.log(i) - alpha, 2.0) / (2.0 * beta2));
            sum += this._adPopulation[i];
            ++i;
        }
        i = 1;
        while (i < this._iNoOfClasses + 1) {
            int n = i++;
            this._adPopulation[n] = this._adPopulation[n] / sum;
        }
        this._t = t;
    }

    @Override
    public int getNoOfClasses() {
        return this._iNoOfClasses;
    }

    @Override
    public double getContent(int classNumber) {
        return this._adPopulation[classNumber];
    }

    public double getT() {
        return this._t;
    }
}

