/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import net.ndmystko.xrd.util.Distribution;

public class AnyDistribution
extends Distribution
implements Serializable {
    private static final long serialVersionUID = -2033866132821840807L;
    private int noOfClasses;
    private double[] population;
    private static final int MAX_LOADED_CLASSES = 201;

    public AnyDistribution(int t) {
        this.noOfClasses = t;
        this.population = new double[this.noOfClasses + 1];
        this.population[t] = 1.0;
    }

    public AnyDistribution(double[] t) {
        this.setDistribution(t);
    }

    public AnyDistribution(File source) throws IOException {
        this.loadDistribution(source);
        this.setDistribution(this.population);
    }

    public void setDistribution(double[] dist) {
        if (this.population == null || this.population.length != dist.length) {
            this.population = new double[dist.length];
        }
        this.noOfClasses = dist.length - 1;
        double sum = 0.0;
        int i = 0;
        while (i < this.noOfClasses + 1) {
            sum += dist[i];
            ++i;
        }
        i = 0;
        while (i < this.noOfClasses + 1) {
            this.population[i] = dist[i] / sum;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadDistribution(File source) throws IOException {
        double[] values;
        block18: {
            BufferedReader bf = new BufferedReader(new FileReader(source));
            StreamTokenizer st = new StreamTokenizer(bf);
            st.eolIsSignificant(false);
            int index = 0;
            values = new double[201];
            try {
                while (true) {
                    switch (st.nextToken()) {
                        case -2: {
                            index = (int)st.nval;
                            if (index <= 200) break;
                            throw new IOException("Up to 200 thickness classes are supported.");
                        }
                        case -3: {
                            throw new IOException("Wrong format of the " + source.getName() + " file");
                        }
                        case -1: {
                            break block18;
                        }
                    }
                    switch (st.nextToken()) {
                        case -2: {
                            values[index] = st.nval;
                            break;
                        }
                        case -3: {
                            throw new IOException("Wrong format of the " + source.getName() + " file");
                        }
                        case -1: {
                            break block18;
                        }
                    }
                }
            }
            finally {
                bf.close();
            }
        }
        int iTopIndex = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] > 0.0) {
                iTopIndex = i;
            }
            ++i;
        }
        this.population = new double[iTopIndex + 1];
        System.arraycopy(values, 0, this.population, 0, iTopIndex + 1);
        this.noOfClasses = iTopIndex;
    }

    @Override
    public int getNoOfClasses() {
        return this.noOfClasses;
    }

    @Override
    public double getContent(int classNumber) {
        return this.population[classNumber];
    }
}

