/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.script;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.mod.EvolutionListener;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Mixture;
import net.ndmystko.xrd.mod.ModEvol;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.PhaseFactory;
import net.ndmystko.xrd.mod.gene.GeneConnector;

public abstract class Script
extends Thread {
    public static final int IS = 0;
    public static final int ISS = 1;
    public static final int ISSS = 2;
    public static final int IS_HEATED = 73;
    public static final int SS = 3;
    public static final int SSS = 4;
    public static final int I = 50;
    public static final int S = 51;
    public static final int K = 52;
    public static final int KS = 56;
    public static final int KSS = 57;
    public static final int KI = 58;
    public static final int SERP = 55;
    public static final int CH = 53;
    public static final int CHS = 54;
    public static final int CHSS = 68;
    public static final int CHSERP = 58;
    public static final int CHSERPR1 = 82;
    public static final int SERPS = 59;
    public static final int SERPSS = 60;
    public static final int T = 61;
    public static final int PYR = 62;
    public static final int HTC = 63;
    public static final int HTSV = 64;
    public static final int HTSH = 65;
    public static final int HTC_HTSV = 66;
    public static final int HTC_HTSH = 67;
    public static final int ITSV = 69;
    public static final int LS = 70;
    public static final int LSS = 71;
    public static final int LSSS = 72;
    public static final int ISCH = 74;
    public static final int ISSCH = 75;
    public static final int PS = 76;
    public static final int PSS = 77;
    public static final int PSSS = 78;
    public static final int MS = 79;
    public static final int MSS = 80;
    public static final int MSSS = 81;
    public static final int CsS = 82;
    public static final int CsSS = 83;
    public static final int CsSSS = 84;
    public static final int USER_PHASE = 100;
    public static final int R0 = 0;
    public static final int R1 = 1;
    public static final int R2 = 2;
    public static final int R3 = 3;
    public static final int ORDERED = 0;
    public static final int SEGREGATED = 1;
    public static final int NEVER_MIND = 2;
    public static final int GLY = 0;
    public static final int AIR_DRY = 1;
    public static final int GLYCERINE = 2;
    public static final int CUTRIEN = 3;
    public static final int CUTRIENGLY = 4;
    public static final int CUTRIENANDGLY = 5;
    public static final String GLY_STRING = "GLY";
    public static final String AIR_DRY_STRING = "WAT";
    public static final String GLYCERINE_STRING = "GLYCERINE";
    public static final String CUTRIEN_STRING = "Cu-TRIEN";
    public static final String CUTRIENGLY_STRING = "Cu-TRIEN/GLY";
    public static final String CUTRIENANDGLY_STRING = "Cu-TRIEN-GLY";
    public static final String ILLITE = "illite";
    public static final String DI_SMECTITE_TWO_GLY = "di-smectite 2gly";
    public static final String DI_SMECTITE_TWO_GLYCERINE = "di-smectite 2glycerine";
    public static final String DI_SMECTITE_ONE_GLY = "di-smectite 1gly";
    public static final String DI_SMECTITE_ONE_GLYCERINE = "di-smectite 1glycerine";
    public static final String DI_SMECTITE_TWO_WAT = "di-smectite 2wat";
    public static final String DI_SMECTITE_TWO_WAT_CONTR = "di-smectite 2wat contr.";
    public static final String DI_SMECTITE_ONE_WAT = "di-smectite 1wat";
    public static final String DI_SMECTITE_ZERO_WAT = "di-smectite 0wat";
    public static final String DI_SMECTITE_HEATED = "di-smectite heated";
    public static final String DI_SMECTITE_CUTRIEN = "di-smectite Cu-Trien";
    public static final String DI_SMECTITE_CUTRIENAND2GLY = "di-smectite Cu-Trien 2gly";
    public static final String TRI_SMECTITE_ONE_GLY = "tri-smectite 1gly";
    public static final String TRI_SMECTITE_TWO_GLY = "tri-smectite 2gly";
    public static final String TRI_SMECTITE_ONE_WAT = "tri-smectite 1wat";
    public static final String TRI_SMECTITE_TWO_WAT = "tri-smectite 2wat";
    public static final String TRI_SMECTITE_TWO_WAT_CONTR = "tri-smectite 2wat contr.";
    public static final String TRI_SMECTITE_ZERO_WAT = "tri-smectite 0wat";
    public static final String KAOLINITE = "kaolinite";
    public static final String SERPENTINE = "serpentine";
    public static final String CHLORITE = "chlorite";
    public static final String TALC = "talc";
    public static final String PYROPHYLLITE = "pyrophyllite";
    public static final String TABILITE = "tobilite";
    public static final String LEUCOPHYLLITE = "leucophyllite";
    public static final String PARAGONITE = "paragonite";
    public static final String MARGARITE = "margarite";
    public static final String VERMICULITE_TWO_WAT = "vermiculite 2wat";
    public static final String HYDROTALCITE_CO3_WAT = "hydrotalcite CO3 wat";
    public static final String HYDROTALCITE_VERT_SO4_WAT = "hydrotalcite vert SO4 wat";
    public static final String HYDROTALCITE_HORIZ_SO4_WAT = "hydrotalcite horiz SO4 wat";
    public static final String USER_LAYER = "user defined";
    public static final String OCT_IRON_CONTENT = "oct iron content";
    public static final String INT_IRON_CONTENT = "interlayer iron content";
    public static final String D_SPACING = "d-spacing";
    public static final String DELTA_D_SPACING = "delta d-spacing";
    public static final String GLYCOL_CONTENT = "glycol content";
    public static final String WATER_CONTENT = "water content";
    public static final String INTERLAYER_CAT_CONTENT = "interlayer cation content";
    public static final String INTERLAYER_CONTENT = "interlayer content";
    public static final String INTERLAYER_CO3_CONTENT = "interlayer CO3 content";
    public static final String INTERLAYER_CONTENT_SHIFT = "interlayer content shift";
    public static final String T_MEAN = "Tmean";
    public static final String SIGMA_STAR = "sigma-star";
    public static final String TWO_GLY = "two gly";
    public static final String ONE_GLY = "one gly";
    public static final String BRUCITE = "brucite";
    public static final String TWO_TO_ONE_LAYER = "2:1 layer";
    public static final String USER_EDGES = "user defined";
    protected static final int DONE = 1;
    protected static final int FAILED = 2;
    protected static final int INTERRUPTED = 3;
    protected static final int REQUEST_R1_IS = 4;
    protected static final int REQUEST_R2_IS = 5;
    protected static final int REQUEST_R3_IS = 6;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.script.script");
    private static final String _sNewLine = System.getProperty("line.separator");
    public static final int MAIN_SCRIPT = 1;
    public static final int SINGLE_STEP_SCRIPT = 2;
    public static final int EXTRA_WATER_RUN_SCRIPT = 3;
    public static final int MIXED_MODE = 0;
    public static final int FULL_MODE = 1;
    public static final int QUICK_MODE = 2;
    public static final double DEFAULT_R2_LIMIT = 10.5;
    public static final double DEFAULT_QUICK_R2_LIMIT = 12.0;
    public double _dR2Limit = 10.5;
    public double _dQuickR2Limit = 12.0;
    protected static final int QUICK_NO_OF_GENERATIONS = 1000;
    protected static final int FULL_NO_OF_GENERATIONS = 2000;
    protected int _iMode = 0;
    protected int _iNoOfThreads = 1;
    protected EvolutionListener _gui = null;
    protected PatternParams _patternParams = null;
    protected AbstractDiffractogram _expPattern = null;
    protected Phase[] _aMonoPhases = null;
    protected List _lExcludedRanges = null;
    protected GeneConnector _globalSigmaStar = null;
    protected static final int POP_SIZE = 50;
    protected static final boolean WITHOUT_EDGES = false;
    protected static final boolean WITH_EDGES = true;

    protected Script(int iMode, EvolutionListener gui, AbstractDiffractogram expPattern, PatternParams patternParams, Phase[] aMonoPhases, GeneConnector globalSigmaStar, List lExcludedRanges) {
        String sThreadsNumber;
        assert (iMode == 0 || iMode == 1 || iMode == 2);
        this._gui = gui;
        this._iMode = iMode;
        this._patternParams = patternParams;
        this._expPattern = expPattern;
        this._aMonoPhases = aMonoPhases;
        this._globalSigmaStar = globalSigmaStar;
        if (lExcludedRanges != null) {
            this._lExcludedRanges = new ArrayList(lExcludedRanges.size());
            this._lExcludedRanges.addAll(lExcludedRanges);
        }
        if ((sThreadsNumber = System.getProperty("net.ndmystko.xrd.mod.threads")) != null) {
            int iNoOfThreads = 1;
            try {
                iNoOfThreads = Integer.parseInt(sThreadsNumber);
                if (iNoOfThreads <= 0) {
                    _logger.logp(Level.CONFIG, "net.ndmystko.xrd.mod.script.Script", "Script", "Wrong value of the parameter: " + sThreadsNumber);
                }
                this._iNoOfThreads = 1;
            }
            catch (NumberFormatException nfe) {
                _logger.logp(Level.CONFIG, "net.ndmystko.xrd.mod.script.Script", "Script", "Wrong format of the parameter: " + sThreadsNumber);
            }
        } else {
            this._iNoOfThreads = 4;
            System.out.println("Detected " + this._iNoOfThreads + " processor(s), splitting calculation into " + this._iNoOfThreads + " thread(s)");
        }
    }

    public void setTreshold(double dR2Limit, double dQuickR2Limit) {
        this._dR2Limit = dR2Limit;
        this._dQuickR2Limit = dQuickR2Limit;
    }

    @Override
    public abstract void run();

    protected synchronized double getFit(Pattern pattern) {
        _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.script.Script", "getFit", "Fit started for pattern: " + pattern.toString());
        int iThisNoOfGenerations = 0;
        switch (this._iMode) {
            case 0: 
            case 2: {
                iThisNoOfGenerations = 1000;
                break;
            }
            case 1: {
                iThisNoOfGenerations = 2000;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Pattern[] patterns = new Pattern[this._iNoOfThreads];
        patterns[0] = pattern;
        if (this._iNoOfThreads > 1) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4000000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(pattern);
                oos.close();
                byte[] abSerialized = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(abSerialized);
                int i = 1;
                while (i < this._iNoOfThreads) {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    patterns[i] = (Pattern)ois.readObject();
                    bais.reset();
                    ++i;
                }
            }
            catch (IOException ioe) {
                _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.script.Script", "getFit", "IOException in getFit", ioe);
                throw new RuntimeException("Internal error:\n" + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.script.Script", "getFit", "ClassNotFoundException in getFit", cnfe);
                throw new RuntimeException("Internal error:\n" + cnfe.getMessage());
            }
        } else assert (this._iNoOfThreads == 1);
        ModEvol evol = new ModEvol(this, patterns, 50, iThisNoOfGenerations);
        evol.addActionListener(this._gui);
        evol.start();
        this._gui.setDescription(pattern.toString());
        this._gui.setPhaseQuick(this._iMode != 1);
        long lBefore = System.currentTimeMillis();
        try {
            this.wait();
        }
        catch (InterruptedException bais) {
            // empty catch block
        }
        double dFit = 0.0;
        if (evol.getProgress() == 100) {
            Chromosome bestOne = evol.getBestChromosome();
            dFit = bestOne.getFit() / evol.getMaxError() * 100.0;
            if (this._iMode == 0 && dFit < this._dQuickR2Limit) {
                _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.script.Script", "getFit", "Received good fit (" + dFit + "%) for MIXED_MODE, restarting evolution" + _sNewLine);
                evol.calcPatternForBestChromosome();
                this._gui.setPhaseQuick(false);
                evol = new ModEvol(this, patterns, 50, 1000);
                evol.addActionListener(this._gui);
                evol.start();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.script.Script", "getFit", "calc took " + (System.currentTimeMillis() - lBefore) / 1000L + "s" + _sNewLine);
            evol.calcPatternForBestChromosome();
            this._gui.addResult(pattern);
            bestOne = evol.getBestChromosome();
            dFit = bestOne.getFit() / evol.getMaxError() * 100.0;
            _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.script.Script", "getFit", "Best fit: " + dFit + "%" + _sNewLine);
            _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.script.Script", "getFit", "*** best fit structure ***" + _sNewLine + pattern.toString() + _sNewLine + pattern.getModel(""));
        } else {
            dFit = Double.NaN;
            _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.script.Script", "getFit", "Analysis stopped");
        }
        return dFit;
    }

    public synchronized void wakeUp() {
        this.notify();
    }

    protected SubResult runR0TwoCompGly(SubPattern refPattern, boolean bRecreate) {
        SubPattern pattern_IS_R0_GLY = this.createStep(0, 0, 0, false, refPattern, bRecreate);
        double dR2_IS_R0_GLY = this.getFit(pattern_IS_R0_GLY.pattern);
        if (Double.isNaN(dR2_IS_R0_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R0_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR0ThreeCompGly(pattern_IS_R0_GLY, true);
    }

    protected SubResult runR0ThreeCompGly(SubPattern refPattern, boolean bRecreate) {
        SubPattern pattern_ISS_R0_GLY = this.createStep(1, 0, 0, false, refPattern, bRecreate);
        double dR2_ISS_R0_GLY = this.getFit(pattern_ISS_R0_GLY.pattern);
        if (Double.isNaN(dR2_ISS_R0_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R0_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(4, refPattern);
    }

    protected SubResult runR0TwoCompWat(SubPattern refPattern, boolean bRecreate) {
        SubPattern pattern_IS_R0_WAT = this.createStep(0, 0, 1, false, refPattern, bRecreate);
        double dR2_IS_R0_WAT = this.getFit(pattern_IS_R0_WAT.pattern);
        if (Double.isNaN(dR2_IS_R0_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R0_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR0ThreeCompWat(pattern_IS_R0_WAT, true);
    }

    protected SubResult runR0ThreeCompWat(SubPattern refPattern, boolean bRecreate) {
        SubPattern pattern_ISS_R0_WAT = this.createStep(1, 0, 1, false, refPattern, bRecreate);
        double dR2_ISS_R0_WAT = this.getFit(pattern_ISS_R0_WAT.pattern);
        if (Double.isNaN(dR2_ISS_R0_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R0_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        SubPattern pattern_ISSS_R0_WAT = this.createStep(2, 0, 1, false, pattern_ISS_R0_WAT, true);
        double dR2_ISSS_R0_WAT = this.getFit(pattern_ISSS_R0_WAT.pattern);
        if (Double.isNaN(dR2_ISSS_R0_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_ISSS_R0_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(4, refPattern);
    }

    protected SubResult runR1TwoCompGly(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R1_GLY = this.createStep(0, 1, 0, false, previous, bRecreate);
        double dR2_IS_R1_GLY = this.getFit(pattern_IS_R1_GLY.pattern);
        if (Double.isNaN(dR2_IS_R1_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R1_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR1ThreeCompGly(pattern_IS_R1_GLY, true);
    }

    protected SubResult runR1ThreeCompGly(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_ISS_R1_GLY = this.createStep(1, 1, 0, false, previous, bRecreate);
        double dR2_ISS_R1_GLY = this.getFit(pattern_ISS_R1_GLY.pattern);
        if (Double.isNaN(dR2_ISS_R1_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R1_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(5, previous);
    }

    protected SubResult runR1TwoCompWat(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R1_WAT = this.createStep(0, 1, 1, false, previous, bRecreate);
        double dR2_IS_R1_WAT = this.getFit(pattern_IS_R1_WAT.pattern);
        if (Double.isNaN(dR2_IS_R1_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R1_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR1ThreeCompWat(pattern_IS_R1_WAT, true);
    }

    protected SubResult runR1ThreeCompWat(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_ISS_R1_WAT = this.createStep(1, 1, 1, false, previous, bRecreate);
        double dR2_ISS_R1_WAT = this.getFit(pattern_ISS_R1_WAT.pattern);
        if (Double.isNaN(dR2_ISS_R1_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R1_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        SubPattern pattern_ISSS_R1_WAT = this.createStep(2, 1, 1, false, pattern_ISS_R1_WAT, true);
        double dR2_ISSS_R1_WAT = this.getFit(pattern_ISSS_R1_WAT.pattern);
        if (Double.isNaN(dR2_ISSS_R1_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_ISSS_R1_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(5, previous);
    }

    protected SubResult runR2TwoCompGly(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R2_GLY = this.createStep(0, 2, 0, false, previous, bRecreate);
        double dR2_IS_R2_GLY = this.getFit(pattern_IS_R2_GLY.pattern);
        if (Double.isNaN(dR2_IS_R2_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R2_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR2ThreeCompGly(pattern_IS_R2_GLY, true);
    }

    protected SubResult runR2ThreeCompGly(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_ISS_R2_GLY = this.createStep(1, 2, 0, false, previous, bRecreate);
        double dR2_ISS_R2_GLY = this.getFit(pattern_ISS_R2_GLY.pattern);
        if (Double.isNaN(dR2_ISS_R2_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R2_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(6, previous);
    }

    protected SubResult runR2TwoCompWat(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R2_WAT = this.createStep(0, 2, 1, false, previous, bRecreate);
        double dR2_IS_R2_WAT = this.getFit(pattern_IS_R2_WAT.pattern);
        if (Double.isNaN(dR2_IS_R2_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R2_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return this.runR2ThreeCompWat(pattern_IS_R2_WAT, true);
    }

    protected SubResult runR2ThreeCompWat(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_ISS_R2_WAT = this.createStep(1, 2, 1, false, previous, bRecreate);
        double dR2_ISS_R2_WAT = this.getFit(pattern_ISS_R2_WAT.pattern);
        if (Double.isNaN(dR2_ISS_R2_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_ISS_R2_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(6, previous);
    }

    protected SubResult runR3TwoCompGly(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R3_GLY = this.createStep(0, 3, 0, false, previous, bRecreate);
        double dR2_IS_R3_GLY = this.getFit(pattern_IS_R3_GLY.pattern);
        if (Double.isNaN(dR2_IS_R3_GLY)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R3_GLY < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(2, null);
    }

    protected SubResult runR3TwoCompWat(SubPattern previous, boolean bRecreate) {
        SubPattern pattern_IS_R3_WAT = this.createStep(0, 3, 1, false, previous, bRecreate);
        double dR2_IS_R3_WAT = this.getFit(pattern_IS_R3_WAT.pattern);
        if (Double.isNaN(dR2_IS_R3_WAT)) {
            return new SubResult(3, null);
        }
        if (dR2_IS_R3_WAT < this._dR2Limit) {
            return new SubResult(1, null);
        }
        return new SubResult(2, null);
    }

    protected SubPattern createStep(int iPhaseType, int iR, int iPhaseState, boolean bWithEdges, SubPattern previous, boolean bRecreateIS) {
        MixedLayerPhase phase = null;
        if (bRecreateIS) {
            phase = PhaseFactory.createMixedLayerPhase(iPhaseType, iR, iPhaseState, bWithEdges, this._patternParams, previous != null ? previous.phase : null, this._globalSigmaStar != null);
        } else {
            Phase[] aISPhase = new Phase[]{previous.phase};
            phase = (MixedLayerPhase)Phase.duplicatePhases(aISPhase)[0];
        }
        ArrayList<MixedLayerPhase> alPhases = new ArrayList<MixedLayerPhase>(7);
        alPhases.add(phase);
        Phase[] phases = null;
        if (this._aMonoPhases != null) {
            Phase[] aMonoPhasesDuplicate = Phase.duplicatePhases(this._aMonoPhases);
            phases = new Phase[1 + aMonoPhasesDuplicate.length];
            phases[0] = phase;
            int i = 0;
            while (i < aMonoPhasesDuplicate.length) {
                phases[i + 1] = aMonoPhasesDuplicate[i];
                ++i;
            }
        } else {
            phases = new Phase[]{phase};
        }
        Pattern pattern = new Pattern(this._patternParams, new Mixture(phases, this._patternParams), this._globalSigmaStar != null);
        if (this._globalSigmaStar != null) {
            pattern.restrictSigmaStar(this._globalSigmaStar);
        }
        pattern.setExpPattern(this._expPattern);
        pattern.setExcludedRanges(this._lExcludedRanges);
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.script.Script", "createStep", "*** created structure ***" + _sNewLine + pattern.toString() + _sNewLine + pattern.getModel(""));
        return new SubPattern(phase, pattern);
    }

    protected class SubPattern {
        protected MixedLayerPhase phase = null;
        protected Pattern pattern = null;

        public SubPattern(MixedLayerPhase cPhase, Pattern cPattern) {
            this.phase = cPhase;
            this.pattern = cPattern;
        }
    }

    protected class SubResult {
        protected int iResult = 0;
        protected SubPattern lastSubPattern = null;

        public SubResult(int iResult, SubPattern lastSubPattern) {
            this.iResult = iResult;
            this.lastSubPattern = lastSubPattern;
        }
    }
}

