/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.script;

import net.ndmystko.xrd.mod.EvolutionListener;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.script.Script;
import net.ndmystko.xrd.mod.script.ScriptParams;

public class MainScript
extends Script {
    private EvolutionListener _gui = null;
    private Task _task = null;
    private ScriptParams _scriptParams = null;

    public MainScript(EvolutionListener gui, Task task, ScriptParams scriptParams) {
        super(0, gui, task.getExpDiffr(), task.getPatternParams(), task.getStablePhases(), task.getSigmaStarConn(), task.getExcludedRanges());
        this._gui = gui;
        this._task = task;
        this._scriptParams = scriptParams;
    }

    @Override
    public void run() {
        boolean bGlycol;
        MixedLayerPhase startingIS = this._task.getStartingIS();
        boolean bl = bGlycol = startingIS.toString().indexOf("GLY") > -1;
        if (!bGlycol) assert (startingIS.toString().indexOf("WAT") > -1) : "Cannot identify state of " + startingIS.toString();
        Script.SubPattern startingSubPattern = new Script.SubPattern(startingIS, null);
        boolean bStop = this.doStep(this._scriptParams.getStartR(), startingSubPattern, false, bGlycol);
        this._gui.evolFinished(bStop);
    }

    private boolean doStep(int iR, Script.SubPattern lastResult, boolean bRecreate, boolean bGlycol) {
        Script.SubResult newResult = null;
        switch (iR) {
            case 0: {
                if (bRecreate || lastResult.phase.getPhaseType() == 0) {
                    newResult = bGlycol ? this.runR0TwoCompGly(lastResult, bRecreate) : this.runR0TwoCompWat(lastResult, bRecreate);
                } else if (!bRecreate && lastResult.phase.getPhaseType() == 1) {
                    newResult = bGlycol ? this.runR0ThreeCompGly(lastResult, bRecreate) : this.runR0ThreeCompWat(lastResult, bRecreate);
                } else assert (false) : "Illegal phase type: " + lastResult.phase.getPhaseType();
                if (newResult.iResult == 1 || newResult.iResult == 2 || newResult.iResult == 3) {
                    return newResult.iResult == 3;
                }
                assert (newResult.iResult == 4);
                if (this._scriptParams.getEndR() > 0) {
                    return this.doStep(1, newResult.lastSubPattern, true, bGlycol);
                }
                return false;
            }
            case 1: {
                if (bRecreate || lastResult.phase.getPhaseType() == 0) {
                    newResult = bGlycol ? this.runR1TwoCompGly(lastResult, bRecreate) : this.runR1TwoCompWat(lastResult, bRecreate);
                } else if (!bRecreate && lastResult.phase.getPhaseType() == 1) {
                    newResult = bGlycol ? this.runR1ThreeCompGly(lastResult, bRecreate) : this.runR1ThreeCompWat(lastResult, bRecreate);
                } else assert (false) : "Illegal phase type: " + lastResult.phase.getPhaseType();
                if (newResult.iResult == 1 || newResult.iResult == 2 || newResult.iResult == 3) {
                    return newResult.iResult == 3;
                }
                assert (newResult.iResult == 5);
                if (this._scriptParams.getEndR() > 1) {
                    return this.doStep(2, newResult.lastSubPattern, true, bGlycol);
                }
                return false;
            }
            case 2: {
                if (bRecreate || lastResult.phase.getPhaseType() == 0) {
                    newResult = bGlycol ? this.runR2TwoCompGly(lastResult, bRecreate) : this.runR2TwoCompWat(lastResult, bRecreate);
                } else if (!bRecreate && lastResult.phase.getPhaseType() == 1) {
                    newResult = bGlycol ? this.runR2ThreeCompGly(lastResult, bRecreate) : this.runR2ThreeCompWat(lastResult, bRecreate);
                } else assert (false) : "Illegal phase type: " + lastResult.phase.getPhaseType();
                if (newResult.iResult == 1 || newResult.iResult == 2 || newResult.iResult == 3) {
                    return newResult.iResult == 3;
                }
                assert (newResult.iResult == 6);
                if (this._scriptParams.getEndR() > 2) {
                    return this.doStep(3, newResult.lastSubPattern, true, bGlycol);
                }
                return false;
            }
            case 3: {
                if (lastResult.phase.getPhaseType() == 0 || lastResult.phase.getPhaseType() == 1) {
                    newResult = bGlycol ? this.runR3TwoCompGly(lastResult, bRecreate) : this.runR3TwoCompWat(lastResult, bRecreate);
                } else assert (false) : "Illegal phase type: " + lastResult.phase.getPhaseType();
                return newResult.iResult == 3;
            }
        }
        assert (false) : "Reichweite out of range: " + lastResult.phase.getProbabMatrix().getR();
        assert (false) : "doStep() should never reach this point";
        return false;
    }
}

