/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.common.util.RoundOff;
import net.ndmystko.xrd.mod.layer.DoubleValue;
import net.ndmystko.xrd.mod.probab.AddEquation;
import net.ndmystko.xrd.mod.probab.MultEquation;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Probability
implements Serializable {
    private static final long serialVersionUID = 8071296408849378669L;
    private int _iNoOfComp = -1;
    private int _iR = -1;
    private int _iRank = -1;
    private DoubleValue[][] _adW = null;
    private DoubleValue[][][] _adP = null;
    private AddEquation _w1Equation = null;
    private String _w1EquationString = null;
    private AddEquation[][] _aPEquation = null;
    private String[][] _aPEquationString = null;
    private MultEquation[][] _aWEquation = null;
    private String[][] _aWEquationString = null;
    private boolean[][] _abPESolved = null;
    private boolean[][] _abWESolved = null;
    private DoubleValue[][][] _aIntermWTerms = null;
    public static final int OK = 0;
    public static final int CANNOT_SOLVE = 1;
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    public static final int P = 0;
    public static final int W = 1;
    private static final double MATCHING_W_TRESHOLD = 0.2;
    private static final NumberFormat PROBAB_FORMATTER = NumberFormat.getInstance();
    private static final boolean DEBUG = false;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.probab.Probability");
    private static final String NEW_LINE = System.getProperty("line.separator");

    static {
        PROBAB_FORMATTER.setMinimumFractionDigits(1);
        PROBAB_FORMATTER.setMaximumFractionDigits(3);
    }

    public Probability(int iNoOfComp, int iR) {
        if (iNoOfComp < 2) {
            throw new IllegalArgumentException("Must be at least two components");
        }
        if (iR < 0) {
            throw new IllegalArgumentException("Reichweite must be at least zero");
        }
        this._iNoOfComp = iNoOfComp;
        this._iR = iR;
        this._iRank = this._iR == 0 ? this._iNoOfComp : (int)Math.pow(this._iNoOfComp, iR);
        this.createMatrices();
        this.createEquations();
    }

    public int getNoOfComp() {
        return this._iNoOfComp;
    }

    public int getR() {
        return this._iR;
    }

    public int getRank() {
        return this._iRank;
    }

    public double getW0(int index) {
        return this._adW[0][index].getValue();
    }

    public double getW(int index) {
        return this._adW[this._iR][index].getValue();
    }

    public double getW(int iR, int index) {
        if (iR > this._iR) {
            if (this._iR == 0) {
                return this._adW[0][index].getValue();
            }
            return this._aIntermWTerms[iR - 1][index][1].getValue() * this._aIntermWTerms[iR - 1][index][0].getValue();
        }
        return this._adW[iR][index].getValue();
    }

    public double getP(int iRow, int iCol) {
        return this._adP[this._iR][iRow][iCol].getValue();
    }

    public double getP(int iR, int iRow, int iCol) {
        return this._adP[iR][iRow][iCol].getValue();
    }

    public void setP(int iR, int iRow, int iCol, double dValue) {
        this._adP[iR][iRow][iCol].setValue(dValue);
    }

    public void setP(int iR, int iRow, int iCol, double dValue, boolean bPropagate) {
        this._adP[iR][iRow][iCol].setValue(dValue);
        if (!bPropagate || iR == this._iR || dValue != 0.0) {
            return;
        }
        int iRank = (int)Math.pow(this._iNoOfComp, iR);
        int iRankNext = iRank * this._iNoOfComp;
        HashSet<Integer> hsExcludedStructures = new HashSet<Integer>();
        int r = iR + 1;
        while (r <= this._iR) {
            int i = 0;
            while (i < iRankNext) {
                if (this._adP[r - 1][i / this._iNoOfComp][i % iRank].getValue() == 0.0) {
                    hsExcludedStructures.add(i);
                }
                ++i;
            }
            i = 0;
            while (i < iRankNext) {
                if (hsExcludedStructures.contains(i)) {
                    int j = 0;
                    while (j < iRankNext) {
                        if (hsExcludedStructures.contains(j)) {
                            this._adP[r][i][j].setValue(0.0);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            iRank = iRankNext;
            iRankNext *= this._iNoOfComp;
            ++r;
        }
    }

    public void setW(int iCol, double dValue) {
        this._adW[0][iCol].setValue(dValue);
    }

    public int solve() {
        return this.solve(this._iR);
    }

    public int solve(int iRLimit) {
        return this.solve(iRLimit, false);
    }

    public int solve(boolean bSolveFull) {
        return this.solve(this._iR, bSolveFull);
    }

    public int solve(int iRLimit, boolean bSolveFull) {
        int iResult = 0;
        this._w1Equation.solve();
        if (bSolveFull) {
            int i = 1;
            while (i < this._abPESolved.length) {
                Arrays.fill(this._abPESolved[i], false);
                ++i;
            }
            i = 1;
            while (i < this._abWESolved.length) {
                Arrays.fill(this._abWESolved[i], false);
                ++i;
            }
        }
        int r = 1;
        while (r <= iRLimit) {
            if (r > 1) {
                int i = 0;
                while (i < this._adW[r].length) {
                    this._adW[r][i].setValue(this._aIntermWTerms[r - 1][i][1].getValue() * this._aIntermWTerms[r - 1][i][0].getValue());
                    ++i;
                }
            }
            boolean bSomethingSolved = false;
            do {
                boolean bSubSolved;
                bSomethingSolved = false;
                int i = 0;
                while (i < this._aPEquation[r].length) {
                    if (!this._abPESolved[r][i]) {
                        this._abPESolved[r][i] = bSubSolved = this._aPEquation[r][i].solve();
                        bSomethingSolved |= bSubSolved;
                    }
                    ++i;
                }
                i = 0;
                while (i < this._aWEquation[r].length) {
                    if (!this._abWESolved[r][i]) {
                        this._abWESolved[r][i] = bSubSolved = this._aWEquation[r][i].solve();
                        bSomethingSolved |= bSubSolved;
                    }
                    ++i;
                }
            } while (bSomethingSolved);
            if (!this.allNumbers(r)) {
                iResult = 1;
                if (!bSolveFull) break;
            }
            ++r;
        }
        return iResult;
    }

    public String getWRatios() {
        double[] adRatios = new double[this._adW[0].length];
        int i = 0;
        while (i < adRatios.length) {
            adRatios[i] = this._adW[0][i].getValue() * 100.0;
            ++i;
        }
        int[] aiRatios = RoundOff.roundOff(adRatios, 100);
        StringBuffer sbRatios = new StringBuffer(20);
        sbRatios.append('(');
        int k = 0;
        while (k < aiRatios.length) {
            sbRatios.append(aiRatios[k]);
            if (k < aiRatios.length - 1) {
                sbRatios.append(':');
            }
            ++k;
        }
        sbRatios.append(')');
        return sbRatios.toString();
    }

    public ArrayList<String> getPValues() {
        ArrayList<String> alValues = new ArrayList<String>();
        int i = 1;
        while (i <= this._iR) {
            alValues.addAll(this.getPValues(i));
            if (i < this._iR) {
                alValues.add(new String(""));
            }
            ++i;
        }
        return alValues;
    }

    public ArrayList<String> getPValues(int iR) {
        int iRank = (int)Math.pow(this._iNoOfComp, iR);
        int iNoOfCondProb = iRank * this._iNoOfComp;
        String[][] asText = new String[iRank][this._iNoOfComp];
        int[] aiMaxTextLength = new int[this._iNoOfComp];
        int i = 0;
        while (i < iNoOfCondProb) {
            asText[i / this._iNoOfComp][i % this._iNoOfComp] = String.valueOf('P') + this.lettersWithin(i, iR) + '=' + PROBAB_FORMATTER.format(this._adP[iR][i / this._iNoOfComp][i % iRank].getValue());
            aiMaxTextLength[i % this._iNoOfComp] = Math.max(aiMaxTextLength[i % this._iNoOfComp], asText[i / this._iNoOfComp][i % this._iNoOfComp].length());
            ++i;
        }
        ArrayList<String> alText = new ArrayList<String>(100);
        StringBuffer sbHeader = new StringBuffer();
        int j = 0;
        while (j < this._iNoOfComp) {
            sbHeader.append(this.letter(j));
            int k = 0;
            while (k < aiMaxTextLength[j]) {
                sbHeader.append(' ');
                ++k;
            }
            ++j;
        }
        alText.add(sbHeader.toString());
        int i2 = 0;
        while (i2 < iRank) {
            StringBuffer sbLine = new StringBuffer();
            int j2 = 0;
            while (j2 < this._iNoOfComp) {
                sbLine.append(asText[i2][j2]);
                if (j2 < this._iNoOfComp - 1) {
                    int k = 0;
                    while (k < aiMaxTextLength[j2] - asText[i2][j2].length()) {
                        sbLine.append(' ');
                        ++k;
                    }
                    sbLine.append(' ');
                }
                ++j2;
            }
            alText.add(sbLine.toString());
            ++i2;
        }
        return alText;
    }

    public ArrayList<String> getWValues() {
        ArrayList<String> alValues = new ArrayList<String>();
        int i = 1;
        while (i <= this._iR) {
            alValues.addAll(this.getWValues(i));
            if (i < this._iR) {
                alValues.add(new String(""));
            }
            ++i;
        }
        return alValues;
    }

    public ArrayList<String> getWValues(int iR) {
        int iRank = (int)Math.pow(this._iNoOfComp, iR);
        int iNoOfCondProb = iRank * this._iNoOfComp;
        String[][] asText = new String[iRank][this._iNoOfComp];
        int[] aiMaxTextLength = new int[this._iNoOfComp];
        int i = 0;
        while (i < iNoOfCondProb) {
            asText[i / this._iNoOfComp][i % this._iNoOfComp] = String.valueOf('W') + this.lettersWithin(i, iR) + '=' + PROBAB_FORMATTER.format(this.getW(iR + 1, i));
            aiMaxTextLength[i % this._iNoOfComp] = Math.max(aiMaxTextLength[i % this._iNoOfComp], asText[i / this._iNoOfComp][i % this._iNoOfComp].length());
            ++i;
        }
        ArrayList<String> alText = new ArrayList<String>(100);
        StringBuffer sbHeader = new StringBuffer();
        int j = 0;
        while (j < this._iNoOfComp) {
            sbHeader.append(this.letter(j));
            int k = 0;
            while (k < aiMaxTextLength[j]) {
                sbHeader.append(' ');
                ++k;
            }
            ++j;
        }
        alText.add(sbHeader.toString());
        int i2 = 0;
        while (i2 < iRank) {
            StringBuffer sbLine = new StringBuffer();
            int j2 = 0;
            while (j2 < this._iNoOfComp) {
                sbLine.append(asText[i2][j2]);
                if (j2 < this._iNoOfComp - 1) {
                    int k = 0;
                    while (k < aiMaxTextLength[j2] - asText[i2][j2].length()) {
                        sbLine.append(' ');
                        ++k;
                    }
                    sbLine.append(' ');
                }
                ++j2;
            }
            alText.add(sbLine.toString());
            ++i2;
        }
        return alText;
    }

    public Element serializeXML() {
        Element probability = new Element("probability");
        probability.setAttribute("no_of_comp", Integer.toString(this._iNoOfComp));
        probability.setAttribute("R", Integer.toString(this._iR));
        Element w = new Element("W");
        int i = 0;
        while (i < this._iNoOfComp) {
            w.setAttribute(this.letter(i), Double.toString(this._adW[0][i].getValue()));
            ++i;
        }
        probability.addContent(w);
        if (this._iR > 0) {
            Element p = new Element("P");
            int r = 1;
            while (r <= this._iR) {
                int iRank = (int)Math.pow(this._iNoOfComp, r);
                int iNoOfCondProb = iRank * this._iNoOfComp;
                int i2 = 0;
                while (i2 < iNoOfCondProb) {
                    p.setAttribute(this.lettersWithin(i2, r), Double.toString(this._adP[r][i2 / this._iNoOfComp][i2 % iRank].getValue()));
                    ++i2;
                }
                ++r;
            }
            probability.addContent(p);
        }
        return probability;
    }

    public static Probability deserializeXML(int iNoOfLayers, Element owner) throws IllegalArgumentException, DataConversionException {
        Attribute noOfCompAttr;
        assert (iNoOfLayers > 1);
        Element input = owner.getChild("probability");
        if (input == null) {
            throw new IllegalArgumentException("Missing probability data");
        }
        int iR = 0;
        Element p = input.getChild("P");
        if (p != null) {
            int iLongest = 0;
            List lAttr = p.getAttributes();
            for (Attribute attr : lAttr) {
                iLongest = Math.max(iLongest, attr.getName().length());
            }
            if (iLongest > 0) {
                iR = iLongest - 1;
            }
        }
        if ((noOfCompAttr = input.getAttribute("no_of_comp")) != null && iNoOfLayers != noOfCompAttr.getIntValue()) {
            throw new IllegalArgumentException("Specified number of components does not correspond to the number of specified layers");
        }
        Attribute rAttr = input.getAttribute("R");
        if (rAttr != null && p == null && rAttr.getIntValue() > 0) {
            throw new IllegalArgumentException("Missing conditional probabilities P");
        }
        if (rAttr != null && iR != rAttr.getIntValue()) {
            throw new IllegalArgumentException("Specified Reichweite does not correspond to the provided conditional probabilities");
        }
        Probability probab = new Probability(iNoOfLayers, iR);
        Element w = input.getChild("W");
        if (w == null) {
            throw new IllegalArgumentException("Missing occurance probabilities W");
        }
        List lAttr = w.getAttributes();
        if (lAttr.size() == 0) {
            throw new IllegalArgumentException("Missing occurance probabilities W");
        }
        for (Attribute attr : lAttr) {
            String sName = attr.getName().toLowerCase();
            if (sName.length() != 1 || !Character.isLetter(sName.charAt(0))) {
                throw new IllegalArgumentException("Illegal name of occurance probability: " + sName);
            }
            int iValue = sName.charAt(0) - 97;
            if (iValue >= iNoOfLayers) {
                throw new IllegalArgumentException("This letter does not correspond number of layers: " + sName.charAt(0));
            }
            probab.setW(iValue, attr.getDoubleValue());
        }
        if (iR > 0) {
            lAttr = p.getAttributes();
            for (Attribute attr : lAttr) {
                int thisR = attr.getName().length() - 1;
                int iLettersValue = Probability.parseLetters(attr.getName().toLowerCase(), thisR, iNoOfLayers);
                int iRank = (int)Math.pow(iNoOfLayers, thisR);
                probab.setP(thisR, iLettersValue / iNoOfLayers, iLettersValue % iRank, attr.getDoubleValue(), true);
            }
        }
        probab.solve();
        return probab;
    }

    public boolean verify() {
        boolean bResult = this._w1Equation.verify();
        if (this._iR > 0) {
            int r = 1;
            while (r <= this._iR) {
                int i = 0;
                while (i < this._aPEquation[r].length) {
                    bResult &= this._aPEquation[r][i].verify();
                    ++i;
                }
                i = 0;
                while (i < this._aWEquation[r].length) {
                    bResult &= this._aWEquation[r][i].verify();
                    ++i;
                }
                ++r;
            }
        }
        return bResult;
    }

    private void createMatrices() {
        int i;
        int iRank = this._iNoOfComp;
        this._adW = new DoubleValue[this._iR + 1][];
        int r = 0;
        while (r <= this._iR) {
            this._adW[r] = new DoubleValue[iRank];
            if (r == 1) {
                i = 0;
                while (i < iRank) {
                    this._adW[r][i] = this._adW[0][i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < iRank) {
                    this._adW[r][i] = new DoubleValue(Double.NaN);
                    ++i;
                }
            }
            if (r > 0) {
                iRank *= this._iNoOfComp;
            }
            ++r;
        }
        iRank = this._iNoOfComp;
        this._adP = new DoubleValue[this._iR + 1][][];
        this._adP[0] = new DoubleValue[iRank][iRank];
        int k = 0;
        while (k < iRank) {
            i = 0;
            while (i < iRank) {
                this._adP[0][k][i] = this._adW[0][i];
                ++i;
            }
            ++k;
        }
        r = 1;
        while (r <= this._iR) {
            this._adP[r] = new DoubleValue[iRank][iRank];
            int k2 = 0;
            while (k2 < iRank) {
                int i2 = 0;
                while (i2 < iRank) {
                    this._adP[r][k2][i2] = new DoubleValue(Double.NaN);
                    ++i2;
                }
                ++k2;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
        this.resetMatrices();
    }

    public void resetMatrices() {
        int iRank = this._iNoOfComp;
        int r = 0;
        while (r <= this._iR) {
            if (r != 1) {
                int i = 0;
                while (i < iRank) {
                    this._adW[r][i].setValue(Double.NaN);
                    ++i;
                }
                if (r > 0) {
                    iRank *= this._iNoOfComp;
                }
            }
            ++r;
        }
        iRank = this._iNoOfComp;
        r = 1;
        while (r <= this._iR) {
            int k = 0;
            while (k < iRank) {
                int i = 0;
                while (i < iRank) {
                    this._adP[r][k][i].setValue(Double.NaN);
                    ++i;
                }
                ++k;
            }
            int iNoOfZeroGroups = iRank / this._iNoOfComp;
            if (iNoOfZeroGroups > 1) {
                int row = 0;
                while (row < iRank) {
                    int group = 0;
                    while (group < iNoOfZeroGroups) {
                        if (group != row % iNoOfZeroGroups) {
                            int col = 0;
                            while (col < this._iNoOfComp) {
                                this._adP[r][row][group * this._iNoOfComp + col].setValue(0.0);
                                ++col;
                            }
                        }
                        ++group;
                    }
                    ++row;
                }
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
        if (this._abPESolved != null && this._abWESolved != null) {
            int i = 1;
            while (i < this._abPESolved.length) {
                Arrays.fill(this._abPESolved[i], false);
                ++i;
            }
            i = 1;
            while (i < this._abWESolved.length) {
                Arrays.fill(this._abWESolved[i], false);
                ++i;
            }
        }
    }

    public boolean matches(Probability probab) {
        assert (this._iR > 0 && this._iR == probab._iR);
        assert (this._iNoOfComp <= probab._iNoOfComp);
        assert (this._iNoOfComp == 2 || this._iNoOfComp == 3);
        assert (probab._iNoOfComp >= 2 && probab._iNoOfComp <= 4);
        StringBuffer sbBuffer = new StringBuffer(300);
        sbBuffer.append("Verifying W matrices:").append(NEW_LINE);
        boolean bMatch = true;
        int i = 1;
        while (i <= this._iR) {
            double dProbabWillite;
            double dThisWillite = this._aIntermWTerms[i][0][1].getValue() * this._aIntermWTerms[i][0][0].getValue();
            boolean bMicroMatch = Math.abs(dThisWillite - (dProbabWillite = probab._aIntermWTerms[i][0][1].getValue() * probab._aIntermWTerms[i][0][0].getValue())) / dThisWillite < 0.2;
            sbBuffer.append("|(").append(dThisWillite).append(" - ").append(dProbabWillite).append(") / ").append(dThisWillite).append("|");
            if (bMicroMatch) {
                sbBuffer.append(" < ").append(20.0).append("%").append(NEW_LINE);
            } else {
                sbBuffer.append(" > ").append(20.0).append("%").append(" FAILED!!!").append(NEW_LINE);
            }
            bMatch &= bMicroMatch;
            ++i;
        }
        _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.probab.Probability", "matches", "*** comparying W matrices ***" + NEW_LINE + sbBuffer.toString());
        return bMatch;
    }

    private void createEquations() {
        int j;
        int i;
        DoubleValue[] w1Terms = new DoubleValue[this._iNoOfComp];
        int i2 = 0;
        while (i2 < this._iNoOfComp) {
            w1Terms[i2] = this._adW[0][i2];
            ++i2;
        }
        this._w1Equation = new AddEquation(w1Terms);
        this._aPEquation = new AddEquation[this._iR + 1][];
        this._abPESolved = new boolean[this._iR + 1][];
        int iRank = this._iNoOfComp;
        int r = 1;
        while (r <= this._iR) {
            this._aPEquation[r] = new AddEquation[iRank];
            this._abPESolved[r] = new boolean[iRank];
            i = 0;
            while (i < iRank) {
                int iStart = i * this._iNoOfComp % iRank;
                DoubleValue[] eqTerms = new DoubleValue[this._iNoOfComp];
                j = 0;
                while (j < this._iNoOfComp) {
                    eqTerms[j] = this._adP[r][i][iStart + j];
                    ++j;
                }
                this._aPEquation[r][i] = new AddEquation(eqTerms);
                ++i;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
        this._aWEquation = new MultEquation[this._iR + 1][];
        this._abWESolved = new boolean[this._iR + 1][];
        iRank = this._iNoOfComp;
        r = 1;
        while (r <= this._iR) {
            this._aWEquation[r] = new MultEquation[iRank];
            this._abWESolved[r] = new boolean[iRank];
            i = 0;
            while (i < iRank) {
                DoubleValue wTerm = this._adW[r][i];
                DoubleValue[][] aTerms = new DoubleValue[this._iNoOfComp][2];
                j = 0;
                while (j < this._iNoOfComp) {
                    aTerms[j][1] = this._adP[r][j * (iRank / this._iNoOfComp) + i / this._iNoOfComp][i];
                    aTerms[j][0] = this._adW[r][j * (iRank / this._iNoOfComp) + i / this._iNoOfComp];
                    ++j;
                }
                this._aWEquation[r][i] = new MultEquation(aTerms, wTerm);
                ++i;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
        this._aIntermWTerms = new DoubleValue[this._iR + 1][][];
        iRank = this._iNoOfComp * this._iNoOfComp;
        r = 1;
        while (r <= this._iR) {
            this._aIntermWTerms[r] = new DoubleValue[iRank][2];
            i = 0;
            while (i < iRank) {
                this._aIntermWTerms[r][i][0] = this._adW[r][i / this._iNoOfComp];
                this._aIntermWTerms[r][i][1] = this._adP[r][i / this._iNoOfComp][i % (iRank / this._iNoOfComp)];
                ++i;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
    }

    public String getW0EquationString() {
        return this._w1EquationString;
    }

    public String getW0EquationValuesString() {
        return this._w1Equation.toString();
    }

    public boolean isW0Solved() {
        return this._w1Equation.verify();
    }

    public String[][] getPEquationString() {
        return this._aPEquationString;
    }

    public String getPEquationValuesString(int iR, int iIndex) {
        return this._aPEquation[iR][iIndex].toString();
    }

    public boolean isPEquationSolved(int iR, int iIndex) {
        return this._aPEquation[iR][iIndex].verify();
    }

    public String[][] getWEquationString() {
        return this._aWEquationString;
    }

    public String getWEquationValuesString(int iR, int iIndex) {
        return this._aWEquation[iR][iIndex].toString();
    }

    public boolean isWEquationSolved(int iR, int iIndex) {
        return this._aWEquation[iR][iIndex].verify();
    }

    public Degree getDegree() {
        double dD = Double.NaN;
        double dS = Double.NaN;
        double dTwoThird = 0.6666666666666666;
        if (this.verify()) {
            double dAllowedError = 1.0E-8;
            switch (this._iR) {
                case 0: {
                    dD = 1.0;
                    break;
                }
                case 1: {
                    double dWa = this._adW[0][0].getValue();
                    double dPaa = this._adP[1][0][0].getValue();
                    double dLimit = (2.0 * dWa - 1.0) / dWa;
                    if (Math.abs(dWa) < dAllowedError || Math.abs(dWa - 1.0) < dAllowedError) {
                        dS = 1.0;
                        break;
                    }
                    if (dWa >= 0.5 && dPaa >= dLimit && dPaa <= dWa) {
                        dD = (1.0 + dWa * (dPaa - 2.0)) / (1.0 - dWa) / (1.0 - dWa);
                        break;
                    }
                    if (dWa <= 0.5 && dPaa <= dWa) {
                        assert (dPaa >= 0.0 - dAllowedError) : "Paa is negative: " + dPaa;
                        dD = dPaa / dWa;
                        break;
                    }
                    if (!(dPaa >= dWa)) break;
                    assert (dPaa <= 1.0 + dAllowedError) : "Paa is greater than 1: " + dPaa;
                    dS = (dPaa - dWa) / (1.0 - dWa);
                    break;
                }
                case 2: {
                    boolean bCannotCalc = this._adP[1][1][1].getValue() != 0.0;
                    bCannotCalc |= this._iNoOfComp > 2 && (this._adP[1][1][2].getValue() != 0.0 || this._adP[1][2][1].getValue() != 0.0 || this._adP[1][2][2].getValue() != 0.0);
                    if (bCannotCalc |= this._iNoOfComp == 4 && (this._adP[1][1][3].getValue() != 0.0 || this._adP[1][3][1].getValue() != 0.0 || this._adP[1][3][3].getValue() != 0.0 || this._adP[1][2][3].getValue() != 0.0 || this._adP[1][3][2].getValue() != 0.0)) break;
                    double dWa = this._adW[0][0].getValue();
                    assert (dWa >= 0.5 - dAllowedError) : "Precondition Wa>=0.5 failed: " + dWa;
                    double dWb = 1.0 - dWa;
                    double dPaaa = this._adP[2][0][0].getValue();
                    double dLimit = (dWa - dWb) / dWa;
                    if (dWa >= dTwoThird && dPaaa >= dTwoThird && dPaaa <= dLimit) {
                        assert (dWa <= 1.0 + dAllowedError) : "Wa is greater than 1: " + dWa;
                        dD = dWa / dWb * (1.0 - (dWa - dWb) / dWb * (1.0 - dPaaa));
                        break;
                    }
                    if (dWa > 0.5 && dWa <= dTwoThird && dPaaa <= dLimit) {
                        assert (dPaaa >= 0.0 - dAllowedError) : "Paaa is negative: " + dPaaa;
                        dD = dWa / (dWa - dWb) * dPaaa;
                        break;
                    }
                    if (!(dPaaa >= dLimit)) break;
                    assert (dPaaa <= 1.0 + dAllowedError) : "Paaa is greater than 1: " + dPaaa;
                    dS = (1.0 - 2.0 * dWa + dWa * dPaaa) / (1.0 - dWa);
                    break;
                }
                case 3: {
                    if (this._adP[1][1][1].getValue() != 0.0 || this._adP[2][2][1].getValue() != 0.0) break;
                    double dWa = this._adW[0][0].getValue();
                    double dWb = this._adW[0][1].getValue();
                    assert (dWa >= 0.6666666666666666 - dAllowedError) : "Precondition Wa>=2/3 failed: " + dWa;
                    double dPaaaa = this._adP[3][0][0].getValue();
                    double dPbaab = this._adP[3][4][1].getValue();
                    double dLimit1 = dWb / (dWa - dWb);
                    double dLimit2 = (dWa - 2.0 * dWb) / (dWa - dWb);
                    if (dWa >= 0.75 && dPbaab <= dLimit1) {
                        assert (dPbaab >= 0.0 - dAllowedError) : "Pbaab is negative: " + dPbaab;
                        dD = (dWa - dWb) / dWb * dPbaab;
                        break;
                    }
                    if (dWa <= 0.75 && dPaaaa <= dLimit2) {
                        assert (dPaaaa >= 0.0 - dAllowedError) : "Paaaa is negative: " + dPaaaa;
                        dD = (dWa - dWb) * dPaaaa / (dWa - 2.0 * dWb);
                        break;
                    }
                    if (!(dPbaab > dLimit1)) break;
                    assert (dPbaab <= 1.0 + dAllowedError) : "Pbaab is greater than 1: " + dPbaab;
                    dS = 1.0 - (1.0 - dPbaab) / (1.0 - dWb / (dWa - dWb));
                }
            }
        }
        return new Degree(dD, dS);
    }

    public void createEquationStrings() {
        int i;
        StringBuffer sbW1 = new StringBuffer(20);
        int i2 = 0;
        while (i2 < this._iNoOfComp) {
            sbW1.append("W").append(this.lettersOutside(i2, 0));
            if (i2 < this._iNoOfComp - 1) {
                sbW1.append(" + ");
            }
            ++i2;
        }
        this._w1EquationString = sbW1.append(" = 1").toString();
        this._aPEquationString = new String[this._iR + 1][];
        int iRank = this._iNoOfComp;
        int r = 1;
        while (r <= this._iR) {
            this._aPEquationString[r] = new String[iRank];
            i = 0;
            while (i < iRank) {
                int iStart = i * this._iNoOfComp;
                StringBuffer sbP = new StringBuffer(30);
                int j = 0;
                while (j < this._iNoOfComp) {
                    sbP.append("P").append(this.lettersWithin(iStart + j, r));
                    if (j < this._iNoOfComp - 1) {
                        sbP.append(" + ");
                    }
                    ++j;
                }
                this._aPEquationString[r][i] = sbP.append(" = 1").toString();
                ++i;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
        this._aWEquationString = new String[this._iR + 1][];
        iRank = this._iNoOfComp;
        r = 1;
        while (r <= this._iR) {
            this._aWEquationString[r] = new String[iRank];
            i = 0;
            while (i < iRank) {
                StringBuffer sbW = new StringBuffer(40);
                sbW.append("W").append(this.lettersOutside(i, r)).append(" = ");
                int j = 0;
                while (j < this._iNoOfComp) {
                    sbW.append("W").append(this.lettersOutside((i + j * iRank) / this._iNoOfComp, r));
                    sbW.append("P").append(this.lettersWithin(i + j * iRank, r));
                    if (j < this._iNoOfComp - 1) {
                        sbW.append(" + ");
                    }
                    ++j;
                }
                this._aWEquationString[r][i] = sbW.toString();
                ++i;
            }
            iRank *= this._iNoOfComp;
            ++r;
        }
    }

    private boolean allNumbers(int iR) {
        boolean bResult = true;
        int iRank = (int)Math.pow(this._iNoOfComp, iR);
        int i = 0;
        while (i < iRank) {
            bResult &= !Double.isNaN(this._adW[iR][i].getValue());
            int k = 0;
            while (k < iRank) {
                bResult &= !Double.isNaN(this._adP[iR][i][k].getValue());
                ++k;
            }
            ++i;
        }
        return bResult;
    }

    protected String letter(int i) {
        int index = 97 + i;
        char[] letter = new char[]{(char)index};
        return new String(letter);
    }

    public String lettersWithin(int value, int iR) {
        iR = iR == 0 ? 1 : iR;
        return this.letters(value, iR);
    }

    public String lettersOutside(int value, int iR) {
        iR = iR == 0 ? 0 : iR - 1;
        return this.letters(value, iR);
    }

    protected String letters(int value, int iR) {
        int iNoOfLetters = iR + 1;
        char[] letters = new char[iNoOfLetters];
        int i = 0;
        while (i < iNoOfLetters) {
            int iLetterWeight = (int)Math.pow(this._iNoOfComp, iR - i);
            int iNumber = value / iLetterWeight;
            letters[i] = (char)(97 + iNumber);
            value -= iNumber * iLetterWeight;
            ++i;
        }
        return new String(letters);
    }

    protected static int parseLetters(String letters, int iR, int iNoOfComp) {
        int iTotal = 0;
        int i = 0;
        while (i < letters.length()) {
            int iLetterWeight = (int)Math.pow(iNoOfComp, iR - i);
            if (!Character.isLetter(letters.charAt(i))) {
                throw new IllegalArgumentException("Illegal name: " + letters);
            }
            int iValue = letters.charAt(i) - 97;
            if (iValue >= iNoOfComp) {
                throw new IllegalArgumentException("Letters do not correspond to the number of specified layers");
            }
            iTotal += iValue * iLetterWeight;
            ++i;
        }
        return iTotal;
    }

    public void copyInto(Probability target) {
        int k;
        if (target._iR != this._iR || target._iNoOfComp != this._iNoOfComp) {
            throw new IllegalArgumentException("Matrices do not match");
        }
        int i = 0;
        while (i < this._adW.length) {
            k = 0;
            while (k < this._adW[i].length) {
                target._adW[i][k].setValue(this._adW[i][k].getValue());
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this._adP.length) {
            k = 0;
            while (k < this._adP[i].length) {
                int j = 0;
                while (j < this._adP[i][k].length) {
                    target._adP[i][k][j].setValue(this._adP[i][k][j].getValue());
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public boolean matches(Probability target, double dMaxError) {
        int k;
        if (target._iR != this._iR || target._iNoOfComp != this._iNoOfComp) {
            throw new IllegalArgumentException("Matrices do not match");
        }
        boolean bMatches = true;
        int i = 0;
        while (i < this._adW.length) {
            k = 0;
            while (k < this._adW[i].length) {
                bMatches &= Math.abs(target._adW[i][k].getValue() - this._adW[i][k].getValue()) <= dMaxError;
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this._adP.length) {
            k = 0;
            while (k < this._adP[i].length) {
                int j = 0;
                while (j < this._adP[i][k].length) {
                    bMatches &= Math.abs(target._adP[i][k][j].getValue() - this._adP[i][k][j].getValue()) <= dMaxError;
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        return bMatches;
    }

    private double roundOut(double number, int precision) {
        int rounded = (int)Math.round(number * Math.pow(10.0, precision));
        return (double)rounded / Math.pow(10.0, precision);
    }

    public String toString() {
        StringBuffer sbMatrix = new StringBuffer();
        sbMatrix.append("components: ").append(this._iNoOfComp).append(", R").append(this._iR).append('\n');
        sbMatrix.append("W [");
        int i = 0;
        while (i < this._adW[0].length) {
            sbMatrix.append(this.roundOut(this._adW[0][i].getValue(), 4));
            if (i < this._adW[0].length - 1) {
                sbMatrix.append(", ");
            }
            ++i;
        }
        sbMatrix.append("]\nP[");
        i = 0;
        while (i < this._adP[this._iR].length) {
            int j = 0;
            while (j < this._adP[this._iR][i].length) {
                sbMatrix.append(this.roundOut(this._adP[this._iR][i][j].getValue(), 4));
                if (j < this._adP[this._iR][i].length - 1) {
                    sbMatrix.append(", ");
                }
                ++j;
            }
            if (i < this._adP[this._iR].length - 1) {
                sbMatrix.append('\n');
            } else {
                sbMatrix.append("]\n");
            }
            ++i;
        }
        return sbMatrix.toString();
    }

    public class Degree
    implements Serializable {
        private static final long serialVersionUID = -7973430034529557959L;
        private double _dD = Double.NaN;
        private double _dS = Double.NaN;

        public Degree(double dD, double dS) {
            this._dD = dD;
            this._dS = dS;
        }

        public double getD() {
            return this._dD;
        }

        public double getS() {
            return this._dS;
        }
    }
}

