/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gene.ModGene;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.ProbabCondition20;
import net.ndmystko.xrd.mod.probab.ProbabCondition21;
import net.ndmystko.xrd.mod.probab.ProbabCondition22;
import net.ndmystko.xrd.mod.probab.ProbabCondition23;
import net.ndmystko.xrd.mod.probab.ProbabCondition30;
import net.ndmystko.xrd.mod.probab.ProbabCondition31;
import net.ndmystko.xrd.mod.probab.ProbabCondition32;
import net.ndmystko.xrd.mod.probab.ProbabCondition40;
import net.ndmystko.xrd.mod.probab.ProbabCondition41;

public class ProbabJUTest
extends TestCase {
    private static final int MODIFICATION_COUNT = 10000;

    public ProbabJUTest(String sMethodName) {
        super(sMethodName);
    }

    public void test20() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(2, 0);
        ProbabJUTest.assertTrue((probab.getR() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.25);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.75, (double)probab.getP(1, 0), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition20 refMatrix = new ProbabCondition20();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void test30() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(3, 0);
        ProbabJUTest.assertTrue((probab.getR() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 3 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.25);
        probab.setW(2, 0.35);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.25, (double)probab.getP(1, 1), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.4, (double)probab.getP(2, 0), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition30 refMatrix = new ProbabCondition30();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void test40() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(4, 0);
        ProbabJUTest.assertTrue((probab.getR() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 4 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.25);
        probab.setW(2, 0.35);
        probab.setW(3, 0.05);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.25, (double)probab.getP(1, 1), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.35, (double)probab.getP(2, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.05, (double)probab.getP(2, 3), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition40 refMatrix = new ProbabCondition40();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void test21() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(2, 1);
        ProbabJUTest.assertTrue((probab.getR() == 1 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.25);
        probab.setP(1, 1, 1, 0.4);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.8, (double)probab.getP(1, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.15, (double)probab.getW(2, 1), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition21 refMatrix = new ProbabCondition21();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void test31() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(3, 1);
        ProbabJUTest.assertTrue((probab.getR() == 1 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 3 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.2);
        probab.setW(2, 0.1);
        probab.setP(1, 1, 1, 0.2);
        probab.setP(1, 2, 1, 0.15);
        probab.setP(1, 1, 2, 0.15);
        probab.setP(1, 2, 2, 0.1);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.7071, (double)probab.getP(1, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.0857, (double)probab.getP(1, 0, 2), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.145, (double)probab.getW(2, 1), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition31 refMatrix = new ProbabCondition31();
        int iFailedCount = 0;
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            double dOrigValue = aGenes[iSelectedGene].getValue();
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            if (!probab.updateProbability()) {
                ++iFailedCount;
                aGenes[iSelectedGene].setValue(dOrigValue);
            } else {
                probab.copyInto(refMatrix);
                ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
                ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            }
            probab.getDegree();
            ++i;
        }
        double dFailRatio = (double)iFailedCount / 10000.0 * 100.0;
        System.out.println("case 3-comp R1: failed " + dFailRatio + '%');
        ProbabJUTest.assertTrue((dFailRatio < 50.0 ? 1 : 0) != 0);
    }

    public void test41() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(4, 1);
        ProbabJUTest.assertTrue((probab.getR() == 1 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 4 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.3);
        probab.setW(2, 0.2);
        probab.setW(3, 0.1);
        probab.setP(1, 1, 1, 0.3);
        probab.setP(1, 2, 1, 0.2);
        probab.setP(1, 1, 2, 0.2);
        probab.setP(1, 1, 3, 0.1);
        probab.setP(1, 2, 2, 0.1);
        probab.setP(1, 3, 1, 0.1);
        probab.setP(1, 2, 3, 0.05);
        probab.setP(1, 3, 2, 0.05);
        probab.setP(1, 3, 3, 0.0);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.1625, (double)probab.getP(1, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.2875, (double)probab.getP(1, 0, 2), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.65, (double)probab.getP(1, 2, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.16, (double)probab.getW(2, 1), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.115, (double)probab.getW(2, 2), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition41 refMatrix = new ProbabCondition41();
        int iFailedCount = 0;
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            double dOrigValue = aGenes[iSelectedGene].getValue();
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            if (!probab.updateProbability()) {
                ++iFailedCount;
                aGenes[iSelectedGene].setValue(dOrigValue);
            } else {
                probab.copyInto(refMatrix);
                ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
                ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            }
            probab.getDegree();
            ++i;
        }
        double dFailRatio = (double)iFailedCount / 10000.0 * 100.0;
        System.out.println("case 4-comp R1: failed " + dFailRatio + '%');
        ProbabJUTest.assertTrue((dFailRatio < 50.0 ? 1 : 0) != 0);
    }

    public void test22() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(2, 2);
        ProbabJUTest.assertTrue((probab.getR() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.2);
        probab.setP(1, 1, 1, 0.0, true);
        probab.setP(2, 2, 1, 0.3);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.7667, (double)probab.getP(2, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.46, (double)probab.getW(3, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.14, (double)probab.getW(3, 4), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition22 refMatrix = new ProbabCondition22();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void test32() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(3, 2);
        ProbabJUTest.assertTrue((probab.getR() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 3 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.2);
        probab.setW(2, 0.1);
        probab.setP(1, 1, 1, 0.0, true);
        probab.setP(1, 2, 1, 0.0, true);
        probab.setP(1, 1, 2, 0.0, true);
        probab.setP(1, 2, 2, 0.0, true);
        probab.setP(2, 3, 1, 0.5);
        probab.setP(2, 3, 2, 0.2);
        probab.setP(2, 6, 1, 0.5);
        probab.setP(2, 6, 2, 0.2);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.775, (double)probab.getP(2, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.1001, (double)probab.getP(2, 0, 2), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.05, (double)probab.getW(3, 1), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition32 refMatrix = new ProbabCondition32();
        int iFailedCount = 0;
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            double dOrigValue = aGenes[iSelectedGene].getValue();
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            if (!probab.updateProbability()) {
                ++iFailedCount;
                aGenes[iSelectedGene].setValue(dOrigValue);
            } else {
                probab.copyInto(refMatrix);
                ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
                ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            }
            probab.getDegree();
            ++i;
        }
        double dFailRatio = (double)iFailedCount / 10000.0 * 100.0;
        System.out.println("case 3-comp R2: failed " + dFailRatio + '%');
        ProbabJUTest.assertTrue((dFailRatio < 50.0 ? 1 : 0) != 0);
    }

    public void test23() {
        AbstractProbabCondition probab = AbstractProbabCondition.getMatrix(2, 3);
        ProbabJUTest.assertTrue((probab.getR() == 3 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((probab.getNoOfComp() == 2 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.updateProbability());
        probab.resetMatrices();
        probab.setW(1, 0.1);
        probab.setP(1, 1, 1, 0.0);
        probab.setP(2, 1, 3, 0.0);
        probab.setP(2, 3, 2, 0.0);
        probab.setP(2, 2, 1, 0.0);
        probab.setP(3, 7, 7, 0.0);
        probab.setP(3, 6, 5, 0.0);
        probab.setP(3, 5, 3, 0.0);
        probab.setP(3, 4, 1, 0.9);
        ProbabJUTest.assertTrue((probab.solve() == 0 ? 1 : 0) != 0);
        ProbabJUTest.assertTrue((boolean)probab.verify());
        ProbabJUTest.assertEquals((double)0.9857, (double)probab.getP(3, 0, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.69, (double)probab.getW(4, 0), (double)1.0E-4);
        ProbabJUTest.assertEquals((double)0.1, (double)probab.getW(4, 4), (double)1.0E-4);
        ModGene[] aGenes = this.grabGenes(probab);
        ProbabCondition23 refMatrix = new ProbabCondition23();
        int i = 0;
        while (i < 10000) {
            int iSelectedGene = (int)(Math.random() * (double)aGenes.length);
            aGenes[iSelectedGene].mutate((double)i / 10000.0);
            ProbabJUTest.assertTrue((boolean)probab.updateProbability());
            probab.getDegree();
            probab.copyInto(refMatrix);
            ProbabJUTest.assertTrue((boolean)probab.setGenesFor(refMatrix));
            ProbabJUTest.assertTrue((boolean)probab.matches(refMatrix, 1.0E-6));
            ++i;
        }
    }

    public void testR0() {
        ProbabCondition20 probab2 = new ProbabCondition20();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabCondition30 probab3 = new ProbabCondition30();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        ProbabCondition40 probab4 = new ProbabCondition40();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
        ModGene wa2Gene = probab2.getWAConnector().getGene();
        ModGene wa3Gene = probab3.getWAConnector().getGene();
        ModGene wa4Gene = probab4.getWAConnector().getGene();
        wa3Gene.setValue(wa2Gene.getValue());
        wa4Gene.setValue(wa2Gene.getValue());
        int i = 0;
        while (i < 10000) {
            wa2Gene.mutate((double)i / 10000.0);
            wa3Gene.setValue(wa2Gene.getValue());
            wa4Gene.setValue(wa2Gene.getValue());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
            ProbabJUTest.assertEquals((double)probab2.getW(1, 0), (double)probab3.getW(1, 0), (double)1.0E-8);
            ProbabJUTest.assertEquals((double)probab2.getW(1, 0), (double)probab4.getW(1, 0), (double)1.0E-8);
            ++i;
        }
        ModGene[] aGenes3 = this.grabGenes(probab3);
        ModGene[] aGenes4 = this.grabGenes(probab4);
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
        int i2 = 0;
        while (i2 < 10000) {
            int iSelectedGene;
            if (Math.random() < 0.5) {
                while (aGenes3[iSelectedGene = (int)(Math.random() * (double)aGenes3.length)] == wa3Gene) {
                }
                aGenes3[iSelectedGene].mutate((double)i2 / 10000.0);
                ((AbstractProbabCondition)probab3).updateProbability();
                ProbabJUTest.assertEquals((double)probab2.getW(1, 0), (double)probab3.getW(1, 0), (double)1.0E-8);
            } else {
                while (aGenes4[iSelectedGene = (int)(Math.random() * (double)aGenes4.length)] == wa4Gene) {
                }
                aGenes4[iSelectedGene].mutate((double)i2 / 10000.0);
                ((AbstractProbabCondition)probab4).updateProbability();
                ProbabJUTest.assertEquals((double)probab2.getW(1, 0), (double)probab4.getW(1, 0), (double)1.0E-8);
            }
            ++i2;
        }
    }

    public void testR1() {
        ProbabCondition21 probab2 = new ProbabCondition21();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabCondition31 probab3 = new ProbabCondition31();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        ProbabCondition41 probab4 = new ProbabCondition41();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
        ModGene wa2Gene = probab2.getWAConnector().getGene();
        ModGene wa3Gene = probab3.getWAConnector().getGene();
        ModGene wa4Gene = probab4.getWAConnector().getGene();
        ModGene p2Gene = probab2.getPControlConnector().getGene();
        ModGene p3Gene = probab3.getPControlConnector().getGene();
        ModGene p4Gene = probab4.getPControlConnector().getGene();
        wa3Gene.setValue(wa2Gene.getValue());
        p3Gene.setValue(p2Gene.getValue());
        wa4Gene.setValue(wa2Gene.getValue());
        p4Gene.setValue(p2Gene.getValue());
        int i = 0;
        while (i < 10000) {
            if (Math.random() < 0.5) {
                wa2Gene.mutate((double)i / 10000.0);
                wa3Gene.setValue(wa2Gene.getValue());
                wa4Gene.setValue(wa2Gene.getValue());
            } else {
                p2Gene.mutate((double)i / 10000.0);
                p3Gene.setValue(p2Gene.getValue());
                p4Gene.setValue(p2Gene.getValue());
            }
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
            ProbabJUTest.assertEquals((double)probab2.getW(2, 0), (double)probab3.getW(2, 0), (double)1.0E-8);
            ProbabJUTest.assertEquals((double)probab2.getW(2, 0), (double)probab4.getW(2, 0), (double)1.0E-8);
            ++i;
        }
        ModGene[] aGenes3 = this.grabGenes(probab3);
        ModGene[] aGenes4 = this.grabGenes(probab4);
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab4).updateProbability());
        int iFailed3Count = 0;
        int iFailed4Count = 0;
        int i2 = 0;
        while (i2 < 10000) {
            double dGeneValue;
            int iSelectedGene;
            if (Math.random() < 0.5) {
                while (aGenes3[iSelectedGene = (int)(Math.random() * (double)aGenes3.length)] == wa3Gene || aGenes3[iSelectedGene] == p3Gene) {
                }
                dGeneValue = aGenes3[iSelectedGene].getValue();
                aGenes3[iSelectedGene].mutate((double)i2 / 10000.0);
                ((AbstractProbabCondition)probab2).updateProbability();
                if (((AbstractProbabCondition)probab3).updateProbability()) {
                    ProbabJUTest.assertEquals((double)probab2.getW(2, 0), (double)probab3.getW(2, 0), (double)1.0E-8);
                } else {
                    aGenes3[iSelectedGene].setValue(dGeneValue);
                    ++iFailed3Count;
                }
            } else {
                while (aGenes4[iSelectedGene = (int)(Math.random() * (double)aGenes4.length)] == wa4Gene || aGenes4[iSelectedGene] == p4Gene) {
                }
                dGeneValue = aGenes4[iSelectedGene].getValue();
                aGenes4[iSelectedGene].mutate((double)i2 / 10000.0);
                if (((AbstractProbabCondition)probab4).updateProbability()) {
                    ProbabJUTest.assertEquals((double)probab2.getW(2, 0), (double)probab4.getW(2, 0), (double)1.0E-8);
                } else {
                    aGenes4[iSelectedGene].setValue(dGeneValue);
                    ++iFailed4Count;
                }
            }
            ++i2;
        }
        System.out.println("Mutating only non-common genes caused R1 3-comp failure: " + (double)iFailed3Count / 10000.0 * 100.0 + '%');
        System.out.println("Mutating only non-common genes caused R1 4-comp failure: " + (double)iFailed4Count / 10000.0 * 100.0 + '%');
    }

    public void testR2() {
        ProbabCondition22 probab2 = new ProbabCondition22();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabCondition32 probab3 = new ProbabCondition32();
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        ModGene wa2Gene = probab2.getWAConnector().getGene();
        ModGene wa3Gene = probab3.getWAConnector().getGene();
        ModGene p2Gene = probab2.getPControlConnector().getGene();
        ModGene p3Gene = probab3.getPControlConnector().getGene();
        wa3Gene.setValue(wa2Gene.getValue());
        p3Gene.setValue(p2Gene.getValue());
        int i = 0;
        while (i < 10000) {
            if (Math.random() < 0.5) {
                wa2Gene.mutate((double)i / 10000.0);
                wa3Gene.setValue(wa2Gene.getValue());
            } else {
                p2Gene.mutate((double)i / 10000.0);
                p3Gene.setValue(p2Gene.getValue());
            }
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
            ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
            ProbabJUTest.assertEquals((double)probab2.getW(2, 0), (double)probab3.getW(2, 0), (double)1.0E-8);
            ++i;
        }
        ModGene[] aGenes3 = this.grabGenes(probab3);
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab2).updateProbability());
        ProbabJUTest.assertTrue((boolean)((AbstractProbabCondition)probab3).updateProbability());
        int iFailed3Count = 0;
        int i2 = 0;
        while (i2 < 10000) {
            int iSelectedGene;
            while (aGenes3[iSelectedGene = (int)(Math.random() * (double)aGenes3.length)] == wa3Gene || aGenes3[iSelectedGene] == p3Gene) {
            }
            double dGeneValue = aGenes3[iSelectedGene].getValue();
            aGenes3[iSelectedGene].mutate((double)i2 / 10000.0);
            if (((AbstractProbabCondition)probab3).updateProbability()) {
                ProbabJUTest.assertEquals((double)probab2.getW(3, 0), (double)probab3.getW(3, 0), (double)1.0E-8);
            } else {
                aGenes3[iSelectedGene].setValue(dGeneValue);
                ++iFailed3Count;
            }
            ++i2;
        }
        System.out.println("Mutating only non-common genes caused R2 3-comp failure: " + (double)iFailed3Count / 10000.0 * 100.0 + '%');
    }

    private ModGene[] grabGenes(AbstractProbabCondition probab) {
        ArrayList alConnectors = new ArrayList(15);
        probab.addConnectors(alConnectors, false, true);
        ModGene[] aGenes = new ModGene[alConnectors.size()];
        int i = 0;
        while (i < aGenes.length) {
            aGenes[i] = ((GeneConnector)alConnectors.get(i)).getGene();
            ++i;
        }
        return aGenes;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ProbabJUTest("test20"));
        suite.addTest((Test)new ProbabJUTest("test30"));
        suite.addTest((Test)new ProbabJUTest("test40"));
        suite.addTest((Test)new ProbabJUTest("test21"));
        suite.addTest((Test)new ProbabJUTest("test31"));
        suite.addTest((Test)new ProbabJUTest("test41"));
        suite.addTest((Test)new ProbabJUTest("test22"));
        suite.addTest((Test)new ProbabJUTest("test32"));
        suite.addTest((Test)new ProbabJUTest("test23"));
        suite.addTest((Test)new ProbabJUTest("testR0"));
        suite.addTest((Test)new ProbabJUTest("testR1"));
        suite.addTest((Test)new ProbabJUTest("testR2"));
        return suite;
    }

    public static void main(String[] argv) throws Exception {
        ProbabJUTest test = new ProbabJUTest("testR2");
        test.test22();
        test.testR2();
    }
}

