/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition41
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 4792693446257880582L;
    private static final int NO_OF_COMP = 4;
    private static final int R = 1;
    private static final int WA_ID = 0;
    private static final int W_RATIO_B_CD_ID = 1;
    private static final int W_RATIO_C_D_ID = 2;
    private static final int PAA_OR_PBB_ID = 3;
    private static final int WB_RATIO_ID = 4;
    private static final int WB_RATIO_B_CD_ID = 5;
    private static final int WB_RATIO_B_C_ID = 6;
    private static final int WC_RATIO_ID = 7;
    private static final int WC_RATIO_B_CD_ID = 8;
    private static final int WC_RATIO_B_C_ID = 9;
    private static final int WD_RATIO_B_CD_ID = 10;
    private static final int WD_RATIO_C_D_ID = 11;
    private static final double[] LOW_LIMIT = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] DEFAULT = new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0};

    public ProbabCondition41() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition41(double dWiLow, double dWiHigh) {
        super(4, 1);
        this._aConnectors = new GeneConnector[12];
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aConnectors[i] = new GeneConnector(LOW_LIMIT[i], HIGH_LIMIT[i], DEFAULT[i], DECAY_CONST[i]);
            ++i;
        }
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[1].getGene().setName("Wb/(Wb+Wc+Wd)");
        this._aConnectors[2].getGene().setName("Wc/(Wc+Wd)");
        this._aConnectors[3].getGene().setName("Paa(Wa<0.5) or PBB(Wa>0.5)");
        this._aConnectors[4].getGene().setName("(Wbb+Wbc+Wbd)/WBB");
        this._aConnectors[5].getGene().setName("Wbb/(Wbb+Wbc+Wbd)");
        this._aConnectors[6].getGene().setName("Wbc/(Wbc+Wbd)");
        this._aConnectors[7].getGene().setName("(Wcb+Wcc+Wcd)/(Wcb+Wcc+Wcd+Wdb+Wdc+Wdd)");
        this._aConnectors[8].getGene().setName("Wcb/(Wcb+Wcc+Wcd)");
        this._aConnectors[9].getGene().setName("Wcc/(Wcc+Wcd)");
        this._aConnectors[10].getGene().setName("Wdb/(Wdb+Wdc+Wdd)");
        this._aConnectors[11].getGene().setName("Wdc/(Wdc+Wdd)");
        this._iWaConnId = 0;
        this._iPControlConnId = 3;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        double dWa = this._aConnectors[0].getValue();
        double dWb = (1.0 - dWa) * this._aConnectors[1].getValue();
        double dWc = (1.0 - dWa) * (1.0 - this._aConnectors[1].getValue()) * this._aConnectors[2].getValue();
        double dWd = (1.0 - dWa) * (1.0 - this._aConnectors[1].getValue()) * (1.0 - this._aConnectors[2].getValue());
        this.setW(1, dWb);
        this.setW(2, dWc);
        this.setW(3, dWd);
        double dWBB = 0.0;
        double dWB = dWb + dWc + dWd;
        dWBB = dWa < 0.5 ? dWB * (dWB - dWa * (1.0 - this._aConnectors[3].getValue())) / dWB : dWB * this._aConnectors[3].getValue();
        double dWbTotal = dWBB * this._aConnectors[4].getValue();
        double dWbb = dWbTotal * this._aConnectors[5].getValue();
        double dWbc = dWbTotal * (1.0 - this._aConnectors[5].getValue()) * this._aConnectors[6].getValue();
        double dWbd = dWbTotal * (1.0 - this._aConnectors[5].getValue()) * (1.0 - this._aConnectors[6].getValue());
        double dWcTotal = (dWBB - dWbTotal) * this._aConnectors[4].getValue();
        double dWcb = dWcTotal * this._aConnectors[8].getValue();
        double dWcc = dWcTotal * (1.0 - this._aConnectors[8].getValue()) * this._aConnectors[9].getValue();
        double dWcd = dWcTotal * (1.0 - this._aConnectors[8].getValue()) * (1.0 - this._aConnectors[9].getValue());
        double dWdTotal = dWBB - dWbTotal - dWcTotal;
        double dWdb = dWdTotal * this._aConnectors[10].getValue();
        double dWdc = dWdTotal * (1.0 - this._aConnectors[10].getValue()) * this._aConnectors[11].getValue();
        double dWdd = dWdTotal * (1.0 - this._aConnectors[10].getValue()) * (1.0 - this._aConnectors[11].getValue());
        if (dWb == 0.0 && (dWbb != 0.0 || dWbc != 0.0 || dWbd != 0.0) || dWc == 0.0 && (dWcb != 0.0 || dWcc != 0.0 || dWcd != 0.0) || dWd == 0.0 && (dWdb != 0.0 || dWdc != 0.0 || dWdd != 0.0)) {
            return false;
        }
        this.setP(1, 1, 1, dWb == 0.0 ? 0.0 : dWbb / dWb);
        this.setP(1, 1, 2, dWb == 0.0 ? 0.0 : dWbc / dWb);
        this.setP(1, 1, 3, dWb == 0.0 ? 0.0 : dWbd / dWb);
        this.setP(1, 2, 1, dWc == 0.0 ? 0.0 : dWcb / dWc);
        this.setP(1, 2, 2, dWc == 0.0 ? 0.0 : dWcc / dWc);
        this.setP(1, 2, 3, dWc == 0.0 ? 0.0 : dWcd / dWc);
        this.setP(1, 3, 1, dWd == 0.0 ? 0.0 : dWdb / dWd);
        this.setP(1, 3, 2, dWd == 0.0 ? 0.0 : dWdc / dWd);
        this.setP(1, 3, 3, dWd == 0.0 ? 0.0 : dWdd / dWd);
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.setGeneValue(0, probab.getW0(0));
        this.setGeneValue(1, probab.getW0(1) / (probab.getW0(1) + probab.getW0(2) + probab.getW0(3)));
        this.setGeneValue(2, probab.getW0(2) / (probab.getW0(2) + probab.getW0(3)));
        double dWBB = probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc")) + probab.getW(2, this.toIndex("bd")) + probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc")) + probab.getW(2, this.toIndex("cd")) + probab.getW(2, this.toIndex("db")) + probab.getW(2, this.toIndex("dc")) + probab.getW(2, this.toIndex("dd"));
        if (probab.getW0(0) < 0.5) {
            this.setGeneValue(3, probab.getP(1, 0, 0));
        } else {
            this.setGeneValue(3, dWBB / (probab.getW0(1) + probab.getW0(2) + probab.getW0(3)));
        }
        this.setGeneValue(4, (probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc")) + probab.getW(2, this.toIndex("bd"))) / dWBB);
        this.setGeneValue(5, probab.getW(2, this.toIndex("bb")) / (probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc")) + probab.getW(2, this.toIndex("bd"))));
        this.setGeneValue(6, probab.getW(2, this.toIndex("bc")) / (probab.getW(2, this.toIndex("bc")) + probab.getW(2, this.toIndex("bd"))));
        this.setGeneValue(7, (probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc")) + probab.getW(2, this.toIndex("cd"))) / (probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc")) + probab.getW(2, this.toIndex("cd")) + probab.getW(2, this.toIndex("db")) + probab.getW(2, this.toIndex("dc")) + probab.getW(2, this.toIndex("dd"))));
        this.setGeneValue(8, probab.getW(2, this.toIndex("cb")) / (probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc")) + probab.getW(2, this.toIndex("cd"))));
        this.setGeneValue(9, probab.getW(2, this.toIndex("cc")) / (probab.getW(2, this.toIndex("cc")) + probab.getW(2, this.toIndex("cd"))));
        this.setGeneValue(10, probab.getW(2, this.toIndex("db")) / (probab.getW(2, this.toIndex("db")) + probab.getW(2, this.toIndex("dc")) + probab.getW(2, this.toIndex("dd"))));
        this.setGeneValue(11, probab.getW(2, this.toIndex("dc")) / (probab.getW(2, this.toIndex("dc")) + probab.getW(2, this.toIndex("dd"))));
    }
}

