/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition40
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 8295351308009093330L;
    private static final int NO_OF_COMP = 4;
    private static final int R = 0;
    private static final int WA_ID = 0;
    private static final int RATIO_B_CD_ID = 1;
    private static final int RATIO_C_D_ID = 2;
    private static final double[] LOW_LIMIT = new double[]{0.0, 0.0, 0.0};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0, 1.0};
    private static final double[] DEFAULT = new double[]{0.25, 0.5, 0.5};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0, 2.0};

    public ProbabCondition40() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition40(double dWiLow, double dWiHigh) {
        super(4, 0);
        this._aConnectors = new GeneConnector[3];
        this._aConnectors[0] = new GeneConnector(LOW_LIMIT[0], HIGH_LIMIT[0], DEFAULT[0], DECAY_CONST[0]);
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[1] = new GeneConnector(LOW_LIMIT[1], HIGH_LIMIT[1], DEFAULT[1], DECAY_CONST[1]);
        this._aConnectors[1].getGene().setName("Wb/(Wb+Wc+Wd)");
        this._aConnectors[2] = new GeneConnector(LOW_LIMIT[2], HIGH_LIMIT[2], DEFAULT[2], DECAY_CONST[2]);
        this._aConnectors[2].getGene().setName("Wc/(Wc+Wd)");
        this._iWaConnId = 0;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        this.setW(1, (1.0 - this._aConnectors[0].getValue()) * this._aConnectors[1].getValue());
        this.setW(2, (1.0 - this._aConnectors[0].getValue()) * (1.0 - this._aConnectors[1].getValue()) * this._aConnectors[2].getValue());
        this.setW(3, (1.0 - this._aConnectors[0].getValue()) * (1.0 - this._aConnectors[1].getValue()) * (1.0 - this._aConnectors[2].getValue()));
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.setGeneValue(0, probab.getW0(0));
        this.setGeneValue(1, probab.getW0(1) / (probab.getW0(1) + probab.getW0(2) + probab.getW0(3)));
        this.setGeneValue(2, probab.getW0(2) / (probab.getW0(2) + probab.getW0(3)));
    }
}

