/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition32
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 6535200272494327858L;
    private static final int NO_OF_COMP = 3;
    private static final int R = 2;
    private static final int WA_ID = 0;
    private static final int W_RATIO_ID = 1;
    private static final int PAAA_OR_PBAB_ID = 2;
    private static final int WBAB_RATIO_ID = 3;
    private static final int WBA_RATIO_ID = 4;
    private static final int WCA_RATIO_ID = 5;
    private static final double[] LOW_LIMIT = new double[]{0.5, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] DEFAULT = new double[]{0.8, 0.5, 0.5, 0.5, 0.5, 0.5};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0};
    private static final double ILLITE_TRESHOLD = 0.6666666666666;

    public ProbabCondition32() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition32(double dWiLow, double dWiHigh) {
        super(3, 2);
        this._aConnectors = new GeneConnector[6];
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aConnectors[i] = new GeneConnector(LOW_LIMIT[i], HIGH_LIMIT[i], DEFAULT[i], DECAY_CONST[i]);
            ++i;
        }
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[1].getGene().setName("Wb/(Wb+Wc)");
        this._aConnectors[2].getGene().setName("Paaa(0.5<Wa<0.67) or PBAB(0.67<Wa<1)");
        this._aConnectors[3].getGene().setName("(Wbab+Wbac)/(Wbab+Wbac+Wcab+Wcac)");
        this._aConnectors[4].getGene().setName("Wbab/(Wbab+Wbac)");
        this._aConnectors[5].getGene().setName("Wcab/(Wcab+Wcac)");
        this._iWaConnId = 0;
        this._iPControlConnId = 2;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        double dWa = this._aConnectors[0].getValue();
        double dWb = (1.0 - dWa) * this._aConnectors[1].getValue();
        double dWc = 1.0 - dWa - dWb;
        this.setW(1, dWb);
        this.setW(2, dWc);
        this.setP(1, 1, 1, 0.0);
        this.setP(1, 1, 2, 0.0);
        this.setP(1, 2, 1, 0.0);
        this.setP(1, 2, 2, 0.0);
        this.setP(2, 4, 4, 0.0);
        this.setP(2, 4, 5, 0.0);
        this.setP(2, 5, 7, 0.0);
        this.setP(2, 5, 8, 0.0);
        this.setP(2, 7, 4, 0.0);
        this.setP(2, 7, 5, 0.0);
        this.setP(2, 8, 7, 0.0);
        this.setP(2, 8, 8, 0.0);
        int iOK = this.solve(1);
        assert (iOK == 0);
        double dPBAB = 0.0;
        double dWB = dWb + dWc;
        dPBAB = this._aConnectors[0].getValue() < 0.6666666666666 ? 1.0 - (dWa - dWB) / dWB * (1.0 - this._aConnectors[2].getValue()) : this._aConnectors[2].getValue();
        double dWBAB = dWB * this.getP(1, 1, 0) * dPBAB;
        double dWbaTotal = dWBAB * this._aConnectors[3].getValue();
        double dWbab = dWbaTotal * this._aConnectors[4].getValue();
        double dWbac = dWbaTotal * (1.0 - this._aConnectors[4].getValue());
        double dWcaTotal = dWBAB - dWbaTotal;
        double dWcab = dWcaTotal * this._aConnectors[5].getValue();
        double dWcac = dWcaTotal * (1.0 - this._aConnectors[5].getValue());
        if (dWb == 0.0 && (dWbab != 0.0 || dWbac != 0.0) || dWc == 0.0 && (dWcab != 0.0 || dWcac != 0.0)) {
            return false;
        }
        this.setP(2, 3, 1, dWb > 0.0 ? dWbab / dWb : 0.0);
        this.setP(2, 3, 2, dWb > 0.0 ? dWbac / dWb : 0.0);
        this.setP(2, 6, 1, dWc > 0.0 ? dWcab / dWc : 0.0);
        this.setP(2, 6, 2, dWc > 0.0 ? dWcac / dWc : 0.0);
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.verifyInputMatrix(probab);
        this.setGeneValue(0, probab.getW0(0));
        this.setGeneValue(1, probab.getW0(1) / (probab.getW0(1) + probab.getW0(2)));
        double dWBAB = probab.getW(3, this.toIndex("bab")) + probab.getW(3, this.toIndex("bac")) + probab.getW(3, this.toIndex("cab")) + probab.getW(3, this.toIndex("cac"));
        if (probab.getW0(0) < 0.6666666666666) {
            this.setGeneValue(2, probab.getP(2, 0, 0));
        } else {
            this.setGeneValue(2, dWBAB / (probab.getW0(1) + probab.getW0(2)) / this.getP(1, 1, 0));
        }
        this.setGeneValue(3, (probab.getW(3, this.toIndex("bab")) + probab.getW(3, this.toIndex("bac"))) / dWBAB);
        this.setGeneValue(4, probab.getW(3, this.toIndex("bab")) / (probab.getW(3, this.toIndex("bab")) + probab.getW(3, this.toIndex("bac"))));
        this.setGeneValue(5, probab.getW(3, this.toIndex("cab")) / (probab.getW(3, this.toIndex("cab")) + probab.getW(3, this.toIndex("cac"))));
    }

    private void verifyInputMatrix(Probability probab) throws IllegalArgumentException {
        if (probab.getW0(0) < LOW_LIMIT[0]) {
            throw new IllegalArgumentException("Illite content lower than limit [" + LOW_LIMIT[0] + "]: " + probab.getW0(0));
        }
        if (probab.getP(1, 1, 1) != 0.0) {
            throw new IllegalArgumentException("Pbb is required to be zero in this matrix");
        }
        if (probab.getP(1, 1, 2) != 0.0) {
            throw new IllegalArgumentException("Pbc is required to be zero in this matrix");
        }
        if (probab.getP(1, 2, 1) != 0.0) {
            throw new IllegalArgumentException("Pcb is required to be zero in this matrix");
        }
        if (probab.getP(1, 2, 2) != 0.0) {
            throw new IllegalArgumentException("Pcc is required to be zero in this matrix");
        }
        if (probab.getP(2, 4, 4) != 0.0) {
            throw new IllegalArgumentException("Pbbb is required to be zero in this matrix");
        }
        if (probab.getP(2, 4, 5) != 0.0) {
            throw new IllegalArgumentException("Pbbc is required to be zero in this matrix");
        }
        if (probab.getP(2, 5, 7) != 0.0) {
            throw new IllegalArgumentException("Pbcb is required to be zero in this matrix");
        }
        if (probab.getP(2, 5, 8) != 0.0) {
            throw new IllegalArgumentException("Pbcc is required to be zero in this matrix");
        }
        if (probab.getP(2, 7, 4) != 0.0) {
            throw new IllegalArgumentException("Pcbb is required to be zero in this matrix");
        }
        if (probab.getP(2, 7, 5) != 0.0) {
            throw new IllegalArgumentException("Pcbc is required to be zero in this matrix");
        }
        if (probab.getP(2, 8, 7) != 0.0) {
            throw new IllegalArgumentException("Pccb is required to be zero in this matrix");
        }
        if (probab.getP(2, 8, 8) != 0.0) {
            throw new IllegalArgumentException("Pccc is required to be zero in this matrix");
        }
    }
}

