/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition31
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 3920012231591207891L;
    private static final int NO_OF_COMP = 3;
    private static final int R = 1;
    private static final int WA_ID = 0;
    private static final int W_RATIO_ID = 1;
    private static final int PAA_OR_PBB_ID = 2;
    private static final int WB_TOTAL_RATIO_ID = 3;
    private static final int WB_RATIO_ID = 4;
    private static final int WC_RATIO_ID = 5;
    private static final double[] LOW_LIMIT = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] DEFAULT = new double[]{0.6, 1.0, 0.0, 1.0, 1.0, 0.5};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0};

    public ProbabCondition31() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition31(double dWiLow, double dWiHigh) {
        super(3, 1);
        this._aConnectors = new GeneConnector[6];
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aConnectors[i] = new GeneConnector(LOW_LIMIT[i], HIGH_LIMIT[i], DEFAULT[i], DECAY_CONST[i]);
            ++i;
        }
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[0].getGene().set_dLowLimit(0.5);
        this._aConnectors[1].getGene().setName("Wb/(Wb+Wc)");
        this._aConnectors[1].getGene().set_dLowLimit(0.7);
        this._aConnectors[2].getGene().setName("Paa(Wa<0.5) or PBB(Wa>0.5)");
        this._aConnectors[2].getGene().set_dHighLimit(0.3);
        this._aConnectors[3].getGene().setName("(Wbb+Wbc)/(Wbb+Wbc+Wcb+Wcc)");
        this._aConnectors[3].getGene().set_dLowLimit(0.8);
        this._aConnectors[4].getGene().setName("Wbb/(Wbb+Wbc)");
        this._aConnectors[4].getGene().set_dLowLimit(0.5);
        this._aConnectors[5].getGene().setName("Wcb/(Wcb+Wcc)");
        this._aConnectors[5].getGene().set_dLowLimit(0.5);
        this._iWaConnId = 0;
        this._iPControlConnId = 2;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        double dWa = this._aConnectors[0].getValue();
        double dWb = (1.0 - dWa) * this._aConnectors[1].getValue();
        double dWc = 1.0 - dWa - dWb;
        this.setW(1, dWb);
        this.setW(2, dWc);
        double dWB = dWb + dWc;
        double dWBB = 0.0;
        dWBB = dWa < 0.5 ? dWB * (dWB - dWa * (1.0 - this._aConnectors[2].getValue())) / dWB : dWB * this._aConnectors[2].getValue();
        double dWbTotal = this._aConnectors[3].getValue() * dWBB;
        double dWbb = dWbTotal * this._aConnectors[4].getValue();
        double dWbc = dWbTotal * (1.0 - this._aConnectors[4].getValue());
        double dWcTotal = dWBB - dWbTotal;
        double dWcb = dWcTotal * this._aConnectors[5].getValue();
        double dWcc = dWcTotal * (1.0 - this._aConnectors[5].getValue());
        if (dWb == 0.0 && (dWbb != 0.0 || dWbc != 0.0) || dWc == 0.0 && (dWcb != 0.0 || dWcc != 0.0)) {
            return false;
        }
        this.setP(1, 1, 1, dWb == 0.0 ? 0.0 : dWbb / dWb);
        this.setP(1, 1, 2, dWb == 0.0 ? 0.0 : dWbc / dWb);
        this.setP(1, 2, 1, dWc == 0.0 ? 0.0 : dWcb / dWc);
        this.setP(1, 2, 2, dWc == 0.0 ? 0.0 : dWcc / dWc);
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.setGeneValue(0, probab.getW0(0));
        this.setGeneValue(1, probab.getW0(1) / (probab.getW0(1) + probab.getW0(2)));
        double dWBB = probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc")) + probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc"));
        if (probab.getW0(0) < 0.5) {
            this.setGeneValue(2, probab.getP(1, 0, 0));
        } else {
            this.setGeneValue(2, dWBB / (probab.getW0(1) + probab.getW0(2)));
        }
        this.setGeneValue(3, (probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc"))) / dWBB);
        this.setGeneValue(4, probab.getW(2, this.toIndex("bb")) / (probab.getW(2, this.toIndex("bb")) + probab.getW(2, this.toIndex("bc"))));
        this.setGeneValue(5, probab.getW(2, this.toIndex("cb")) / (probab.getW(2, this.toIndex("cb")) + probab.getW(2, this.toIndex("cc"))));
    }
}

