/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition30
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = -7311355637567490823L;
    private static final int NO_OF_COMP = 3;
    private static final int R = 0;
    private static final int WA_ID = 0;
    private static final int W_RATIO_ID = 1;
    private static final double[] LOW_LIMIT = new double[]{0.0, 0.0};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0};
    private static final double[] DEFAULT = new double[]{0.33, 0.8};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0};

    public ProbabCondition30() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition30(double dWiLow, double dWiHigh) {
        super(3, 0);
        this._aConnectors = new GeneConnector[2];
        this._aConnectors[0] = new GeneConnector(LOW_LIMIT[0], HIGH_LIMIT[0], DEFAULT[0], DECAY_CONST[0]);
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[0].getGene().set_dHighLimit(0.5);
        this._aConnectors[1] = new GeneConnector(LOW_LIMIT[1], HIGH_LIMIT[1], DEFAULT[1], DECAY_CONST[1]);
        this._aConnectors[1].getGene().setName("Wb/(Wb+Wc)");
        this._aConnectors[1].getGene().set_dLowLimit(0.7);
        this._iWaConnId = 0;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        this.setW(1, (1.0 - this._aConnectors[0].getValue()) * this._aConnectors[1].getValue());
        this.setW(2, (1.0 - this._aConnectors[0].getValue()) * (1.0 - this._aConnectors[1].getValue()));
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.setGeneValue(0, probab.getW0(0));
        this.setGeneValue(1, probab.getW0(1) / (probab.getW0(1) + probab.getW0(2)));
    }
}

