/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition22
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = -9080837937853654417L;
    private static final int NO_OF_COMP = 2;
    private static final int R = 2;
    private static final int WA_ID = 0;
    private static final int PAAA_OR_PBAB_ID = 1;
    private static final double[] LOW_LIMIT = new double[]{0.5, 0.0};
    private static final double[] DEFAULT = new double[]{0.6, 0.5};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0};
    private static final double ILLITE_TRESHOLD = 0.6666666666666;

    public ProbabCondition22() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition22(double dWiLow, double dWiHigh) {
        super(2, 2);
        this._aConnectors = new GeneConnector[2];
        this._aConnectors[0] = new GeneConnector(LOW_LIMIT[0], HIGH_LIMIT[0], DEFAULT[0], DECAY_CONST[0]);
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[1] = new GeneConnector(LOW_LIMIT[1], HIGH_LIMIT[1], DEFAULT[1], DECAY_CONST[1]);
        this._aConnectors[1].getGene().setName("Paaa(0.5<Wa<0.67) or Pbab(0.67<Wa<1)");
        this._iWaConnId = 0;
        this._iPControlConnId = 1;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        this.setW(0, this._aConnectors[0].getValue());
        this.setP(1, 1, 1, 0.0);
        this.setP(2, 1, 3, 0.0);
        int iResult = this.solve(1);
        if (iResult != 0) {
            return false;
        }
        if (this._aConnectors[0].getValue() < 0.6666666666666) {
            this.setP(2, 0, 0, this._aConnectors[1].getValue());
        } else {
            this.setP(2, 2, 1, this._aConnectors[1].getValue());
        }
        iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.verifyInputMatrix(probab);
        this.setGeneValue(0, probab.getW0(0));
        if (probab.getW0(0) < 0.6666666666666) {
            this.setGeneValue(1, probab.getP(2, 0, 0));
        } else {
            this.setGeneValue(1, probab.getP(2, 2, 1));
        }
    }

    private void verifyInputMatrix(Probability probab) throws IllegalArgumentException {
        if (probab.getW0(0) < LOW_LIMIT[0]) {
            throw new IllegalArgumentException("Illite content lower than limit [" + LOW_LIMIT[0] + "]: " + probab.getW0(0));
        }
        if (probab.getP(1, 1, 1) != 0.0) {
            throw new IllegalArgumentException("Pbb is required to be zero in this matrix");
        }
        if (probab.getP(2, 1, 3) != 0.0) {
            throw new IllegalArgumentException("Pabb is required to be zero in this matrix");
        }
    }
}

