/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition21
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 8731357789606918238L;
    private static final int NO_OF_COMP = 2;
    private static final int R = 1;
    private static final int WA_ID = 0;
    private static final int PAA_OR_PBB_ID = 1;
    private static final double[] LOW_LIMIT = new double[]{0.0, 0.0};
    private static final double[] DEFAULT = new double[]{0.6, 0.5};
    private static final double[] HIGH_LIMIT = new double[]{1.0, 1.0};
    private static final double[] DECAY_CONST = new double[]{2.0, 2.0};

    public ProbabCondition21() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition21(double dWiLow, double dWiHigh) {
        super(2, 1);
        this._aConnectors = new GeneConnector[2];
        this._aConnectors[0] = new GeneConnector(LOW_LIMIT[0], HIGH_LIMIT[0], DEFAULT[0], DECAY_CONST[0]);
        this._aConnectors[0].getGene().setName("Wa");
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[1] = new GeneConnector(LOW_LIMIT[1], HIGH_LIMIT[1], DEFAULT[1], DECAY_CONST[1]);
        this._aConnectors[1].getGene().setName("Paa(Wa<0.5) or Pbb(Wa>0.5)");
        this._iWaConnId = 0;
        this._iPControlConnId = 1;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        double dWa = this._aConnectors[0].getValue();
        this.setW(0, dWa);
        if (dWa < 0.5) {
            this.setP(1, 0, 0, this._aConnectors[1].getValue());
        } else {
            this.setP(1, 1, 1, this._aConnectors[1].getValue());
        }
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) {
        this.setGeneValue(0, probab.getW0(0));
        if (probab.getW0(0) < 0.5) {
            this.setGeneValue(1, probab.getP(1, 0, 0));
        } else {
            this.setGeneValue(1, probab.getP(1, 1, 1));
        }
    }
}

