/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class ProbabCondition20
extends AbstractProbabCondition
implements Serializable {
    private static final long serialVersionUID = 3329817508328058323L;
    private static final int NO_OF_COMP = 2;
    private static final int R = 0;
    private static final int WA_ID = 0;
    private static final double[] LOW_LIMIT = new double[]{0.0};
    private static final double[] HIGH_LIMIT = new double[]{1.0};
    private static final double[] DEFAULT = new double[]{0.0};
    private static final double[] DECAY_CONST = new double[]{2.0};

    public ProbabCondition20() {
        this(LOW_LIMIT[0], HIGH_LIMIT[0]);
    }

    public ProbabCondition20(double dWiLow, double dWiHigh) {
        super(2, 0);
        this._aConnectors = new GeneConnector[1];
        this._aConnectors[0] = new GeneConnector(LOW_LIMIT[0], HIGH_LIMIT[0], DEFAULT[0], DECAY_CONST[0]);
        this._aConnectors[0].getGene().setLimits(dWiLow, dWiHigh);
        this._aConnectors[0].getGene().setName("Wa");
        this._iWaConnId = 0;
    }

    @Override
    public boolean updateProbability() {
        this.resetMatrices();
        this.setW(0, this._aConnectors[0].getValue());
        int iResult = this.solve();
        return iResult == 0 && this.verify();
    }

    @Override
    protected void setGenes(Probability probab) throws IllegalArgumentException {
        this.setGeneValue(0, probab.getW0(0));
    }
}

