/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class MultEquation
implements Serializable {
    private static final long serialVersionUID = 8650476024151575837L;
    public static final int W = 0;
    public static final int P = 1;
    private DoubleValue[][] _aTerms = null;
    private DoubleValue _wTerm = null;
    private static final double MAX_ERROR = 0.001;
    private static final NumberFormat _fourDigitNumberFormatter = NumberFormat.getInstance(Locale.US);

    static {
        _fourDigitNumberFormatter.setMinimumFractionDigits(0);
        _fourDigitNumberFormatter.setMaximumFractionDigits(4);
    }

    public MultEquation(DoubleValue[][] aTerms, DoubleValue wTerm) {
        assert (aTerms[0].length == 2);
        this._aTerms = aTerms;
        this._wTerm = wTerm;
    }

    public boolean solve() {
        if (Double.isNaN(this._wTerm.getValue())) {
            return false;
        }
        boolean bResult = false;
        int iUnknownTermCount = 0;
        int iUnknownTermPos = 0;
        int i = 0;
        while (i < this._aTerms.length) {
            int j = 0;
            while (j < 2) {
                if (Double.isNaN(this._aTerms[i][j].getValue())) {
                    iUnknownTermPos = i;
                    if (++iUnknownTermCount > 1) break;
                }
                ++j;
            }
            ++i;
        }
        if (iUnknownTermCount == 1) {
            assert (!Double.isNaN(this._aTerms[iUnknownTermPos][0].getValue()));
            assert (Double.isNaN(this._aTerms[iUnknownTermPos][1].getValue()));
            double dKnownTotal = 0.0;
            if (this._aTerms[iUnknownTermPos][0].getValue() > 0.0) {
                int i2 = 0;
                while (i2 < this._aTerms.length) {
                    if (i2 != iUnknownTermPos) {
                        dKnownTotal += this._aTerms[i2][0].getValue() * this._aTerms[i2][1].getValue();
                    }
                    ++i2;
                }
                this._aTerms[iUnknownTermPos][1].setValue((this._wTerm.getValue() - dKnownTotal) / this._aTerms[iUnknownTermPos][0].getValue());
            } else {
                this._aTerms[iUnknownTermPos][1].setValue(0.0);
            }
            bResult = true;
        }
        return bResult;
    }

    public boolean verify() {
        double dTotal = 0.0;
        int i = 0;
        while (i < this._aTerms.length) {
            dTotal += this._aTerms[i][0].getValue() * this._aTerms[i][1].getValue();
            ++i;
        }
        return Math.abs(this._wTerm.getValue() - dTotal) < 0.001;
    }

    public String toString() {
        int iNoOfComp = this._aTerms.length;
        StringBuffer sbEquation = new StringBuffer(40);
        sbEquation.append(Double.isNaN(this._wTerm.getValue()) ? "?" : _fourDigitNumberFormatter.format(this._wTerm.getValue()));
        double dTotal = 0.0;
        int i = 0;
        while (i < iNoOfComp) {
            dTotal += this._aTerms[i][0].getValue() * this._aTerms[i][1].getValue();
            ++i;
        }
        if (Math.abs(this._wTerm.getValue() - dTotal) < 0.001) {
            sbEquation.append(" = ");
        } else {
            sbEquation.append(" <> ");
        }
        i = 0;
        while (i < iNoOfComp) {
            sbEquation.append(Double.isNaN(this._aTerms[i][0].getValue()) ? "?" : _fourDigitNumberFormatter.format(this._aTerms[i][0].getValue()));
            sbEquation.append(" * ");
            sbEquation.append(Double.isNaN(this._aTerms[i][1].getValue()) ? "?" : _fourDigitNumberFormatter.format(this._aTerms[i][1].getValue()));
            if (i < iNoOfComp - 1) {
                sbEquation.append(" + ");
            }
            ++i;
        }
        return sbEquation.toString();
    }
}

