/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class AddEquation
implements Serializable {
    private static final long serialVersionUID = -7561828752476612781L;
    private int _iNoOfComp = -1;
    private DoubleValue[] _aTerms = null;
    private static final double MAX_ERROR = 0.001;
    private static final NumberFormat _fourDigitNumberFormatter = NumberFormat.getInstance(Locale.US);

    static {
        _fourDigitNumberFormatter.setMinimumFractionDigits(0);
        _fourDigitNumberFormatter.setMaximumFractionDigits(4);
    }

    public AddEquation(DoubleValue[] aTerms) {
        this._iNoOfComp = aTerms.length;
        this._aTerms = aTerms;
    }

    public DoubleValue getTerm(int iIndex) {
        return this._aTerms[iIndex];
    }

    public boolean solve() {
        boolean bResult = false;
        int iUnknownTermCount = 0;
        int iUnknownTermPos = 0;
        int i = 0;
        while (i < this._iNoOfComp) {
            if (Double.isNaN(this._aTerms[i].getValue())) {
                ++iUnknownTermCount;
                iUnknownTermPos = i;
            }
            ++i;
        }
        if (iUnknownTermCount == 1) {
            double dKnownTotal = 0.0;
            int i2 = 0;
            while (i2 < this._iNoOfComp) {
                if (!Double.isNaN(this._aTerms[i2].getValue())) {
                    dKnownTotal += this._aTerms[i2].getValue();
                }
                ++i2;
            }
            this._aTerms[iUnknownTermPos].setValue(1.0 - dKnownTotal);
            bResult = true;
        }
        return bResult;
    }

    public boolean verify() {
        boolean bInRange = true;
        double dTotal = 0.0;
        int i = 0;
        while (i < this._iNoOfComp) {
            dTotal += this._aTerms[i].getValue();
            bInRange &= this._aTerms[i].getValue() >= -0.001 && this._aTerms[i].getValue() <= 1.001;
            ++i;
        }
        return Math.abs(dTotal) < 0.001 ? bInRange : Math.abs(1.0 - dTotal) < 0.001 && bInRange;
    }

    public String toString() {
        StringBuffer sbEquation = new StringBuffer(30);
        double dTotal = 0.0;
        int i = 0;
        while (i < this._iNoOfComp) {
            dTotal += this._aTerms[i].getValue();
            sbEquation.append(Double.isNaN(this._aTerms[i].getValue()) ? "?" : _fourDigitNumberFormatter.format(this._aTerms[i].getValue()));
            if (i < this._iNoOfComp - 1) {
                sbEquation.append(" + ");
            }
            ++i;
        }
        sbEquation.append(" = ").append(Double.isNaN(dTotal) ? "?" : _fourDigitNumberFormatter.format(dTotal));
        return sbEquation.toString();
    }
}

