/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.probab;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.common.util.TwoDoubles;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gene.ModGene;
import net.ndmystko.xrd.mod.probab.ProbabCondition20;
import net.ndmystko.xrd.mod.probab.ProbabCondition21;
import net.ndmystko.xrd.mod.probab.ProbabCondition22;
import net.ndmystko.xrd.mod.probab.ProbabCondition23;
import net.ndmystko.xrd.mod.probab.ProbabCondition30;
import net.ndmystko.xrd.mod.probab.ProbabCondition31;
import net.ndmystko.xrd.mod.probab.ProbabCondition32;
import net.ndmystko.xrd.mod.probab.ProbabCondition40;
import net.ndmystko.xrd.mod.probab.ProbabCondition41;
import net.ndmystko.xrd.mod.probab.Probability;

public abstract class AbstractProbabCondition
extends Probability
implements Serializable {
    private static final long serialVersionUID = 1809352886374516573L;
    protected GeneConnector[] _aConnectors = null;
    protected int _iWaConnId = -1;
    protected int _iPControlConnId = -1;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.probab.AbstractProbabCondition");
    private static Class[][] CONDITIONS;

    static {
        Class[][] classArrayArray = new Class[4][];
        Class[] classArray = new Class[5];
        classArray[2] = ProbabCondition20.class;
        classArray[3] = ProbabCondition30.class;
        classArray[4] = ProbabCondition40.class;
        classArrayArray[0] = classArray;
        Class[] classArray2 = new Class[5];
        classArray2[2] = ProbabCondition21.class;
        classArray2[3] = ProbabCondition31.class;
        classArray2[4] = ProbabCondition41.class;
        classArrayArray[1] = classArray2;
        Class[] classArray3 = new Class[5];
        classArray3[2] = ProbabCondition22.class;
        classArray3[3] = ProbabCondition32.class;
        classArrayArray[2] = classArray3;
        Class[] classArray4 = new Class[5];
        classArray4[2] = ProbabCondition23.class;
        classArrayArray[3] = classArray4;
        CONDITIONS = classArrayArray;
    }

    protected AbstractProbabCondition(int iNoOfComp, int iR) {
        super(iNoOfComp, iR);
    }

    public abstract boolean updateProbability();

    public double getIlliteContent() {
        return this.getW0(0);
    }

    public void setIlliteContent(double dValue) {
        ModGene waGene = this._aConnectors[this._iWaConnId].getGene();
        if (dValue >= waGene.getLowLimit() && dValue <= waGene.getHighLimit()) {
            waGene.setValue(dValue);
        } else {
            _logger.logp(Level.INFO, this.getClass().getName(), "setIlliteContent", "requested illite content: " + dValue + " is out of allowed range: " + waGene.getLowLimit() + " - " + waGene.getHighLimit());
            if (Math.abs(dValue - waGene.getLowLimit()) < Math.abs(dValue - waGene.getHighLimit())) {
                waGene.setValue(waGene.getLowLimit());
            } else {
                waGene.setValue(waGene.getHighLimit());
            }
        }
    }

    public TwoDoubles getIlliteRange() {
        return new TwoDoubles(this._aConnectors[this._iWaConnId].getGene().getLowLimit(), this._aConnectors[this._iWaConnId].getGene().getHighLimit());
    }

    public void setIlliteRange(double dWiLow, double dWiHigh) {
        this._aConnectors[this._iWaConnId].getGene().setLimits(dWiLow, dWiHigh);
    }

    public double getAbsoluteLowIlliteLimit() {
        return this._aConnectors[this._iWaConnId].getGene().getFinalLowLimit();
    }

    public boolean isRangeRestricted() {
        boolean bUnrestricted = true;
        ModGene waGene = this._aConnectors[this._iWaConnId].getGene();
        bUnrestricted &= Math.abs(waGene.getLowLimit() - waGene.getFinalLowLimit()) < 1.0E-10;
        return !(bUnrestricted &= Math.abs(waGene.getHighLimit() - waGene.getFinalHighLimit()) < 1.0E-10);
    }

    public boolean setGenesFor(Probability probab) throws IllegalArgumentException {
        assert (probab.getR() == this.getR() && probab.getNoOfComp() == this.getNoOfComp()) : "Probability matrix size does not match";
        GeneConnector[] aOrigConnectors = new GeneConnector[this._aConnectors.length];
        int i = 0;
        while (i < aOrigConnectors.length) {
            aOrigConnectors[i] = (GeneConnector)this._aConnectors[i].clone();
            ++i;
        }
        this.setGenes(probab);
        boolean bSuccess = this.updateProbability();
        if (!bSuccess) {
            int i2 = 0;
            while (i2 < aOrigConnectors.length) {
                this._aConnectors[i2].setValue(aOrigConnectors[i2].getValue());
                ++i2;
            }
        }
        return bSuccess;
    }

    protected abstract void setGenes(Probability var1) throws IllegalArgumentException;

    protected void setGeneValue(int iGeneId, double dNewValue) throws IllegalArgumentException {
        if (dNewValue < this._aConnectors[iGeneId].getGene().getLowLimit() - 1.0E-10 || dNewValue > this._aConnectors[iGeneId].getGene().getHighLimit() + 1.0E-10) {
            throw new IllegalArgumentException("New value of '" + this._aConnectors[iGeneId].getGene().getName() + "' outside of allowed range: " + dNewValue);
        }
        this._aConnectors[iGeneId].setValue(dNewValue);
    }

    public void addConnectors(List lList, boolean bActiveOnly, boolean bNoDuplicates) {
        int i = 0;
        while (i < this._aConnectors.length) {
            if (!(!this._aConnectors[i].isActive() && bActiveOnly || lList.contains(this._aConnectors[i]) && bNoDuplicates)) {
                lList.add(this._aConnectors[i]);
            }
            ++i;
        }
    }

    public void addConnectorsBranch(DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < this._aConnectors.length) {
            parent.add(new DefaultMutableTreeNode(this._aConnectors[i]));
            ++i;
        }
    }

    public GeneConnector getWAConnector() {
        return this._aConnectors[this._iWaConnId];
    }

    public GeneConnector getPControlConnector() {
        assert (this._iPControlConnId >= 0) : "You shouldn't have asked for P control connector for class " + this.getClass().getName();
        return this._aConnectors[this._iPControlConnId];
    }

    protected int toIndex(String sLetters) {
        return Probability.parseLetters(sLetters, this.getR(), this.getNoOfComp());
    }

    public static AbstractProbabCondition getMatrix(int iNoOfComp, int iR) {
        if (iR < 0 || iR > 3 || iNoOfComp < 2 || iNoOfComp > 4 || CONDITIONS[iR][iNoOfComp] == null) {
            throw new IllegalArgumentException("Illegal set of R: " + iR + " and no of components: " + iNoOfComp);
        }
        Constructor<?>[] aConstr = CONDITIONS[iR][iNoOfComp].getConstructors();
        int iConstrIndex = -1;
        int i = 0;
        while (i < aConstr.length) {
            if (aConstr[i].getParameterTypes().length <= 0) {
                iConstrIndex = i;
                break;
            }
            ++i;
        }
        AbstractProbabCondition condition = null;
        try {
            condition = (AbstractProbabCondition)aConstr[iConstrIndex].newInstance(new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Unexpected error in matrix creation.");
        }
        return condition;
    }
}

