/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.net;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.xrd.mod.SybillaProducer;
import net.ndmystko.xrd.mod.net.Answer;
import net.ndmystko.xrd.mod.net.Request;

public class RequestHandlerThread
implements Runnable {
    private Socket _socket = null;
    private ObjectInputStream _ois = null;
    private ObjectOutputStream _oos = null;
    private SybillaProducer _producer = null;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.net.RequestHandlerThread");

    public RequestHandlerThread(Socket socket, ObjectInputStream ois, ObjectOutputStream oos, SybillaProducer producer) {
        this._ois = ois;
        this._oos = oos;
        this._socket = socket;
        this._producer = producer;
    }

    @Override
    public void run() {
        block31: {
            try {
                Request request = null;
                try {
                    request = (Request)this._ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "error in reading Request object", cnfe);
                    request = null;
                    this.sendAnswer(new Answer(1));
                }
                catch (ClassCastException cce) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "error in reading Request object", cce);
                    request = null;
                    this.sendAnswer(new Answer(1));
                }
                catch (InvalidClassException ice) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "error in reading Request object", ice);
                    request = null;
                    this.sendAnswer(new Answer(1));
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "error in reading Request object", ioe);
                    request = null;
                }
                if (request == null) break block31;
                switch (request.getRequestID()) {
                    case 1: {
                        Answer answer = null;
                        if (this._producer.isCalculating()) {
                            answer = new Answer(2);
                            answer.setProgress(this._producer.getProgress());
                            answer.setCalculatedPatternName(this._producer.getCalculatedPatternName());
                            answer.setCurrentMisfit(this._producer.getCurrentMisfit());
                            answer.setPhaseQuick(this._producer.isPhaseQuick());
                        } else {
                            answer = new Answer(3);
                        }
                        answer.setDoneTaskNames(this._producer.getDoneTaskNames());
                        answer.setToBeDoneTaskNames(this._producer.getToBeDoneTaskNames());
                        this.sendAnswer(answer);
                        break;
                    }
                    case 2: {
                        this._producer.addTask(request.getTask());
                        Answer answer = new Answer(4);
                        this.sendAnswer(answer);
                        break;
                    }
                    case 3: {
                        this._producer.startCalculation();
                        Answer answer = null;
                        if (this._producer.isCalculating()) {
                            answer = new Answer(2);
                            answer.setProgress(this._producer.getProgress());
                            answer.setCalculatedPatternName(this._producer.getCalculatedPatternName());
                            answer.setCurrentMisfit(this._producer.getCurrentMisfit());
                            answer.setPhaseQuick(this._producer.isPhaseQuick());
                        } else {
                            answer = new Answer(3);
                        }
                        answer.setDoneTaskNames(this._producer.getDoneTaskNames());
                        answer.setToBeDoneTaskNames(this._producer.getToBeDoneTaskNames());
                        this.sendAnswer(answer);
                        break;
                    }
                    case 4: {
                        this._producer.stopCalculation();
                        Answer answer = new Answer(5);
                        this.sendAnswer(answer);
                        break;
                    }
                    case 5: {
                        Answer answer = new Answer(6);
                        answer.setTasks(this._producer.getTasks(request.getTaskIds()));
                        this.sendAnswer(answer);
                        break;
                    }
                    case 6: {
                        this._producer.deleteTasks(request.getTaskIds());
                        Answer answer = null;
                        if (this._producer.isCalculating()) {
                            answer = new Answer(2);
                            answer.setProgress(this._producer.getProgress());
                            answer.setCalculatedPatternName(this._producer.getCalculatedPatternName());
                            answer.setCurrentMisfit(this._producer.getCurrentMisfit());
                            answer.setPhaseQuick(this._producer.isPhaseQuick());
                        } else {
                            answer = new Answer(3);
                        }
                        answer.setDoneTaskNames(this._producer.getDoneTaskNames());
                        answer.setToBeDoneTaskNames(this._producer.getToBeDoneTaskNames());
                        this.sendAnswer(answer);
                        break;
                    }
                    case 7: {
                        boolean bSuccess = this.saveSybilla(request);
                        Answer answer = new Answer(bSuccess ? 7 : 8);
                        this.sendAnswer(answer);
                        break;
                    }
                    case 8: {
                        Answer answer = new Answer(9);
                        this.sendAnswer(answer);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.exit(0);
                        break;
                    }
                    case 9: {
                        Answer answer = new Answer(10);
                        answer.setCalculatedPatternName(this.getLog());
                        this.sendAnswer(answer);
                        break;
                    }
                    default: {
                        _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "received request of unknown id: " + request.getRequestID());
                        this.sendAnswer(new Answer(1));
                        break;
                    }
                }
            }
            finally {
                try {
                    this._socket.close();
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "run", "error when trying to close socket", ioe);
                }
            }
        }
    }

    private void sendAnswer(Answer answer) {
        try {
            this._oos.writeObject(answer);
            this._oos.flush();
        }
        catch (IOException ioe) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "sendAnswer", "error when writing Answer object", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveSybilla(Request request) {
        File tempFile = new File("sybilla.jar~");
        byte[] aBuffer = new byte[200000];
        ByteArrayInputStream bais = new ByteArrayInputStream(request.getSybilla());
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int iCount = 0;
            while ((iCount = bais.read(aBuffer, 0, aBuffer.length)) > -1) {
                bos.write(aBuffer, 0, iCount);
            }
        }
        catch (IOException ioe) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "saveSybilla", "error in writing " + tempFile.getName(), ioe);
            return false;
        }
        try (JarFile tempSybilla = new JarFile(tempFile);){
            if (tempSybilla.getJarEntry("net/ndmystko/xrd/mod/SybillaGuiLess.class") == null) {
                _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "saveSybilla", "uploaded jar seems corrupted: it does not contain SybillaGuiLess class");
                return false;
            }
        }
        catch (IOException ioe) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "saveSybilla", "error in closing " + tempFile.getName(), ioe);
            return false;
        }
        boolean bRenamed = tempFile.renameTo(new File("sybilla.jar"));
        if (bRenamed) return bRenamed;
        _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.RequestHandlerThread", "saveSybilla", "wasn't able to rename " + tempFile.getName());
        return bRenamed;
    }

    private String getLog() {
        StringBuffer sbData;
        block11: {
            sbData = new StringBuffer(10000);
            FileReader fr = null;
            try {
                File currentDir;
                File[] aLogs;
                File errorServer = new File("errorServer.log");
                if (errorServer.exists()) {
                    fr = new FileReader(errorServer);
                    sbData.append("Content of errorServer.log:\n");
                    BufferedReader br = new BufferedReader(fr);
                    String sLine = null;
                    while ((sLine = br.readLine()) != null) {
                        sbData.append(sLine).append('\n');
                    }
                    fr.close();
                }
                if ((aLogs = (currentDir = new File(".")).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("sybillaServer.log") && !pathname.getName().endsWith("lck");
                    }
                })) == null) {
                    sbData.append("Listed directory is null\n");
                } else {
                    sbData.append("Dumping identified files:\n");
                    int i = 0;
                    while (i < aLogs.length) {
                        if (!aLogs[i].isDirectory()) {
                            fr = new FileReader(aLogs[i]);
                            sbData.append("Content of ").append(aLogs[i].getPath()).append('\n');
                            BufferedReader br = new BufferedReader(fr);
                            String sLine = null;
                            while ((sLine = br.readLine()) != null) {
                                sbData.append(sLine).append('\n');
                            }
                            fr.close();
                        }
                        ++i;
                    }
                }
            }
            catch (IOException ioe) {
                sbData.append("Following error occured while reading files:\n" + ioe.getMessage() + '\n');
                if (fr == null) break block11;
                try {
                    fr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return sbData.toString();
    }
}

