/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.net;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.net.Answer;
import net.ndmystko.xrd.mod.net.Request;

public class ConnectorManual
implements Runnable {
    public static final String TASKS_ARRIVED = "Tasks arrived!";
    public static final String BUSY = "busy";
    public static final String FREE = "free";
    private ActionListener _listener = null;
    private Socket _socket = null;
    private Request _request = null;
    private Task[] _aTasks = null;
    private HashMap _hmTaskDoneNames = null;
    private HashMap _hmTaskToBeDoneNames = null;
    private int _iProgress = -1;
    private String _sCalculatedPatternName = "";
    private double _dCurrentMisfit = 0.0;
    private boolean _bPhaseQuick = true;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.net.ConnectorManual");

    public ConnectorManual(ActionListener listener, Socket socket, Request request) {
        this._listener = listener;
        this._socket = socket;
        this._request = request;
    }

    public void disconnectListener() {
        this._listener = null;
    }

    @Override
    public void run() {
        block44: {
            try {
                boolean bRequestError = false;
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(this._socket.getOutputStream());
                    oos.writeObject(this._request);
                    oos.flush();
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error when writing Request object", ioe);
                    bRequestError = true;
                }
                if (bRequestError) break block44;
                Answer answer = null;
                boolean bAnswerError = false;
                try {
                    ObjectInputStream ois = new ObjectInputStream(this._socket.getInputStream());
                    answer = (Answer)ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error in reading Answer object", cnfe);
                    answer = null;
                    if (this._listener != null) {
                        this._listener.actionPerformed(new ActionEvent(this, 1001, "Answer is incompatible\nthere is probably an old version of Sybilla on the server"));
                    }
                    bAnswerError = true;
                }
                catch (ClassCastException cce) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error in reading Answer object", cce);
                    answer = null;
                    if (this._listener != null) {
                        this._listener.actionPerformed(new ActionEvent(this, 1001, "Answer is incompatible\nthere is probably an old version of Sybilla on the server"));
                    }
                    bAnswerError = true;
                }
                catch (InvalidClassException ice) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error in reading Answer object", ice);
                    answer = null;
                    if (this._listener != null) {
                        this._listener.actionPerformed(new ActionEvent(this, 1001, "Answer is incompatible\nthere is probably an old version of Sybilla on the server"));
                    }
                    bAnswerError = true;
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error in reading Answer object", ioe);
                    answer = null;
                    if (this._listener != null) {
                        this._listener.actionPerformed(new ActionEvent(this, 1001, "Error while reading answer:\n" + ioe.getMessage()));
                    }
                    bAnswerError = true;
                }
                catch (OutOfMemoryError oome) {
                    answer = null;
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "out of memory", oome);
                    if (this._listener != null) {
                        this._listener.actionPerformed(new ActionEvent(this, 1001, "You ran out of memory, try downloading a single task"));
                    }
                    bAnswerError = true;
                }
                if (answer != null) {
                    switch (answer.getAnswerID()) {
                        case 3: {
                            if (this._listener != null) {
                                this._hmTaskDoneNames = answer.getDoneTaskNames();
                                this._hmTaskToBeDoneNames = answer.getToBeDoneTaskNames();
                                this._listener.actionPerformed(new ActionEvent(this, 1001, FREE));
                                break;
                            }
                            break block44;
                        }
                        case 2: {
                            if (this._listener != null) {
                                this._hmTaskDoneNames = answer.getDoneTaskNames();
                                this._hmTaskToBeDoneNames = answer.getToBeDoneTaskNames();
                                this._iProgress = answer.getProgress();
                                this._sCalculatedPatternName = answer.getCalculatedPatternName();
                                this._dCurrentMisfit = answer.getCurrentMisfit();
                                this._bPhaseQuick = answer.isPhaseQuick();
                                this._listener.actionPerformed(new ActionEvent(this, 1001, BUSY));
                                break;
                            }
                            break block44;
                        }
                        case 4: {
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Remote Sybilla accepted the task"));
                                break;
                            }
                            break block44;
                        }
                        case 5: {
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Remote Sybilla received your request to stop"));
                                break;
                            }
                            break block44;
                        }
                        case 6: {
                            if (this._listener != null) {
                                this._aTasks = answer.getTasks();
                                if (this._aTasks != null && this._aTasks.length > 0) {
                                    this._listener.actionPerformed(new ActionEvent(this, 1001, TASKS_ARRIVED));
                                    break;
                                }
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "No tasks available"));
                                break;
                            }
                            break block44;
                        }
                        case 7: {
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Remote Sybilla accepted the new sybilla.jar\nnow you can safely shoot it down"));
                                break;
                            }
                            break block44;
                        }
                        case 8: {
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Remote Sybilla rejected the new sybilla.jar\nplease try again"));
                                break;
                            }
                            break block44;
                        }
                        case 9: {
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Remote Sybilla will exit within 5 seconds"));
                                break;
                            }
                            break block44;
                        }
                        case 10: {
                            if (this._listener != null) {
                                _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "remote log:\n" + answer.getCalculatedPatternName());
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Supposed remote log has been appended to a local log."));
                                break;
                            }
                            break block44;
                        }
                        default: {
                            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "received answer of unknown id: " + answer.getAnswerID());
                            if (this._listener != null) {
                                this._listener.actionPerformed(new ActionEvent(this, 1001, "Answer is incompatible\nthere is probably an old version of Sybilla on the server"));
                                break;
                            }
                            break block44;
                        }
                    }
                    break block44;
                }
                if (!bAnswerError) {
                    _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "got neither answer nor error, timed-out?");
                }
            }
            finally {
                try {
                    this._socket.close();
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorManual", "run", "error when trying to close socket", ioe);
                }
            }
        }
    }

    public Task[] getTasks() {
        return this._aTasks;
    }

    public HashMap getTaskDoneNames() {
        return this._hmTaskDoneNames;
    }

    public HashMap getTaskToBeDoneNames() {
        return this._hmTaskToBeDoneNames;
    }

    public int getProgress() {
        return this._iProgress;
    }

    public String getCalculatedPatternName() {
        return this._sCalculatedPatternName;
    }

    public double getCurrentMisfit() {
        return this._dCurrentMisfit;
    }

    public boolean isPhaseQuick() {
        return this._bPhaseQuick;
    }
}

