/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.xrd.mod.SybillaProducer;
import net.ndmystko.xrd.mod.net.RequestHandlerThread;

public class ConnectorAuto
implements Runnable {
    public static final int SERVER_PORT = 8222;
    private static final int ERROR_LIMIT = 15;
    private ServerSocket _serverSocket = new ServerSocket(8222);
    private int _iErrorCount = 0;
    private SybillaProducer _producer = null;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.net.ConnectorAuto");

    public ConnectorAuto(SybillaProducer producer) throws IOException {
        this._producer = producer;
    }

    @Override
    public void run() {
        Socket _socket = null;
        try {
            while (true) {
                try {
                    _socket = this._serverSocket.accept();
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorAuto", "run", "error in serverSocket.accept()", ioe);
                    if (++this._iErrorCount != 15) continue;
                    break;
                }
                ObjectInputStream ois = null;
                ObjectOutputStream oos = null;
                try {
                    ois = new ObjectInputStream(_socket.getInputStream());
                    oos = new ObjectOutputStream(_socket.getOutputStream());
                }
                catch (IOException ioe) {
                    _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.net.ConnectorAuto", "run", "error in building streams around the new socket", ioe);
                    try {
                        _socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (++this._iErrorCount != 15) continue;
                    break;
                }
                new Thread(new RequestHandlerThread(_socket, ois, oos, this._producer)).start();
            }
        }
        finally {
            try {
                this._serverSocket.close();
            }
            catch (IOException ioe) {
                _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.net.ConnectorAuto", "run", "error in closing server socket", ioe);
            }
        }
        _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.net.ConnectorAuto", "run", "Connector ends its short live");
    }
}

