/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer.edge;

import java.io.Serializable;
import java.util.List;
import net.ndmystko.xrd.AtomicScatteringFactor;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.layer.AbstractElement;
import net.ndmystko.xrd.mod.layer.DoubleValue;
import net.ndmystko.xrd.mod.layer.edge.AnyEdges;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public abstract class AbstractEdge
extends AbstractElement
implements Serializable {
    private static final long serialVersionUID = 5923142604018098544L;
    protected double[] _adFAStableK = null;
    protected double[] _adFBStableK = null;
    protected double[] _adFAK = null;
    protected double[] _adFBK = null;
    protected double[] _adFAStable0 = null;
    protected double[] _adFBStable0 = null;
    protected double[] _adFA0 = null;
    protected double[] _adFB0 = null;
    protected Object[][] _atomsK = null;
    protected Object[][] _atoms0 = null;
    protected DoubleValue _dSpacingK = null;
    protected DoubleValue _dSpacing0 = null;

    protected AbstractEdge(PatternParams params) {
        super(params);
        int iNoOfData = (int)Math.round((this._dMax2theta - this._dMin2theta) / this._dStepSize) + 1;
        this._adFAStableK = new double[iNoOfData];
        this._adFBStableK = new double[iNoOfData];
        this._adFAK = new double[iNoOfData];
        this._adFBK = new double[iNoOfData];
        this._adFAStable0 = new double[iNoOfData];
        this._adFBStable0 = new double[iNoOfData];
        this._adFA0 = new double[iNoOfData];
        this._adFB0 = new double[iNoOfData];
    }

    protected AbstractEdge(AbstractEdge pattern) {
        super(pattern._patternParams);
        int iNoOfData = (int)Math.round((this._dMax2theta - this._dMin2theta) / this._dStepSize) + 1;
        this._adFAStableK = new double[iNoOfData];
        this._adFBStableK = new double[iNoOfData];
        this._adFAK = new double[iNoOfData];
        this._adFBK = new double[iNoOfData];
        this._adFAStable0 = new double[iNoOfData];
        this._adFBStable0 = new double[iNoOfData];
        this._adFA0 = new double[iNoOfData];
        this._adFB0 = new double[iNoOfData];
    }

    public void computeCommonFactors(Object[][] atoms0, DoubleValue dSpacing0, Object[][] atomsK, DoubleValue dSpacingK) {
        this._dSpacing0 = dSpacing0;
        this._atoms0 = atoms0;
        this.computeCommonFactors(this._atoms0, this._adFAStable0, this._adFBStable0, this._patternParams);
        this._dSpacingK = dSpacingK;
        this._atomsK = atomsK;
        this.computeCommonFactors(this._atomsK, this._adFAStableK, this._adFBStableK, this._patternParams);
    }

    public void computeVariableFactors() {
        this.computeVariableFactors(this._atoms0, this._adFA0, this._adFB0, this._adFAStable0, this._adFBStable0, this._patternParams);
        this.computeVariableFactors(this._atomsK, this._adFAK, this._adFBK, this._adFAStableK, this._adFBStableK, this._patternParams);
    }

    public double getDSpacing0() {
        return this._dSpacing0.getValue();
    }

    public double getTotalDSpacing() {
        return this._dSpacing0.getValue() + this._dSpacingK.getValue();
    }

    @Override
    protected double getBCellParam() {
        return 9.0;
    }

    public double getVolume() {
        double dB = this.getBCellParam();
        double dA = dB / Math.sqrt(3.0);
        double dC = this._dSpacing0.getValue() + this._dSpacingK.getValue();
        return dA * dB * dC;
    }

    public double getDensity(double dVolume) {
        return (this.getWeight(this._atoms0) + this.getWeight(this._atomsK)) / dVolume;
    }

    public double getFactorAK(int index) {
        return this._adFAK[index];
    }

    public double getFactorAK(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFAK[index];
    }

    public double[] getFactorAK() {
        return this._adFAK;
    }

    public double getFactorBK(int index) {
        return this._adFBK[index];
    }

    public double getFactorBK(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFBK[index];
    }

    public double[] getFactorBK() {
        return this._adFBK;
    }

    public double getFactorA0(int index) {
        return this._adFA0[index];
    }

    public double getFactorA0(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFA0[index];
    }

    public double[] getFactorA0() {
        return this._adFA0;
    }

    public double getFactorB0(int index) {
        return this._adFB0[index];
    }

    public double getFactorB0(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFB0[index];
    }

    public double[] getFactorB0() {
        return this._adFB0;
    }

    public Element serializeXML() {
        Element edge = new Element("edge");
        edge.setAttribute("name", this.getName());
        Element topLayer = new Element("top_edge");
        topLayer.setAttribute("d_spacing", String.valueOf(this._dSpacingK.getValue()));
        edge.addContent(topLayer);
        int i = 0;
        while (i < this._atomsK.length) {
            Element atom = new Element("atom");
            atom.setAttribute("type", AtomicScatteringFactor.getName((Integer)this._atomsK[i][0]));
            atom.setAttribute("position", String.valueOf(((DoubleValue)this._atomsK[i][1]).getValue()));
            atom.setAttribute("content", String.valueOf(((DoubleValue)this._atomsK[i][2]).getValue()));
            topLayer.addContent(atom);
            ++i;
        }
        Element bottomLayer = new Element("bottom_edge");
        bottomLayer.setAttribute("d_spacing", String.valueOf(this._dSpacing0.getValue()));
        edge.addContent(bottomLayer);
        int i2 = 0;
        while (i2 < this._atoms0.length) {
            Element atom = new Element("atom");
            atom.setAttribute("type", AtomicScatteringFactor.getName((Integer)this._atoms0[i2][0]));
            atom.setAttribute("position", String.valueOf(((DoubleValue)this._atoms0[i2][1]).getValue()));
            atom.setAttribute("content", String.valueOf(((DoubleValue)this._atoms0[i2][2]).getValue()));
            bottomLayer.addContent(atom);
            ++i2;
        }
        return edge;
    }

    public static AbstractEdge deserializeXML(Element owner, PatternParams patternParams) throws DataConversionException, IllegalArgumentException {
        Element edge = owner.getChild("edge");
        if (edge == null) {
            return null;
        }
        Attribute aName = edge.getAttribute("name");
        String sName = aName == null ? "unknown" : aName.getValue();
        boolean bTopPresent = false;
        Element eTopEdge = edge.getChild("top_edge");
        Object[][] aAtomsK = new Object[0][0];
        double dTopEdgeDSpacing = 0.0;
        if (eTopEdge != null) {
            Attribute aDSpacing = eTopEdge.getAttribute("d_spacing");
            if (aDSpacing == null) {
                throw new IllegalArgumentException("Missing d-spacing of the top layer '" + sName + "'");
            }
            dTopEdgeDSpacing = aDSpacing.getDoubleValue();
            List lAtoms = eTopEdge.getChildren("atom");
            if (lAtoms.size() > 0) {
                bTopPresent = true;
                int i = 0;
                aAtomsK = new Object[lAtoms.size()][3];
                for (Element atom : lAtoms) {
                    Attribute aType = atom.getAttribute("type");
                    if (aType == null) {
                        throw new IllegalArgumentException("Missing atom type in top edge '" + sName + "'");
                    }
                    int iIndex = AtomicScatteringFactor.getIndex(aType.getValue());
                    if (iIndex < 0) {
                        throw new IllegalArgumentException("Unknown atom type " + aType.getValue() + " in top edge '" + sName + "'");
                    }
                    aAtomsK[i][0] = new Integer(iIndex);
                    Attribute aPosition = atom.getAttribute("position");
                    if (aPosition == null) {
                        throw new IllegalArgumentException("Missing atom position in top edge '" + sName + "'");
                    }
                    aAtomsK[i][1] = new DoubleValue(aPosition.getDoubleValue());
                    Attribute aQuantity = atom.getAttribute("content");
                    if (aQuantity == null) {
                        throw new IllegalArgumentException("Missing atom content in top edge '" + sName + "'");
                    }
                    aAtomsK[i][2] = new DoubleValue(aQuantity.getDoubleValue());
                    ++i;
                }
            }
        }
        Element eBottomEdge = edge.getChild("bottom_edge");
        Object[][] aAtoms0 = new Object[0][0];
        double dBottomEdgeDSpacing = 0.0;
        if (eBottomEdge != null) {
            Attribute aDSpacing = eBottomEdge.getAttribute("d_spacing");
            if (aDSpacing == null) {
                throw new IllegalArgumentException("Missing d-spacing of the bottom layer '" + sName + "'");
            }
            dBottomEdgeDSpacing = aDSpacing.getDoubleValue();
            List lAtoms = eBottomEdge.getChildren("atom");
            if (lAtoms.size() > 0) {
                int i = 0;
                aAtoms0 = new Object[lAtoms.size()][3];
                for (Element atom : lAtoms) {
                    Attribute aType = atom.getAttribute("type");
                    if (aType == null) {
                        throw new IllegalArgumentException("Missing atom type in bottom edge '" + sName + "'");
                    }
                    int iIndex = AtomicScatteringFactor.getIndex(aType.getValue());
                    if (iIndex < 0) {
                        throw new IllegalArgumentException("Unknown atom type " + aType.getValue() + " in bottom edge '" + sName + "'");
                    }
                    aAtoms0[i][0] = new Integer(iIndex);
                    Attribute aPosition = atom.getAttribute("position");
                    if (aPosition == null) {
                        throw new IllegalArgumentException("Missing atom position in bottom edge '" + sName + "'");
                    }
                    aAtoms0[i][1] = new DoubleValue(aPosition.getDoubleValue());
                    Attribute aQuantity = atom.getAttribute("content");
                    if (aQuantity == null) {
                        throw new IllegalArgumentException("Missing atom content in bottom edge '" + sName + "'");
                    }
                    aAtoms0[i][2] = new DoubleValue(aQuantity.getDoubleValue());
                    ++i;
                }
            } else if (!bTopPresent) {
                return null;
            }
        } else if (!bTopPresent) {
            return null;
        }
        AnyEdges result = new AnyEdges(patternParams, aAtoms0, aAtomsK, new DoubleValue(dBottomEdgeDSpacing), new DoubleValue(dTopEdgeDSpacing));
        result.setName(sName);
        return result;
    }
}

