/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.ndmystko.xrd.AtomicScatteringFactor;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;
import org.jdom.Element;

public class TalcLayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = 7970289079145690598L;
    private static final double D_SPACING_LOW = 9.33;
    private static final double D_SPACING_HIGH = 9.4;
    private static final double D_SPACING_DEFAULT = 9.33;
    private DoubleValue _dSpacing = new DoubleValue(9.33);
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private Object[][] _aAtoms = new Object[][]{{new Integer(1), new DoubleValue(0.0), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(0.01), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(0.012), new DoubleValue(2.0)}, {new Integer(4), new DoubleValue(0.544), new DoubleValue(2.0)}, {new Integer(4), new DoubleValue(0.546), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(2.163), new DoubleValue(4.0)}, {new Integer(12), new DoubleValue(2.21), new DoubleValue(2.0)}, {new Integer(10), new DoubleValue(3.26), new DoubleValue(6.0)}, {new Integer(12), new DoubleValue(4.31), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(4.357), new DoubleValue(4.0)}, {new Integer(4), new DoubleValue(5.974), new DoubleValue(2.0)}, {new Integer(4), new DoubleValue(5.976), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(6.508), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(6.51), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(6.52), new DoubleValue(2.0)}};
    private static final double D_SPACING_DECAY_CONST = 2.0;
    private static final String NAME = "talc";
    DecimalFormat formatter;

    public TalcLayer(PatternParams params) {
        super(params);
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
        this.setFormatter();
    }

    public TalcLayer(AbstractLayer absPattern) {
        super(absPattern);
        TalcLayer pattern = (TalcLayer)absPattern;
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i = 0;
        while (i < genes.length) {
            genes[i].updateTo(patternGenes[i]);
            ++i;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
        this.setFormatter();
    }

    private void setFormatter() {
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
    }

    @Override
    public Element serializeXML() {
        Element layer = new Element("layer");
        layer.setAttribute("name", this.getName());
        layer.setAttribute("d_spacing", String.valueOf(this._dSpacing.getValue()));
        layer.setAttribute("d_spacing_delta", String.valueOf(this._dSpacingDelta.getValue()));
        int i = 0;
        while (i < this._atoms.length) {
            Element atom = new Element("atom");
            atom.setAttribute("type", AtomicScatteringFactor.getName((Integer)this._atoms[i][0]));
            atom.setAttribute("position", this.formatter.format(((DoubleValue)this._atoms[i][1]).getValue()));
            atom.setAttribute("content", String.valueOf(((DoubleValue)this._atoms[i][2]).getValue()));
            layer.addContent(atom);
            ++i;
        }
        return layer;
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[1];
        DoubleValue[] aDSpacing = new DoubleValue[]{this._dSpacing};
        ContentGene dSpacingGene = new ContentGene(9.33, 9.4, 9.33, 2.0, aDSpacing);
        dSpacingGene.setName("d-spacing");
        genes[0] = dSpacingGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 9.179;
    }
}

