/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class SerpentineLayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = -781073147307254044L;
    private static final double D_SPACING_LOW = 7.0;
    private static final double D_SPACING_HIGH = 7.25;
    private static final double D_SPACING_DEFAULT = 7.156;
    private DoubleValue _dSpacing = new DoubleValue(7.156);
    private static final double D_DELTA_LOW = 0.0;
    private static final double D_DELTA_HIGH = 0.5;
    private static final double D_DELTA_DEFAULT = 0.0;
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private Object[][] _aAtoms = new Object[][]{{new Integer(12), new DoubleValue(4.32), new DoubleValue(6.0)}, {new Integer(6), new DoubleValue(3.31), new DoubleValue(1.0)}, {new Integer(10), new DoubleValue(3.31), new DoubleValue(5.0)}, {new Integer(12), new DoubleValue(2.27), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(2.27), new DoubleValue(4.0)}, {new Integer(4), new DoubleValue(0.58), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private static final int OCT_FE_ID = 1;
    private static final int OCT_MG_ID = 2;
    private static final double D_DELTA_DECAY_CONST = 2.0;
    private static final double D_SPACING_DECAY_CONST = 2.0;
    private static final double OCT_FE_DECAY_CONST = 1.0;
    private static final String NAME = "serpentine";

    public SerpentineLayer(PatternParams params) {
        super(params);
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public SerpentineLayer(AbstractLayer absPattern) {
        super(absPattern);
        SerpentineLayer pattern = (SerpentineLayer)absPattern;
        this._dSpacingDelta.setValue(pattern._dSpacingDelta.getValue());
        this._dSpacingDelta.setGene(pattern._dSpacingDelta.isGene());
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i = 0;
        while (i < genes.length) {
            genes[i].updateTo(patternGenes[i]);
            ++i;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[3];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[1][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[2][2], (DoubleValue)this._aAtoms[1][2]);
        octIronGene.setName("oct iron content");
        genes[0] = octIronGene;
        DoubleValue[] aDSpacing = new DoubleValue[]{this._dSpacing};
        ContentGene dSpacingGene = new ContentGene(7.0, 7.25, 7.156, 2.0, aDSpacing);
        dSpacingGene.setName("d-spacing");
        genes[1] = dSpacingGene;
        DoubleValue[] aDSpacingDelta = new DoubleValue[]{this._dSpacingDelta};
        ContentGene deltaDSpacingGene = new ContentGene(0.0, 0.5, 0.0, 2.0, aDSpacingDelta);
        deltaDSpacingGene.setActive(false);
        deltaDSpacingGene.setName("delta d-spacing");
        genes[2] = deltaDSpacingGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 9.22 + 0.017 * ((DoubleValue)this._aAtoms[1][2]).getValue();
    }
}

