/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.ndmystko.xrd.Diffractometer;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.ChloriteLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteOneGlyLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoGlyLayer;
import net.ndmystko.xrd.mod.layer.HydrotalciteCO3WatLayer;
import net.ndmystko.xrd.mod.layer.HydrotalciteHorizSO4WatLayer;
import net.ndmystko.xrd.mod.layer.HydrotalciteVertSO4WatLayer;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.ProbabCondition20;
import net.ndmystko.xrd.mod.probab.ProbabCondition30;

public class LayerJUTest
extends TestCase {
    private PatternParams _params = null;

    public LayerJUTest(String sMethodName) {
        super(sMethodName);
    }

    public void setUp() throws Exception {
        this._params = new PatternParams(2.0, 52.0, 0.05, new Diffractometer());
    }

    public void testDiSmectiteOneGly() {
        DiSmectiteOneGlyLayer layer1 = new DiSmectiteOneGlyLayer(this._params);
        layer1.updateLayer();
        layer1.computeVariableFactors();
        DiSmectiteOneGlyLayer layer2 = new DiSmectiteOneGlyLayer(layer1);
        layer2.updateLayer();
        layer2.computeVariableFactors();
        LayerJUTest.assertEquals((double)layer1._adFA[0], (double)layer2._adFA[0], (double)1.0E-12);
        layer1.getGenes()[1].setGeneValue(13.33);
        layer1.updateLayer();
        layer1.computeVariableFactors();
        layer2.updateLayer();
        layer2.computeVariableFactors();
        LayerJUTest.assertFalse((Math.abs(layer1._adFA[0] - layer2._adFA[0]) < 1.0E-12 ? 1 : 0) != 0);
        layer1.updateLayer();
        layer1.computeVariableFactors();
        layer2.getGenes()[1].setGeneValue(13.33);
        layer2.updateLayer();
        layer2.computeVariableFactors();
        LayerJUTest.assertEquals((double)layer1._adFA[0], (double)layer2._adFA[0], (double)1.0E-12);
    }

    public void testHtcHtsv() {
        Phase phase1 = new Phase(this._params, new HydrotalciteCO3WatLayer(this._params), null, 63, false);
        phase1.calcIntensities();
        AbstractLayer[] layers = new AbstractLayer[]{new HydrotalciteCO3WatLayer(this._params), new HydrotalciteVertSO4WatLayer(this._params)};
        ProbabCondition20 probab = new ProbabCondition20();
        MixedLayerPhase phase2 = new MixedLayerPhase(this._params, layers, null, probab, 66, false);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertFalse((Math.abs(phase1.getIntensities().getIntensity(0) - phase2.getIntensities().getIntensity(0)) < 1.0E-10 ? 1 : 0) != 0);
        probab.setIlliteContent(1.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase1.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
        Phase phase3 = new Phase(this._params, new HydrotalciteVertSO4WatLayer(this._params), null, 64, false);
        phase3.calcIntensities();
        probab.setIlliteContent(0.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase3.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
    }

    public void testHtcHtsh() {
        Phase phase1 = new Phase(this._params, new HydrotalciteCO3WatLayer(this._params), null, 63, false);
        phase1.calcIntensities();
        AbstractLayer[] layers = new AbstractLayer[]{new HydrotalciteCO3WatLayer(this._params), new HydrotalciteHorizSO4WatLayer(this._params)};
        ProbabCondition20 probab = new ProbabCondition20();
        MixedLayerPhase phase2 = new MixedLayerPhase(this._params, layers, null, probab, 67, false);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertFalse((Math.abs(phase1.getIntensities().getIntensity(0) - phase2.getIntensities().getIntensity(0)) < 1.0E-10 ? 1 : 0) != 0);
        probab.setIlliteContent(1.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase1.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
        Phase phase3 = new Phase(this._params, new HydrotalciteHorizSO4WatLayer(this._params), null, 65, false);
        phase3.calcIntensities();
        probab.setIlliteContent(0.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase3.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
    }

    public void testChS() {
        Phase phase1 = new Phase(this._params, new ChloriteLayer(this._params), null, 63, false);
        phase1.calcIntensities();
        AbstractLayer[] layers = new AbstractLayer[]{new ChloriteLayer(this._params), new DiSmectiteTwoGlyLayer(this._params)};
        ProbabCondition20 probab = new ProbabCondition20();
        MixedLayerPhase phase2 = new MixedLayerPhase(this._params, layers, null, probab, 54, false);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertFalse((Math.abs(phase1.getIntensities().getIntensity(0) - phase2.getIntensities().getIntensity(0)) < 1.0E-10 ? 1 : 0) != 0);
        probab.setIlliteContent(1.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase1.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
        Phase phase3 = new Phase(this._params, new DiSmectiteTwoGlyLayer(this._params), null, 65, false);
        phase3.calcIntensities();
        probab.setIlliteContent(0.0);
        assert (((AbstractProbabCondition)probab).updateProbability());
        ((Phase)phase2).calcIntensities();
        LayerJUTest.assertEquals((double)phase3.getIntensities().getIntensity(0), (double)phase2.getIntensities().getIntensity(0), (double)1.0E-10);
        AbstractLayer[] layers2 = new AbstractLayer[]{new ChloriteLayer(this._params), new DiSmectiteTwoGlyLayer(this._params), new DiSmectiteOneGlyLayer(this._params)};
        ProbabCondition30 probab2 = new ProbabCondition30(0.0, 1.0);
        MixedLayerPhase phase5 = new MixedLayerPhase(this._params, layers2, null, probab2, 68, false);
        assert (((AbstractProbabCondition)probab2).updateProbability());
        ((Phase)phase5).calcIntensities();
        AbstractLayer[] layers1 = new AbstractLayer[]{new DiSmectiteTwoGlyLayer(this._params), new DiSmectiteOneGlyLayer(this._params)};
        ProbabCondition20 probab1 = new ProbabCondition20();
        MixedLayerPhase phase4 = new MixedLayerPhase(this._params, layers1, null, probab1, 0, false);
        assert (((AbstractProbabCondition)probab1).updateProbability());
        ((Phase)phase4).calcIntensities();
        LayerJUTest.assertFalse((Math.abs(phase5.getIntensities().getIntensity(0) - phase4.getIntensities().getIntensity(0)) < 1.0E-10 ? 1 : 0) != 0);
        probab2.setIlliteContent(0.0);
        assert (((AbstractProbabCondition)probab2).updateProbability());
        ((Phase)phase5).calcIntensities();
        probab1.setIlliteContent(0.5);
        assert (((AbstractProbabCondition)probab1).updateProbability());
        ((Phase)phase4).calcIntensities();
        LayerJUTest.assertEquals((double)phase4.getIntensities().getIntensity(0), (double)phase5.getIntensities().getIntensity(0), (double)1.0E-10);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new LayerJUTest("testDiSmectiteOneGly"));
        suite.addTest((Test)new LayerJUTest("testHtcHtsv"));
        suite.addTest((Test)new LayerJUTest("testHtcHtsh"));
        suite.addTest((Test)new LayerJUTest("testChS"));
        return suite;
    }

    public static void main(String[] argv) throws Exception {
        LayerJUTest test = new LayerJUTest("testDiSmectiteOneGly");
        test.setUp();
        test.testHtcHtsv();
    }
}

