/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.gene.RelatedPositionAndRatioGene;
import net.ndmystko.xrd.mod.gene.RelativeContentGeneBasedOnActualContentChloriteOctahedral;
import net.ndmystko.xrd.mod.gene.TotalContentGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class IlliteLayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = 4865849185235808265L;
    public static final double D_SPACING_LOW = 9.6;
    public static final double D_SPACING_HIGH = 10.7;
    public static final double D_SPACING_DEFAULT = 9.98;
    private DoubleValue _dSpacing = new DoubleValue(9.98);
    private static final double D_DELTA_LOW = 0.0;
    private static final double D_DELTA_HIGH = 0.6;
    private static final double D_DELTA_DEFAULT = 0.0;
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    public static final double INTER_CONT_LOW = 0.5;
    public static final double INTER_CONT_HIGH = 2.0;
    public static final double INTER_CONT_DEFAULT = 2.0;
    private Object[][] _aAtoms = new Object[][]{{new Integer(16), new DoubleValue(8.29), new DoubleValue(0.0)}, {new Integer(7), new DoubleValue(8.29), new DoubleValue(1.9)}, {new Integer(1), new DoubleValue(6.6), new DoubleValue(6.0)}, {new Integer(4), new DoubleValue(6.02), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(4.365), new DoubleValue(4.0)}, {new Integer(12), new DoubleValue(4.365), new DoubleValue(2.0)}, {new Integer(6), new DoubleValue(3.3), new DoubleValue(0.5)}, {new Integer(5), new DoubleValue(3.3), new DoubleValue(5.5)}, {new Integer(12), new DoubleValue(2.235), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(2.235), new DoubleValue(4.0)}, {new Integer(4), new DoubleValue(0.58), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private DoubleValue[] _aOctahedralQuant = new DoubleValue[]{(DoubleValue)this._aAtoms[6][2], (DoubleValue)this._aAtoms[7][2]};
    private double[] _adOctahedralOrigValues = new double[]{((DoubleValue)this._aAtoms[6][2]).getValue(), ((DoubleValue)this._aAtoms[7][2]).getValue()};
    private static final int OCT_FE_ID = 6;
    private static final int OCT_AL_ID = 7;
    private static final int INT_NH_ID = 0;
    private static final int INT_K_ID = 1;
    private static final int UPPER_OXY_ID = 2;
    public static final double OCT_FE_DECAY_CONST = 1.0;
    public static final double D_SPACING_DECAY_CONST = 2.0;
    public static final double INTER_CONT_DECAY_CONST = 2.0;
    private static final double D_DELTA_DECAY_CONST = 2.0;
    private static final double OCT_FE_MAX_CONTENT = 1.0;
    private static final double INTER_CONT_FACTOR_DECAY_CONST = 2.0;
    private static final String NAME = "illite";

    public IlliteLayer(PatternParams params) {
        super(params);
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public IlliteLayer(AbstractLayer absPattern) {
        super(absPattern);
        IlliteLayer pattern = (IlliteLayer)absPattern;
        int i = 0;
        while (i < this._aAtoms.length) {
            this._aAtoms[i][0] = new Integer((Integer)pattern._aAtoms[i][0]);
            DoubleValue atomQuant = (DoubleValue)pattern._aAtoms[i][2];
            ((DoubleValue)this._aAtoms[i][2]).setValue(atomQuant.getValue());
            ((DoubleValue)this._aAtoms[i][2]).setGene(atomQuant.isGene());
            DoubleValue atomPos = (DoubleValue)pattern._aAtoms[i][1];
            ((DoubleValue)this._aAtoms[i][1]).setValue(atomPos.getValue());
            ((DoubleValue)this._aAtoms[i][1]).setGene(atomPos.isGene());
            ++i;
        }
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        this._dSpacingDelta.setValue(pattern._dSpacingDelta.getValue());
        this._dSpacingDelta.setGene(pattern._dSpacingDelta.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i2 = 0;
        while (i2 < genes.length) {
            genes[i2].updateTo(patternGenes[i2]);
            ++i2;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[5];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[6][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[7][2], (DoubleValue)this._aAtoms[6][2]);
        octIronGene.setName("oct iron content");
        octIronGene.getConnector().getGene().set_dHighLimit(1.0);
        genes[0] = octIronGene;
        RelativeContentGeneBasedOnActualContentChloriteOctahedral octahedralVacancyGene = new RelativeContentGeneBasedOnActualContentChloriteOctahedral(0.5, 1.0, 0.667, 2.0, this._aOctahedralQuant, this._adOctahedralOrigValues);
        octahedralVacancyGene.setName("vacancy in octahedral (=0.67 dioctahedral; =1.0 trioctahedral)");
        octahedralVacancyGene.computeVariables();
        genes[1] = octahedralVacancyGene;
        RelatedPositionAndRatioGene interPosGene = new RelatedPositionAndRatioGene(9.6, 10.7, 9.98, 2.0, (DoubleValue)this._aAtoms[1][1], (DoubleValue)this._aAtoms[0][1], (DoubleValue)this._aAtoms[1][2], (DoubleValue)this._aAtoms[0][2], this._dSpacing, ((DoubleValue)this._aAtoms[2][1]).getValue(), 9.98, 10.35);
        interPosGene.setName("d-spacing");
        interPosGene.setActive(false);
        genes[2] = interPosGene;
        TotalContentGene interContGene = new TotalContentGene(0.5, 2.0, ((DoubleValue)this._aAtoms[1][2]).getValue(), 2.0, (DoubleValue)this._aAtoms[1][2], (DoubleValue)this._aAtoms[0][2]);
        interContGene.setName("interlayer cation content");
        interContGene.setActive(false);
        genes[3] = interContGene;
        DoubleValue[] aDSpacingDelta = new DoubleValue[]{this._dSpacingDelta};
        ContentGene deltaDSpacingGene = new ContentGene(0.0, 0.6, 0.0, 2.0, aDSpacingDelta);
        deltaDSpacingGene.setActive(true);
        deltaDSpacingGene.setName("delta d-spacing");
        genes[4] = deltaDSpacingGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 9.0 + 0.042 * ((DoubleValue)this._aAtoms[6][2]).getValue();
    }

    public double getKContent() {
        return ((DoubleValue)this._aAtoms[1][2]).getValue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (Math.abs(4.0 - ((DoubleValue)this._aAtoms[6][2]).getValue() - ((DoubleValue)this._aAtoms[7][2]).getValue()) > 1.0E-8) {
            System.out.println("Mismatch in oct cation, Fe: " + ((DoubleValue)this._aAtoms[6][2]).getValue() + ", Al: " + ((DoubleValue)this._aAtoms[7][2]).getValue());
        } else {
            System.out.println("Oct iron in IlliteLayer ok.");
        }
    }
}

