/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.gene.ContentSubstGene;
import net.ndmystko.xrd.mod.gene.RelatedPositionGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class HydrotalciteHorizSO4WatLayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = -1466977697034139432L;
    private static final double D_SPACING_LOW = 8.84;
    private static final double D_SPACING_HIGH = 8.95;
    private static final double D_SPACING_DEFAULT = 8.84;
    private DoubleValue _dSpacing = new DoubleValue(8.84);
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private Object[][] _aAtoms = new Object[][]{{new Integer(1), new DoubleValue(6.72), new DoubleValue(0.5)}, {new Integer(13), new DoubleValue(6.06), new DoubleValue(1.5)}, {new Integer(1), new DoubleValue(6.06), new DoubleValue(1.5)}, {new Integer(3), new DoubleValue(5.42), new DoubleValue(1.0)}, {new Integer(1), new DoubleValue(4.79), new DoubleValue(1.5)}, {new Integer(13), new DoubleValue(4.79), new DoubleValue(1.5)}, {new Integer(1), new DoubleValue(4.13), new DoubleValue(0.5)}, {new Integer(12), new DoubleValue(2.0), new DoubleValue(6.0)}, {new Integer(6), new DoubleValue(1.0), new DoubleValue(0.0)}, {new Integer(5), new DoubleValue(1.0), new DoubleValue(6.0)}, {new Integer(12), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private DoubleValue[] _aInterPos = new DoubleValue[]{(DoubleValue)this._aAtoms[0][1], (DoubleValue)this._aAtoms[1][1], (DoubleValue)this._aAtoms[2][1], (DoubleValue)this._aAtoms[3][1], (DoubleValue)this._aAtoms[4][1], (DoubleValue)this._aAtoms[5][1], (DoubleValue)this._aAtoms[6][1]};
    private double[] _adInterRelativePos = new double[]{1.29, 0.63, 0.63, 0.0, -0.63, -0.63, -1.29};
    private DoubleValue[] _aInterCont = new DoubleValue[]{(DoubleValue)this._aAtoms[0][2], (DoubleValue)this._aAtoms[1][2], (DoubleValue)this._aAtoms[2][2], (DoubleValue)this._aAtoms[3][2], (DoubleValue)this._aAtoms[4][2], (DoubleValue)this._aAtoms[5][2], (DoubleValue)this._aAtoms[6][2]};
    private double[] _adDefaultInterCont = new double[]{this._aInterCont[0].getValue(), this._aInterCont[1].getValue(), this._aInterCont[2].getValue(), this._aInterCont[3].getValue(), this._aInterCont[4].getValue(), this._aInterCont[5].getValue(), this._aInterCont[6].getValue()};
    private boolean[] _abInterAdd;
    private static final double INTER_CONTENT_MAX_SHIFT = 0.25;
    private static final int UPPER_OH_ID = 7;
    private static final int OCT_FE_ID = 8;
    private static final int OCT_AL_ID = 9;
    private static final double OCT_FE_DECAY_CONST = 1.0;
    private static final double D_SPACING_DECAY_CONST = 2.0;
    private static final double INTERLAYER_DECAY_CONST = 2.0;
    private static final String NAME = "hydrotalcite horiz SO4 wat";

    public HydrotalciteHorizSO4WatLayer(PatternParams params) {
        super(params);
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[5] = true;
        this._abInterAdd = blArray;
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public HydrotalciteHorizSO4WatLayer(AbstractLayer absPattern) {
        super(absPattern);
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[5] = true;
        this._abInterAdd = blArray;
        HydrotalciteHorizSO4WatLayer pattern = (HydrotalciteHorizSO4WatLayer)absPattern;
        int i = 0;
        while (i < this._aAtoms.length) {
            this._aAtoms[i][0] = new Integer((Integer)pattern._aAtoms[i][0]);
            DoubleValue atomQuant = (DoubleValue)pattern._aAtoms[i][2];
            ((DoubleValue)this._aAtoms[i][2]).setValue(atomQuant.getValue());
            ((DoubleValue)this._aAtoms[i][2]).setGene(atomQuant.isGene());
            DoubleValue atomPos = (DoubleValue)pattern._aAtoms[i][1];
            ((DoubleValue)this._aAtoms[i][1]).setValue(atomPos.getValue());
            ((DoubleValue)this._aAtoms[i][1]).setGene(atomPos.isGene());
            ++i;
        }
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i2 = 0;
        while (i2 < genes.length) {
            genes[i2].updateTo(patternGenes[i2]);
            ++i2;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[3];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[8][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[9][2], (DoubleValue)this._aAtoms[8][2]);
        octIronGene.setName("oct iron content");
        genes[0] = octIronGene;
        RelatedPositionGene interPosGene = new RelatedPositionGene(8.84, 8.95, 8.84, 2.0, this._aInterPos, this._adInterRelativePos, this._dSpacing, ((DoubleValue)this._aAtoms[7][1]).getValue());
        interPosGene.setName("d-spacing");
        genes[1] = interPosGene;
        ContentSubstGene interContGene = new ContentSubstGene(this._aInterCont, this._adDefaultInterCont, this._abInterAdd, 0.25, 2.0);
        interContGene.setName("interlayer content shift");
        genes[2] = interContGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 3.04;
    }
}

