/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.gene.ContentSubstGene;
import net.ndmystko.xrd.mod.gene.RelatedPositionGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class HydrotalciteCO3WatLayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = 8150080251052319044L;
    private static final double D_SPACING_LOW = 7.56;
    private static final double D_SPACING_HIGH = 7.9;
    private static final double D_SPACING_DEFAULT = 7.56;
    private DoubleValue _dSpacing = new DoubleValue(7.56);
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private Object[][] _aAtoms = new Object[][]{{new Integer(17), new DoubleValue(4.78), new DoubleValue(1.0)}, {new Integer(13), new DoubleValue(4.78), new DoubleValue(4.0)}, {new Integer(12), new DoubleValue(2.0), new DoubleValue(6.0)}, {new Integer(6), new DoubleValue(1.0), new DoubleValue(0.0)}, {new Integer(5), new DoubleValue(1.0), new DoubleValue(6.0)}, {new Integer(12), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private DoubleValue[] _aInterPos = new DoubleValue[]{(DoubleValue)this._aAtoms[0][1], (DoubleValue)this._aAtoms[1][1]};
    private double[] _adInterRelativePos = new double[]{0.0, 0.0};
    private DoubleValue[] _aInterCont = new DoubleValue[]{(DoubleValue)this._aAtoms[0][2], (DoubleValue)this._aAtoms[1][2]};
    private double[] _adDefaultInterCont = new double[]{this._aInterCont[0].getValue(), this._aInterCont[1].getValue()};
    private boolean[] _abInterAdd;
    private static final int INTER_CO3_ID = 0;
    private static final int INTER_H2O_ID = 1;
    private static final int UPPER_OH_ID = 2;
    private static final int OCT_FE_ID = 3;
    private static final int OCT_AL_ID = 4;
    private static final double INTER_CONTENT_MAX_SHIFT = 0.5;
    private static final double OCT_FE_DECAY_CONST = 1.0;
    private static final double D_SPACING_DECAY_CONST = 2.0;
    private static final double INTERLAYER_DECAY_CONST = 2.0;
    private static final String NAME = "hydrotalcite CO3 wat";

    public HydrotalciteCO3WatLayer(PatternParams params) {
        super(params);
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this._abInterAdd = blArray;
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public HydrotalciteCO3WatLayer(AbstractLayer absPattern) {
        super(absPattern);
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this._abInterAdd = blArray;
        HydrotalciteCO3WatLayer pattern = (HydrotalciteCO3WatLayer)absPattern;
        int i = 0;
        while (i < this._aAtoms.length) {
            this._aAtoms[i][0] = new Integer((Integer)pattern._aAtoms[i][0]);
            DoubleValue atomQuant = (DoubleValue)pattern._aAtoms[i][2];
            ((DoubleValue)this._aAtoms[i][2]).setValue(atomQuant.getValue());
            ((DoubleValue)this._aAtoms[i][2]).setGene(atomQuant.isGene());
            DoubleValue atomPos = (DoubleValue)pattern._aAtoms[i][1];
            ((DoubleValue)this._aAtoms[i][1]).setValue(atomPos.getValue());
            ((DoubleValue)this._aAtoms[i][1]).setGene(atomPos.isGene());
            ++i;
        }
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i2 = 0;
        while (i2 < genes.length) {
            genes[i2].updateTo(patternGenes[i2]);
            ++i2;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[3];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[3][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[4][2], (DoubleValue)this._aAtoms[3][2]);
        octIronGene.setName("oct iron content");
        genes[0] = octIronGene;
        RelatedPositionGene interPosGene = new RelatedPositionGene(7.56, 7.9, 7.56, 2.0, this._aInterPos, this._adInterRelativePos, this._dSpacing, ((DoubleValue)this._aAtoms[2][1]).getValue());
        interPosGene.setName("d-spacing");
        genes[1] = interPosGene;
        ContentSubstGene interContGene = new ContentSubstGene(this._aInterCont, this._adDefaultInterCont, this._abInterAdd, 0.5, 2.0);
        interContGene.setName("interlayer content shift");
        genes[2] = interContGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 3.04;
    }
}

