/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.gene.RelatedPositionGene;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.AbstractSmectite;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class DiSmectiteTwoWatLayer
extends AbstractSmectite
implements Serializable {
    private static final long serialVersionUID = 5329597969076377247L;
    private static final double D_SPACING_LOW = 14.0;
    private static final double D_SPACING_HIGH = 16.0;
    private static final double D_SPACING_DEFAULT = 15.0;
    private DoubleValue _dSpacing = new DoubleValue(15.0);
    private static final double D_DELTA_LOW = 0.0;
    private static final double D_DELTA_HIGH = 0.75;
    private static final double D_DELTA_DEFAULT = 0.0;
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private Object[][] _aAtoms = new Object[][]{{new Integer(13), new DoubleValue(11.97), new DoubleValue(0.0)}, {new Integer(9), new DoubleValue(10.77), new DoubleValue(0.0)}, {new Integer(13), new DoubleValue(9.57), new DoubleValue(0.0)}, {new Integer(1), new DoubleValue(6.54), new DoubleValue(6.0)}, {new Integer(4), new DoubleValue(5.97), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(4.33), new DoubleValue(4.0)}, {new Integer(12), new DoubleValue(4.33), new DoubleValue(2.0)}, {new Integer(6), new DoubleValue(3.27), new DoubleValue(0.5)}, {new Integer(5), new DoubleValue(3.27), new DoubleValue(3.5)}, {new Integer(12), new DoubleValue(2.21), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(2.21), new DoubleValue(4.0)}, {new Integer(4), new DoubleValue(0.57), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private DoubleValue[] _aInterPos = new DoubleValue[]{(DoubleValue)this._aAtoms[0][1], (DoubleValue)this._aAtoms[1][1], (DoubleValue)this._aAtoms[2][1]};
    private double[] _adInterRelativePos = new double[]{((DoubleValue)this._aAtoms[0][1]).getValue() - ((DoubleValue)this._aAtoms[1][1]).getValue(), 0.0, ((DoubleValue)this._aAtoms[2][1]).getValue() - ((DoubleValue)this._aAtoms[1][1]).getValue()};
    private static final double INTER_WAT_CONT_LOW = 0.0;
    private static final double INTER_WAT_CONT_HIGH = 5.5;
    private static final double INTER_WAT_CONT_DEFAULT = 0.0;
    private DoubleValue[] _aWatCont = new DoubleValue[]{(DoubleValue)this._aAtoms[0][2], (DoubleValue)this._aAtoms[2][2]};
    private static final double INTER_CAT_CONT_LOW = 0.0;
    private static final double INTER_CAT_CONT_HIGH = 0.8;
    private static final double INTER_CAT_CONT_DEFAULT = 0.0;
    private DoubleValue[] _aCatCont = new DoubleValue[]{(DoubleValue)this._aAtoms[1][2]};
    private static final int OCT_FE_ID = 7;
    private static final int OCT_AL_ID = 8;
    private static final int TOP_SILICON_ID = 4;
    private static final int BOTTOM_SILICON_ID = 11;
    private static final int UPPER_OXY_ID = 3;
    private static final String NAME = "di-smectite 2wat";

    public DiSmectiteTwoWatLayer(PatternParams params) {
        super(params);
        this.setOctIron(this._aAtoms, 7, 8);
        this.setSiliconPosition(this._aAtoms, 4, 11);
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public DiSmectiteTwoWatLayer(AbstractLayer absPattern) {
        super(absPattern);
        DiSmectiteTwoWatLayer pattern = (DiSmectiteTwoWatLayer)absPattern;
        int i = 0;
        while (i < this._aAtoms.length) {
            this._aAtoms[i][0] = new Integer((Integer)pattern._aAtoms[i][0]);
            DoubleValue atomQuant = (DoubleValue)pattern._aAtoms[i][2];
            ((DoubleValue)this._aAtoms[i][2]).setValue(atomQuant.getValue());
            ((DoubleValue)this._aAtoms[i][2]).setGene(atomQuant.isGene());
            DoubleValue atomPos = (DoubleValue)pattern._aAtoms[i][1];
            ((DoubleValue)this._aAtoms[i][1]).setValue(atomPos.getValue());
            ((DoubleValue)this._aAtoms[i][1]).setGene(atomPos.isGene());
            ++i;
        }
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        this._dSpacingDelta.setValue(pattern._dSpacingDelta.getValue());
        this._dSpacingDelta.setGene(pattern._dSpacingDelta.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i2 = 0;
        while (i2 < genes.length) {
            genes[i2].updateTo(patternGenes[i2]);
            ++i2;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[5];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[7][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[8][2], (DoubleValue)this._aAtoms[7][2]);
        octIronGene.setName("oct iron content");
        genes[0] = octIronGene;
        RelatedPositionGene interPosGene = new RelatedPositionGene(14.0, 16.0, 15.0, 2.0, this._aInterPos, this._adInterRelativePos, this._dSpacing, ((DoubleValue)this._aAtoms[3][1]).getValue());
        interPosGene.setName("d-spacing");
        genes[1] = interPosGene;
        ContentGene watContGene = new ContentGene(0.0, 5.5, 0.0, 2.0, this._aWatCont);
        watContGene.setName("water content");
        genes[2] = watContGene;
        ContentGene catContGene = new ContentGene(0.0, 0.8, 0.0, 2.0, this._aCatCont);
        catContGene.setName("interlayer cation content");
        genes[3] = catContGene;
        DoubleValue[] aDSpacingDelta = new DoubleValue[]{this._dSpacingDelta};
        ContentGene deltaDSpacingGene = new ContentGene(0.0, 0.75, 0.0, 2.0, aDSpacingDelta);
        deltaDSpacingGene.setActive(false);
        deltaDSpacingGene.setName("delta d-spacing");
        genes[4] = deltaDSpacingGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 9.0 + 0.035 * ((DoubleValue)this._aAtoms[7][2]).getValue();
    }
}

