/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.ContentGene;
import net.ndmystko.xrd.mod.gene.ContentRatioGene;
import net.ndmystko.xrd.mod.gene.RelatedPositionGene;
import net.ndmystko.xrd.mod.gene.RelativeContentGeneInterlayerChlorite;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class DiSmectiteHydroxyInterlayer
extends AbstractLayer
implements Serializable {
    private static final long serialVersionUID = -5936427528765518719L;
    private static final double D_SPACING_LOW = 13.8;
    private static final double D_SPACING_HIGH = 14.6;
    private static final double D_SPACING_DEFAULT = 14.13;
    private DoubleValue _dSpacing = new DoubleValue(14.13);
    private static final double D_DELTA_LOW = 0.0;
    private static final double D_DELTA_HIGH = 0.3;
    private static final double D_DELTA_DEFAULT = 0.0;
    private DoubleValue _dSpacingDelta = new DoubleValue(0.0);
    private static final double INTER_CONT_FACTOR_LOW = 0.2;
    private static final double INTER_CONT_FACTOR_HIGH = 1.0;
    private static final double INTER_CONT_FACTOR_DEFAULT = 1.0;
    private static final double OCT_IRON_LOW = 0.0;
    private static final double OCT_IRON_DEFAULT = 0.5;
    private static final double OCT_IRON_HIGH = 4.0;
    private static final int INT_FE_ID = 1;
    private static final int INT_AL_ID = 2;
    private static final int OCT_FE_ID = 8;
    private static final int OCT_AL_ID = 9;
    private static final int UPPER_OXY_ID = 4;
    private Object[][] _aAtoms = new Object[][]{{new Integer(12), new DoubleValue(11.34), new DoubleValue(6.0)}, {new Integer(6), new DoubleValue(10.32), new DoubleValue(0.5)}, {new Integer(5), new DoubleValue(10.32), new DoubleValue(5.5)}, {new Integer(12), new DoubleValue(9.3), new DoubleValue(6.0)}, {new Integer(1), new DoubleValue(6.54), new DoubleValue(6.0)}, {new Integer(4), new DoubleValue(5.97), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(4.33), new DoubleValue(4.0)}, {new Integer(12), new DoubleValue(4.33), new DoubleValue(2.0)}, {new Integer(6), new DoubleValue(3.27), new DoubleValue(0.5)}, {new Integer(5), new DoubleValue(3.27), new DoubleValue(3.5)}, {new Integer(12), new DoubleValue(2.21), new DoubleValue(2.0)}, {new Integer(1), new DoubleValue(2.21), new DoubleValue(4.0)}, {new Integer(4), new DoubleValue(0.57), new DoubleValue(4.0)}, {new Integer(1), new DoubleValue(0.0), new DoubleValue(6.0)}};
    private DoubleValue[] _aInterPos = new DoubleValue[]{(DoubleValue)this._aAtoms[0][1], (DoubleValue)this._aAtoms[1][1], (DoubleValue)this._aAtoms[2][1], (DoubleValue)this._aAtoms[3][1]};
    private double[] _adInterRelativePos = new double[]{((DoubleValue)this._aAtoms[0][1]).getValue() - ((DoubleValue)this._aAtoms[1][1]).getValue(), 0.0, 0.0, ((DoubleValue)this._aAtoms[3][1]).getValue() - ((DoubleValue)this._aAtoms[1][1]).getValue()};
    private DoubleValue[] _aInterQuant = new DoubleValue[]{(DoubleValue)this._aAtoms[0][2], (DoubleValue)this._aAtoms[1][2], (DoubleValue)this._aAtoms[2][2], (DoubleValue)this._aAtoms[3][2]};
    private double[] _adInterOrigValues = new double[]{((DoubleValue)this._aAtoms[0][2]).getValue(), ((DoubleValue)this._aAtoms[1][2]).getValue(), ((DoubleValue)this._aAtoms[2][2]).getValue(), ((DoubleValue)this._aAtoms[3][2]).getValue()};
    private double[] _adInterOctahedralOrigValues = new double[]{((DoubleValue)this._aAtoms[9][2]).getValue(), ((DoubleValue)this._aAtoms[8][2]).getValue(), ((DoubleValue)this._aAtoms[2][2]).getValue(), ((DoubleValue)this._aAtoms[1][2]).getValue()};
    private DoubleValue[] _aOctahedralQuant = new DoubleValue[]{(DoubleValue)this._aAtoms[8][2], (DoubleValue)this._aAtoms[9][2]};
    private double[] _adOctahedralOrigValues = new double[]{((DoubleValue)this._aAtoms[8][2]).getValue(), ((DoubleValue)this._aAtoms[9][2]).getValue()};
    private DoubleValue[] _aInterlayerQuant = new DoubleValue[]{(DoubleValue)this._aAtoms[1][2], (DoubleValue)this._aAtoms[2][2]};
    private double[] _adInterlayerOrigValues = new double[]{((DoubleValue)this._aAtoms[1][2]).getValue(), ((DoubleValue)this._aAtoms[2][2]).getValue()};
    private static final double OCT_FE_DECAY_CONST = 1.0;
    private static final double D_SPACING_DECAY_CONST = 2.0;
    private static final double INTER_CONT_FACTOR_DECAY_CONST = 2.0;
    private static final double D_DELTA_DECAY_CONST = 2.0;
    private static final double OCT_FE_MAX_CONTENT = 1.0;
    private static final String NAME = "di-smectite tri-HI";

    public DiSmectiteHydroxyInterlayer(PatternParams params) {
        super(params);
        this.setGenes(this.createGenes());
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    public DiSmectiteHydroxyInterlayer(AbstractLayer absPattern) {
        super(absPattern);
        DiSmectiteHydroxyInterlayer pattern = (DiSmectiteHydroxyInterlayer)absPattern;
        int i = 0;
        while (i < this._aAtoms.length) {
            this._aAtoms[i][0] = new Integer((Integer)pattern._aAtoms[i][0]);
            DoubleValue atomQuant = (DoubleValue)pattern._aAtoms[i][2];
            ((DoubleValue)this._aAtoms[i][2]).setValue(atomQuant.getValue());
            ((DoubleValue)this._aAtoms[i][2]).setGene(atomQuant.isGene());
            DoubleValue atomPos = (DoubleValue)pattern._aAtoms[i][1];
            ((DoubleValue)this._aAtoms[i][1]).setValue(atomPos.getValue());
            ((DoubleValue)this._aAtoms[i][1]).setGene(atomPos.isGene());
            ++i;
        }
        this._dSpacing.setValue(pattern._dSpacing.getValue());
        this._dSpacing.setGene(pattern._dSpacing.isGene());
        this._dSpacingDelta.setValue(pattern._dSpacingDelta.getValue());
        this._dSpacingDelta.setGene(pattern._dSpacingDelta.isGene());
        AbstractLayerGene[] genes = this.createGenes();
        AbstractLayerGene[] patternGenes = pattern.getGenes();
        int i2 = 0;
        while (i2 < genes.length) {
            genes[i2].updateTo(patternGenes[i2]);
            ++i2;
        }
        this.setGenes(genes);
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    private AbstractLayerGene[] createGenes() {
        AbstractLayerGene[] genes = new AbstractLayerGene[5];
        ContentRatioGene octIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[8][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[9][2], (DoubleValue)this._aAtoms[8][2]);
        octIronGene.setName("oct iron content");
        octIronGene.getConnector().getGene().set_dHighLimit(1.0);
        genes[0] = octIronGene;
        RelatedPositionGene interPosGene = new RelatedPositionGene(13.8, 14.6, 14.13, 2.0, this._aInterPos, this._adInterRelativePos, this._dSpacing, ((DoubleValue)this._aAtoms[4][1]).getValue());
        interPosGene.setName("d-spacing");
        genes[1] = interPosGene;
        ContentRatioGene intIronGene = new ContentRatioGene(((DoubleValue)this._aAtoms[1][2]).getValue(), 1.0, (DoubleValue)this._aAtoms[2][2], (DoubleValue)this._aAtoms[1][2]);
        intIronGene.setName("interlayer iron content");
        intIronGene.getConnector().getGene().set_dHighLimit(1.0);
        genes[2] = intIronGene;
        RelativeContentGeneInterlayerChlorite interContGene = new RelativeContentGeneInterlayerChlorite(0.2, 1.0, 1.0, 2.0, this._aInterQuant, this._adInterOrigValues);
        interContGene.setName("interlayer content");
        interContGene.computeVariables();
        genes[3] = interContGene;
        DoubleValue[] aDSpacingDelta = new DoubleValue[]{this._dSpacingDelta};
        ContentGene deltaDSpacingGene = new ContentGene(0.0, 0.3, 0.0, 2.0, aDSpacingDelta);
        deltaDSpacingGene.setActive(false);
        deltaDSpacingGene.setName("delta d-spacing");
        genes[4] = deltaDSpacingGene;
        return genes;
    }

    @Override
    public void computeCommonFactors() {
        this.computeCommonFactors(this._aAtoms, this._dSpacing, this._dSpacingDelta);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected double getBCellParam() {
        return 9.22 + 0.014 * (((DoubleValue)this._aAtoms[8][2]).getValue() + ((DoubleValue)this._aAtoms[1][2]).getValue());
    }
}

