/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import net.ndmystko.xrd.AtomicScatteringFactor;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.layer.AbstractElement;
import net.ndmystko.xrd.mod.layer.AnyLayer;
import net.ndmystko.xrd.mod.layer.DoubleValue;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public abstract class AbstractLayer
extends AbstractElement
implements Serializable {
    private static final long serialVersionUID = -3215275783877822901L;
    protected transient double[] _adFAStable = null;
    protected transient double[] _adFBStable = null;
    protected transient double[] _adFA = null;
    protected transient double[] _adFB = null;
    protected Object[][] _atoms = null;
    protected DoubleValue _dSpacing = null;
    protected DoubleValue _dSpacingDelta = null;

    protected AbstractLayer(PatternParams params) {
        super(params);
        this.initVectors();
    }

    protected AbstractLayer(AbstractLayer pattern) {
        super(pattern._patternParams);
        this.initVectors();
    }

    private void initVectors() {
        int iNoOfData = (int)Math.round((this._dMax2theta - this._dMin2theta) / this._dStepSize) + 1;
        this._adFAStable = new double[iNoOfData];
        this._adFBStable = new double[iNoOfData];
        this._adFA = new double[iNoOfData];
        this._adFB = new double[iNoOfData];
    }

    public void computeCommonFactors(Object[][] atoms, DoubleValue dSpacing, DoubleValue dSpacingDelta) {
        this._atoms = atoms;
        this._dSpacing = dSpacing;
        this._dSpacingDelta = dSpacingDelta;
        this.computeCommonFactors(this._atoms, this._adFAStable, this._adFBStable, this._patternParams);
    }

    public void computeVariableFactors() {
        this.computeVariableFactors(this._atoms, this._adFA, this._adFB, this._adFAStable, this._adFBStable, this._patternParams);
    }

    public double getVolume() {
        double dB = this.getBCellParam();
        double dA = dB / Math.sqrt(3.0);
        double dC = this._dSpacing.getValue();
        return dA * dB * dC;
    }

    public double getDensity(double dVolume) {
        return this.getWeight(this._atoms) / dVolume;
    }

    public double getDSpacing() {
        return this._dSpacing.getValue();
    }

    public double getDSpacingDelta() {
        return this._dSpacingDelta.getValue();
    }

    public double getFactorA(int index) {
        return this._adFA[index];
    }

    public double getFactorA(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFA[index];
    }

    public double[] getFactorA() {
        return this._adFA;
    }

    public double getFactorB(int index) {
        return this._adFB[index];
    }

    public double getFactorB(double dTwoTheta) {
        int index = (int)Math.round((dTwoTheta - this._dMin2theta) / this._dStepSize);
        return this._adFB[index];
    }

    public double[] getFactorB() {
        return this._adFB;
    }

    public Element serializeXML() {
        Element layer = new Element("layer");
        layer.setAttribute("name", this.getName());
        layer.setAttribute("d_spacing", String.valueOf(this._dSpacing.getValue()));
        layer.setAttribute("d_spacing_delta", String.valueOf(this._dSpacingDelta.getValue()));
        int i = 0;
        while (i < this._atoms.length) {
            Element atom = new Element("atom");
            atom.setAttribute("type", AtomicScatteringFactor.getName((Integer)this._atoms[i][0]));
            atom.setAttribute("position", String.valueOf(((DoubleValue)this._atoms[i][1]).getValue()));
            atom.setAttribute("content", String.valueOf(((DoubleValue)this._atoms[i][2]).getValue()));
            layer.addContent(atom);
            ++i;
        }
        return layer;
    }

    public static AbstractLayer deserializeXML(Element owner, PatternParams patternParams) throws DataConversionException, IllegalArgumentException {
        Element layer = owner.getChild("layer");
        if (layer == null) {
            throw new IllegalArgumentException("Missing layer");
        }
        Attribute aName = layer.getAttribute("name");
        String sName = aName == null ? "unknown" : aName.getValue();
        Attribute aDSpacing = layer.getAttribute("d_spacing");
        if (aDSpacing == null) {
            throw new IllegalArgumentException("Missing d-spacing in layer '" + sName + "'");
        }
        double dDSpacing = aDSpacing.getDoubleValue();
        Attribute aDSpacingDelta = layer.getAttribute("d_spacing_delta");
        double dDSpacingDelta = aDSpacingDelta == null ? 0.0 : aDSpacingDelta.getDoubleValue();
        List lAtoms = layer.getChildren("atom");
        if (lAtoms.size() == 0) {
            throw new IllegalArgumentException("Missing atoms in layer '" + sName + "'");
        }
        Object[][] aAtoms = new Object[lAtoms.size()][3];
        int i = 0;
        for (Element atom : lAtoms) {
            Attribute aType = atom.getAttribute("type");
            if (aType == null) {
                throw new IllegalArgumentException("Missing atom type in layer '" + sName + "'");
            }
            int iIndex = AtomicScatteringFactor.getIndex(aType.getValue());
            if (iIndex < 0) {
                throw new IllegalArgumentException("Unknown atom type " + aType.getValue() + " in layer '" + sName + "'");
            }
            aAtoms[i][0] = new Integer(iIndex);
            Attribute aPosition = atom.getAttribute("position");
            if (aPosition == null) {
                throw new IllegalArgumentException("Missing atom position in layer '" + sName + "'");
            }
            aAtoms[i][1] = new DoubleValue(aPosition.getDoubleValue());
            Attribute aQuantity = atom.getAttribute("content");
            if (aQuantity == null) {
                throw new IllegalArgumentException("Missing atom content in layer '" + sName + "'");
            }
            aAtoms[i][2] = new DoubleValue(aQuantity.getDoubleValue());
            ++i;
        }
        AnyLayer result = new AnyLayer(patternParams, aAtoms, new DoubleValue(dDSpacing), new DoubleValue(dDSpacingDelta));
        result.setName(sName);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initVectors();
        this.computeCommonFactors(this._atoms, this._dSpacing, this._dSpacingDelta);
        this.computeVariableFactors();
    }
}

