/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.layer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.xrd.AtomicScatteringFactor;
import net.ndmystko.xrd.Z;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.AbstractSmectite;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public abstract class AbstractElement
implements Serializable {
    private static final long serialVersionUID = -5351042271613363227L;
    public static final int ATOM_TYPE = 0;
    public static final int ATOM_POS = 1;
    public static final int ATOM_QUANT = 2;
    protected PatternParams _patternParams = null;
    protected double _dMin2theta = 0.0;
    protected double _dMax2theta = 0.0;
    protected double _dStepSize = 0.0;
    protected double _dLambda = 0.0;
    private AbstractLayerGene[] _aGenes = new AbstractLayerGene[0];

    protected AbstractElement(PatternParams params) {
        this._patternParams = params;
        this._dMin2theta = this._patternParams.getMin2theta();
        this._dMax2theta = this._patternParams.getMax2theta();
        this._dStepSize = this._patternParams.getStepSize();
        this._dLambda = this._patternParams.getLambda();
    }

    protected AbstractElement(AbstractElement pattern) {
        this._dMin2theta = pattern._dMin2theta;
        this._dMax2theta = pattern._dMax2theta;
        this._dStepSize = pattern._dStepSize;
        this._dLambda = pattern._dLambda;
    }

    protected void computeCommonFactors(Object[][] atoms, double[] adFAStable, double[] adFBStable, PatternParams patternParams) {
        Arrays.fill(adFAStable, 0.0);
        Arrays.fill(adFBStable, 0.0);
        AtomicScatteringFactor[] aFactors = patternParams.getAtomicScatteringFactors();
        Z z = patternParams.getZ();
        int i = 0;
        while (i < adFAStable.length) {
            int k = 0;
            while (k < atoms.length) {
                if (!((DoubleValue)atoms[k][1]).isGene() && !((DoubleValue)atoms[k][2]).isGene()) {
                    double dScatteringFactor = ((DoubleValue)atoms[k][2]).getValue() * aFactors[(Integer)atoms[k][0]].getIntensity(i);
                    double dPhaseFactor = Math.PI * 2 * ((DoubleValue)atoms[k][1]).getValue() * z.getZ(i);
                    int n = i;
                    adFAStable[n] = adFAStable[n] + dScatteringFactor * Math.cos(dPhaseFactor);
                    int n2 = i;
                    adFBStable[n2] = adFBStable[n2] + dScatteringFactor * Math.sin(dPhaseFactor);
                }
                ++k;
            }
            ++i;
        }
    }

    public abstract void computeCommonFactors();

    public PatternParams get_patternParams() {
        return this._patternParams;
    }

    public void set_patternParams(PatternParams _patternParams) {
        this._patternParams = _patternParams;
    }

    public abstract String getName();

    public void updateLayer() {
        int i = 0;
        while (i < this._aGenes.length) {
            if (this._aGenes[i].isActive()) {
                this._aGenes[i].computeVariables();
            }
            ++i;
        }
    }

    protected void computeVariableFactors(Object[][] atoms, double[] adFA, double[] adFB, double[] adFAStable, double[] adFBStable, PatternParams patternParams) {
        System.arraycopy(adFAStable, 0, adFA, 0, adFA.length);
        System.arraycopy(adFBStable, 0, adFB, 0, adFB.length);
        int iNoOfData = adFA.length;
        double dTwoPi = Math.PI * 2;
        AtomicScatteringFactor[] aFactors = patternParams.getAtomicScatteringFactors();
        Z z = patternParams.getZ();
        int k = 0;
        while (k < atoms.length) {
            if (((DoubleValue)atoms[k][1]).isGene() || ((DoubleValue)atoms[k][2]).isGene()) {
                int i = 0;
                while (i < adFA.length) {
                    double dPhaseFactor = dTwoPi * ((DoubleValue)atoms[k][1]).getValue() * z.getZ(i);
                    double dScatteringFactor = ((DoubleValue)atoms[k][2]).getValue() * aFactors[(Integer)atoms[k][0]].getIntensity(i);
                    int n = i;
                    adFA[n] = adFA[n] + dScatteringFactor * Math.cos(dPhaseFactor);
                    int n2 = i++;
                    adFB[n2] = adFB[n2] + dScatteringFactor * Math.sin(dPhaseFactor);
                }
            }
            ++k;
        }
    }

    protected abstract double getBCellParam();

    protected double getWeight(Object[][] atoms) {
        double dWeight = 0.0;
        int k = 0;
        while (k < atoms.length) {
            dWeight += ((DoubleValue)atoms[k][2]).getValue() * AtomicScatteringFactor.getAtomicWeight((Integer)atoms[k][0]);
            ++k;
        }
        return dWeight;
    }

    protected void setGenes(AbstractLayerGene[] genes) {
        this._aGenes = genes;
    }

    public AbstractLayerGene[] getGenes() {
        return this._aGenes;
    }

    public void setGenesActive(boolean bActive) {
        if (this._aGenes != null) {
            int i = 0;
            while (i < this._aGenes.length) {
                this._aGenes[i].setActive(bActive);
                ++i;
            }
        }
        this.computeCommonFactors();
    }

    public void addConnectors(List lList, boolean bActiveOnly, boolean bNoDuplicates) {
        int i = 0;
        while (i < this._aGenes.length) {
            if (!(!this._aGenes[i].isActive() && bActiveOnly || lList.contains(this._aGenes[i]) && bNoDuplicates)) {
                lList.add(this._aGenes[i].getConnector());
            }
            ++i;
        }
    }

    public void addConnectorsBranch(DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < this._aGenes.length) {
            parent.add(new DefaultMutableTreeNode(this._aGenes[i].getConnector()));
            ++i;
        }
    }

    public void freezeGeneAt(String sName, double dValue) {
        AbstractLayerGene gene = null;
        boolean bMoreThanOne = false;
        int i = 0;
        while (i < this._aGenes.length) {
            if (this._aGenes[i].getName().equals(sName)) {
                if (gene == null) {
                    gene = this._aGenes[i];
                } else {
                    bMoreThanOne = true;
                    break;
                }
            }
            ++i;
        }
        if (gene == null) {
            throw new IllegalArgumentException("Could not find gene " + sName + " in " + this.getName());
        }
        if (bMoreThanOne) {
            throw new IllegalArgumentException("There is more than one gene '" + sName + "' in " + this.getName());
        }
        gene.setGeneValue(dValue);
        gene.setActive(false);
        this.computeCommonFactors();
    }

    public void shrinkGeneLimits() {
    }

    public void inheritSmectiteGeneValues(AbstractElement pattern, boolean bCopyFixed) {
        assert (this instanceof AbstractSmectite && pattern instanceof AbstractSmectite) : "This method is for smectites only";
        int i = 0;
        while (i < this._aGenes.length) {
            String sName = this._aGenes[i].getName();
            if (sName.equals("oct iron content") || sName.equals("interlayer cation content") || sName.equals("delta d-spacing")) {
                int j = 0;
                while (j < pattern._aGenes.length) {
                    if (sName.equals(pattern._aGenes[j].getName())) {
                        this._aGenes[i].setGeneValue(pattern._aGenes[j].getGeneValue());
                        if (!bCopyFixed) break;
                        this._aGenes[i].setActive(pattern._aGenes[j].isActive());
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.computeCommonFactors();
    }

    public void inheritGenes(AbstractElement pattern) {
        int i = 0;
        while (i < this._aGenes.length) {
            String sName = this._aGenes[i].getName();
            int j = 0;
            while (j < pattern._aGenes.length) {
                if (sName.equals(pattern._aGenes[j].getName())) {
                    this._aGenes[i].getConnector().updateTo(pattern._aGenes[j].getConnector());
                }
                ++j;
            }
            ++i;
        }
        this.computeCommonFactors();
    }

    public static AbstractLayerGene findLayerGene(AbstractElement layer, String sGeneName) {
        int iGeneIndex = -1;
        int iGeneCount = 0;
        int i = 0;
        while (i < layer._aGenes.length) {
            if (layer._aGenes[i].getName().equals(sGeneName)) {
                iGeneIndex = i;
                ++iGeneCount;
            }
            ++i;
        }
        assert (iGeneCount < 2);
        AbstractLayerGene foundGene = null;
        if (iGeneCount == 1) {
            foundGene = layer._aGenes[iGeneIndex];
        }
        return foundGene;
    }

    public boolean shareConnector(AbstractElement anotherLayer, String sGeneName) {
        AbstractLayerGene thisGene = AbstractElement.findLayerGene(this, sGeneName);
        AbstractLayerGene anotherGene = AbstractElement.findLayerGene(anotherLayer, sGeneName);
        if (thisGene != null && anotherGene != null) {
            thisGene.setConnector(anotherGene.getConnector());
        }
        return thisGene != null && anotherGene != null;
    }
}

