/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.ndmystko.xrd.mod.Verificator;
import net.ndmystko.xrd.mod.gui.CommonSybilla;

public class VerificationDialog
extends JDialog {
    private static final long serialVersionUID = 3007857982128296721L;
    private JPanel _dataPanel = null;
    private NumberFormat _oneDigitNumberFormatter = null;
    private CommonSybilla _owner;
    private int _iMenuStatus = -1;
    private Font defaultFont = new Font("sans-serif", 0, 12);

    public VerificationDialog(CommonSybilla owner) {
        super(owner.frame);
        this._owner = owner;
        this.setTitle("Verification");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VerificationDialog.this.okAction();
            }
        });
        this._oneDigitNumberFormatter = NumberFormat.getInstance();
        this._oneDigitNumberFormatter.setMinimumFractionDigits(0);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(1);
        this._dataPanel = new JPanel(new GridLayout(0, 2, 20, 10));
        this._dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.getContentPane().add((Component)this._dataPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerificationDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public void showUp(int iMenuStatus, Verificator verificator) {
        this._dataPanel.removeAll();
        JLabel label1 = new JLabel("dry density:");
        JLabel label2 = new JLabel("TSA:");
        JLabel label3 = new JLabel("T mean:");
        JLabel label4 = new JLabel("%K2O:");
        JLabel label1value = new JLabel(this._oneDigitNumberFormatter.format(verificator.getDryDensity()));
        JLabel label2value = new JLabel(this._oneDigitNumberFormatter.format(verificator.getTSA()));
        JLabel label3value = new JLabel(this._oneDigitNumberFormatter.format(verificator.getTMean()));
        JLabel label4value = new JLabel(this._oneDigitNumberFormatter.format(verificator.getPercK2O()));
        label1.setFont(this.defaultFont);
        label2.setFont(this.defaultFont);
        label3.setFont(this.defaultFont);
        label4.setFont(this.defaultFont);
        label1value.setFont(this.defaultFont);
        label2value.setFont(this.defaultFont);
        label3value.setFont(this.defaultFont);
        label4value.setFont(this.defaultFont);
        this._dataPanel.add(label1);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(3);
        this._dataPanel.add(label1value);
        this._dataPanel.add(label2);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(0);
        this._dataPanel.add(label2value);
        this._dataPanel.add(label3);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(1);
        this._dataPanel.add(label3value);
        this._dataPanel.add(label4);
        this._dataPanel.add(label4value);
        this._iMenuStatus = iMenuStatus;
        this.pack();
        this.setVisible(true);
    }

    private void okAction() {
        if (this._iMenuStatus != -1) {
            this._owner.setItemsEnabled(this._iMenuStatus);
        }
        this.setVisible(false);
    }

    public void setAllFonts(Font _f) {
        this.defaultFont = _f;
        Component[] componentArray = this._dataPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            item.setFont(_f);
            if (item instanceof Container) {
                Component[] componentArray2 = ((Container)item).getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component item2 = componentArray2[n4];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        Component[] componentArray3 = ((Container)item2).getComponents();
                        int n5 = componentArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Component item3 = componentArray3[n6];
                            item3.setFont(_f);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.pack();
        this.repaint();
    }
}

