/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.gui.SybillaManual;
import net.ndmystko.xrd.mod.gui.TaskNamesDialog;
import net.ndmystko.xrd.mod.net.ConnectorManual;
import net.ndmystko.xrd.mod.net.Request;
import net.ndmystko.xrd.mod.script.ScriptParams;

public class UploadDialog
extends JDialog
implements ActionListener {
    private SybillaManual _owner;
    private int _iMenuStatus = -1;
    private JTextField _hostNameTextField = null;
    private JTextField _hostPortTextField = null;
    private JTextField _tresholdTextField = null;
    private JTextField _quickTresholdTextField = null;
    private JComboBox _startRCombo = null;
    private JComboBox _endRCombo = null;
    private static final String[] R = new String[]{"R0", "R1", "R2", "R3"};
    private JButton _helloButton = null;
    private JButton _okButton = null;
    private JButton _uploadButton = null;
    private JButton _uploadJarButton = null;
    private JButton _deleteButton = null;
    private JButton _startButton = null;
    private JButton _stopButton = null;
    private JButton _shootDownButton = null;
    private JButton _grabLogButton = null;
    private TaskNamesDialog _taskNamesDialog = null;
    private JCheckBox _sigmaGlobalCheckBox = null;
    private JCheckBox _scriptedCheckBox = null;
    private JPanel hostPanel = null;
    private ConnectorManual _connectorManual = null;
    private ThreadGroup _connThreadGroup = null;
    private Thread _connManualThread = null;
    private Font defaultFont = new Font("sans-serif", 0, 12);
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.gui.UploadDialog");

    public UploadDialog(SybillaManual owner) {
        super(owner.frame);
        this._owner = owner;
        this.setTitle("task uploader");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UploadDialog.this.okAction();
            }
        });
        this._connThreadGroup = new ThreadGroup("upload connectors");
        this.hostPanel = new JPanel();
        this.hostPanel.setLayout(new BoxLayout(this.hostPanel, 1));
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("remote Sybilla:");
        this.hostPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, titledBorder));
        JLabel hostNameLabel = new JLabel("host name:");
        hostNameLabel.setAlignmentX(0.0f);
        this.hostPanel.add(hostNameLabel);
        this._hostNameTextField = new JTextField("localhost");
        int iTextFieldHeight = (int)((double)this.defaultFont.getSize() * 2.0);
        this._hostNameTextField.setAlignmentX(0.0f);
        this._hostNameTextField.setPreferredSize(new Dimension(200, iTextFieldHeight));
        this._hostNameTextField.setMaximumSize(new Dimension(200, iTextFieldHeight));
        this.hostPanel.add(this._hostNameTextField);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel hostPortLabel = new JLabel("host port:");
        hostPortLabel.setAlignmentX(0.0f);
        this.hostPanel.add(hostPortLabel);
        this._hostPortTextField = new JTextField(String.valueOf(8222), 5);
        this._hostPortTextField.setAlignmentX(0.0f);
        this._hostPortTextField.setPreferredSize(new Dimension(200, iTextFieldHeight));
        this._hostPortTextField.setMaximumSize(new Dimension(200, iTextFieldHeight));
        this.hostPanel.add(this._hostPortTextField);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel tresholdPanel = new JPanel();
        tresholdPanel.setLayout(new BoxLayout(tresholdPanel, 0));
        tresholdPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tresholdPanel.setAlignmentX(0.0f);
        JLabel tresholdLabel = new JLabel("threshold: ");
        tresholdLabel.setAlignmentY(1.0f);
        tresholdPanel.add(tresholdLabel);
        this._tresholdTextField = new JTextField(String.valueOf(10.5));
        this._tresholdTextField.setAlignmentY(1.0f);
        this._tresholdTextField.setPreferredSize(new Dimension(100, iTextFieldHeight));
        this._tresholdTextField.setMaximumSize(new Dimension(100, iTextFieldHeight));
        tresholdPanel.add(this._tresholdTextField);
        tresholdPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JLabel quickTresholdLabel = new JLabel("quick threshold: ");
        quickTresholdLabel.setAlignmentY(1.0f);
        tresholdPanel.add(quickTresholdLabel);
        this._quickTresholdTextField = new JTextField(String.valueOf(12.0));
        this._quickTresholdTextField.setAlignmentY(1.0f);
        this._quickTresholdTextField.setPreferredSize(new Dimension(100, iTextFieldHeight));
        this._quickTresholdTextField.setMaximumSize(new Dimension(100, iTextFieldHeight));
        tresholdPanel.add(this._quickTresholdTextField);
        tresholdPanel.add(Box.createVerticalGlue());
        this.hostPanel.add(tresholdPanel);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel rLimitPanel = new JPanel();
        rLimitPanel.setLayout(new BoxLayout(rLimitPanel, 0));
        rLimitPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rLimitPanel.setAlignmentX(0.0f);
        JLabel startRLabel = new JLabel("start R: ");
        startRLabel.setAlignmentY(1.0f);
        rLimitPanel.add(startRLabel);
        this._startRCombo = new JComboBox<String>(R);
        this._startRCombo.setSelectedIndex(0);
        this._startRCombo.setAlignmentY(1.0f);
        rLimitPanel.add(this._startRCombo);
        rLimitPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        JLabel endRLabel = new JLabel("end R: ");
        endRLabel.setAlignmentY(1.0f);
        rLimitPanel.add(endRLabel);
        this._endRCombo = new JComboBox<String>(R);
        this._endRCombo.setSelectedIndex(1);
        this._endRCombo.setAlignmentY(1.0f);
        rLimitPanel.add(this._endRCombo);
        rLimitPanel.add(Box.createHorizontalGlue());
        rLimitPanel.add(Box.createHorizontalGlue());
        rLimitPanel.add(Box.createHorizontalGlue());
        rLimitPanel.add(Box.createHorizontalGlue());
        this.hostPanel.add(rLimitPanel);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this._sigmaGlobalCheckBox = new JCheckBox("sigma-star global", true);
        this._sigmaGlobalCheckBox.setAlignmentX(0.0f);
        this.hostPanel.add(this._sigmaGlobalCheckBox);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this._scriptedCheckBox = new JCheckBox("scripted", true);
        this._scriptedCheckBox.setAlignmentX(0.0f);
        this.hostPanel.add(this._scriptedCheckBox);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 0));
        actionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        actionPanel.setAlignmentX(0.0f);
        this._helloButton = new JButton("say hello");
        this._helloButton.setAlignmentX(0.0f);
        this._helloButton.addActionListener(this);
        actionPanel.add(this._helloButton);
        actionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._uploadButton = new JButton("upload");
        this._uploadButton.setAlignmentX(0.0f);
        this._uploadButton.addActionListener(this);
        actionPanel.add(this._uploadButton);
        actionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._deleteButton = new JButton("delete");
        this._deleteButton.setAlignmentX(0.0f);
        this._deleteButton.addActionListener(this);
        actionPanel.add(this._deleteButton);
        actionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._startButton = new JButton("start");
        this._startButton.setAlignmentX(0.0f);
        this._startButton.addActionListener(this);
        actionPanel.add(this._startButton);
        actionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._stopButton = new JButton("stop");
        this._stopButton.setAlignmentX(0.0f);
        this._stopButton.addActionListener(this);
        actionPanel.add(this._stopButton);
        this.hostPanel.add(actionPanel);
        JPanel serverActionPanel = new JPanel();
        serverActionPanel.setLayout(new BoxLayout(serverActionPanel, 0));
        serverActionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        serverActionPanel.setAlignmentX(0.0f);
        this._uploadJarButton = new JButton("upload sybilla.jar");
        this._uploadJarButton.setAlignmentX(0.0f);
        this._uploadJarButton.addActionListener(this);
        serverActionPanel.add(this._uploadJarButton);
        serverActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._shootDownButton = new JButton("shoot down");
        this._shootDownButton.setAlignmentX(0.0f);
        this._shootDownButton.addActionListener(this);
        serverActionPanel.add(this._shootDownButton);
        serverActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._grabLogButton = new JButton("grab log");
        this._grabLogButton.setAlignmentX(0.0f);
        this._grabLogButton.addActionListener(this);
        serverActionPanel.add(this._grabLogButton);
        this.hostPanel.add(serverActionPanel);
        this.getContentPane().add((Component)this.hostPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this._okButton = new JButton("OK");
        this._okButton.addActionListener(this);
        buttonPanel.add(this._okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this._taskNamesDialog = new TaskNamesDialog(this);
        this.pack();
    }

    public void showUp(int menuStatus) {
        this._iMenuStatus = menuStatus;
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.okAction();
        } else if (e.getSource() == this._helloButton) {
            this.helloAction();
        } else if (e.getSource() == this._uploadButton) {
            this.uploadAction();
        } else if (e.getSource() == this._deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this._startButton) {
            this.startAction();
        } else if (e.getSource() == this._stopButton) {
            this.stopAction();
        } else if (e.getSource() == this._uploadJarButton) {
            this.uploadJarAction();
        } else if (e.getSource() == this._shootDownButton) {
            this.shootdownAction();
        } else if (e.getSource() == this._grabLogButton) {
            this.grabLogAction();
        } else if (e.getSource() == this._taskNamesDialog) {
            if (e.getActionCommand().equals("delete")) {
                this.deleteSelectedAction();
            }
        } else if (e.getSource() instanceof ConnectorManual) {
            ConnectorManual connManual = (ConnectorManual)e.getSource();
            connManual.disconnectListener();
            if (e.getActionCommand().equals("free")) {
                this._taskNamesDialog.showUp(this, connManual, false);
            } else if (e.getActionCommand().equals("busy")) {
                this._taskNamesDialog.showUp(this, connManual, true);
            } else {
                JOptionPane.showMessageDialog(this._owner.frame, e.getActionCommand(), "remote Sybilla's answer", 1);
            }
        } else {
            System.out.println("Caught unknown event: " + e.toString());
        }
    }

    public void setScriptParams(ScriptParams scriptParams) {
        if (scriptParams == null) {
            return;
        }
        this._startRCombo.setSelectedIndex(scriptParams.getStartR());
        this._endRCombo.setSelectedIndex(scriptParams.getEndR());
    }

    private void helloAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "helloAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(1);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
        this._taskNamesDialog.setTarget(1);
    }

    private void uploadAction() {
        double dR2Limit = 0.0;
        try {
            dR2Limit = Double.parseDouble(this._tresholdTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Error in treshold value: " + nfe.getMessage(), "treshold error", 0);
            return;
        }
        double dQuickR2Limit = 0.0;
        try {
            dQuickR2Limit = Double.parseDouble(this._quickTresholdTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Error in quick treshold value: " + nfe.getMessage(), "quick treshold error", 0);
            return;
        }
        if (dQuickR2Limit < dR2Limit) {
            JOptionPane.showMessageDialog(this._owner.frame, "Quick treshold lower than treshold doesn't make sense...", "treshold error", 0);
            return;
        }
        if (dQuickR2Limit <= 0.0 || dQuickR2Limit > 99.0 || dR2Limit <= 0.0 || dR2Limit > 99.0) {
            JOptionPane.showMessageDialog(this._owner.frame, "Treshold values out of allowed range (0-99]", "treshold error", 0);
            return;
        }
        Task task = this._owner.createTask(this._scriptedCheckBox.isSelected(), this._sigmaGlobalCheckBox.isSelected(), this._startRCombo.getSelectedIndex(), this._endRCombo.getSelectedIndex());
        if (task == null) {
            return;
        }
        task.setTreshold(dR2Limit, dQuickR2Limit);
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "uploadAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(2);
            request.setTask(task);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void deleteAction() {
        this.helloAction();
        this._taskNamesDialog.setTarget(2);
    }

    private void deleteSelectedAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "deleteSelectedAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(6);
            request.setTaskIds(this._taskNamesDialog.getTaskIds());
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void startAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "startAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(3);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void stopAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "stopAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(4);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void uploadJarAction() {
        byte[] aBuffer = new byte[200000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1500000);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream("sybilla.jar"));){
            int iCount = 0;
            while ((iCount = bis.read(aBuffer, 0, aBuffer.length)) > -1) {
                baos.write(aBuffer, 0, iCount);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Following error occurred when reading sybilla.jar:\n" + ioe.getMessage(), "read error", 0);
            return;
        }
        byte[] sybillaBytes = baos.toByteArray();
        if (sybillaBytes.length == 0) {
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot read sybilla.jar", "read error", 0);
            return;
        }
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "startAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(7);
            request.setSybilla(sybillaBytes);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void shootdownAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "shootdownAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(8);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void grabLogAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.UploadDialog", "grabLogAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(9);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private Socket getSocket() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(this._hostNameTextField.getText());
        }
        catch (UnknownHostException uhe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot find specified host\n" + uhe.getMessage(), "unknown host", 0);
            return null;
        }
        Socket socket = null;
        try {
            socket = new Socket(addr, Integer.parseInt(this._hostPortTextField.getText()));
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot connect\n" + ioe.getMessage(), "network error", 0);
            return null;
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Specified port is non-integer", "wrong port", 0);
            return null;
        }
        return socket;
    }

    private void okAction() {
        if (this._iMenuStatus != -1) {
            this._owner.setItemsEnabled(this._iMenuStatus);
        }
        this.setVisible(false);
    }

    public void setHostName(String sHostName) {
        this._hostNameTextField.setText(sHostName);
    }

    public String getHostName() {
        return this._hostNameTextField.getText();
    }

    public void setAllFonts(Font _f) {
        this.defaultFont = _f;
        int iTextFieldHeight = (int)((double)this.defaultFont.getSize() * 1.5);
        this._hostNameTextField.setPreferredSize(new Dimension(200, iTextFieldHeight));
        this._hostPortTextField.setPreferredSize(new Dimension(200, iTextFieldHeight));
        this._tresholdTextField.setPreferredSize(new Dimension(100, iTextFieldHeight));
        this._quickTresholdTextField.setPreferredSize(new Dimension(100, iTextFieldHeight));
        this._hostNameTextField.setMinimumSize(new Dimension(200, iTextFieldHeight));
        this._hostPortTextField.setMinimumSize(new Dimension(200, iTextFieldHeight));
        this._tresholdTextField.setMinimumSize(new Dimension(100, iTextFieldHeight));
        this._quickTresholdTextField.setMinimumSize(new Dimension(100, iTextFieldHeight));
        this._hostNameTextField.setMaximumSize(new Dimension(200, iTextFieldHeight));
        this._hostPortTextField.setMaximumSize(new Dimension(200, iTextFieldHeight));
        this._tresholdTextField.setMaximumSize(new Dimension(100, iTextFieldHeight));
        this._quickTresholdTextField.setMaximumSize(new Dimension(100, iTextFieldHeight));
        Component[] componentArray = this.hostPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            item.setFont(_f);
            if (item instanceof Container) {
                Component[] componentArray2 = ((Container)item).getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component item2 = componentArray2[n4];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        Component[] componentArray3 = ((Container)item2).getComponents();
                        int n5 = componentArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Component item3 = componentArray3[n6];
                            item3.setFont(_f);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.pack();
        this.repaint();
    }
}

