/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.ndmystko.xrd.mod.net.ConnectorManual;

public class TaskNamesDialog
extends JDialog
implements ActionListener {
    private JDialog _owner;
    private HashMap _hmTaskDoneNames = null;
    private HashMap _hmTaskToBeDoneNames = null;
    private HashMap _hmTaskIds = new LinkedHashMap();
    private int _iTarget = 0;
    public static final int HELLO = 1;
    public static final int DELETE = 2;
    public static final int DOWNLOAD = 3;
    public static final String DELETE_ACTION = "delete";
    public static final String DOWNLOAD_ACTION = "download";
    private ActionListener _listener = null;
    private JPanel _mainPanel = null;
    private JScrollPane _scrollMainPanel = null;
    private GridBagLayout _mainPanelLayout = null;
    private JButton _deleteButton = null;
    private JButton _downloadButton = null;
    private JButton _closeButton = null;
    private NumberFormat _twoDigitNumberFormatter = null;

    public TaskNamesDialog(JDialog owner) {
        super((Dialog)owner, true);
        this._owner = owner;
        this.setTitle("task names");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TaskNamesDialog.this.closeAction();
            }
        });
        this._twoDigitNumberFormatter = NumberFormat.getInstance();
        this._twoDigitNumberFormatter.setMinimumFractionDigits(2);
        this._twoDigitNumberFormatter.setMaximumFractionDigits(2);
        this._mainPanel = new JPanel();
        this._mainPanelLayout = new GridBagLayout();
        this._mainPanel.setLayout(this._mainPanelLayout);
        this._mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._scrollMainPanel = new JScrollPane(this._mainPanel, 20, 30);
        this.getContentPane().add((Component)this._scrollMainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this._deleteButton = new JButton(DELETE_ACTION);
        this._deleteButton.addActionListener(this);
        buttonPanel.add(this._deleteButton);
        this._downloadButton = new JButton(DOWNLOAD_ACTION);
        this._downloadButton.addActionListener(this);
        buttonPanel.add(this._downloadButton);
        this._closeButton = new JButton("close");
        this._closeButton.addActionListener(this);
        buttonPanel.add(this._closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public void showUp(ActionListener listener, ConnectorManual connector, boolean bBusy) {
        this._hmTaskDoneNames = connector.getTaskDoneNames();
        this._hmTaskToBeDoneNames = connector.getTaskToBeDoneNames();
        this._listener = listener;
        this._hmTaskIds.clear();
        this._mainPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(8, 8, 8, 8);
        c.anchor = 17;
        JComponent busyLabel = null;
        if (bBusy) {
            busyLabel = new JPanel();
            busyLabel.setLayout(new BoxLayout(busyLabel, 1));
            busyLabel.setAlignmentX(0.0f);
            JLabel freeLabel = new JLabel("Remote Sybilla is busy working now");
            freeLabel.setAlignmentX(0.0f);
            busyLabel.add(freeLabel);
            JLabel patternNameLabel = new JLabel(" * calculated pattern: " + connector.getCalculatedPatternName());
            patternNameLabel.setAlignmentX(0.0f);
            busyLabel.add(patternNameLabel);
            JLabel progressLabel = new JLabel(" * progress: " + connector.getProgress() + "%  (phase " + (connector.isPhaseQuick() ? "quick)" : "full)"));
            progressLabel.setAlignmentX(0.0f);
            busyLabel.add(progressLabel);
            JLabel currMisfitLabel = new JLabel(" * current misfit: " + this._twoDigitNumberFormatter.format(connector.getCurrentMisfit()) + '%');
            currMisfitLabel.setAlignmentX(0.0f);
            busyLabel.add(currMisfitLabel);
        } else {
            busyLabel = new JLabel("Remote Sybilla is free to work");
            busyLabel.setAlignmentX(0.0f);
        }
        c.gridy = 0;
        c.gridx = 0;
        this._mainPanelLayout.setConstraints(busyLabel, c);
        this._mainPanel.add(busyLabel);
        JPanel toBeDonePanel = new JPanel();
        toBeDonePanel.setLayout(new BoxLayout(toBeDonePanel, 1));
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("tasks to be done:");
        toBeDonePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        toBeDonePanel.setAlignmentX(0.0f);
        if (this._hmTaskToBeDoneNames.size() == 0) {
            JLabel noneLabel = new JLabel("none                        ");
            noneLabel.setAlignmentX(0.0f);
            toBeDonePanel.add(noneLabel);
        } else {
            int iCount = 0;
            for (Integer hashCode : this._hmTaskToBeDoneNames.keySet()) {
                if (this._iTarget == 2) {
                    JCheckBox nameCheckBox = new JCheckBox((String)this._hmTaskToBeDoneNames.get(hashCode));
                    nameCheckBox.setAlignmentX(0.0f);
                    toBeDonePanel.add(nameCheckBox);
                    if (iCount++ == 0 && bBusy) {
                        nameCheckBox.setEnabled(false);
                        continue;
                    }
                    this._hmTaskIds.put(hashCode, nameCheckBox);
                    continue;
                }
                JLabel nameLabel = new JLabel((String)this._hmTaskToBeDoneNames.get(hashCode));
                nameLabel.setAlignmentX(0.0f);
                toBeDonePanel.add(nameLabel);
            }
        }
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        this._mainPanelLayout.setConstraints(toBeDonePanel, c);
        this._mainPanel.add(toBeDonePanel);
        JPanel donePanel = new JPanel();
        donePanel.setLayout(new BoxLayout(donePanel, 1));
        Border emptyBorder2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("tasks done:");
        donePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder2, emptyBorder2));
        donePanel.setAlignmentX(0.0f);
        if (this._hmTaskDoneNames.size() == 0) {
            JLabel noneLabel = new JLabel("none                        ");
            noneLabel.setAlignmentX(0.0f);
            donePanel.add(noneLabel);
        } else {
            boolean iCount = false;
            for (Integer hashCode : this._hmTaskDoneNames.keySet()) {
                if (this._iTarget == 2 || this._iTarget == 3) {
                    JCheckBox nameCheckBox = new JCheckBox((String)this._hmTaskDoneNames.get(hashCode));
                    nameCheckBox.setAlignmentX(0.0f);
                    donePanel.add(nameCheckBox);
                    this._hmTaskIds.put(hashCode, nameCheckBox);
                    continue;
                }
                JLabel nameLabel = new JLabel((String)this._hmTaskDoneNames.get(hashCode));
                nameLabel.setAlignmentX(0.0f);
                donePanel.add(nameLabel);
            }
        }
        c.gridy = 2;
        c.gridx = 0;
        c.fill = 1;
        this._mainPanelLayout.setConstraints(donePanel, c);
        this._mainPanel.add(donePanel);
        if (this._hmTaskDoneNames.size() + this._hmTaskToBeDoneNames.size() > 15) {
            this._scrollMainPanel.setPreferredSize(new Dimension(250, 500));
        } else {
            this._scrollMainPanel.setPreferredSize(null);
        }
        this._deleteButton.setVisible(this._iTarget == 2 && this._hmTaskIds.size() > 0);
        this._downloadButton.setVisible(this._iTarget == 3 && this._hmTaskIds.size() > 0);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._closeButton) {
            this.closeAction();
        } else if (e.getSource() == this._downloadButton) {
            this.closeAction();
            this._listener.actionPerformed(new ActionEvent(this, 1001, DOWNLOAD_ACTION));
        } else if (e.getSource() == this._deleteButton) {
            this.closeAction();
            this._listener.actionPerformed(new ActionEvent(this, 1001, DELETE_ACTION));
        } else {
            System.out.println("Caught unknown event: " + e.toString());
        }
    }

    public void setTarget(int iTarget) {
        this._iTarget = iTarget;
    }

    public List getTaskIds() {
        ArrayList<Integer> lTaskIds = new ArrayList<Integer>(10);
        for (Integer hashCode : this._hmTaskIds.keySet()) {
            if (!((JCheckBox)this._hmTaskIds.get(hashCode)).isSelected()) continue;
            lTaskIds.add(hashCode);
        }
        return lTaskIds;
    }

    private void closeAction() {
        this.setVisible(false);
    }
}

