/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FontUIResource;
import net.ndmystko.common.gui.AcceptAllFileFilter;
import net.ndmystko.common.gui.CTCopyrightWindow;
import net.ndmystko.common.gui.OpenFileListener;
import net.ndmystko.common.gui.RecentlyOpenedFiles;
import net.ndmystko.common.gui.SwingWorker;
import net.ndmystko.presentation.DrawXRDAdapter;
import net.ndmystko.presentation.DrawXRDEvent;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.Atom;
import net.ndmystko.xrd.DiffrFileFilter;
import net.ndmystko.xrd.RealDiffractogram;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.XRDRangeSelected;
import net.ndmystko.xrd.XlsParser;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Mixture;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.SybillaDiffractogram;
import net.ndmystko.xrd.mod.SybillaLeastSquares;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.Verificator;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gui.AdjustDialog;
import net.ndmystko.xrd.mod.gui.CalcPatternThread;
import net.ndmystko.xrd.mod.gui.ChoosePhasesDialog;
import net.ndmystko.xrd.mod.gui.CommonSybilla;
import net.ndmystko.xrd.mod.gui.DownloadDialog;
import net.ndmystko.xrd.mod.gui.FontFrame;
import net.ndmystko.xrd.mod.gui.GenesDialog;
import net.ndmystko.xrd.mod.gui.ProbabilityDialog;
import net.ndmystko.xrd.mod.gui.RemoveBackgroundDialog;
import net.ndmystko.xrd.mod.gui.ShowContent;
import net.ndmystko.xrd.mod.gui.SybillaDrawXRDJPanel;
import net.ndmystko.xrd.mod.gui.UploadDialog;
import net.ndmystko.xrd.mod.gui.VerificationDialog;
import net.ndmystko.xrd.mod.script.ScriptParams;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class SybillaManual
extends CommonSybilla
implements OpenFileListener,
ActionListener {
    private static final String version = "2.2.25";
    private static final String TITLE_BAR = "Sybilla Manual_v2.2.25";
    private static SybillaManual sybilla;
    private Object selectedObject = null;
    private NumberFormat saveNumberFormatter;
    private NumberFormat twoDigitNumberFormatter;
    private NumberFormat fourDigitNumberFormatter;
    private JMenu fileMenu;
    private JMenu inputFileMenu;
    private JMenu toolsFileMenu;
    private JMenu imageMenu;
    private JMenu serverMenu;
    private JMenu aboutMenu;
    private JLabel twoThetaLabel;
    private JLabel dSpacingLabel;
    private JLabel twoThetaStaticLbl;
    private JLabel dSpacingStaticLbl;
    private JLabel calculatedStructuresLabel;
    private JLabel fitLabel;
    private RecentlyOpenedFiles recentFiles;
    private JMenuItem loadPatternItem;
    private JMenuItem removeBcgItem;
    private JMenuItem savePatternItem;
    private JMenuItem closeItem;
    private JMenuItem exitItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem choosePhasesItem;
    private JMenuItem readAtomicFactorsItem;
    private JMenuItem saveAtomicFactorsItem;
    private JMenuItem createFromInputItem;
    private JMenuItem removeSelectedItem;
    private JMenuItem adjustItem;
    private JMenuItem showContentItem;
    private JMenuItem saveCreatedPatternItem;
    private JMenuItem saveXmlStructureItem;
    private JMenuItem saveSummaryItem;
    private JMenuItem loadFitItem;
    private JMenuItem saveFitItem;
    private JMenuItem saveEverythingItem;
    private JMenuItem verifyItem;
    private JMenuItem createProbabItem;
    private JMenuItem convertToAirItem;
    private JMenuItem convertToGlyItem;
    private JMenuItem unzoomItem;
    private JMenuItem printItem;
    private JMenuItem _captureImageItem;
    private JMenuItem _width1MenuItem;
    private JMenuItem _width15MenuItem;
    private JMenuItem _width2MenuItem;
    private JMenuItem _width25MenuItem;
    private JMenuItem _width3MenuItem;
    private JMenuItem _fontSizeItem;
    private JMenuItem uploadItem;
    private JMenuItem downloadItem;
    private JList createdPatternsList;
    private PhasesListModel createdPatternsListModel;
    private JButton clearResultsButton;
    private static final int DEFAULT_DRAWING_AREA_WIDTH = 1000;
    private static final int DEFAULT_DRAWING_AREA_HEIGHT = 750;
    protected static final Cursor defaultCursor;
    protected static final Cursor waitCursor;
    private JPopupMenu _popupMenu = null;
    private JMenuItem removeRangeItem;
    private static final Color phaseColor;
    private static final Cursor _moveCursor;
    private boolean _bMouseDragged = false;
    private boolean _bMoveCursorSet = false;
    private int _iPossibleDraggingStartedAt = -1;
    private RemoveBackgroundDialog _removeBcgDialog = null;
    private ChoosePhasesDialog _choosePhasesDialog = null;
    private GenesDialog _slidersDialog = null;
    private AdjustDialog _adjustDialog = null;
    private ShowContent _showContent = null;
    private ProbabilityDialog _probabDialog = null;
    private GenesDialog _restrictionsDialog = null;
    private UploadDialog _uploadDialog = null;
    private DownloadDialog _downloadDialog = null;
    private VerificationDialog _verificationDialog;
    private FontFrame _fontSizeModificationFrame;
    protected JFileChooser chooser;
    protected JFileChooser saveDialog;
    private DiffrFileFilter loadFilter;
    private DiffrFileFilter xmlFilter;
    private DiffrFileFilter saveFilter;
    private DiffrFileFilter csvFilter;
    private DiffrFileFilter _txtFilter;
    private DiffrFileFilter serFilter;
    private DiffrFileFilter pngFilter;
    public DiffrFileFilter _remSerFilter;
    private AcceptAllFileFilter _allFilter;
    private static final String[] LOAD_FILETYPES;
    private static final String[] XML_FILETYPE;
    private static final String[] TXT_FILETYPE;
    private static final String[] SAVE_FILETYPES;
    private static final String[] CSV_FILETYPE;
    private static final String[] SER_FILETYPE;
    private static final String[] PNG_FILETYPES;
    public static final String[] REMOTE_SER_FILETYPE;
    private static final double DEFAULT_LAMBDA = 1.54178;
    private AbstractDiffractogram _expPattern = null;
    private UserDiffractogram _composedPattern = null;
    private AbstractDiffractogram _previewedPattern = null;
    private SybillaLeastSquares _fitter = null;
    private AbstractDiffractogram _autoExpGlyPattern = null;
    private AbstractDiffractogram _autoExpWatPattern = null;
    private static final String SERIALIZED_RESULTS_FILE_NAME = "resultsManual.ser";
    private static final String SERIALIZED_FILE_NAME = "common.ser";
    private static Preferences _prefs;
    private static final String CHOOSE_PHASES_NODE = "choose_phases";
    private int programState = 0;
    public static final int PROGRAM_STARTED = 0;
    private static final int EXP_PATTERN_LOADED = 3;
    private static final int DIALOG_DISPLAYED = 6;
    private static final int STAND_ALONE_CREATED = 8;
    private static final int PATTERN_CREATED = 9;
    private static Logger _logger;
    private static Font menuFont;
    private static Font panelFont;

    static {
        defaultCursor = new Cursor(0);
        waitCursor = new Cursor(3);
        phaseColor = new Color(0.1f, 0.5f, 0.1f);
        _moveCursor = new Cursor(13);
        LOAD_FILETYPES = new String[]{"uxd", "csv", "jt", "txt", "ex$", "ex", "xls"};
        XML_FILETYPE = new String[]{"xml"};
        TXT_FILETYPE = new String[]{"txt"};
        SAVE_FILETYPES = new String[]{"uxd"};
        CSV_FILETYPE = new String[]{"csv"};
        SER_FILETYPE = new String[]{"ser"};
        PNG_FILETYPES = new String[]{"png"};
        REMOTE_SER_FILETYPE = new String[]{"rsr"};
        _prefs = null;
        _logger = Logger.getLogger("net.ndmystko.xrd.mod.gui.SybillaManual");
        menuFont = new Font("sans-serif", 0, 20);
        panelFont = new Font("sans-serif", 0, 30);
    }

    public static void main(String[] argv) {
        _prefs = Preferences.userNodeForPackage(SybillaManual.class);
        sybilla = new SybillaManual(TITLE_BAR, 1000, 750);
        if (argv != null && argv.length > 0) {
            File toBeOpened = new File(argv[0]);
            sybilla.loadPattern(toBeOpened);
        }
    }

    public SybillaManual(String title, int width, int height) {
        String sDir;
        this.frame = new JFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SybillaManual.this.adieu();
            }
        });
        CTCopyrightWindow crWindow = new CTCopyrightWindow(this.frame, "2003-2007");
        crWindow.setVisible(true);
        if (!crWindow.canContinue()) {
            this.frame.dispose();
            System.exit(0);
        }
        PatternParams.setGuiComponent(this.frame);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.deserializeCommonData();
        this.saveNumberFormatter = NumberFormat.getInstance(Locale.US);
        this.saveNumberFormatter.setMinimumFractionDigits(0);
        this.saveNumberFormatter.setMaximumFractionDigits(5);
        this.saveNumberFormatter.setGroupingUsed(false);
        this.twoDigitNumberFormatter = NumberFormat.getInstance(Locale.US);
        this.twoDigitNumberFormatter.setMinimumFractionDigits(2);
        this.twoDigitNumberFormatter.setMaximumFractionDigits(2);
        this.fourDigitNumberFormatter = NumberFormat.getInstance(Locale.US);
        this.fourDigitNumberFormatter.setMinimumFractionDigits(4);
        this.fourDigitNumberFormatter.setMaximumFractionDigits(4);
        Font f = new Font("sans-serif", 1, 12);
        UIManager.put("Button.font", f);
        UIManager.put("ToggleButton.font", f);
        UIManager.put("RadioButton.font", f);
        UIManager.put("CheckBox.font", f);
        UIManager.put("ColorChooser.font", f);
        UIManager.put("ComboBox.font", f);
        UIManager.put("Label.font", f);
        UIManager.put("List.font", f);
        UIManager.put("MenuBar.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("RadioButtonMenuItem.font", f);
        UIManager.put("CheckBoxMenuItem.font", f);
        UIManager.put("Menu.font", f);
        UIManager.put("PopupMenu.font", f);
        UIManager.put("OptionPane.font", f);
        UIManager.put("Panel.font", f);
        UIManager.put("ProgressBar.font", f);
        UIManager.put("ScrollPane.font", f);
        UIManager.put("Viewport.font", f);
        UIManager.put("TabbedPane.font", f);
        UIManager.put("Table.font", f);
        UIManager.put("TableHeader.font", f);
        UIManager.put("TextField.font", f);
        UIManager.put("PasswordField.font", f);
        UIManager.put("TextArea.font", f);
        UIManager.put("TextPane.font", f);
        UIManager.put("EditorPane.font", f);
        UIManager.put("TitledBorder.font", f);
        UIManager.put("ToolBar.font", f);
        UIManager.put("ToolTip.font", f);
        UIManager.put("Tree.font", f);
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu("file");
        this.loadPatternItem = new JMenuItem("open pattern");
        this.loadPatternItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        this.loadPatternItem.addActionListener(this);
        this.fileMenu.add(this.loadPatternItem);
        this.closeItem = new JMenuItem("close");
        this.closeItem.addActionListener(this);
        this.fileMenu.add(this.closeItem);
        this.removeBcgItem = new JMenuItem("remove bcg");
        this.removeBcgItem.addActionListener(this);
        this.fileMenu.add(this.removeBcgItem);
        this.savePatternItem = new JMenuItem("save pattern");
        this.savePatternItem.addActionListener(this);
        this.fileMenu.add(this.savePatternItem);
        this.fileMenu.addSeparator();
        if (this.recentFiles == null) {
            this.recentFiles = new RecentlyOpenedFiles();
            this.recentFiles.createItems(_prefs);
        }
        this.recentFiles.registerItems(this.fileMenu);
        this.recentFiles.setOpenFileListener(this);
        this.recentFiles.setEnabled(true);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem("exit");
        this.exitItem.addActionListener(this);
        this.fileMenu.add(this.exitItem);
        menuBar.add(this.fileMenu);
        this.inputFileMenu = new JMenu("fitting");
        this.choosePhasesItem = new JMenuItem("add gene phases");
        this.choosePhasesItem.addActionListener(this);
        this.inputFileMenu.add(this.choosePhasesItem);
        this.createFromInputItem = new JMenuItem("add from input file");
        this.createFromInputItem.addActionListener(this);
        this.inputFileMenu.add(this.createFromInputItem);
        this.saveAtomicFactorsItem = new JMenuItem("save atomic factors");
        this.saveAtomicFactorsItem.addActionListener(this);
        this.inputFileMenu.add(this.saveAtomicFactorsItem);
        this.readAtomicFactorsItem = new JMenuItem("read atomic factors");
        this.readAtomicFactorsItem.addActionListener(this);
        this.inputFileMenu.add(this.readAtomicFactorsItem);
        this.removeSelectedItem = new JMenuItem("remove selected");
        this.removeSelectedItem.addActionListener(this);
        this.inputFileMenu.add(this.removeSelectedItem);
        this.adjustItem = new JMenuItem("adjust contents");
        this.adjustItem.addActionListener(this);
        this.inputFileMenu.add(this.adjustItem);
        this.showContentItem = new JMenuItem("show content");
        this.showContentItem.addActionListener(this);
        this.inputFileMenu.add(this.showContentItem);
        this.saveCreatedPatternItem = new JMenuItem("save fit pattern");
        this.saveCreatedPatternItem.addActionListener(this);
        this.inputFileMenu.add(this.saveCreatedPatternItem);
        this.saveXmlStructureItem = new JMenuItem("save full structure");
        this.saveXmlStructureItem.addActionListener(this);
        this.inputFileMenu.add(this.saveXmlStructureItem);
        this.saveSummaryItem = new JMenuItem("save summary");
        this.saveSummaryItem.addActionListener(this);
        this.inputFileMenu.add(this.saveSummaryItem);
        this.loadFitItem = new JMenuItem("load fit");
        this.loadFitItem.addActionListener(this);
        this.inputFileMenu.add(this.loadFitItem);
        this.saveFitItem = new JMenuItem("save fit");
        this.saveFitItem.addActionListener(this);
        this.inputFileMenu.add(this.saveFitItem);
        this.saveEverythingItem = new JMenuItem("save all");
        this.saveEverythingItem.addActionListener(this);
        this.inputFileMenu.add(this.saveEverythingItem);
        menuBar.add(this.inputFileMenu);
        this.toolsFileMenu = new JMenu("tools");
        this.verifyItem = new JMenuItem("verify model");
        this.verifyItem.addActionListener(this);
        this.toolsFileMenu.add(this.verifyItem);
        this.createProbabItem = new JMenuItem("create probab matrix");
        this.createProbabItem.addActionListener(this);
        this.toolsFileMenu.add(this.createProbabItem);
        this.convertToAirItem = new JMenuItem("convert to air-dry");
        this.convertToAirItem.addActionListener(this);
        this.toolsFileMenu.add(this.convertToAirItem);
        this.convertToGlyItem = new JMenuItem("convert to gly");
        this.convertToGlyItem.addActionListener(this);
        this.toolsFileMenu.add(this.convertToGlyItem);
        menuBar.add(this.toolsFileMenu);
        this.imageMenu = new JMenu("image");
        this.printItem = new JMenuItem("print");
        this.printItem.addActionListener(this);
        this.imageMenu.add(this.printItem);
        this._captureImageItem = new JMenuItem("capture");
        this._captureImageItem.addActionListener(this);
        this.imageMenu.add(this._captureImageItem);
        this.unzoomItem = new JMenuItem("unzoom");
        this.unzoomItem.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        this.unzoomItem.addActionListener(this);
        this.imageMenu.add(this.unzoomItem);
        ButtonGroup lineWidthButtonGroup = new ButtonGroup();
        JMenu widthMenu = new JMenu("line width");
        this._width1MenuItem = new JRadioButtonMenuItem("1 pixel", true);
        this._width1MenuItem.addActionListener(this);
        lineWidthButtonGroup.add(this._width1MenuItem);
        widthMenu.add(this._width1MenuItem);
        this._width15MenuItem = new JRadioButtonMenuItem("1.5 pixels", true);
        this._width15MenuItem.addActionListener(this);
        lineWidthButtonGroup.add(this._width15MenuItem);
        widthMenu.add(this._width15MenuItem);
        this._width2MenuItem = new JRadioButtonMenuItem("2 pixels", false);
        this._width2MenuItem.addActionListener(this);
        lineWidthButtonGroup.add(this._width2MenuItem);
        widthMenu.add(this._width2MenuItem);
        this._width25MenuItem = new JRadioButtonMenuItem("2.5 pixels", true);
        this._width25MenuItem.addActionListener(this);
        lineWidthButtonGroup.add(this._width25MenuItem);
        widthMenu.add(this._width25MenuItem);
        this._width3MenuItem = new JRadioButtonMenuItem("3 pixels", false);
        this._width3MenuItem.addActionListener(this);
        lineWidthButtonGroup.add(this._width3MenuItem);
        widthMenu.add(this._width3MenuItem);
        this.imageMenu.add(widthMenu);
        this._fontSizeItem = new JMenuItem("font size");
        this._fontSizeItem.addActionListener(this);
        this.imageMenu.add(this._fontSizeItem);
        menuBar.add(this.imageMenu);
        this.serverMenu = new JMenu("remote");
        this.uploadItem = new JMenuItem("upload");
        this.uploadItem.addActionListener(this);
        this.serverMenu.add(this.uploadItem);
        this.downloadItem = new JMenuItem("download");
        this.downloadItem.addActionListener(this);
        this.serverMenu.add(this.downloadItem);
        menuBar.add(this.serverMenu);
        this.aboutMenu = new JMenu("about");
        this.aboutMenuItem = new JMenuItem("about");
        this.aboutMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(this);
        menuBar.add(this.aboutMenu);
        this.frame.setJMenuBar(menuBar);
        this.drawingArea = new SybillaDrawXRDJPanel();
        this.drawingArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SybillaManual.this.drawingArea.unzoom();
                }
            }
        });
        this.drawingArea.addDrawXRDListener(new DrawXRDAdapter(){

            @Override
            public void mouseMoved(DrawXRDEvent e) {
                double twoTheta = e.get2theta();
                if (twoTheta > 0.0) {
                    SybillaManual.this.twoThetaLabel.setText(SybillaManual.this.twoDigitNumberFormatter.format(twoTheta));
                    double d = 0.77089 / Math.sin(twoTheta * Math.PI / 360.0);
                    SybillaManual.this.dSpacingLabel.setText(SybillaManual.this.fourDigitNumberFormatter.format(d));
                } else {
                    SybillaManual.this.twoThetaLabel.setText(" ");
                    SybillaManual.this.dSpacingLabel.setText(" ");
                }
            }

            @Override
            public void rangeSelected(DrawXRDEvent e) {
                SybillaManual.this.drawingArea.addRangeSelected(e.getRangeSelected());
                if (SybillaManual.this._fitter != null) {
                    SybillaManual.this._fitter.setExcludedRanges(SybillaManual.this.drawingArea.getAllRanges());
                    if (SybillaManual.this.createdPatternsListModel.size() > 0) {
                        SybillaManual.this.fitAllPatterns();
                    }
                }
            }

            @Override
            public void rightButtonClicked(DrawXRDEvent e) {
                if (e.getTargetObject() instanceof XRDRangeSelected) {
                    SybillaManual.this.selectedObject = e.getTargetObject();
                    MouseEvent ev = e.getMouseEvent();
                    SybillaManual.this._popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }
        });
        this.drawingArea.addMouseListener(new DeselectAdapter());
        this.drawingArea.setPreferredSize(new Dimension(width, height));
        this.drawingArea.setMinimumSize(new Dimension(width / 2, height));
        this.drawingArea.setCursor(new Cursor(1));
        this.frame.getContentPane().add((Component)this.drawingArea, "Center");
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 1));
        Border etchedBorder = BorderFactory.createEtchedBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        resultsPanel.setBorder(BorderFactory.createCompoundBorder(etchedBorder, emptyBorder));
        resultsPanel.setPreferredSize(new Dimension(250, height));
        this.calculatedStructuresLabel = new JLabel("Calculated structures:");
        resultsPanel.add(this.calculatedStructuresLabel);
        resultsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.createdPatternsListModel = new PhasesListModel();
        this.createdPatternsList = new JList(this.createdPatternsListModel);
        this.createdPatternsList.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "delete item");
        this.createdPatternsList.getActionMap().put("delete item", new DeleteListItem());
        this.createdPatternsList.getSelectionModel().setSelectionMode(0);
        this.createdPatternsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SybillaManual.this.listSelectionChanged(e);
            }
        });
        this.createdPatternsList.addMouseListener(new ListItemDoubleClicked());
        this.createdPatternsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SybillaManual.this._iPossibleDraggingStartedAt = SybillaManual.this.createdPatternsList.locationToIndex(new Point(e.getX(), e.getY()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SybillaManual.this._bMouseDragged) {
                    SybillaManual.this._bMouseDragged = false;
                    SybillaManual.this._bMoveCursorSet = false;
                    int iFinalIndex = SybillaManual.this.createdPatternsList.locationToIndex(new Point(e.getX(), e.getY()));
                    if (SybillaManual.this._iPossibleDraggingStartedAt == iFinalIndex) {
                        SybillaManual.this.frame.setCursor(defaultCursor);
                        return;
                    }
                    if (SybillaManual.this._iPossibleDraggingStartedAt < iFinalIndex) {
                        --iFinalIndex;
                    }
                    Object moved = SybillaManual.this.createdPatternsListModel.getElementAt(SybillaManual.this._iPossibleDraggingStartedAt);
                    SybillaManual.this.createdPatternsListModel.removeElementAt(SybillaManual.this._iPossibleDraggingStartedAt);
                    SybillaManual.this.createdPatternsListModel.insertElementAt(moved, iFinalIndex);
                    SybillaManual.this.createdPatternsList.setSelectedIndex(iFinalIndex);
                    SybillaManual.this.frame.setCursor(defaultCursor);
                }
            }
        });
        this.createdPatternsList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SybillaManual.this._bMouseDragged = true;
                if (!SybillaManual.this._bMoveCursorSet) {
                    SybillaManual.this.frame.setCursor(_moveCursor);
                    SybillaManual.this._bMoveCursorSet = true;
                }
            }
        });
        JScrollPane scrollPaneResultList = new JScrollPane(this.createdPatternsList, 20, 32);
        resultsPanel.add(scrollPaneResultList);
        resultsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clearResultsButton = new JButton("clear list");
        this.clearResultsButton.setAlignmentX(0.0f);
        this.clearResultsButton.addActionListener(this);
        resultsPanel.add(this.clearResultsButton);
        resultsPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.fitLabel = new JLabel("misfit: ");
        this.fitLabel.setAlignmentX(0.0f);
        resultsPanel.add(this.fitLabel);
        resultsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.twoThetaStaticLbl = new JLabel("2-theta: ");
        this.twoThetaStaticLbl.setAlignmentX(0.0f);
        resultsPanel.add(this.twoThetaStaticLbl);
        this.twoThetaLabel = new JLabel("?");
        this.twoThetaLabel.setAlignmentX(0.0f);
        resultsPanel.add(this.twoThetaLabel);
        resultsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.dSpacingStaticLbl = new JLabel("d-spacing: ");
        this.dSpacingStaticLbl.setAlignmentX(0.0f);
        resultsPanel.add(this.dSpacingStaticLbl);
        this.dSpacingLabel = new JLabel("?");
        this.dSpacingLabel.setAlignmentX(0.0f);
        resultsPanel.add(this.dSpacingLabel);
        this.frame.getContentPane().add((Component)resultsPanel, "East");
        this._popupMenu = new JPopupMenu();
        this.removeRangeItem = new JMenuItem("remove");
        this.removeRangeItem.addActionListener(this);
        this._popupMenu.add(this.removeRangeItem);
        this._popupMenu.pack();
        this.loadFilter = new DiffrFileFilter(LOAD_FILETYPES);
        this.xmlFilter = new DiffrFileFilter(XML_FILETYPE);
        this._txtFilter = new DiffrFileFilter(TXT_FILETYPE);
        this.saveFilter = new DiffrFileFilter(SAVE_FILETYPES);
        this.csvFilter = new DiffrFileFilter(CSV_FILETYPE);
        this.serFilter = new DiffrFileFilter(SER_FILETYPE);
        this._remSerFilter = new DiffrFileFilter(REMOTE_SER_FILETYPE);
        this.pngFilter = new DiffrFileFilter(PNG_FILETYPES);
        this._allFilter = new AcceptAllFileFilter();
        this.chooser = new JFileChooser();
        this.chooser.setFileFilter(this.loadFilter);
        this.chooser.setMultiSelectionEnabled(false);
        try {
            sDir = _prefs.get("chooser.current.dir", null);
            this.chooser.setCurrentDirectory(sDir != null ? new File(sDir) : null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.chooser.setCurrentDirectory(null);
        }
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.saveFilter = new DiffrFileFilter(SAVE_FILETYPES);
        this.saveDialog = new JFileChooser();
        this.saveDialog.setFileFilter(this.saveFilter);
        this.saveDialog.setMultiSelectionEnabled(false);
        try {
            sDir = _prefs.get("saveDialog.current.dir", null);
            this.saveDialog.setCurrentDirectory(sDir != null ? new File(sDir) : null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.saveDialog.setCurrentDirectory(null);
        }
        this.saveDialog.removeChoosableFileFilter(this.saveDialog.getAcceptAllFileFilter());
        this._removeBcgDialog = new RemoveBackgroundDialog(this);
        this._removeBcgDialog.pack();
        this._choosePhasesDialog = new ChoosePhasesDialog(this, _prefs.node(CHOOSE_PHASES_NODE));
        this._choosePhasesDialog.pack();
        this._slidersDialog = new GenesDialog(this, "adjust genes");
        this._adjustDialog = new AdjustDialog(this);
        this._showContent = new ShowContent(this);
        this._probabDialog = new ProbabilityDialog(this);
        this._restrictionsDialog = new GenesDialog(this, "I/S restrictions");
        this._uploadDialog = new UploadDialog(this);
        this._uploadDialog.setHostName(_prefs.get("upload_dialog.host_name", "136.171.255.140"));
        this._downloadDialog = new DownloadDialog(this, this.saveDialog, this.chooser);
        this._downloadDialog.setHostName(_prefs.get("download_dialog.host_name", "136.171.255.140"));
        this._verificationDialog = new VerificationDialog(this);
        this._fontSizeModificationFrame = new FontFrame(this);
        this.setItemsEnabled(0);
        this.frame.setTitle(title);
        this.frame.pack();
        this.frame.setVisible(true);
        this.deserializePatterns();
        this.setMenuFontSize(menuFont);
        this.setPanelFontSize(panelFont);
    }

    @Override
    public void openFile(File file) {
        this.loadPattern(file);
    }

    private boolean loadPattern(File file) {
        RealDiffractogram loadedPattern = null;
        try {
            loadedPattern = file.getName().toLowerCase().endsWith(".xls") ? XlsParser.loadDiffractogram(file.getPath()) : new RealDiffractogram(file.getPath());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error during loading pattern:\n" + e.getMessage(), TITLE_BAR, 0);
            return false;
        }
        if (this.createdPatternsListModel.size() > 0) {
            AbstractDiffractogram firstPattern = ((Pattern)this.createdPatternsListModel.get(0)).getFinalDiffr();
            if (Math.abs(loadedPattern.getMin2theta() - firstPattern.getMin2theta()) > 1.0E-6 || Math.abs(loadedPattern.getMax2theta() - firstPattern.getMax2theta()) > 1.0E-6 || Math.abs(loadedPattern.getStepSize() - firstPattern.getStepSize()) > 1.0E-6) {
                int reply = JOptionPane.showConfirmDialog(this.frame, "File " + file.getName() + " has different range or step size than the ones\nalready present at the list. You can clear the list and proceed or\ngive up loading this pattern. Do you choose to give up?", TITLE_BAR, 0, 3);
                if (reply == 1) {
                    this.createdPatternsListModel.clear();
                } else {
                    return false;
                }
            }
        }
        this._composedPattern = new UserDiffractogram(loadedPattern);
        this._composedPattern.setColor(Color.red);
        this._fitter = new SybillaLeastSquares(loadedPattern, this.drawingArea.getAllRanges());
        try {
            this.drawingArea.addDiffractogram(loadedPattern, true);
            this.drawingArea.addDiffractogram(this._composedPattern, true);
        }
        catch (XRDException e) {
            this.drawingArea.removeAllDiffractograms();
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), TITLE_BAR, 0);
            return false;
        }
        this._expPattern = loadedPattern;
        this.drawingArea.setExpPatternName(this._expPattern.getName());
        if (this.createdPatternsListModel.size() > 0) {
            this.fitAllPatterns();
            this.setItemsEnabled(9);
        } else {
            this.drawingArea.repaint();
            this.setItemsEnabled(3);
        }
        this.frame.setTitle("Sybilla Manual_v2.2.25 - " + loadedPattern.getName());
        return true;
    }

    public boolean setPattern(AbstractDiffractogram expPattern) {
        if (this.createdPatternsListModel.size() > 0) {
            AbstractDiffractogram firstPattern = ((Pattern)this.createdPatternsListModel.get(0)).getFinalDiffr();
            if (expPattern.getMin2theta() != firstPattern.getMin2theta() || expPattern.getMax2theta() != firstPattern.getMax2theta() || expPattern.getStepSize() != firstPattern.getStepSize()) {
                int reply = JOptionPane.showConfirmDialog(this.frame, "Pattern " + expPattern.getName() + " has different range or step size than the ones\nalready present at the list. You can clear the list and proceed or\ngive up loading this pattern. Do you choose to give up?", TITLE_BAR, 0, 3);
                if (reply == 1) {
                    this.createdPatternsListModel.clear();
                } else {
                    return false;
                }
            }
        }
        this._composedPattern = new UserDiffractogram(expPattern);
        this._composedPattern.setColor(Color.red);
        this._fitter = new SybillaLeastSquares(expPattern, this.drawingArea.getAllRanges());
        try {
            this.drawingArea.addDiffractogram(expPattern, true);
            this.drawingArea.addDiffractogram(this._composedPattern, true);
        }
        catch (XRDException e) {
            this.drawingArea.removeAllDiffractograms();
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), TITLE_BAR, 0);
            return false;
        }
        this._expPattern = expPattern;
        this.drawingArea.setExpPatternName(this._expPattern.getName());
        if (this.createdPatternsListModel.size() > 0) {
            this.fitAllPatterns();
            this.setItemsEnabled(9);
        } else {
            this.drawingArea.repaint();
            this.setItemsEnabled(3);
        }
        this.frame.setTitle("Sybilla Manual_v2.2.25 - " + expPattern.getName());
        return true;
    }

    private void closePatterns() {
        this.drawingArea.setExpPatternName(null);
        this.drawingArea.removeAllDiffractograms();
        this._expPattern = null;
        this._composedPattern = null;
        this._previewedPattern = null;
        this._autoExpGlyPattern = null;
        this._autoExpWatPattern = null;
        this._fitter = null;
        this.resetAdjustements();
        this._choosePhasesDialog.reset();
        this.fitLabel.setText("misfit:");
        this.setItemsEnabled(this.createdPatternsListModel.size() == 0 ? 0 : 8);
        this.drawingArea.repaint();
        this.frame.setTitle(TITLE_BAR);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.loadPatternItem) {
            boolean opened;
            this.chooser.setFileFilter(this.loadFilter);
            int returnVal = this.chooser.showOpenDialog(this.frame);
            if (returnVal == 0 && (opened = this.loadPattern(this.chooser.getSelectedFile()))) {
                this.recentFiles.openingFile(this.chooser.getSelectedFile());
            }
        } else if (e.getSource() == this.closeItem) {
            this.closePatterns();
        } else if (e.getSource() == this.removeBcgItem) {
            if (this._expPattern != null) {
                this._removeBcgDialog.showUp(this.programState, this._expPattern);
                this.setItemsEnabled(6);
                this.drawingArea.setAreaSelectable(true);
                this.drawingArea.setInterestedInPopup(true);
            }
        } else if (e.getSource() == this.savePatternItem) {
            this.saveExpPattern();
        } else if (e.getSource() == this.choosePhasesItem) {
            if (this._expPattern != null) {
                this._choosePhasesDialog.showUp(true, false, this, this.programState, this._expPattern.getMin2theta(), this._expPattern.getMax2theta(), this._expPattern.getStepSize(), 1.54178);
            } else if (this.createdPatternsListModel.size() == 0) {
                this._choosePhasesDialog.showUp(true, false, this, this.programState, Double.NaN, Double.NaN, Double.NaN, 1.54178);
            } else {
                PatternParams patternParams = ((Pattern)this.createdPatternsListModel.get(0)).getPatternParams();
                this._choosePhasesDialog.showUp(true, false, this, this.programState, patternParams.getMin2theta(), patternParams.getMax2theta(), patternParams.getStepSize(), 1.54178);
            }
            this.setItemsEnabled(6);
        } else if (e.getSource() == this.saveXmlStructureItem) {
            this.saveDialog.setFileFilter(this.xmlFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveStructure(this.saveDialog.getSelectedFile(), true);
            }
        } else if (e.getSource() == this.saveSummaryItem) {
            this.saveDialog.setFileFilter(this._txtFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveStructure(this.saveDialog.getSelectedFile(), false);
            }
        } else if (e.getSource() == this.createFromInputItem) {
            this.chooser.setFileFilter(this.xmlFilter);
            int returnVal = this.chooser.showOpenDialog(this.frame);
            if (returnVal == 0) {
                this.createFromInputFile(this.chooser.getSelectedFile());
            }
        } else if (e.getSource() == this.removeSelectedItem) {
            this.removeSelectedPattern();
        } else if (e.getSource() == this.adjustItem) {
            this.adjustPatterns();
        } else if (e.getSource() == this.showContentItem) {
            this.showContent();
        } else if (e.getSource() == this.saveCreatedPatternItem) {
            this.saveDialog.setFileFilter(this.csvFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveCreatedPattern(this.saveDialog.getSelectedFile());
            }
        } else if (e.getSource() == this.loadFitItem) {
            this.loadFit();
        } else if (e.getSource() == this.saveFitItem) {
            this.saveDialog.setFileFilter(this.serFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveFit(this.saveDialog.getSelectedFile());
            }
        } else if (e.getSource() == this.saveEverythingItem) {
            this.saveDialog.setFileFilter(this._allFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveEverything(this.saveDialog.getSelectedFile());
            }
        } else if (e.getSource() == this.convertToAirItem) {
            this.convertPhases(1);
        } else if (e.getSource() == this.convertToGlyItem) {
            this.convertPhases(0);
        } else if (e.getSource() == this.verifyItem) {
            this.verifyModel();
        } else if (e.getSource() == this.createProbabItem) {
            this.saveDialog.setFileFilter(this.xmlFilter);
            this._probabDialog.showUp(-1, null, this.saveDialog, false);
        } else if (e.getSource() == this.uploadItem) {
            this._uploadDialog.showUp(this.programState);
            this.setItemsEnabled(6);
        } else if (e.getSource() == this.downloadItem) {
            this._downloadDialog.showUp(this.programState);
            this.setItemsEnabled(6);
        } else if (e.getSource() == this.aboutMenuItem) {
            JOptionPane.showMessageDialog(this.frame, "<html>The Sybilla program was originally developed by Krystof Mystkowski from the algorithms described in Drits & Tchoubar (1990) <br> and under the joint supervision of Victor A. Drits, Boris A. Sakharov, Douglas K. McCarty, and Jan \u015arodo\u0144.<br> The present version has been enriched and compiled by Marek Szczerba.</html>", "about", -1);
        } else if (e.getSource() == this.clearResultsButton) {
            this.clearResults();
        } else if (e.getSource() == this._choosePhasesDialog) {
            if (e.getActionCommand().equals("phases accepted")) {
                if (this._expPattern != null) {
                    this.phasesSelected(this._choosePhasesDialog.getChosenPhases(), this._choosePhasesDialog.getPatternParams(this._expPattern.getMin2theta(), this._expPattern.getMax2theta(), this._expPattern.getStepSize(), 1.54178));
                } else {
                    this.phasesSelected(this._choosePhasesDialog.getChosenPhases(), this._choosePhasesDialog.getPatternParams(Double.NaN, Double.NaN, Double.NaN, 1.54178));
                }
            }
        } else if (e.getSource() == this.exitItem) {
            this.adieu();
        } else if (e.getSource() == this.removeRangeItem) {
            this.drawingArea.removeRangeSelected((XRDRangeSelected)this.selectedObject);
            if (this._fitter != null) {
                this._fitter.setExcludedRanges(this.drawingArea.getAllRanges());
                if (this.createdPatternsListModel.size() > 0) {
                    this.fitAllPatterns();
                }
            }
            this.drawingArea.repaint();
        } else if (e.getSource() == this.unzoomItem) {
            this.drawingArea.unzoom();
        } else if (e.getSource() == this.printItem) {
            this.print();
        } else if (e.getSource() == this._captureImageItem) {
            this.screenshot();
        } else if (e.getSource() == this._width1MenuItem) {
            this.drawingArea.setLineWidth(1.0f);
            this.drawingArea.repaint();
        } else if (e.getSource() == this._width15MenuItem) {
            this.drawingArea.setLineWidth(1.5f);
            this.drawingArea.repaint();
        } else if (e.getSource() == this._width2MenuItem) {
            this.drawingArea.setLineWidth(2.0f);
            this.drawingArea.repaint();
        } else if (e.getSource() == this._width25MenuItem) {
            this.drawingArea.setLineWidth(2.5f);
            this.drawingArea.repaint();
        } else if (e.getSource() == this._width3MenuItem) {
            this.drawingArea.setLineWidth(3.0f);
            this.drawingArea.repaint();
        } else if (e.getSource() == this._fontSizeItem) {
            this._fontSizeModificationFrame.setVisible(true);
        } else if (e.getSource() instanceof CalcPatternThread) {
            this.createdFromInputFile(e);
        } else if (e.getSource() == this.saveAtomicFactorsItem) {
            this.saveDialog.setFileFilter(this.xmlFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showSaveDialog(this.frame);
            if (returnVal == 0) {
                this.saveAtomicFactor(this.saveDialog.getSelectedFile());
            }
        } else if (e.getSource() == this.readAtomicFactorsItem) {
            this.saveDialog.setFileFilter(this.xmlFilter);
            this.setupSaveDialog();
            int returnVal = this.saveDialog.showOpenDialog(this.frame);
            if (returnVal == 0) {
                this.readAtomicFactor(this.saveDialog.getSelectedFile());
            }
        } else {
            System.out.println("Caught unknown exception: " + e.toString());
        }
    }

    private void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = printJob.defaultPage();
        pf.setOrientation(0);
        printJob.setPrintable(this.drawingArea, pf);
        if (printJob.printDialog()) {
            try {
                this.frame.setCursor(waitCursor);
                printJob.print();
                this.frame.setCursor(defaultCursor);
            }
            catch (PrinterException err) {
                this.frame.setCursor(defaultCursor);
                JOptionPane.showMessageDialog(this.frame, "Error occured during printing", TITLE_BAR, 0);
            }
        }
    }

    private void listSelectionChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this._previewedPattern != null) {
                this.drawingArea.removeDiffractogram(this._previewedPattern, false);
                this._previewedPattern = null;
            }
            if (this.createdPatternsList.getSelectedIndex() > -1) {
                int iIndex = this.createdPatternsList.getSelectedIndex();
                this._previewedPattern = ((Pattern)this.createdPatternsListModel.get(iIndex)).getFinalDiffr();
                try {
                    this.drawingArea.addDiffractogram(this._previewedPattern, false);
                }
                catch (XRDException ex) {
                    JOptionPane.showMessageDialog(this.frame, "Internal error occured, it has been logged", TITLE_BAR, 0);
                    _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.gui.SybillaManual", "listSelectionChanged", "cannot add pattern for preview???", ex);
                }
            }
            this.drawingArea.repaint();
        }
    }

    private void saveStructure(File selectedFile, boolean bXML) {
        int reply;
        File file;
        String sFileExtension;
        boolean bWarningShown = false;
        ArrayList<Phase> alPhases = new ArrayList<Phase>(20);
        Object[] aoPatterns = this.createdPatternsListModel.toArray();
        Pattern firstPattern = (Pattern)aoPatterns[0];
        int i = 0;
        while (i < aoPatterns.length) {
            StringBuffer sbMisfit;
            Pattern nextPattern = (Pattern)aoPatterns[i];
            if (i > 0 && !bWarningShown && (sbMisfit = firstPattern.isCompatible(nextPattern)).length() > 0) {
                JOptionPane.showMessageDialog(this.frame, "Parameters of patterns that compose fit are different:\n" + sbMisfit.toString(), TITLE_BAR, 2);
                bWarningShown = true;
            }
            Phase[] aPhases = nextPattern.getPhases();
            int j = 0;
            while (j < aPhases.length) {
                alPhases.add(aPhases[j]);
                ++j;
            }
            ++i;
        }
        Phase[] aAllPhases = new Phase[alPhases.size()];
        aAllPhases = alPhases.toArray(aAllPhases);
        PatternParams patternParams = ((Pattern)this.createdPatternsListModel.get(0)).getPatternParams();
        Pattern pattern = new Pattern(patternParams, new Mixture(aAllPhases, patternParams), false);
        String sFileName = selectedFile.getPath();
        String string = sFileExtension = bXML ? XML_FILETYPE[0] : TXT_FILETYPE[0];
        if (!sFileName.toLowerCase().endsWith(sFileExtension)) {
            sFileName = sFileName.concat(String.valueOf('.') + sFileExtension);
        }
        if ((file = new File(sFileName)).exists() && (reply = JOptionPane.showConfirmDialog(this.frame, "File " + sFileName + " already exists,\ndo you to overwrite it?", TITLE_BAR, 0, 3)) == 1) {
            return;
        }
        try {
            pattern.setContentInfo(this.gatherContent());
            if (bXML) {
                pattern.serializeXML(file);
            } else {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                pw.println(pattern.getModel(this._expPattern.getName().replaceAll("\\.[\\w\\$]{2,3}$", "")));
                pw.close();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error occured during writing the file:\n" + e.getMessage(), TITLE_BAR, 0);
            return;
        }
    }

    private void saveAtomicFactor(File file) {
        Element rootElement = new Element("atomic_factors");
        Document inputModelDump = new Document(rootElement);
        rootElement.addContent(Atom.serializeXML());
        XMLOutputter outputter = new XMLOutputter("  ", true);
        try {
            FileWriter writer = new FileWriter(file);
            outputter.output(inputModelDump, (Writer)writer);
            writer.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void readAtomicFactor(File file) {
        SAXBuilder builder = new SAXBuilder();
        Document xmlDocument = null;
        try {
            xmlDocument = builder.build(file);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        Element inputModel = xmlDocument.getRootElement();
        try {
            Atom.deserializeXML(inputModel);
        }
        catch (IllegalArgumentException iae) {
            this.frame.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this.frame, iae.getMessage(), TITLE_BAR, 0);
            return;
        }
        JOptionPane.showMessageDialog(this.frame, "New atomic factors read. The following phases will have changed factors.", "Atomic factors read", 1);
    }

    private void setupSaveDialog() {
        this.saveDialog.setCurrentDirectory(this.chooser.getCurrentDirectory());
        if (this._expPattern != null) {
            String sName = this._expPattern.getName();
            int iDotPos = sName.lastIndexOf(46);
            if (iDotPos > 0) {
                sName = sName.substring(0, iDotPos);
            }
            this.saveDialog.setSelectedFile(new File(sName));
        }
    }

    private void clearResults() {
        int reply = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to clear all results?", "clear results", 0, 3);
        if (reply == 0) {
            this.createdPatternsListModel.clear();
            this._choosePhasesDialog.reset();
            this._choosePhasesDialog.setDiffrParamsEnabled(true);
            File toBeDeleted = new File(SERIALIZED_RESULTS_FILE_NAME);
            if (toBeDeleted.exists()) {
                try {
                    toBeDeleted.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (this._previewedPattern != null) {
                this.drawingArea.removeDiffractogram(this._previewedPattern, false);
            }
            if (this._composedPattern != null) {
                Arrays.fill(this._composedPattern.getIntensities(), 0.0);
                this._composedPattern.setMaxIntensity(0.0);
            }
            if (this.programState == 8) {
                this.setItemsEnabled(0);
            } else if (this.programState == 9) {
                this.setItemsEnabled(3);
            } else {
                this.setItemsEnabled(0);
            }
            this.drawingArea.repaint();
        }
    }

    public void clearPhases() {
        this.createdPatternsListModel.clear();
    }

    private void convertPhases(int iTargetState) {
        if (this.createdPatternsListModel.size() == 0) {
            JOptionPane.showMessageDialog(this.frame, "There aren't phases that could be converted", "no phases", 0);
            return;
        }
        Phase[] aPhases = this.gatherPhases();
        boolean bISIdentified = false;
        int i = 0;
        while (i < aPhases.length) {
            if (aPhases[i] instanceof MixedLayerPhase) {
                MixedLayerPhase phase = (MixedLayerPhase)aPhases[i];
                if (!(bISIdentified || phase.getPhaseType() != 0 && phase.getPhaseType() != 1 && phase.getPhaseType() != 2)) {
                    bISIdentified = true;
                    phase.convertSmectite(iTargetState);
                } else {
                    try {
                        phase.convertSmectite(iTargetState);
                    }
                    catch (IllegalArgumentException iae) {
                        JOptionPane.showMessageDialog(this.frame, iae.getMessage(), "conversion error", 0);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.createdPatternsListModel.size()) {
            Pattern pattern = (Pattern)this.createdPatternsListModel.get(i);
            boolean bProbabOK = pattern.calcProbabilities();
            assert (bProbabOK) : "newly created matrix failed";
            pattern.calcIntensities();
            pattern.rebuildDescription();
            ++i;
        }
        this.createdPatternsListModel.fireContentsChanged(this, 0, this.createdPatternsListModel.size() - 1);
        this.fitAllPatterns();
        JOptionPane.showMessageDialog(this.frame, "Phases have been converted", "conversion ok", 1);
    }

    @Override
    public void setItemsEnabled(int state) {
        this.programState = state;
        switch (state) {
            case 0: {
                this.createdPatternsList.setEnabled(true);
                this.drawingArea.setZoomable(false);
                this.drawingArea.setAreaSelectable(false);
                this.drawingArea.setInterestedInMouseMotion(false);
                this.drawingArea.setInterestedInPopup(false);
                this.drawingArea.setRangesDisplayable(false);
                this.drawingArea.setObjectSelectable(false);
                this.recentFiles.setEnabled(true);
                this.loadPatternItem.setEnabled(true);
                this.closeItem.setEnabled(false);
                this.savePatternItem.setEnabled(false);
                this.fileMenu.setEnabled(true);
                this.removeBcgItem.setEnabled(false);
                this.choosePhasesItem.setEnabled(true);
                this.saveSummaryItem.setEnabled(false);
                this.loadFitItem.setEnabled(true);
                this.saveFitItem.setEnabled(false);
                this.saveEverythingItem.setEnabled(false);
                this.verifyItem.setEnabled(false);
                this.convertToAirItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.convertToGlyItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.clearResultsButton.setEnabled(true);
                this.createFromInputItem.setEnabled(true);
                this.removeSelectedItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.adjustItem.setEnabled(false);
                this.showContentItem.setEnabled(false);
                this.saveCreatedPatternItem.setEnabled(false);
                this.unzoomItem.setEnabled(false);
                this._captureImageItem.setEnabled(false);
                this.uploadItem.setEnabled(false);
                this.downloadItem.setEnabled(true);
                break;
            }
            case 3: {
                this.createdPatternsList.setEnabled(true);
                this.drawingArea.setZoomable(true);
                this.drawingArea.setAreaSelectable(true);
                this.drawingArea.setInterestedInMouseMotion(true);
                this.drawingArea.setInterestedInPopup(true);
                this.drawingArea.setRangesDisplayable(true);
                this.drawingArea.setObjectSelectable(false);
                this.recentFiles.setEnabled(false);
                this.loadPatternItem.setEnabled(false);
                this.closeItem.setEnabled(true);
                this.savePatternItem.setEnabled(true);
                this.fileMenu.setEnabled(true);
                this.removeBcgItem.setEnabled(true);
                this.choosePhasesItem.setEnabled(true);
                this.saveXmlStructureItem.setEnabled(false);
                this.saveSummaryItem.setEnabled(false);
                this.loadFitItem.setEnabled(false);
                this.saveFitItem.setEnabled(false);
                this.saveEverythingItem.setEnabled(false);
                this.verifyItem.setEnabled(false);
                this.convertToAirItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.convertToGlyItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.clearResultsButton.setEnabled(false);
                this.createFromInputItem.setEnabled(true);
                this.removeSelectedItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.adjustItem.setEnabled(false);
                this.showContentItem.setEnabled(false);
                this.saveCreatedPatternItem.setEnabled(false);
                this.unzoomItem.setEnabled(true);
                this._captureImageItem.setEnabled(true);
                this.uploadItem.setEnabled(false);
                this.downloadItem.setEnabled(false);
                break;
            }
            case 9: {
                this.createdPatternsList.setEnabled(true);
                this.drawingArea.setZoomable(true);
                this.drawingArea.setAreaSelectable(true);
                this.drawingArea.setInterestedInMouseMotion(true);
                this.drawingArea.setInterestedInPopup(true);
                this.drawingArea.setRangesDisplayable(true);
                this.drawingArea.setObjectSelectable(true);
                this.recentFiles.setEnabled(false);
                this.loadPatternItem.setEnabled(false);
                this.closeItem.setEnabled(true);
                this.savePatternItem.setEnabled(this._expPattern != null);
                this.fileMenu.setEnabled(true);
                this.removeBcgItem.setEnabled(true);
                this.choosePhasesItem.setEnabled(true);
                this.saveXmlStructureItem.setEnabled(true);
                this.saveSummaryItem.setEnabled(true);
                this.loadFitItem.setEnabled(false);
                this.saveFitItem.setEnabled(true);
                this.saveEverythingItem.setEnabled(true);
                this.verifyItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.convertToAirItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.convertToGlyItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.clearResultsButton.setEnabled(true);
                this.createFromInputItem.setEnabled(true);
                this.removeSelectedItem.setEnabled(true);
                this.adjustItem.setEnabled(true);
                this.showContentItem.setEnabled(true);
                this.saveCreatedPatternItem.setEnabled(true);
                this.unzoomItem.setEnabled(true);
                this._captureImageItem.setEnabled(true);
                this.uploadItem.setEnabled(this._expPattern != null);
                this.downloadItem.setEnabled(false);
                break;
            }
            case 8: {
                this.createdPatternsList.setEnabled(true);
                this.drawingArea.setZoomable(true);
                this.drawingArea.setAreaSelectable(true);
                this.drawingArea.setInterestedInMouseMotion(true);
                this.drawingArea.setInterestedInPopup(true);
                this.drawingArea.setRangesDisplayable(true);
                this.drawingArea.setObjectSelectable(true);
                this.recentFiles.setEnabled(true);
                this.loadPatternItem.setEnabled(true);
                this.closeItem.setEnabled(false);
                this.savePatternItem.setEnabled(false);
                this.fileMenu.setEnabled(true);
                this.removeBcgItem.setEnabled(false);
                this.choosePhasesItem.setEnabled(true);
                this.saveXmlStructureItem.setEnabled(false);
                this.saveSummaryItem.setEnabled(false);
                this.loadFitItem.setEnabled(false);
                this.saveFitItem.setEnabled(false);
                this.saveEverythingItem.setEnabled(false);
                this.verifyItem.setEnabled(false);
                this.convertToAirItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.convertToGlyItem.setEnabled(this.createdPatternsListModel.size() > 0);
                this.clearResultsButton.setEnabled(true);
                this.createFromInputItem.setEnabled(true);
                this.removeSelectedItem.setEnabled(true);
                this.adjustItem.setEnabled(false);
                this.showContentItem.setEnabled(false);
                this.saveCreatedPatternItem.setEnabled(true);
                this.unzoomItem.setEnabled(true);
                this._captureImageItem.setEnabled(true);
                this.uploadItem.setEnabled(false);
                this.downloadItem.setEnabled(false);
                break;
            }
            case 6: {
                this.createdPatternsList.setEnabled(false);
                this.drawingArea.setZoomable(true);
                this.drawingArea.setAreaSelectable(false);
                this.drawingArea.setInterestedInMouseMotion(true);
                this.drawingArea.setInterestedInPopup(false);
                this.drawingArea.setRangesDisplayable(true);
                this.drawingArea.setObjectSelectable(false);
                this.recentFiles.setEnabled(false);
                this.loadPatternItem.setEnabled(false);
                this.closeItem.setEnabled(false);
                this.savePatternItem.setEnabled(false);
                this.fileMenu.setEnabled(true);
                this.removeBcgItem.setEnabled(false);
                this.choosePhasesItem.setEnabled(false);
                this.saveXmlStructureItem.setEnabled(false);
                this.saveSummaryItem.setEnabled(false);
                this.loadFitItem.setEnabled(false);
                this.saveFitItem.setEnabled(false);
                this.saveEverythingItem.setEnabled(false);
                this.verifyItem.setEnabled(false);
                this.convertToAirItem.setEnabled(false);
                this.convertToGlyItem.setEnabled(false);
                this.clearResultsButton.setEnabled(false);
                this.createFromInputItem.setEnabled(false);
                this.removeSelectedItem.setEnabled(false);
                this.adjustItem.setEnabled(false);
                this.showContentItem.setEnabled(false);
                this.saveCreatedPatternItem.setEnabled(false);
                this.unzoomItem.setEnabled(true);
                this._captureImageItem.setEnabled(false);
                this.uploadItem.setEnabled(false);
                this.downloadItem.setEnabled(false);
                break;
            }
            default: {
                assert (false) : "No other cases supported at the moment...";
                break;
            }
        }
    }

    private void createFromInputFile(File source) {
        this.frame.setCursor(waitCursor);
        Pattern pattern = null;
        try {
            pattern = Pattern.deserializeXML(source);
        }
        catch (JDOMException jde) {
            this.frame.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this.frame, jde.getMessage(), TITLE_BAR, 0);
            return;
        }
        catch (IllegalArgumentException iae) {
            this.frame.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this.frame, iae.getMessage(), TITLE_BAR, 0);
            return;
        }
        if (!pattern.calcProbabilities()) {
            this.frame.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this.frame, "There is an error in probability matrices.", TITLE_BAR, 0);
            return;
        }
        pattern.getFinalDiffr().setColor(phaseColor);
        ((UserDiffractogram)pattern.getFinalDiffr()).setName(source.getName());
        Thread calcThread = new Thread(new CalcPatternThread(pattern, this));
        calcThread.setPriority(1);
        calcThread.start();
        String sFileName = source.getPath();
        int iExtPos = sFileName.toLowerCase().indexOf(XML_FILETYPE[0]);
        if (iExtPos >= 0) {
            sFileName = sFileName.substring(0, iExtPos - 1);
        }
        this.saveDialog.setSelectedFile(new File(sFileName));
    }

    private SybillaDiffractogram[] gatherPatterns() {
        SybillaDiffractogram[] aPatterns = new SybillaDiffractogram[this.createdPatternsListModel.size()];
        int i = 0;
        while (i < this.createdPatternsListModel.size()) {
            aPatterns[i] = (SybillaDiffractogram)((Pattern)this.createdPatternsListModel.get(i)).getFinalDiffr();
            ++i;
        }
        return aPatterns;
    }

    private void createdFromInputFile(ActionEvent event) {
        Pattern firstPattern;
        StringBuffer sbMisMatch;
        Pattern pattern = ((CalcPatternThread)event.getSource()).getPattern();
        if (this.createdPatternsListModel.size() > 0 && (sbMisMatch = pattern.isCompatible(firstPattern = (Pattern)this.createdPatternsListModel.firstElement())).length() > 0) {
            JOptionPane.showMessageDialog(this.frame, "Parameters of the pattern that is being added\ndo not fit other patterns:\n" + sbMisMatch.toString(), TITLE_BAR, 2);
        }
        this.createdPatternsListModel.addElement(pattern);
        if (this._fitter != null) {
            AbstractXRDData[] aPatterns = this.gatherPatterns();
            double[] adWeights = this._fitter.fit(aPatterns);
            int i = 0;
            while (i < aPatterns.length) {
                if (pattern.getFinalDiffr() == aPatterns[i]) {
                    aPatterns[i].setScale(adWeights[i]);
                }
                ++i;
            }
        }
        this.frame.setCursor(defaultCursor);
        this.fitAllPatterns();
        _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.SybillaManual", "createFromInputFile", "*** structure created from XML input file ***" + System.getProperty("line.separator") + pattern.getModel(this._expPattern != null ? this._expPattern.getName() : ""));
        if (this.programState == 0) {
            this.setItemsEnabled(8);
            this.createdPatternsList.setSelectedIndex(0);
        } else if (this.programState != 8) {
            this.setItemsEnabled(9);
        }
    }

    private void fitAllPatterns() {
        if (this._fitter == null) {
            this.drawingArea.repaint();
            return;
        }
        AbstractXRDData[] aPatterns = this.gatherPatterns();
        if (aPatterns.length == 0) {
            this.drawingArea.repaint();
            return;
        }
        double[] dWeights = this._fitter.fit(aPatterns);
        this._fitter.mix((SybillaDiffractogram[])aPatterns, dWeights, this._composedPattern);
        this.fitLabel.setText("misfit: " + this.twoDigitNumberFormatter.format(this._fitter.getMisfit()) + "%");
        this.drawingArea.repaint();
        if (this._showContent.isVisible()) {
            this._showContent.updateContent(dWeights);
        }
    }

    public void setMisfit(double dValue) {
        if (Double.isNaN(dValue)) {
            this.fitLabel.setText("misfit: ");
        } else {
            this.fitLabel.setText("misfit: " + this.twoDigitNumberFormatter.format(dValue) + "%");
        }
    }

    private void saveExpPattern() {
        int reply;
        File file;
        this.saveDialog.setFileFilter(this.saveFilter);
        int returnVal = this.saveDialog.showSaveDialog(this.frame);
        if (returnVal != 0) {
            return;
        }
        File fileToExport = this.saveDialog.getSelectedFile();
        String fileName = fileToExport.getPath();
        if (!fileName.toLowerCase().endsWith(SAVE_FILETYPES[0])) {
            fileName = fileName.concat(String.valueOf('.') + SAVE_FILETYPES[0]);
        }
        if ((file = new File(fileName)).exists() && (reply = JOptionPane.showConfirmDialog(this.frame, "File " + fileName + " already exists,\ndo you to overwrite it?", TITLE_BAR, 0, 3)) == 1) {
            return;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
            this._expPattern.save(bw, false, false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error occured during writing the file:\n" + e.getMessage(), TITLE_BAR, 0);
            return;
        }
    }

    private void saveCreatedPattern(File selectedFile) {
        int reply;
        File file;
        UserDiffractogram patternToSave = this._composedPattern;
        if (patternToSave == null) {
            JOptionPane.showMessageDialog(this.frame, "I have no idea which pattern you want to save.", TITLE_BAR, 0);
            return;
        }
        String sFileName = selectedFile.getPath();
        if (!sFileName.toLowerCase().endsWith(CSV_FILETYPE[0])) {
            sFileName = sFileName.concat(String.valueOf('.') + CSV_FILETYPE[0]);
        }
        if ((file = new File(sFileName)).exists() && (reply = JOptionPane.showConfirmDialog(this.frame, "File " + sFileName + " already exists,\ndo you to overwrite it?", TITLE_BAR, 0, 3)) == 1) {
            return;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(sFileName)));
            if (this._expPattern != null) {
                Object[] aoPatterns = this.createdPatternsListModel.toArray();
                Pattern[] aPatterns = new Pattern[aoPatterns.length];
                SybillaDiffractogram[] aDiffr = new SybillaDiffractogram[aPatterns.length];
                int i = 0;
                while (i < aPatterns.length) {
                    aPatterns[i] = (Pattern)aoPatterns[i];
                    aDiffr[i] = (SybillaDiffractogram)aPatterns[i].getFinalDiffr();
                    ++i;
                }
                pw.print("two theta, experimental, fit");
                i = 0;
                while (i < aPatterns.length) {
                    pw.print(", " + aPatterns[i].toString());
                    ++i;
                }
                pw.println();
                i = 0;
                while (i < patternToSave.getNoOfSteps()) {
                    double dTwoTheta = patternToSave.getMin2theta() + (double)i * patternToSave.getStepSize();
                    pw.print(String.valueOf(this.twoDigitNumberFormatter.format(dTwoTheta)) + ", " + this.saveNumberFormatter.format(this._expPattern.getIntensity(i)) + ", " + this.saveNumberFormatter.format(patternToSave.getIntensity(i)));
                    int j = 0;
                    while (j < aPatterns.length) {
                        pw.print(", " + this.saveNumberFormatter.format(aDiffr[j].getIntensity(i) * aDiffr[j].getScale()));
                        ++j;
                    }
                    pw.println();
                    ++i;
                }
            } else {
                pw.println("two theta, calculated");
                int i = 0;
                while (i < patternToSave.getNoOfSteps()) {
                    double dTwoTheta = patternToSave.getMin2theta() + (double)i * patternToSave.getStepSize();
                    pw.println(String.valueOf(this.twoDigitNumberFormatter.format(dTwoTheta)) + ", " + this.saveNumberFormatter.format(patternToSave.getIntensity(i)));
                    ++i;
                }
            }
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error occured during writing the file:\n" + e.getMessage(), TITLE_BAR, 0);
            return;
        }
    }

    public void phasesSelected(Phase[] aPhases, PatternParams patternParams) {
        boolean bWarningShown = false;
        boolean bPhasesPresent = this.createdPatternsListModel.size() > 0;
        HashSet<AbstractDiffractogram> hsNewDiffractograms = new HashSet<AbstractDiffractogram>();
        if (aPhases.length > 0 && (this.programState == 0 || this.programState == 3 || this.programState == 9 || this.programState == 8)) {
            this.frame.setCursor(waitCursor);
            int i = 0;
            while (i < aPhases.length) {
                Pattern refPattern;
                StringBuffer sbMisfit;
                Phase[] nextPhase = new Phase[]{aPhases[i]};
                Pattern pattern = new Pattern(patternParams, new Mixture(nextPhase, patternParams), !aPhases[i].isSigmaStarGenePresent());
                if (bPhasesPresent && !bWarningShown && (sbMisfit = (refPattern = (Pattern)this.createdPatternsListModel.firstElement()).isCompatible(pattern)).length() > 0) {
                    JOptionPane.showMessageDialog(this.frame, "Parameters of at least one pattern that is being added\ndo not fit other patterns:\n" + sbMisfit.toString(), TITLE_BAR, 2);
                    bWarningShown = true;
                }
                pattern.getFinalDiffr().setColor(phaseColor);
                ((UserDiffractogram)pattern.getFinalDiffr()).setName(aPhases[i].getDescription());
                boolean bProbabOK = pattern.calcProbabilities();
                assert (bProbabOK) : "Probabilities failed for " + aPhases[i].getDescription();
                pattern.calcIntensities();
                this.createdPatternsListModel.addElement(pattern);
                hsNewDiffractograms.add(pattern.getFinalDiffr());
                ++i;
            }
            if (this._expPattern == null && this.createdPatternsList.getSelectedIndex() < 0) {
                this.createdPatternsList.setSelectedIndex(0);
            }
            if (this._fitter != null) {
                AbstractXRDData[] aPatterns = this.gatherPatterns();
                double[] adWeights = this._fitter.fit(aPatterns);
                int i2 = 0;
                while (i2 < aPatterns.length) {
                    if (hsNewDiffractograms.contains(aPatterns[i2])) {
                        aPatterns[i2].setScale(adWeights[i2]);
                    }
                    ++i2;
                }
            }
            this._choosePhasesDialog.reset();
            if (!bPhasesPresent) {
                this._choosePhasesDialog.setDiffrParams(patternParams.getDiffractometer());
            }
            this._choosePhasesDialog.setDiffrParamsEnabled(false);
            this.frame.setCursor(defaultCursor);
            this.fitAllPatterns();
            this.setItemsEnabled(this._expPattern != null ? 9 : 8);
        }
    }

    @Override
    public void patternModified() {
        this.fitAllPatterns();
    }

    private void adjustPatterns() {
        this.createdPatternsList.clearSelection();
        this._adjustDialog.showUp(9, this.gatherPatterns(), this._composedPattern);
        this.setItemsEnabled(6);
    }

    private void showContent() {
        Object[] aPattern = new Object[this.createdPatternsListModel.size()];
        this.createdPatternsListModel.copyInto(aPattern);
        assert (this.programState == 9) : "illegal state";
        this._showContent.showUp(-1, this._fitter.fit(this.gatherPatterns()), aPattern);
    }

    private Pattern.Content[] gatherContent() {
        Object[] aPattern = new Object[this.createdPatternsListModel.size()];
        this.createdPatternsListModel.copyInto(aPattern);
        Pattern.Content[] aContent = null;
        assert (this.programState == 9) : "illegal state";
        aContent = this._showContent.gatherContent(this._fitter.fit(this.gatherPatterns()), aPattern);
        return aContent;
    }

    public void removeSelectedPattern() {
        int iIndex = this.createdPatternsList.getSelectedIndex();
        if (iIndex > -1) {
            AbstractDiffractogram diffr = ((Pattern)this.createdPatternsListModel.remove(iIndex)).getFinalDiffr();
            this.drawingArea.removeDiffractogram(diffr, false);
            this.fitAllPatterns();
            if (this.createdPatternsListModel.size() == 0) {
                if (this._expPattern != null) {
                    this.setItemsEnabled(3);
                } else {
                    this.setItemsEnabled(0);
                }
            }
        }
    }

    @Override
    public void backgroundRemoved() {
        if (this.programState == 3) {
            this._fitter = new SybillaLeastSquares(this._expPattern, this.drawingArea.getAllRanges());
            this.fitAllPatterns();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Task createTask(boolean bScripted, boolean bSigmaStarGlobal, int iStartR, int iEndR) {
        if (this.createdPatternsListModel.size() == 0) {
            JOptionPane.showMessageDialog(this.frame, "No phases has been selected", "missing phases", 0);
            return null;
        }
        if (this._expPattern == null) {
            JOptionPane.showMessageDialog(this.frame, "Missing experimental pattern", "missing exp pattern", 0);
            return null;
        }
        if (iEndR < iStartR) {
            JOptionPane.showMessageDialog(this.frame, "Script Reichweite limits are incorrect", "wrong script params", 0);
            return null;
        }
        Task task = null;
        try {
            if (bScripted) {
                ScriptParams scriptParams = new ScriptParams(iStartR, iEndR);
                PatternParams patternParams = this._choosePhasesDialog.getPatternParams(this._expPattern.getMin2theta(), this._expPattern.getMax2theta(), this._expPattern.getStepSize(), 1.54178);
                if (patternParams == null) {
                    return null;
                }
                Phase[] aPhases = this.gatherPhases();
                int iRefISIndex = -1;
                int i = 0;
                while (i < aPhases.length) {
                    if (aPhases[i].getPhaseType() == 0 || aPhases[i].getPhaseType() == 1) {
                        iRefISIndex = i;
                        break;
                    }
                    ++i;
                }
                if (iRefISIndex < 0) {
                    JOptionPane.showMessageDialog(this.frame, "Haven't found any two or three comp I/S...", TITLE_BAR, 0);
                    return null;
                }
                int iISR = ((MixedLayerPhase)aPhases[iRefISIndex]).getAbstractProbabMatrix().getR();
                if (iISR != iStartR) {
                    JOptionPane.showMessageDialog(this.frame, "Selected 'start R' does not correspond to\nReichweite of the I/S phase", "create task", 0);
                    return null;
                }
                GeneConnector globalSigmaStar = null;
                if (bSigmaStarGlobal) {
                    globalSigmaStar = aPhases[iRefISIndex].getSigmaStarConn();
                }
                Phase[] aPhasesDuplicate = this.duplicatePhases(aPhases, bSigmaStarGlobal);
                Phase[] aStablePhases = null;
                int iStableIndex = 0;
                if (aPhasesDuplicate.length > 1) {
                    aStablePhases = new Phase[aPhasesDuplicate.length - 1];
                    int i2 = 0;
                    while (i2 < aPhasesDuplicate.length) {
                        if (i2 != iRefISIndex) {
                            aStablePhases[iStableIndex++] = aPhasesDuplicate[i2];
                        }
                        ++i2;
                    }
                }
                task = new Task((MixedLayerPhase)aPhasesDuplicate[iRefISIndex], this._expPattern, patternParams.getDiffractometer(), aStablePhases, globalSigmaStar, new ArrayList(this.drawingArea.getAllRanges()), scriptParams, 1);
            } else {
                PatternParams patternParams = this._choosePhasesDialog.getPatternParams(this._expPattern.getMin2theta(), this._expPattern.getMax2theta(), this._expPattern.getStepSize(), 1.54178);
                if (patternParams == null) {
                    return null;
                }
                GeneConnector globalSigmaStar = null;
                Phase[] aPhases = this.gatherPhases();
                if (bSigmaStarGlobal) {
                    int iRefISIndex = 0;
                    int i = 0;
                    while (i < aPhases.length) {
                        if (aPhases[i].getPhaseType() == 0 || aPhases[i].getPhaseType() == 1) {
                            iRefISIndex = i;
                            break;
                        }
                        ++i;
                    }
                    globalSigmaStar = aPhases[iRefISIndex].getSigmaStarConn();
                }
                Phase[] aPhasesDuplicate = this.duplicatePhases(aPhases, bSigmaStarGlobal);
                task = new Task(null, this._expPattern, patternParams.getDiffractometer(), aPhasesDuplicate, globalSigmaStar, new ArrayList(this.drawingArea.getAllRanges()), null, 2);
            }
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(this.frame, iae.getMessage(), TITLE_BAR, 0);
            return null;
        }
        return task;
    }

    private Phase[] gatherPhases() {
        ArrayList<Phase> alPhases = new ArrayList<Phase>(20);
        Object[] aoPatterns = this.createdPatternsListModel.toArray();
        int i = 0;
        while (i < aoPatterns.length) {
            Pattern nextPattern = (Pattern)aoPatterns[i];
            Phase[] aPhases = nextPattern.getPhases();
            int j = 0;
            while (j < aPhases.length) {
                alPhases.add(aPhases[j]);
                ++j;
            }
            ++i;
        }
        Phase[] aAllPhases = new Phase[alPhases.size()];
        aAllPhases = alPhases.toArray(aAllPhases);
        return aAllPhases;
    }

    private Phase[] duplicatePhases(Phase[] aPhases, boolean bSigmaStarGlobal) {
        Phase[] aPhasesDuplicate = Phase.duplicatePhases(aPhases);
        if (bSigmaStarGlobal) {
            int i = 0;
            while (i < aPhasesDuplicate.length) {
                aPhasesDuplicate[i].removeSigmaStarGene();
                ++i;
            }
        } else {
            int i = 0;
            while (i < aPhasesDuplicate.length) {
                if (!aPhasesDuplicate[i].isSigmaStarGenePresent()) {
                    aPhasesDuplicate[i].establishSigmaStarGene(null);
                }
                ++i;
            }
        }
        return aPhasesDuplicate;
    }

    public UploadDialog getUploadDialog() {
        return this._uploadDialog;
    }

    @Override
    public ProbabilityDialog getProbabilityDialog() {
        return this._probabDialog;
    }

    @Override
    public JFileChooser getXMLSaveDialog() {
        this.saveDialog.setFileFilter(this.xmlFilter);
        return this.saveDialog;
    }

    private void serializePatterns() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(SERIALIZED_RESULTS_FILE_NAME);
                oos = new ObjectOutputStream(fos);
                oos.writeInt(this.createdPatternsListModel.getSize());
                Enumeration results = this.createdPatternsListModel.elements();
                while (results.hasMoreElements()) {
                    oos.writeObject((Pattern)results.nextElement());
                }
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Cannot save results", TITLE_BAR, 0);
        }
    }

    private void saveFit(File selectedFile) {
        int reply;
        File file;
        File fileToExport = this.saveDialog.getSelectedFile();
        String sFileName = fileToExport.getPath();
        if (!sFileName.toLowerCase().endsWith(SER_FILETYPE[0])) {
            sFileName = sFileName.concat(String.valueOf('.') + SER_FILETYPE[0]);
        }
        if ((file = new File(sFileName)).exists() && (reply = JOptionPane.showConfirmDialog(this.frame, "File " + sFileName + " already exists,\ndo you to overwrite it?", "file exists", 0, 3)) == 1) {
            return;
        }
        this.frame.setCursor(waitCursor);
        ObjectOutputStream oos = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                oos = new ObjectOutputStream(fos);
                oos.writeInt(this.programState);
                oos.writeObject(this._expPattern);
                oos.writeObject(this.drawingArea.getAllRanges());
                oos.writeObject(this.createdPatternsListModel.toArray());
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            this.frame.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this.frame, "Cannot save task\n" + e.getMessage(), "save error", 0);
        }
        this.frame.setCursor(defaultCursor);
    }

    private void saveEverything(File selectedFile) {
        this.saveFit(selectedFile);
        this.saveStructure(selectedFile, true);
        this.saveStructure(selectedFile, false);
        this.saveCreatedPattern(selectedFile);
        JOptionPane.showMessageDialog(this.frame, "Files has been saved", "save all", 1);
    }

    private void verifyModel() {
        Object[] aPattern = new Object[this.createdPatternsListModel.size()];
        this.createdPatternsListModel.copyInto(aPattern);
        Pattern.Content[] aContent = this._showContent.gatherContent(this._fitter.fit(this.gatherPatterns()), aPattern);
        Verificator verificator = new Verificator(aContent, aPattern);
        if (verificator.getErrorMessage() != null) {
            JOptionPane.showMessageDialog(this.frame, verificator.getErrorMessage(), TITLE_BAR, 0);
        } else {
            this._verificationDialog.showUp(this.programState, verificator);
            this.setItemsEnabled(6);
        }
    }

    private void deserializePatterns() {
        File file = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            file = new File(SERIALIZED_RESULTS_FILE_NAME);
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            int iResultsCount = ois.readInt();
            int i = 0;
            while (i < iResultsCount) {
                Pattern pattern = (Pattern)ois.readObject();
                this.createdPatternsListModel.addElement(pattern);
                if (i == 0) {
                    this._choosePhasesDialog.setDiffrParams(pattern.getPatternParams().getDiffractometer());
                    this._choosePhasesDialog.setDiffrParamsEnabled(false);
                }
                ++i;
            }
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException iResultsCount) {
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.frame, "Cannot read previous results", TITLE_BAR, 0);
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.gui.SybillaManual", "deserializePatterns", "IOException in deserializePatterns", ioe);
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog(this.frame, "Cannot read previous results", TITLE_BAR, 0);
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.gui.SybillaManual", "deserializePatterns", "ClassNotFoundException in deserializePatterns", cnfe);
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (ClassCastException cce) {
            JOptionPane.showMessageDialog(this.frame, "Cannot read previous results", TITLE_BAR, 0);
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.gui.SybillaManual", "deserializePatterns", "ClassCastException in deserializePatterns", cce);
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.resetAdjustements();
        this.setItemsEnabled(this.createdPatternsListModel.size() == 0 ? 0 : 8);
    }

    private void loadFit() {
        this.chooser.setFileFilter(this.serFilter);
        int returnVal = this.chooser.showOpenDialog(this.frame);
        if (returnVal != 0) {
            return;
        }
        final int iOriginalState = this.programState;
        SwingWorker worker = new SwingWorker(){
            Object[] aoPhases = null;
            AbstractDiffractogram expPattern = null;
            ArrayList alExcludedRanges = null;
            int iProgState = -1;
            boolean bSuccess = false;

            @Override
            public Object construct() {
                SybillaManual.this.setItemsEnabled(6);
                ObjectInputStream ois = null;
                try {
                    FileInputStream fis = new FileInputStream(SybillaManual.this.chooser.getSelectedFile());
                    ois = new ObjectInputStream(fis);
                    this.iProgState = ois.readInt();
                    this.expPattern = (AbstractDiffractogram)ois.readObject();
                    this.alExcludedRanges = (ArrayList)ois.readObject();
                    this.aoPhases = (Object[])ois.readObject();
                    this.bSuccess = true;
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(SybillaManual.this.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
                }
                catch (ClassCastException cce) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(SybillaManual.this.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
                }
                catch (InvalidClassException ice) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(SybillaManual.this.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
                }
                catch (IOException ioe) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(SybillaManual.this.frame, "Following error occurred when reading the file:\n" + ioe.getMessage(), "read error", 0);
                }
                return null;
            }

            @Override
            public void finished() {
                if (!this.bSuccess) {
                    SybillaManual.this.setItemsEnabled(iOriginalState);
                    return;
                }
                SybillaManual.this.createdPatternsListModel.clear();
                int i = 0;
                while (i < this.aoPhases.length) {
                    SybillaManual.this.createdPatternsListModel.addElement(this.aoPhases[i]);
                    ++i;
                }
                SybillaManual.this._choosePhasesDialog.reset();
                SybillaManual.this._choosePhasesDialog.setDiffrParams(((Pattern)this.aoPhases[0]).getPatternParams().getDiffractometer());
                SybillaManual.this._choosePhasesDialog.setDiffrParamsEnabled(false);
                SybillaManual.this._expPattern = this.expPattern;
                SybillaManual.this._composedPattern = new UserDiffractogram(SybillaManual.this._expPattern);
                SybillaManual.this._composedPattern.setColor(Color.red);
                try {
                    SybillaManual.this.drawingArea.addDiffractogram(SybillaManual.this._expPattern, true);
                    SybillaManual.this.drawingArea.addDiffractogram(SybillaManual.this._composedPattern, true);
                    SybillaManual.this.drawingArea.setExpPatternName(SybillaManual.this._expPattern.getName());
                }
                catch (XRDException ex) {
                    JOptionPane.showMessageDialog(SybillaManual.this.frame, "Internal error - cannot display loaded pattern\n" + ex.getMessage(), "internal error", 0);
                }
                SybillaManual.this.drawingArea.setRanges(this.alExcludedRanges);
                SybillaManual.this.frame.setTitle("Sybilla Manual_v2.2.25 - " + SybillaManual.this._expPattern.getName());
                SybillaManual.this._fitter = new SybillaLeastSquares(SybillaManual.this._expPattern, this.alExcludedRanges);
                SybillaManual.this.setItemsEnabled(this.iProgState);
                SybillaManual.this.fitAllPatterns();
            }
        };
        worker.start();
    }

    private void screenshot() {
        int reply;
        File file;
        this.saveDialog.setFileFilter(this.pngFilter);
        int returnVal = this.saveDialog.showSaveDialog(this.frame);
        if (returnVal != 0) {
            return;
        }
        File fileToSave = this.saveDialog.getSelectedFile();
        String fileName = fileToSave.getPath();
        if (!fileName.toLowerCase().endsWith(PNG_FILETYPES[0])) {
            fileName = fileName.concat(String.valueOf('.') + PNG_FILETYPES[0]);
        }
        if ((file = new File(fileName)).exists() && (reply = JOptionPane.showConfirmDialog(this.frame, "File " + fileName + " already exists,\ndo you to overwrite it?", TITLE_BAR, 0, 3)) == 1) {
            return;
        }
        int iMenuState = this.programState;
        this.setItemsEnabled(6);
        BufferedImage screenshot = this.drawingArea.captureImage();
        boolean bSuccess = true;
        try {
            ImageIO.write((RenderedImage)screenshot, "png", file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Cannot save screenshot: " + e.getMessage(), TITLE_BAR, 0);
            bSuccess = false;
        }
        if (!bSuccess) {
            JOptionPane.showMessageDialog(this.frame, "Screenshot wasn't saved", TITLE_BAR, 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Screenshot saved successfully", TITLE_BAR, 1);
        }
        this.setItemsEnabled(iMenuState);
    }

    private void adieu() {
        _prefs.put("chooser.current.dir", this.chooser.getCurrentDirectory().getPath());
        _prefs.put("saveDialog.current.dir", this.saveDialog.getCurrentDirectory().getPath());
        _prefs.put("upload_dialog.host_name", this._uploadDialog.getHostName());
        _prefs.put("download_dialog.host_name", this._downloadDialog.getHostName());
        this.serializeCommonData();
        try {
            _prefs.flush();
        }
        catch (BackingStoreException bse) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.gui.SybillaManual", "adieu", "Error while flushing Preferences", bse);
        }
        this.recentFiles.saveState(_prefs);
        this._choosePhasesDialog.saveState();
        this.serializePatterns();
        this.frame.dispose();
        System.exit(0);
    }

    private void resetAdjustements() {
        SybillaDiffractogram[] aPatterns = this.gatherPatterns();
        int i = 0;
        while (i < aPatterns.length) {
            aPatterns[i].setAdjustementScale(0.0);
            aPatterns[i].setAdjustementOffset(0.0);
            aPatterns[i].setScale(1.0);
            aPatterns[i].setOffset(0.0);
            ++i;
        }
    }

    public void setMenuFontSize(int menuFontSize) {
        menuFont = new Font("sans-serif", 0, menuFontSize);
        this.setMenuFontSize(menuFont);
    }

    public void setPanelFontSize(int panelFontSize) {
        panelFont = new Font("sans-serif", 0, panelFontSize);
        this.setPanelFontSize(panelFont);
    }

    public int getMenuFontSize() {
        return menuFont.getSize();
    }

    public int getPanelFontSize() {
        return panelFont.getSize();
    }

    private void setMenuFontSize(Font _f) {
        this.fileMenu.setFont(_f);
        int i = 0;
        while (i < this.fileMenu.getItemCount()) {
            if (this.fileMenu.getItem(i) != null) {
                this.fileMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this.inputFileMenu.setFont(_f);
        i = 0;
        while (i < this.inputFileMenu.getItemCount()) {
            if (this.inputFileMenu.getItem(i) != null) {
                this.inputFileMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this.toolsFileMenu.setFont(_f);
        i = 0;
        while (i < this.toolsFileMenu.getItemCount()) {
            if (this.toolsFileMenu.getItem(i) != null) {
                this.toolsFileMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this.imageMenu.setFont(_f);
        i = 0;
        while (i < this.imageMenu.getItemCount()) {
            if (this.imageMenu.getItem(i) != null) {
                this.imageMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this.serverMenu.setFont(_f);
        i = 0;
        while (i < this.serverMenu.getItemCount()) {
            if (this.serverMenu.getItem(i) != null) {
                this.serverMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this.aboutMenu.setFont(_f);
        i = 0;
        while (i < this.aboutMenu.getItemCount()) {
            if (this.aboutMenu.getItem(i) != null) {
                this.aboutMenu.getItem(i).setFont(_f);
            }
            ++i;
        }
        this._width1MenuItem.setFont(_f);
        this._width15MenuItem.setFont(_f);
        this._width2MenuItem.setFont(_f);
        this._width25MenuItem.setFont(_f);
        this._width3MenuItem.setFont(_f);
        this._fontSizeModificationFrame.setAllFonts(_f);
        this._removeBcgDialog.setAllFonts(_f);
        this._choosePhasesDialog.setAllFonts(_f);
        this._showContent.setAllFonts(_f);
        this._adjustDialog.setAllFonts(_f);
        this._uploadDialog.setAllFonts(_f);
        this._downloadDialog.setAllFonts(_f);
        this._verificationDialog.setAllFonts(_f);
        this._probabDialog.setAllFonts(_f);
        this._slidersDialog.setAllFonts(_f);
        this._restrictionsDialog.setAllFonts(_f);
        this.setFontSizeAndResizeFileChoosers(_f.getSize());
    }

    private void setPanelFontSize(Font _f) {
        this.calculatedStructuresLabel.setFont(_f);
        this.createdPatternsList.setFont(_f);
        this.clearResultsButton.setFont(_f);
        this.fitLabel.setFont(_f);
        this.twoThetaStaticLbl.setFont(_f);
        this.twoThetaLabel.setFont(_f);
        this.dSpacingStaticLbl.setFont(_f);
        this.dSpacingLabel.setFont(_f);
        this.drawingArea.setPanelFontSize(_f);
    }

    public void setFontSizeAndResizeFileChoosers(int fontSize) {
        Font _f = new Font("sans-serif", 0, fontSize);
        this.setFileChooserFont(this.chooser.getComponents(), _f);
        this.setFileChooserFont(this.saveDialog.getComponents(), _f);
        this.chooser.setPreferredSize(new Dimension(40 * fontSize, 25 * fontSize));
        this.saveDialog.setPreferredSize(new Dimension(40 * fontSize, 25 * fontSize));
        this.chooser.setFont(_f);
        this.saveDialog.setFont(_f);
        UIManager.put("OptionPane.messageFont", new FontUIResource(_f));
        UIManager.put("OptionPane.buttonFont", new FontUIResource(_f));
        UIManager.put("OptionPane.font", new FontUIResource(_f));
    }

    private void setFileChooserFont(Component[] comp, Font _font) {
        int fontSize = _font.getSize();
        int x = 0;
        while (x < comp.length) {
            if (comp[x] instanceof Container) {
                this.setFileChooserFont(((Container)comp[x]).getComponents(), _font);
            }
            try {
                if (comp[x] instanceof Container) {
                    comp[x].setFont(_font);
                }
                if (comp[x] instanceof JList) {
                    comp[x].setFont(_font);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (comp[x] instanceof JButton) {
                Icon icon = ((JButton)comp[x]).getIcon();
                String toolTipText = ((JButton)comp[x]).getToolTipText();
                if (toolTipText != null) {
                    String newToolTip = "<html><p style=\"font-size:" + fontSize + "px\">" + toolTipText + "</p></html>";
                    ((JButton)comp[x]).setToolTipText(newToolTip);
                }
                if (icon != null && icon instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)icon;
                    Image image = imageIcon.getImage();
                    Image rescaledImage = image.getScaledInstance((int)((double)fontSize * 2.1), (int)((double)fontSize * 2.1), 4);
                    ImageIcon imageIcon2 = new ImageIcon(rescaledImage);
                    ((JButton)comp[x]).setIcon(imageIcon2);
                }
            }
            ++x;
        }
    }

    public void serializeCommonData() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(SERIALIZED_FILE_NAME);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(menuFont);
                oos.writeObject(panelFont);
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Cannot save common settings", TITLE_BAR, 0);
        }
    }

    private void deserializeCommonData() {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(SERIALIZED_FILE_NAME);
            ois = new ObjectInputStream(fis);
            menuFont = (Font)ois.readObject();
            panelFont = (Font)ois.readObject();
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    class DeleteListItem
    extends AbstractAction {
        DeleteListItem() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SybillaManual.this.programState != 6) {
                SybillaManual.this.removeSelectedPattern();
            }
        }
    }

    private class DeselectAdapter
    extends MouseAdapter {
        private DeselectAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SybillaManual.this.programState != 6 && SybillaManual.this.programState != 8 && (SybillaManual.this.programState != 9 || SybillaManual.this._expPattern != null)) {
                SybillaManual.this.createdPatternsList.clearSelection();
            }
        }
    }

    class ListItemDoubleClicked
    extends MouseAdapter {
        ListItemDoubleClicked() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Pattern pattern;
            if (e.getClickCount() == 2 && SybillaManual.this.programState != 6 && (pattern = (Pattern)SybillaManual.this.createdPatternsList.getSelectedValue()) != null) {
                SybillaManual.this._slidersDialog.showUp(SybillaManual.this.programState, pattern.getConnectorsTree(), pattern);
                SybillaManual.this.setItemsEnabled(6);
            }
        }
    }

    class PhasesListModel
    extends DefaultListModel {
        PhasesListModel() {
        }

        @Override
        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }
}

