/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.SybillaDiffractogram;
import net.ndmystko.xrd.mod.gui.CommonSybilla;

public class ShowContent
extends JDialog {
    private JPanel _phasesPanel = null;
    private NumberFormat _oneDigitNumberFormatter = null;
    private Object[] _aPattern = null;
    private JLabel[] _aContentLabel = null;
    private CommonSybilla owner;
    private int menuStatus = -1;
    private Font defaultFont = new Font("sans-serif", 0, 12);

    public ShowContent(CommonSybilla owner) {
        super(owner.frame);
        this.owner = owner;
        this.setTitle("content");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowContent.this.okAction();
            }
        });
        this._oneDigitNumberFormatter = NumberFormat.getInstance();
        this._oneDigitNumberFormatter.setMinimumFractionDigits(0);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(1);
        this._phasesPanel = new JPanel(new GridLayout(0, 2, 20, 10));
        this._phasesPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.getContentPane().add((Component)this._phasesPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowContent.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public void showUp(int menuStatus, double[] adWeight, Object[] aPattern) {
        this._phasesPanel.removeAll();
        this._aPattern = aPattern;
        Pattern.Content[] aPhaseContent = this.gatherContent(adWeight, aPattern);
        this._aContentLabel = new JLabel[aPhaseContent.length];
        int i = 0;
        while (i < aPhaseContent.length) {
            JLabel phaseNameLabel = new JLabel(aPhaseContent[i].getPhaseName());
            phaseNameLabel.setFont(this.defaultFont);
            this._phasesPanel.add(phaseNameLabel);
            String sContent = String.valueOf(this._oneDigitNumberFormatter.format(aPhaseContent[i].getPhaseContent())) + '%';
            this._aContentLabel[i] = new JLabel(sContent);
            this._aContentLabel[i].setFont(this.defaultFont);
            this._phasesPanel.add(this._aContentLabel[i]);
            ++i;
        }
        this.menuStatus = menuStatus;
        this.pack();
        this.setVisible(true);
    }

    public void updateContent(double[] adWeight) {
        Pattern.Content[] aPhaseContent = this.gatherContent(adWeight, this._aPattern);
        int i = 0;
        while (i < aPhaseContent.length) {
            String sContent = String.valueOf(this._oneDigitNumberFormatter.format(aPhaseContent[i].getPhaseContent())) + '%';
            this._aContentLabel[i].setText(sContent);
            this._aContentLabel[i].setFont(this.defaultFont);
            ++i;
        }
    }

    public Pattern.Content[] gatherContent(double[] adWeight, Object[] aPattern) {
        Pattern.Content[] aPhaseContent = new Pattern.Content[aPattern.length];
        double dTotalWeight = 0.0;
        int i = 0;
        while (i < adWeight.length) {
            SybillaDiffractogram sd = (SybillaDiffractogram)((Pattern)aPattern[i]).getFinalDiffr();
            dTotalWeight += adWeight[i] + sd.getAdjustementScale();
            ++i;
        }
        i = 0;
        while (i < aPattern.length) {
            Pattern pattern = (Pattern)aPattern[i];
            double dAdjustScale = ((SybillaDiffractogram)pattern.getFinalDiffr()).getAdjustementScale();
            aPhaseContent[i] = new Pattern.Content(pattern.toString(), (adWeight[i] + dAdjustScale) / dTotalWeight * 100.0);
            ++i;
        }
        return aPhaseContent;
    }

    private void okAction() {
        if (this.menuStatus != -1) {
            this.owner.setItemsEnabled(this.menuStatus);
        }
        this.setVisible(false);
    }

    public void setAllFonts(Font _f) {
        this.defaultFont = _f;
        Component[] componentArray = this._phasesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            item.setFont(_f);
            if (item instanceof Container) {
                Component[] componentArray2 = ((Container)item).getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component item2 = componentArray2[n4];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        Component[] componentArray3 = ((Container)item2).getComponents();
                        int n5 = componentArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Component item3 = componentArray3[n6];
                            item3.setFont(_f);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.pack();
        this.repaint();
    }
}

