/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.XRDRangeSelected;
import net.ndmystko.xrd.mod.gui.CommonSybilla;

public class RemoveBackgroundDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -822177452496493772L;
    private JButton removeButton;
    private JButton _undoButton;
    private JButton closeButton;
    private JSlider cSlider;
    private JPanel shiftPanel;
    private JPanel actionPanel;
    private TitledBorder actionNamesPanel;
    private JRadioButton removeFlatRadioButton;
    private JRadioButton _addFlatRadioButton;
    private JRadioButton removeBumpRadioButton;
    private JRadioButton removeExpRadioButton;
    private JButton shiftLeftButton;
    private JButton shiftRightButton;
    private JLabel cLabel;
    private ChangeListener _sliderListener = new SliderListener();
    private MouseAdapter _bumpBcgListener = null;
    private UserDiffractogram _subtractedBackground = null;
    private AbstractDiffractogram _pattern = null;
    private UserDiffractogram _background = null;
    private double _dBcgMinIntensity = 0.0;
    private static final double ZERO_INTENSITY_TRESHOLD = 1.0E-4;
    private int menuStatus = -1;
    private CommonSybilla owner;
    private boolean _bShownOnce = false;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.sybilla");
    private Font defaultFont = new Font("sans-serif", 0, 12);

    public RemoveBackgroundDialog(CommonSybilla owner) {
        super(owner.frame);
        this.owner = owner;
        this.setTitle("remove background");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemoveBackgroundDialog.this.closeAction();
            }
        });
        this.setResizable(false);
        this._bumpBcgListener = new Adapter();
        JPanel slidersPanel = new JPanel();
        slidersPanel.setLayout(new FlowLayout());
        Border etchedBorder = BorderFactory.createEtchedBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        slidersPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, etchedBorder));
        JPanel cSliderPanel = new JPanel();
        cSliderPanel.setLayout(new BoxLayout(cSliderPanel, 1));
        this.cLabel = new JLabel("c param:");
        this.cLabel.setAlignmentX(0.5f);
        cSliderPanel.add(this.cLabel);
        cSliderPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        cSliderPanel.setPreferredSize(new Dimension(80, 650));
        cSliderPanel.setMinimumSize(new Dimension(80, 650));
        this.cSlider = new JSlider(1, 0, 100, 100);
        this.cSlider.setMajorTickSpacing(10);
        this.cSlider.setPaintTicks(true);
        this.cSlider.setAlignmentX(0.5f);
        this.cSlider.addChangeListener(this._sliderListener);
        cSliderPanel.add(this.cSlider);
        slidersPanel.add(cSliderPanel);
        this.getContentPane().add((Component)slidersPanel, "Center");
        JPanel choicePanel = new JPanel();
        choicePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        choicePanel.setLayout(new BoxLayout(choicePanel, 1));
        choicePanel.setAlignmentX(0.0f);
        this.actionPanel = new JPanel(new GridLayout(0, 1));
        this.actionNamesPanel = BorderFactory.createTitledBorder("background type");
        this.actionPanel.setBorder(this.actionNamesPanel);
        this.actionPanel.setAlignmentX(0.0f);
        this.actionPanel.setAlignmentY(0.0f);
        ButtonGroup actionGroup = new ButtonGroup();
        this.removeFlatRadioButton = new JRadioButton("y = c", false);
        this.removeFlatRadioButton.addActionListener(this);
        actionGroup.add(this.removeFlatRadioButton);
        this.actionPanel.add(this.removeFlatRadioButton);
        this._addFlatRadioButton = new JRadioButton("y = c (add)", false);
        this._addFlatRadioButton.addActionListener(this);
        actionGroup.add(this._addFlatRadioButton);
        this.actionPanel.add(this._addFlatRadioButton);
        this.removeBumpRadioButton = new JRadioButton("y = 0.9 exp[-b(x-X)^2+c]", false);
        this.removeBumpRadioButton.addActionListener(this);
        actionGroup.add(this.removeBumpRadioButton);
        this.actionPanel.add(this.removeBumpRadioButton);
        this.removeExpRadioButton = new JRadioButton("y = 0.9 exp[bx+c]", false);
        this.removeExpRadioButton.addActionListener(this);
        actionGroup.add(this.removeExpRadioButton);
        this.actionPanel.add(this.removeExpRadioButton);
        choicePanel.add(this.actionPanel);
        choicePanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this.shiftPanel = new JPanel(new FlowLayout());
        this.shiftPanel.setAlignmentX(0.0f);
        this.shiftLeftButton = new JButton("shift left");
        this.shiftLeftButton.addActionListener(this);
        this.shiftLeftButton.setEnabled(false);
        this.shiftPanel.add(this.shiftLeftButton);
        this.shiftRightButton = new JButton("shift right");
        this.shiftRightButton.addActionListener(this);
        this.shiftRightButton.setEnabled(false);
        this.shiftPanel.add(this.shiftRightButton);
        choicePanel.add(this.shiftPanel);
        choicePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel removePanel = new JPanel(new FlowLayout());
        removePanel.setAlignmentX(0.0f);
        this.removeButton = new JButton("remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        removePanel.add(this.removeButton);
        this._undoButton = new JButton("undo");
        this._undoButton.setEnabled(false);
        this._undoButton.addActionListener(this);
        removePanel.add(this._undoButton);
        choicePanel.add(removePanel);
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        choicePanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)choicePanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public void showUp(int menuStatus, AbstractDiffractogram pattern) {
        this.menuStatus = menuStatus;
        this._pattern = pattern;
        this._background = null;
        this.cSlider.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.cSlider.setValue(100);
        this.pack();
        if (!this._bShownOnce) {
            int x = this.getGraphicsConfiguration().getBounds().width - this.getWidth();
            int y = this.getGraphicsConfiguration().getBounds().height - this.getHeight();
            this.setLocation(x, y);
            this._bShownOnce = true;
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.closeAction();
        } else if (e.getSource() == this.shiftLeftButton) {
            this.shiftPatternBy(-1);
        } else if (e.getSource() == this.shiftRightButton) {
            this.shiftPatternBy(1);
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        } else if (e.getSource() == this._undoButton) {
            this.undoAction();
        } else if (e.getSource().getClass().getName().equals("javax.swing.JRadioButton")) {
            if (e.getSource() == this.removeFlatRadioButton || e.getSource() == this.removeBumpRadioButton || e.getSource() == this.removeExpRadioButton) {
                this.removeButton.setText("remove");
            } else if (e.getSource() == this._addFlatRadioButton) {
                this.removeButton.setText("add");
            }
            this.updatePattern();
        } else {
            System.out.println("Unknown event caught: " + e.toString());
        }
    }

    private void shiftPatternBy(int steps) {
        this._pattern.shift(steps);
        this.owner.drawingArea.repaint();
    }

    private void undoAction() {
        if (this._addFlatRadioButton.isSelected()) {
            this._pattern.subtractPattern(this._subtractedBackground);
        } else {
            this._pattern.addPattern(this._subtractedBackground);
        }
        this._undoButton.setEnabled(false);
        this.updatePattern();
        this._subtractedBackground = null;
    }

    private void removeAction() {
        if (this._addFlatRadioButton.isSelected()) {
            this._pattern.addPattern(this._background);
        } else {
            this._pattern.subtractPattern(this._background);
        }
        this._subtractedBackground = (UserDiffractogram)this._background.clone();
        this._undoButton.setEnabled(true);
        this.updatePattern();
    }

    private void updateRestrBumpBcg() {
        int iBcgMaxAtIndex = -1;
        double dBcgMax = 0.0;
        int i = 0;
        while (i < this._background.getNoOfSteps()) {
            if (dBcgMax < this._background.getIntensity(i)) {
                dBcgMax = this._background.getIntensity(i);
                iBcgMaxAtIndex = i;
            }
            ++i;
        }
        double dBcgMaxAt = this._background.getMin2theta() + (double)iBcgMaxAtIndex * this._background.getStepSize();
        ArrayList alExcludedRanges = this.owner.drawingArea.getAllRanges();
        XRDRangeSelected range = null;
        int i2 = 0;
        while (i2 < alExcludedRanges.size()) {
            range = (XRDRangeSelected)alExcludedRanges.get(i2);
            if (range.getMin2theta() < dBcgMaxAt && range.getMax2theta() > dBcgMaxAt) break;
            range = null;
            ++i2;
        }
        if (range == null) {
            return;
        }
        double[] adIntensities = this._background.getIntensities();
        int iLowIndex = (int)Math.round((range.getMin2theta() - this._background.getMin2theta()) / this._background.getStepSize());
        double dLowIntensity = adIntensities[iLowIndex];
        Arrays.fill(adIntensities, 0, iLowIndex + 1, 0.0);
        int iHighIndex = (int)Math.round((range.getMax2theta() - this._background.getMin2theta()) / this._background.getStepSize());
        double dHighIntensity = adIntensities[iHighIndex];
        Arrays.fill(adIntensities, iHighIndex, adIntensities.length, 0.0);
        double dGradient = (dHighIntensity - dLowIntensity) / (double)(iHighIndex - iLowIndex);
        int i3 = 1;
        while (i3 < iHighIndex - iLowIndex) {
            double dBase = dLowIntensity + (double)i3 * dGradient;
            int n = iLowIndex + i3;
            adIntensities[n] = adIntensities[n] - dBase;
            ++i3;
        }
        double dMaxIntensity = 0.0;
        int i4 = iLowIndex;
        while (i4 < iHighIndex) {
            if (dMaxIntensity < adIntensities[i4]) {
                dMaxIntensity = adIntensities[i4];
            }
            ++i4;
        }
        this._background.setMaxIntensity(dMaxIntensity);
    }

    private void updatePattern() {
        double dMinIntensity = this._pattern.getIntensity(0);
        double dMaxIntensity = 0.0;
        int i = 1;
        while (i < this._pattern.getNoOfSteps()) {
            dMinIntensity = Math.min(dMinIntensity, this._pattern.getIntensity(i));
            dMaxIntensity = Math.max(dMaxIntensity, this._pattern.getIntensity(i));
            ++i;
        }
        if (dMinIntensity < 1.0E-4 && !this._addFlatRadioButton.isSelected()) {
            this.owner.drawingArea.removeDiffractogram(this._background, false);
            this._background = null;
            this.cSlider.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.owner.drawingArea.removeMouseListener(this._bumpBcgListener);
            this.owner.drawingArea.repaint();
            JOptionPane.showMessageDialog(this.owner.frame, "Pattern " + this._pattern.getName() + " has no more background that could be subtracted.", "no background", 0);
        } else {
            if (this._background == null) {
                try {
                    this._background = new UserDiffractogram(this._pattern.getMin2theta(), this._pattern.getMax2theta(), this._pattern.getStepSize());
                    this.owner.drawingArea.addDiffractogram(this._background, false);
                }
                catch (XRDException e) {
                    _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.gui.RemoveBackgroundDialog", "updatePattern", "error in adding background", e);
                }
            }
            Arrays.fill(this._background.getIntensities(), 0.0);
            this._background.setMaxIntensity(0.0);
            this.removeButton.setEnabled(this.removeFlatRadioButton.isSelected() || this._addFlatRadioButton.isSelected());
            this.cSlider.setEnabled(this.removeFlatRadioButton.isSelected() || this._addFlatRadioButton.isSelected());
            if (this.removeFlatRadioButton.isSelected()) {
                this._dBcgMinIntensity = dMinIntensity;
                this.cSlider.setValue(100);
                this.processFlatBackground(false);
                this.owner.drawingArea.removeMouseListener(this._bumpBcgListener);
            } else if (this._addFlatRadioButton.isSelected()) {
                this._dBcgMinIntensity = dMaxIntensity / 10.0;
                this.cSlider.setValue(0);
                this.processFlatBackground(false);
                this.owner.drawingArea.removeMouseListener(this._bumpBcgListener);
            } else {
                this.owner.drawingArea.addMouseListener(this._bumpBcgListener);
            }
            this.owner.drawingArea.repaint();
        }
        this.shiftLeftButton.setEnabled(true);
        this.shiftRightButton.setEnabled(true);
    }

    private void closeAction() {
        this.owner.drawingArea.removeMouseListener(this._bumpBcgListener);
        if (this._background != null) {
            this.owner.drawingArea.removeDiffractogram(this._background, false);
            this.owner.drawingArea.repaint();
            this._background = null;
        }
        if (this.menuStatus != -1) {
            this.owner.setItemsEnabled(this.menuStatus);
        }
        this.owner.backgroundRemoved();
        this.setVisible(false);
    }

    private void processFlatBackground(boolean bRepaint) {
        double dPresentValue = this._dBcgMinIntensity * (double)this.cSlider.getValue() / 100.0;
        Arrays.fill(this._background.getIntensities(), dPresentValue);
        this._background.setMaxIntensity(dPresentValue);
        if (bRepaint) {
            this.owner.drawingArea.repaint();
        }
    }

    public void setAllFonts(Font _f) {
        this.defaultFont = _f;
        this.removeButton.setFont(_f);
        this._undoButton.setFont(_f);
        this.closeButton.setFont(_f);
        this.shiftPanel.setFont(_f);
        this.removeFlatRadioButton.setFont(_f);
        this._addFlatRadioButton.setFont(_f);
        this.removeBumpRadioButton.setFont(_f);
        this.removeExpRadioButton.setFont(_f);
        this.shiftLeftButton.setFont(_f);
        this.shiftRightButton.setFont(_f);
        this.cSlider.setFont(_f);
        this.actionPanel.setFont(_f);
        this.actionNamesPanel.setTitleFont(_f);
        this.cLabel.setFont(_f);
        this.pack();
        this.repaint();
    }

    private class Adapter
    extends MouseAdapter {
        private Adapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            double dX2 = ((RemoveBackgroundDialog)RemoveBackgroundDialog.this).owner.drawingArea.angle2theta(e.getX());
            if (dX2 < RemoveBackgroundDialog.this._pattern.getMin2theta() || dX2 > RemoveBackgroundDialog.this._pattern.getMax2theta()) {
                return;
            }
            double dY2 = ((RemoveBackgroundDialog)RemoveBackgroundDialog.this).owner.drawingArea.intens(e.getY());
            if (dY2 > RemoveBackgroundDialog.this._pattern.getIntensity(dX2) || dY2 < 0.0) {
                return;
            }
            if (RemoveBackgroundDialog.this.removeBumpRadioButton.isSelected()) {
                double dX1 = RemoveBackgroundDialog.this._pattern.getMin2theta();
                double dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1);
                double dB = this.bBump(dX1, dX2, dY1, dY2);
                double dC = this.cBump(dY2);
                double[] adIntensities = RemoveBackgroundDialog.this._background.getIntensities();
                int i = 1;
                while (i < adIntensities.length) {
                    if (!(Math.abs(dX2 - (dX1 += RemoveBackgroundDialog.this._pattern.getStepSize())) < 1.0E-5)) {
                        dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1);
                        double dBcgIntens = Math.exp(-dB * (dX1 - dX2) * (dX1 - dX2) + dC);
                        if (dBcgIntens > dY1) {
                            dB = this.bBump(dX1, dX2, dY1, dY2);
                            dC = this.cBump(dY2);
                        }
                    }
                    ++i;
                }
                dX1 = RemoveBackgroundDialog.this._pattern.getMin2theta();
                if (!(Math.exp(-dB * (dX1 - dX2) * (dX1 - dX2) + dC) >= Math.exp(dC))) {
                    i = 0;
                    while (i < adIntensities.length) {
                        adIntensities[i] = 0.9 * Math.exp(-dB * (dX1 - dX2) * (dX1 - dX2) + dC);
                        dX1 += RemoveBackgroundDialog.this._pattern.getStepSize();
                        ++i;
                    }
                    RemoveBackgroundDialog.this._background.setMaxIntensity(0.9 * Math.exp(dC));
                    RemoveBackgroundDialog.this.updateRestrBumpBcg();
                    RemoveBackgroundDialog.this.removeButton.setEnabled(true);
                }
            } else if (RemoveBackgroundDialog.this.removeExpRadioButton.isSelected()) {
                double dBcgIntens;
                double dX1 = RemoveBackgroundDialog.this._pattern.getMax2theta();
                double dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1);
                double dB = this.bExp(dX1, dX2, dY1, dY2);
                double dC = this.cExp(dX1, dX2, dY1, dY2);
                double[] adIntensities = RemoveBackgroundDialog.this._background.getIntensities();
                int iX2Step = (int)Math.round((dX2 - RemoveBackgroundDialog.this._pattern.getMin2theta()) / RemoveBackgroundDialog.this._pattern.getStepSize());
                int i = adIntensities.length - 1;
                while (i > iX2Step) {
                    dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1);
                    dBcgIntens = Math.exp(dB * dX1 + dC);
                    if (dBcgIntens > dY1) {
                        dB = this.bExp(dX1, dX2, dY1, dY2);
                        dC = this.cExp(dX1, dX2, dY1, dY2);
                    }
                    dX1 -= RemoveBackgroundDialog.this._pattern.getStepSize();
                    --i;
                }
                i = iX2Step;
                while (i > 0) {
                    dY2 = RemoveBackgroundDialog.this._pattern.getIntensity(dX2 -= RemoveBackgroundDialog.this._pattern.getStepSize());
                    dBcgIntens = Math.exp(dB * dX2 + dC);
                    if (dBcgIntens > dY2) {
                        dX1 = RemoveBackgroundDialog.this._pattern.getMax2theta();
                        dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1);
                        dX2 = RemoveBackgroundDialog.this._pattern.getMin2theta();
                        dY2 = RemoveBackgroundDialog.this._pattern.getIntensity(0);
                        dB = this.bExp(dX1, dX2, dY1, dY2);
                        dC = this.cExp(dX1, dX2, dY1, dY2);
                        int j = adIntensities.length - 1;
                        while (j > 0) {
                            dY1 = RemoveBackgroundDialog.this._pattern.getIntensity(dX1 -= RemoveBackgroundDialog.this._pattern.getStepSize());
                            dBcgIntens = Math.exp(dB * dX1 + dC);
                            if (dBcgIntens > dY1) {
                                dB = this.bExp(dX1, dX2, dY1, dY2);
                                dC = this.cExp(dX1, dX2, dY1, dY2);
                            }
                            --j;
                        }
                        break;
                    }
                    --i;
                }
                dX1 = RemoveBackgroundDialog.this._pattern.getMin2theta();
                i = 0;
                while (i < adIntensities.length) {
                    adIntensities[i] = 0.9 * Math.exp(dB * dX1 + dC);
                    dX1 += RemoveBackgroundDialog.this._pattern.getStepSize();
                    ++i;
                }
                RemoveBackgroundDialog.this._background.setMaxIntensity(adIntensities[0]);
                RemoveBackgroundDialog.this.removeButton.setEnabled(true);
            }
        }

        private double bBump(double dX1, double dX2, double dY1, double dY2) {
            return (Math.log(dY2) - Math.log(dY1)) / ((dX1 - dX2) * (dX1 - dX2));
        }

        private double cBump(double dY2) {
            return Math.log(dY2);
        }

        private double bExp(double dX1, double dX2, double dY1, double dY2) {
            return (Math.log(dY1) - Math.log(dY2)) / (dX1 - dX2);
        }

        private double cExp(double dX1, double dX2, double dY1, double dY2) {
            double dLogY1 = Math.log(dY1);
            return dLogY1 - dX1 * (dLogY1 - Math.log(dY2)) / (dX1 - dX2);
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (RemoveBackgroundDialog.this._background == null) {
                return;
            }
            if (RemoveBackgroundDialog.this.removeFlatRadioButton.isSelected() || RemoveBackgroundDialog.this._addFlatRadioButton.isSelected()) {
                RemoveBackgroundDialog.this.processFlatBackground(true);
            } else {
                System.err.println("Unknown source!: " + e.toString());
            }
        }
    }
}

