/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.ndmystko.xrd.mod.gui.CommonSybilla;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class ProbabilityDialog
extends JDialog
implements ActionListener {
    private JTextField _rTextField = null;
    private JTextField _noOfCompTextField = null;
    private Probability _probab = null;
    private Probability _inputProbab = null;
    private LinkedList _llProbabStack = new LinkedList();
    private static final int PROBAB_STACK_LIMIT = 5;
    private ProbabilityDialog _altDialog = null;
    private JTabbedPane _tabs = null;
    private JTextField[][][] _aCondProbabTextField = null;
    private JTextField[][] _aOccurProbabTextField = null;
    private NumberFormat _fourDigitNumberFormatter = null;
    private NumberFormat _twoDigitNumberFormatter = null;
    private int _iTextFieldWidth = 60;
    private int _iTextFieldHeight = 0;
    private JButton _saveButton = null;
    private JButton _recreateButton = null;
    private JButton _closeButton = null;
    private JButton _updateSizeButton = null;
    private JButton[] _updateContentButton = null;
    private JButton[] _revertChangesButton = null;
    private JLabel _w0EquationLabel = null;
    private JLabel _w0EquationValuesLabel = null;
    private JLabel[][] _aPEquationLabel = null;
    private JLabel[][] _aPEquationValuesLabel = null;
    private JLabel[][] _aWEquationLabel = null;
    private JLabel[][] _aWEquationValuesLabel = null;
    private JLabel _orderingLabel = null;
    private Font _labelFont = null;
    private Font _labelValuesFont = null;
    private JPanel paramsPanel;
    private JPanel dataPanel;
    private JPanel buttonPanel;
    private JPanel enclosingOccurPanel;
    private JPanel occurProbabPanel;
    private JPanel lowerButtonPanel;
    private JPanel enclosingCondPanel;
    private JPanel condProbabPanel;
    private JPanel lowerButtonPanelP = null;
    private JFileChooser _saveDialog = null;
    private static final String XML_FILETYPE = "xml";
    private CommonSybilla _owner;
    private int menuStatus = -1;
    private ArrayList _alListener = new ArrayList(2);
    public static final String MODIFIED_AND_VALID_ON_CLOSE = "The matrix has been modified and is valid";
    public static final String INVALID_ON_CLOSE = "The matrix is invalid";
    private Font defaultFont = new Font("sans-serif", 0, 12);

    public ProbabilityDialog(CommonSybilla owner) {
        super(owner.frame);
        this._owner = owner;
        this.setTitle("probability dialog");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProbabilityDialog.this.closeAction(false);
            }
        });
        this._fourDigitNumberFormatter = NumberFormat.getInstance(Locale.US);
        this._fourDigitNumberFormatter.setMinimumFractionDigits(0);
        this._fourDigitNumberFormatter.setMaximumFractionDigits(4);
        this._twoDigitNumberFormatter = NumberFormat.getInstance(Locale.US);
        this._twoDigitNumberFormatter.setMinimumFractionDigits(0);
        this._twoDigitNumberFormatter.setMaximumFractionDigits(2);
        this.paramsPanel = new JPanel();
        this.paramsPanel.setLayout(new BoxLayout(this.paramsPanel, 0));
        this.paramsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel rLabel = new JLabel("R: ");
        rLabel.setAlignmentY(1.0f);
        this.paramsPanel.add(rLabel);
        this._rTextField = new JTextField("2");
        this._iTextFieldHeight = (int)((double)this._rTextField.getFontMetrics(this._rTextField.getFont()).getHeight() * 1.3);
        this._rTextField.setAlignmentY(1.0f);
        this._rTextField.setMaximumSize(new Dimension(this._iTextFieldWidth / 2, this._iTextFieldHeight));
        this._rTextField.setPreferredSize(new Dimension(this._iTextFieldWidth / 2, this._iTextFieldHeight));
        this.paramsPanel.add(this._rTextField);
        this.paramsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        JLabel noOfCompLabel = new JLabel("components: ");
        noOfCompLabel.setAlignmentY(1.0f);
        this.paramsPanel.add(noOfCompLabel);
        this._noOfCompTextField = new JTextField("2");
        this._noOfCompTextField.setAlignmentY(1.0f);
        this._noOfCompTextField.setMaximumSize(new Dimension(this._iTextFieldWidth / 2, this._iTextFieldHeight));
        this._noOfCompTextField.setPreferredSize(new Dimension(this._iTextFieldWidth / 2, this._iTextFieldHeight));
        this.paramsPanel.add(this._noOfCompTextField);
        this.paramsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this._updateSizeButton = new JButton("update");
        this._updateSizeButton.setAlignmentY(1.0f);
        this._updateSizeButton.addActionListener(this);
        this.paramsPanel.add(this._updateSizeButton);
        this.paramsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this._orderingLabel = new JLabel("D2=?");
        this._orderingLabel.setAlignmentY(1.0f);
        this.paramsPanel.add(this._orderingLabel);
        this.paramsPanel.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.paramsPanel, "North");
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dataPanel.setPreferredSize(new Dimension(400, 400));
        this._tabs = new JTabbedPane();
        this.dataPanel.add(this._tabs);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this._saveButton = new JButton("save");
        this._saveButton.addActionListener(this);
        this.buttonPanel.add(this._saveButton);
        this._recreateButton = new JButton("recreate");
        this._recreateButton.addActionListener(this);
        this.buttonPanel.add(this._recreateButton);
        this._closeButton = new JButton("close");
        this._closeButton.addActionListener(this);
        this.buttonPanel.add(this._closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void showUp(int menuStatus, Probability probab, JFileChooser saveDialog, boolean bReadOnly) {
        this.menuStatus = menuStatus;
        this._saveDialog = saveDialog;
        this._probab = probab;
        if (probab != null) {
            this._inputProbab = new Probability(probab.getNoOfComp(), probab.getR());
            probab.copyInto(this._inputProbab);
        } else {
            this._inputProbab = null;
        }
        this._recreateButton.setVisible(this._probab instanceof AbstractProbabCondition);
        this.createSheets(bReadOnly);
        this._updateSizeButton.setEnabled(!bReadOnly);
        this.pack();
        if (this._probab != null && bReadOnly) {
            this._tabs.setSelectedIndex(this._probab.getR() == 0 ? 1 : this._probab.getR() * 2 - 1);
        }
        this.setVisible(true);
    }

    private boolean createSheets(boolean bReadOnly) {
        if (this._probab == null) {
            int iR = 0;
            try {
                iR = Integer.parseInt(this._rTextField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this._owner.frame, "Specified R is non-readable", "wrong R", 0);
                return false;
            }
            if (iR < 0 || iR > 3) {
                JOptionPane.showMessageDialog(this._owner.frame, "R must be in range [0-3]", "wrong R", 0);
                return false;
            }
            int iNoOfComp = 0;
            try {
                iNoOfComp = Integer.parseInt(this._noOfCompTextField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this._owner.frame, "Specified no of components is non-readable", "wrong no of components", 0);
                return false;
            }
            if (iNoOfComp < 2 || iNoOfComp > 4) {
                JOptionPane.showMessageDialog(this._owner.frame, "No of components must be in range [2-4]", "wrong no of components", 0);
                return false;
            }
            this._probab = new Probability(iNoOfComp, iR);
            this._probab.createEquationStrings();
        }
        this._rTextField.setEnabled(!bReadOnly);
        this._noOfCompTextField.setEnabled(!bReadOnly);
        if (bReadOnly) {
            this._rTextField.setText(String.valueOf(this._probab.getR()));
            this._noOfCompTextField.setText(String.valueOf(this._probab.getNoOfComp()));
        }
        this._updateContentButton = new JButton[this._probab.getR() + 1];
        this._revertChangesButton = new JButton[this._probab.getR() + 1];
        this._aCondProbabTextField = new JTextField[this._probab.getR() + 1][][];
        this._aOccurProbabTextField = new JTextField[this._probab.getR() + 2][];
        if (this._probab.getW0EquationString() != null) {
            this._labelFont = new Font("Monospaced", 2, 12);
            this._labelValuesFont = new Font("Monospaced", 2, 10);
            this._aPEquationLabel = new JLabel[this._probab.getR() + 1][];
            this._aPEquationValuesLabel = new JLabel[this._probab.getR() + 1][];
            this._aWEquationLabel = new JLabel[this._probab.getR() + 1][];
            this._aWEquationValuesLabel = new JLabel[this._probab.getR() + 1][];
        }
        this._tabs.removeAll();
        int iRank = 1;
        int iR = 0;
        while (iR < this._probab.getR() + 2) {
            int n;
            Component[] componentArray;
            String sIndicesString;
            JLabel lettersLabel;
            if (iR != 1) {
                iRank *= this._probab.getNoOfComp();
            }
            if (!this.skipW(this._probab.getR(), iR)) {
                Component[] occurParamTextField2;
                this._aOccurProbabTextField[iR] = new JTextField[iRank];
                this.enclosingOccurPanel = new JPanel();
                this.enclosingOccurPanel.setLayout(new BoxLayout(this.enclosingOccurPanel, 1));
                this.enclosingOccurPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.occurProbabPanel = new JPanel(new GridLayout(iRank + 1, iRank, 5, 5));
                this.occurProbabPanel.setMaximumSize(new Dimension(iRank * this._iTextFieldWidth, (iRank + 1) * this._iTextFieldHeight));
                this.occurProbabPanel.setAlignmentX(0.0f);
                this.occurProbabPanel.setAlignmentY(0.0f);
                int iCol = 0;
                while (iCol < iRank) {
                    lettersLabel = new JLabel(this._probab.lettersOutside(iCol, iR));
                    lettersLabel.setAlignmentX(0.0f);
                    lettersLabel.setAlignmentY(1.0f);
                    this.occurProbabPanel.add(lettersLabel);
                    ++iCol;
                }
                int iRow = 0;
                while (iRow < iRank) {
                    int iCol2 = 0;
                    while (iCol2 < iRank) {
                        if (iCol2 != iRow) {
                            this.occurProbabPanel.add(new JLabel(""));
                        } else {
                            String sValue = "?";
                            if (!Double.isNaN(this._probab.getW(iR, iCol2))) {
                                sValue = this._fourDigitNumberFormatter.format(this._probab.getW(iR, iCol2));
                            }
                            occurParamTextField2 = new JTextField(sValue);
                            occurParamTextField2.setEnabled(Double.isNaN(this._probab.getW(iR, iCol2)) && !bReadOnly);
                            occurParamTextField2.setMaximumSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                            occurParamTextField2.setPreferredSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                            occurParamTextField2.setMinimumSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                            occurParamTextField2.setHorizontalAlignment(2);
                            this.occurProbabPanel.add((Component)occurParamTextField2);
                            this._aOccurProbabTextField[iR][iCol2] = occurParamTextField2;
                        }
                        ++iCol2;
                    }
                    ++iRow;
                }
                this.enclosingOccurPanel.add(this.occurProbabPanel);
                if (this._probab.getR() == 0 && iR == 0 || this._probab.getR() > 0 && iR == 1) {
                    this.enclosingOccurPanel.add(Box.createRigidArea(new Dimension(0, 40)));
                    this.lowerButtonPanel = new JPanel();
                    this.lowerButtonPanel.setLayout(new BoxLayout(this.lowerButtonPanel, 0));
                    this.lowerButtonPanel.setAlignmentX(0.0f);
                    this._updateContentButton[0] = new JButton("recalculate");
                    this._updateContentButton[0].addActionListener(this);
                    this._updateContentButton[0].setEnabled(!bReadOnly);
                    this.lowerButtonPanel.add(this._updateContentButton[0]);
                    this.lowerButtonPanel.add(Box.createRigidArea(new Dimension(30, 0)));
                    this._revertChangesButton[0] = new JButton("revert");
                    this._revertChangesButton[0].addActionListener(this);
                    this._revertChangesButton[0].setEnabled(false);
                    this.lowerButtonPanel.add(this._revertChangesButton[0]);
                    this.lowerButtonPanel.add(Box.createHorizontalGlue());
                    this.enclosingOccurPanel.add(this.lowerButtonPanel);
                    occurParamTextField2 = this.lowerButtonPanel.getComponents();
                    int sValue = occurParamTextField2.length;
                    int iCol2 = 0;
                    while (iCol2 < sValue) {
                        Component item = occurParamTextField2[iCol2];
                        item.setFont(this.defaultFont);
                        ++iCol2;
                    }
                }
                if (this._probab.getW0EquationString() != null) {
                    this.enclosingOccurPanel.add(Box.createRigidArea(new Dimension(0, 30)));
                    if (iR == 0) {
                        this._w0EquationLabel = new JLabel(this._probab.getW0EquationString());
                        this._w0EquationLabel.setAlignmentX(0.0f);
                        this._w0EquationLabel.setFont(this._labelFont);
                        this.enclosingOccurPanel.add(this._w0EquationLabel);
                        this._w0EquationValuesLabel = new JLabel("");
                        this._w0EquationValuesLabel.setAlignmentX(0.0f);
                        this._w0EquationValuesLabel.setFont(this._labelValuesFont);
                        this._w0EquationValuesLabel.setForeground(Color.red);
                        this.enclosingOccurPanel.add(this._w0EquationValuesLabel);
                        this.enclosingOccurPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                    } else if (iR < this._probab.getR() + 1) {
                        String[][] aWEquationLabel = this._probab.getWEquationString();
                        int iCount = aWEquationLabel[iR].length;
                        this._aWEquationLabel[iR] = new JLabel[iCount];
                        this._aWEquationValuesLabel[iR] = new JLabel[iCount];
                        int iLab = 0;
                        while (iLab < iCount) {
                            this._aWEquationLabel[iR][iLab] = new JLabel(aWEquationLabel[iR][iLab]);
                            this._aWEquationLabel[iR][iLab].setAlignmentX(0.0f);
                            this._aWEquationLabel[iR][iLab].setFont(this._labelFont);
                            this.enclosingOccurPanel.add(this._aWEquationLabel[iR][iLab]);
                            this._aWEquationValuesLabel[iR][iLab] = new JLabel("");
                            this._aWEquationValuesLabel[iR][iLab].setAlignmentX(0.0f);
                            this._aWEquationValuesLabel[iR][iLab].setFont(this._labelValuesFont);
                            this._aWEquationValuesLabel[iR][iLab].setForeground(Color.red);
                            this.enclosingOccurPanel.add(this._aWEquationValuesLabel[iR][iLab]);
                            ++iLab;
                        }
                        this.enclosingOccurPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                    }
                }
                this.enclosingOccurPanel.add(Box.createVerticalGlue());
                JScrollPane occurProbabScroll = new JScrollPane(this.enclosingOccurPanel, 20, 30);
                sIndicesString = null;
                switch (iR) {
                    case 0: {
                        sIndicesString = "i";
                        break;
                    }
                    case 1: {
                        sIndicesString = "i";
                        break;
                    }
                    case 2: {
                        sIndicesString = "ij";
                        break;
                    }
                    case 3: {
                        sIndicesString = "ijk";
                        break;
                    }
                    case 4: {
                        sIndicesString = "ijkl";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this._tabs.addTab("W" + sIndicesString, occurProbabScroll);
                componentArray = this.enclosingOccurPanel.getComponents();
                n = componentArray.length;
                int occurParamTextField2 = 0;
                while (occurParamTextField2 < n) {
                    Component item = componentArray[occurParamTextField2];
                    item.setFont(this.defaultFont);
                    ++occurParamTextField2;
                }
                componentArray = this.occurProbabPanel.getComponents();
                n = componentArray.length;
                occurParamTextField2 = 0;
                while (occurParamTextField2 < n) {
                    Component item = componentArray[occurParamTextField2];
                    item.setFont(this.defaultFont);
                    ++occurParamTextField2;
                }
            }
            if (!this.skipP(this._probab.getR(), iR)) {
                this._aCondProbabTextField[iR] = new JTextField[iRank][iRank];
                this.enclosingCondPanel = new JPanel();
                this.enclosingCondPanel.setLayout(new BoxLayout(this.enclosingCondPanel, 1));
                this.enclosingCondPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.condProbabPanel = new JPanel(new GridLayout(iRank + 1, iRank + 1, 5, 5));
                this.condProbabPanel.setMaximumSize(new Dimension((iRank + 1) * this._iTextFieldWidth, (iRank + 1) * this._iTextFieldHeight));
                this.condProbabPanel.setAlignmentX(0.0f);
                this.condProbabPanel.setAlignmentY(0.0f);
                this.condProbabPanel.add(new JLabel(""));
                int iCol = 0;
                while (iCol < iRank) {
                    lettersLabel = new JLabel(this._probab.lettersOutside(iCol, iR));
                    lettersLabel.setAlignmentX(0.0f);
                    lettersLabel.setAlignmentY(1.0f);
                    this.condProbabPanel.add(lettersLabel);
                    ++iCol;
                }
                int iRow = 0;
                while (iRow < iRank) {
                    lettersLabel = new JLabel(this._probab.lettersOutside(iRow, iR));
                    lettersLabel.setAlignmentX(1.0f);
                    lettersLabel.setAlignmentY(0.5f);
                    this.condProbabPanel.add(lettersLabel);
                    int iCol3 = 0;
                    while (iCol3 < iRank) {
                        String sValue = "?";
                        if (!Double.isNaN(this._probab.getP(iR, iRow, iCol3))) {
                            sValue = this._fourDigitNumberFormatter.format(this._probab.getP(iR, iRow, iCol3));
                        }
                        JTextField condParamTextField = new JTextField(sValue);
                        condParamTextField.setEnabled(Double.isNaN(this._probab.getP(iR, iRow, iCol3)) && iR > 0 && !bReadOnly);
                        condParamTextField.setMaximumSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                        condParamTextField.setPreferredSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                        condParamTextField.setMinimumSize(new Dimension(this._iTextFieldWidth, this._iTextFieldHeight));
                        condParamTextField.setHorizontalAlignment(2);
                        this.condProbabPanel.add(condParamTextField);
                        this._aCondProbabTextField[iR][iRow][iCol3] = condParamTextField;
                        ++iCol3;
                    }
                    ++iRow;
                }
                this.enclosingCondPanel.add(this.condProbabPanel);
                if (iR > 0) {
                    this.enclosingCondPanel.add(Box.createRigidArea(new Dimension(0, 40)));
                    this.lowerButtonPanelP = new JPanel();
                    this.lowerButtonPanelP.setLayout(new BoxLayout(this.lowerButtonPanelP, 0));
                    this.lowerButtonPanelP.setAlignmentX(0.0f);
                    this._updateContentButton[iR] = new JButton("recalculate");
                    this._updateContentButton[iR].addActionListener(this);
                    this._updateContentButton[iR].setEnabled(!bReadOnly);
                    this.lowerButtonPanelP.add(this._updateContentButton[iR]);
                    this.lowerButtonPanelP.add(Box.createRigidArea(new Dimension(30, 0)));
                    this._revertChangesButton[iR] = new JButton("revert");
                    this._revertChangesButton[iR].addActionListener(this);
                    this._revertChangesButton[iR].setEnabled(false);
                    this.lowerButtonPanelP.add(this._revertChangesButton[iR]);
                    this.lowerButtonPanelP.add(Box.createHorizontalGlue());
                    this.enclosingCondPanel.add(this.lowerButtonPanelP);
                    Component[] componentArray2 = this.lowerButtonPanelP.getComponents();
                    int iCol3 = componentArray2.length;
                    int lettersLabel2 = 0;
                    while (lettersLabel2 < iCol3) {
                        Component item = componentArray2[lettersLabel2];
                        item.setFont(this.defaultFont);
                        ++lettersLabel2;
                    }
                }
                if (this._probab.getW0EquationString() != null && iR > 0) {
                    this.enclosingCondPanel.add(Box.createRigidArea(new Dimension(0, 30)));
                    String[][] aPEquationLabel = this._probab.getPEquationString();
                    int iCount = aPEquationLabel[iR].length;
                    this._aPEquationLabel[iR] = new JLabel[iCount];
                    this._aPEquationValuesLabel[iR] = new JLabel[iCount];
                    int iLab = 0;
                    while (iLab < iCount) {
                        this._aPEquationLabel[iR][iLab] = new JLabel(aPEquationLabel[iR][iLab]);
                        this._aPEquationLabel[iR][iLab].setAlignmentX(0.0f);
                        this._aPEquationLabel[iR][iLab].setFont(this._labelFont);
                        this.enclosingCondPanel.add(this._aPEquationLabel[iR][iLab]);
                        this._aPEquationValuesLabel[iR][iLab] = new JLabel("");
                        this._aPEquationValuesLabel[iR][iLab].setAlignmentX(0.0f);
                        this._aPEquationValuesLabel[iR][iLab].setFont(this._labelValuesFont);
                        this._aPEquationValuesLabel[iR][iLab].setForeground(Color.red);
                        this.enclosingCondPanel.add(this._aPEquationValuesLabel[iR][iLab]);
                        ++iLab;
                    }
                    this.enclosingCondPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                }
                this.enclosingCondPanel.add(Box.createVerticalGlue());
                JScrollPane condProbabScroll = new JScrollPane(this.enclosingCondPanel, 20, 30);
                sIndicesString = null;
                switch (iR) {
                    case 0: {
                        sIndicesString = "ij";
                        break;
                    }
                    case 1: {
                        sIndicesString = "ij";
                        break;
                    }
                    case 2: {
                        sIndicesString = "ijk";
                        break;
                    }
                    case 3: {
                        sIndicesString = "ijkl";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this._tabs.addTab("P" + sIndicesString, condProbabScroll);
                componentArray = this.enclosingCondPanel.getComponents();
                n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component item = componentArray[n2];
                    item.setFont(this.defaultFont);
                    ++n2;
                }
                componentArray = this.condProbabPanel.getComponents();
                n = componentArray.length;
                n2 = 0;
                while (n2 < n) {
                    Component item = componentArray[n2];
                    item.setFont(this.defaultFont);
                    ++n2;
                }
            }
            ++iR;
        }
        this.updateOrderingLabel(this._probab);
        return true;
    }

    public void updateMatrixContent(boolean bReadValuesToMatrix) {
        int iCol;
        int iR;
        int iRank = 1;
        if (bReadValuesToMatrix) {
            int iCol2 = 0;
            while (iCol2 < this._probab.getNoOfComp()) {
                double dW = Double.NaN;
                try {
                    dW = Double.parseDouble(this._aOccurProbabTextField[this._probab.getR() == 0 ? 0 : 1][iCol2].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this._probab.setW(iCol2, dW);
                ++iCol2;
            }
            iR = this._probab.getR();
            while (iR > 0) {
                iRank = (int)Math.pow(this._probab.getNoOfComp(), iR);
                int iRow = 0;
                while (iRow < iRank) {
                    iCol = 0;
                    while (iCol < iRank) {
                        if (this._aCondProbabTextField[iR][iRow][iCol].isEnabled()) {
                            double dP = Double.NaN;
                            try {
                                dP = Double.parseDouble(this._aCondProbabTextField[iR][iRow][iCol].getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            this._probab.setP(iR, iRow, iCol, dP, true);
                        }
                        ++iCol;
                    }
                    ++iRow;
                }
                --iR;
            }
            this._probab.solve(true);
        }
        iRank = 1;
        iR = 0;
        while (iR <= this._probab.getR() + 1) {
            if (iR != 1) {
                iRank *= this._probab.getNoOfComp();
            }
            if (!this.skipW(this._probab.getR(), iR)) {
                int iCol3 = 0;
                while (iCol3 < iRank) {
                    if (Double.isNaN(this._probab.getW(iR, iCol3))) {
                        this._aOccurProbabTextField[iR][iCol3].setText("?");
                    } else {
                        this._aOccurProbabTextField[iR][iCol3].setText(this._fourDigitNumberFormatter.format(this._probab.getW(iR, iCol3)));
                    }
                    ++iCol3;
                }
            }
            ++iR;
        }
        iRank = 1;
        iR = 0;
        while (iR <= this._probab.getR()) {
            if (iR != 1) {
                iRank *= this._probab.getNoOfComp();
            }
            if (!this.skipP(this._probab.getR(), iR)) {
                int iRow = 0;
                while (iRow < iRank) {
                    iCol = 0;
                    while (iCol < iRank) {
                        if (Double.isNaN(this._probab.getP(iR, iRow, iCol))) {
                            this._aCondProbabTextField[iR][iRow][iCol].setText("?");
                        } else {
                            this._aCondProbabTextField[iR][iRow][iCol].setText(this._fourDigitNumberFormatter.format(this._probab.getP(iR, iRow, iCol)));
                        }
                        ++iCol;
                    }
                    ++iRow;
                }
            }
            ++iR;
        }
        if (this._probab.getW0EquationString() != null) {
            if (this._probab.getR() == 0) {
                if (this._probab.isW0Solved()) {
                    this._w0EquationLabel.setForeground(Color.black);
                    this._w0EquationValuesLabel.setText("");
                } else {
                    this._w0EquationLabel.setForeground(Color.red);
                    this._w0EquationValuesLabel.setText(this._probab.getW0EquationValuesString());
                }
            }
            iRank = 1;
            iR = 1;
            while (iR <= this._probab.getR()) {
                iRank *= this._probab.getNoOfComp();
                int iCol4 = 0;
                while (iCol4 < iRank) {
                    if (this._probab.isWEquationSolved(iR, iCol4)) {
                        this._aWEquationLabel[iR][iCol4].setForeground(Color.black);
                        this._aWEquationValuesLabel[iR][iCol4].setText("");
                    } else {
                        this._aWEquationLabel[iR][iCol4].setForeground(Color.red);
                        this._aWEquationValuesLabel[iR][iCol4].setText(this._probab.getWEquationValuesString(iR, iCol4));
                    }
                    if (this._probab.isPEquationSolved(iR, iCol4)) {
                        this._aPEquationLabel[iR][iCol4].setForeground(Color.black);
                        this._aPEquationValuesLabel[iR][iCol4].setText("");
                    } else {
                        this._aPEquationLabel[iR][iCol4].setForeground(Color.red);
                        this._aPEquationValuesLabel[iR][iCol4].setText(this._probab.getPEquationValuesString(iR, iCol4));
                    }
                    ++iCol4;
                }
                ++iR;
            }
        }
        this.updateOrderingLabel(this._probab);
    }

    private void updateOrderingLabel(Probability matrix) {
        Probability.Degree degree = matrix.getDegree();
        assert (Double.isNaN(degree.getD()) || Double.isNaN(degree.getS())) : "Both S and D are present";
        StringBuffer sbLabel = new StringBuffer(10);
        if (!Double.isNaN(degree.getD())) {
            sbLabel.append('D').append(String.valueOf(matrix.getR())).append('=');
            sbLabel.append(this._twoDigitNumberFormatter.format(degree.getD()));
        } else if (!Double.isNaN(degree.getS())) {
            sbLabel.append('S').append(String.valueOf(matrix.getR())).append('=');
            sbLabel.append(this._twoDigitNumberFormatter.format(degree.getS()));
        } else {
            sbLabel.append('D').append(String.valueOf(matrix.getR())).append("=?");
        }
        this._orderingLabel.setText(sbLabel.toString());
    }

    private void updateMatrixSize() {
        Probability tempProbab = this._probab;
        this._probab = null;
        boolean bOK = this.createSheets(false);
        if (bOK) {
            this._tabs.validate();
            this._llProbabStack.clear();
            int i = 0;
            while (i < this._revertChangesButton.length) {
                this._revertChangesButton[i].setEnabled(false);
                ++i;
            }
        } else {
            this._probab = tempProbab;
        }
    }

    private void saveMatrix() {
        int reply;
        File targetFile;
        int returnVal = this._saveDialog.showSaveDialog(this._owner.frame);
        if (returnVal != 0) {
            return;
        }
        File fileToExport = this._saveDialog.getSelectedFile();
        String fileName = fileToExport.getPath();
        if (!fileName.toLowerCase().endsWith(XML_FILETYPE)) {
            fileName = fileName.concat(".xml");
        }
        if ((targetFile = new File(fileName)).exists() && (reply = JOptionPane.showConfirmDialog(this._owner.frame, "File " + fileName + " already exists,\ndo you to overwrite it?", "save probability", 0, 3)) == 1) {
            return;
        }
        Element rootElement = this._probab.serializeXML();
        Document probabModel = new Document(rootElement);
        try {
            XMLOutputter outputter = new XMLOutputter("  ", true);
            FileWriter writer = new FileWriter(targetFile);
            outputter.output(probabModel, (Writer)writer);
            writer.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this._owner.frame, "An error occured when writing file:\n" + ioe.getMessage(), "save probability", 0);
        }
    }

    private void recreateMatrix() {
        assert (this._altDialog == null) : "alt ProbabilityDialog is not null!";
        this._altDialog = new ProbabilityDialog(this._owner);
        this._altDialog._closeButton.setText("accept");
        this._altDialog._rTextField.setText(String.valueOf(this._probab.getR()));
        this._altDialog._noOfCompTextField.setText(String.valueOf(this._probab.getNoOfComp()));
        this._altDialog.setLocation((int)this.getLocation().getX() + 20, (int)this.getLocation().getY() + 20);
        this._altDialog.showUp(-1, null, this._saveDialog, false);
        this._altDialog.setModal(true);
        this._altDialog.addModificationListener(this);
        this._altDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ProbabilityDialog.this._altDialog.dispose();
                ProbabilityDialog.this._altDialog = null;
            }
        });
        this._altDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProbabilityDialog.this._altDialog.dispose();
                ProbabilityDialog.this._altDialog = null;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block25: {
            if (e.getSource() == this._closeButton) {
                this.closeAction(true);
            } else if (e.getSource() == this._saveButton) {
                this.saveMatrix();
            } else if (e.getSource() == this._recreateButton) {
                this.recreateMatrix();
            } else if (e.getSource() == this._updateSizeButton) {
                this.updateMatrixSize();
            } else if (this._altDialog != null && e.getSource() == this._altDialog) {
                if (e.getActionCommand().equals(INVALID_ON_CLOSE)) {
                    JOptionPane.showMessageDialog(this._owner.frame, "Illegal matrix has been ignored.", "incorrect matrix", 0);
                    return;
                }
                assert (e.getActionCommand().equals(MODIFIED_AND_VALID_ON_CLOSE));
                try {
                    boolean bSuccess = ((AbstractProbabCondition)this._probab).setGenesFor(this._altDialog._probab);
                    if (!bSuccess) {
                        JOptionPane.showMessageDialog(this._owner.frame, "Recreated matrix failed", "incorrect matrix", 0);
                        break block25;
                    }
                    this.updateMatrixContent(false);
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(this._owner.frame, iae.getMessage(), "incorrect matrix", 0);
                }
            } else {
                int k;
                Probability probabCopy;
                boolean bEventConsumed = false;
                int i = 0;
                while (i < this._updateContentButton.length) {
                    if (e.getSource() == this._updateContentButton[i]) {
                        probabCopy = new Probability(this._probab.getNoOfComp(), this._probab.getR());
                        this._probab.copyInto(probabCopy);
                        if (this._llProbabStack.size() == 5) {
                            this._llProbabStack.removeFirst();
                        }
                        this._llProbabStack.add(probabCopy);
                        this.updateMatrixContent(true);
                        k = 0;
                        while (k < this._revertChangesButton.length) {
                            this._revertChangesButton[k].setEnabled(true);
                            ++k;
                        }
                        bEventConsumed = true;
                        break;
                    }
                    ++i;
                }
                if (!bEventConsumed) {
                    i = 0;
                    while (i < this._revertChangesButton.length) {
                        if (e.getSource() == this._revertChangesButton[i]) {
                            probabCopy = (Probability)this._llProbabStack.removeLast();
                            probabCopy.copyInto(this._probab);
                            this.updateMatrixContent(false);
                            if (this._llProbabStack.size() == 0) {
                                k = 0;
                                while (k < this._revertChangesButton.length) {
                                    this._revertChangesButton[k].setEnabled(false);
                                    ++k;
                                }
                            }
                            bEventConsumed = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!bEventConsumed) {
                    System.out.println("Caught unknown event: " + e.toString());
                }
            }
        }
    }

    private boolean skipP(int iR, int iCurrR) {
        return iR > 0 && iCurrR == 0 || iCurrR == iR + 1;
    }

    private boolean skipW(int iR, int iCurrR) {
        return iR > 0 && iCurrR == 0 || iR == 0 && iCurrR == iR + 1;
    }

    public void addModificationListener(ActionListener listener) {
        this._alListener.add(listener);
    }

    public void removeModificationListener(ActionListener listener) {
        this._alListener.remove(listener);
    }

    private void closeAction(boolean bFromButton) {
        if (bFromButton && this._probab.verify() && (this._inputProbab == null || !this._probab.matches(this._inputProbab, 0.001))) {
            int i = 0;
            while (i < this._alListener.size()) {
                ((ActionListener)this._alListener.get(i)).actionPerformed(new ActionEvent(this, 1001, MODIFIED_AND_VALID_ON_CLOSE));
                ++i;
            }
        } else if (bFromButton && !this._probab.verify()) {
            int i = 0;
            while (i < this._alListener.size()) {
                ((ActionListener)this._alListener.get(i)).actionPerformed(new ActionEvent(this, 1001, INVALID_ON_CLOSE));
                ++i;
            }
        }
        if (this.menuStatus != -1) {
            this._owner.setItemsEnabled(this.menuStatus);
        }
        this.setVisible(false);
    }

    public void setAllFonts(Font _f) {
        Component item;
        this.defaultFont = _f;
        Component[] componentArray = this.paramsPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = componentArray[n2];
            item.setFont(_f);
            if (item instanceof JTextField) {
                int iTextFieldHeight = (int)((double)this.defaultFont.getSize() * 1.5);
                item.setPreferredSize(new Dimension(50, iTextFieldHeight));
                item.setMinimumSize(new Dimension(50, iTextFieldHeight));
                item.setMaximumSize(new Dimension(50, iTextFieldHeight));
            }
            ++n2;
        }
        componentArray = this.dataPanel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            item = componentArray[n2];
            item.setFont(_f);
            ++n2;
        }
        componentArray = this.buttonPanel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            item = componentArray[n2];
            item.setFont(_f);
            ++n2;
        }
        if (this.enclosingOccurPanel != null) {
            componentArray = this.enclosingOccurPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(this.defaultFont);
                ++n2;
            }
        }
        if (this.occurProbabPanel != null) {
            componentArray = this.occurProbabPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(this.defaultFont);
                ++n2;
            }
        }
        if (this.lowerButtonPanel != null) {
            componentArray = this.lowerButtonPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(_f);
                ++n2;
            }
        }
        if (this.enclosingCondPanel != null) {
            componentArray = this.enclosingCondPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(this.defaultFont);
                ++n2;
            }
        }
        if (this.condProbabPanel != null) {
            componentArray = this.condProbabPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(this.defaultFont);
                ++n2;
            }
        }
        if (this.lowerButtonPanelP != null) {
            componentArray = this.lowerButtonPanelP.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                item = componentArray[n2];
                item.setFont(this.defaultFont);
                ++n2;
            }
        }
        this.pack();
        this.repaint();
    }
}

