/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gene.ModGene;
import net.ndmystko.xrd.mod.gui.CommonSybilla;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.Probability;

public class GenesDialog
extends JDialog
implements ActionListener,
TreeSelectionListener,
ChangeListener {
    private GeneConnector _selectedConn = null;
    private Probability _probab = null;
    private Pattern _adjustedPattern = null;
    private GeneConnector[] _aConnectors = null;
    private ModGene[] _aGenes = null;
    private boolean[] _abActive = null;
    private JTree _tree = null;
    private JScrollPane _rootScrollPane = null;
    private JPanel _mainPanel;
    private JPanel buttonPanel = null;
    private JSlider _minValueSlider = null;
    private JLabel _statMinValueLabel = null;
    private JLabel _minValueLabel = null;
    private JSlider _valueSlider = null;
    private JLabel _statValueLabel = null;
    private JLabel _valueLabel = null;
    private JSlider _maxValueSlider = null;
    private JLabel _statMaxValueLabel = null;
    private JLabel _maxValueLabel = null;
    private JLabel _orderingLabel = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _probabButton = null;
    private JButton _restrictButton = null;
    private JButton _submitButton = null;
    private JCheckBox _activeCB = null;
    protected static final Cursor DEFAULT_CURSOR = new Cursor(0);
    protected static final Cursor WAIT_CURSOR = new Cursor(3);
    private NumberFormat _nfLabelFormatter;
    private NumberFormat _nfSliderFormatter;
    private Font defaultFont = new Font("sans-serif", 0, 12);
    private CommonSybilla _owner;
    private int _menuStatus = -1;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.gui.GenesDialog");

    public GenesDialog(CommonSybilla owner, String sTitle) {
        super(owner.frame);
        this._owner = owner;
        this.setTitle(sTitle);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GenesDialog.this.okAction();
            }
        });
        this._nfLabelFormatter = NumberFormat.getInstance();
        this._nfLabelFormatter.setMinimumFractionDigits(0);
        this._nfLabelFormatter.setMaximumFractionDigits(2);
        this._nfSliderFormatter = NumberFormat.getInstance();
        this._mainPanel = new JPanel(new BorderLayout());
        JPanel slidersPanel = new JPanel();
        slidersPanel.setLayout(new BoxLayout(slidersPanel, 1));
        slidersPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel minLabelPanel = new JPanel();
        minLabelPanel.setLayout(new BoxLayout(minLabelPanel, 0));
        minLabelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        minLabelPanel.setAlignmentX(0.5f);
        this._statMinValueLabel = new JLabel("low limit:");
        minLabelPanel.add(this._statMinValueLabel);
        minLabelPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this._minValueLabel = new JLabel("?");
        minLabelPanel.add(this._minValueLabel);
        slidersPanel.add(minLabelPanel);
        slidersPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this._minValueSlider = new JSlider(0, 0, 100, 0);
        this._minValueSlider.setEnabled(false);
        this._minValueSlider.setPaintLabels(true);
        this._minValueSlider.setAlignmentX(0.5f);
        this._minValueSlider.addChangeListener(this);
        slidersPanel.add(this._minValueSlider);
        slidersPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel valueLabelPanel = new JPanel();
        valueLabelPanel.setLayout(new BoxLayout(valueLabelPanel, 0));
        valueLabelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        valueLabelPanel.setAlignmentX(0.5f);
        this._statValueLabel = new JLabel("gene value:");
        valueLabelPanel.add(this._statValueLabel);
        valueLabelPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this._valueLabel = new JLabel("?");
        valueLabelPanel.add(this._valueLabel);
        slidersPanel.add(valueLabelPanel);
        this._valueSlider = new JSlider(0, 0, 100, 50);
        this._valueSlider.setEnabled(false);
        this._valueSlider.setPaintLabels(true);
        this._valueSlider.setAlignmentX(0.5f);
        this._valueSlider.addChangeListener(this);
        slidersPanel.add(this._valueSlider);
        slidersPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel maxLabelPanel = new JPanel();
        maxLabelPanel.setLayout(new BoxLayout(maxLabelPanel, 0));
        maxLabelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        maxLabelPanel.setAlignmentX(0.5f);
        this._statMaxValueLabel = new JLabel("high limit:");
        maxLabelPanel.add(this._statMaxValueLabel);
        maxLabelPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this._maxValueLabel = new JLabel("?");
        maxLabelPanel.add(this._maxValueLabel);
        slidersPanel.add(maxLabelPanel);
        this._maxValueSlider = new JSlider(0, 0, 100, 100);
        this._maxValueSlider.setEnabled(false);
        this._maxValueSlider.setPaintLabels(true);
        this._maxValueSlider.setAlignmentX(0.5f);
        this._maxValueSlider.addChangeListener(this);
        slidersPanel.add(this._maxValueSlider);
        slidersPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel activePanel = new JPanel();
        activePanel.setLayout(new BoxLayout(activePanel, 0));
        activePanel.setAlignmentX(0.5f);
        this._activeCB = new JCheckBox("active", false);
        this._activeCB.setEnabled(false);
        this._activeCB.setAlignmentY(1.0f);
        this._activeCB.addActionListener(this);
        activePanel.add(this._activeCB);
        activePanel.add(Box.createHorizontalGlue());
        this._orderingLabel = new JLabel("D1=?");
        this._orderingLabel.setAlignmentY(1.0f);
        activePanel.add(this._orderingLabel);
        slidersPanel.add(activePanel);
        this._mainPanel.add((Component)slidersPanel, "South");
        this.getContentPane().add((Component)this._mainPanel, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this._okButton = new JButton("OK");
        this._okButton.addActionListener(this);
        this.buttonPanel.add(this._okButton);
        this._submitButton = new JButton("accept");
        this._submitButton.addActionListener(this);
        this.buttonPanel.add(this._submitButton);
        this._restrictButton = new JButton("restrict");
        this._restrictButton.addActionListener(this);
        this.buttonPanel.add(this._restrictButton);
        this._cancelButton = new JButton("cancel");
        this._cancelButton.addActionListener(this);
        this.buttonPanel.add(this._cancelButton);
        this._probabButton = new JButton("probab");
        this._probabButton.addActionListener(this);
        this.buttonPanel.add(this._probabButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void showUp(int menuStatus, DefaultMutableTreeNode root, Pattern adjustedPattern) {
        this._menuStatus = menuStatus;
        this._adjustedPattern = adjustedPattern;
        this._probabButton.setVisible(adjustedPattern != null);
        if (adjustedPattern != null) {
            Phase[] aPhases = adjustedPattern.getPhases();
            int i = 0;
            while (i < aPhases.length) {
                if (aPhases[i] instanceof MixedLayerPhase) {
                    if (this._probab != null) {
                        this._probab = null;
                        _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.gui.GenesDialog", "showUp", "more than one mixed-layered phase!");
                        break;
                    }
                    this._probab = ((MixedLayerPhase)aPhases[i]).getProbabMatrix();
                }
                ++i;
            }
            this.updateOrderingLabel(this._probab);
        }
        this._tree = new JTree(root);
        this._tree.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        if (this._rootScrollPane != null) {
            this._mainPanel.remove(this._rootScrollPane);
        }
        this._rootScrollPane = new JScrollPane(this._tree, 20, 30);
        this._rootScrollPane.setPreferredSize(new Dimension(400, 350));
        this._rootScrollPane.setFont(this.defaultFont);
        this._mainPanel.add((Component)this._rootScrollPane, "Center");
        this.detachGenes(root);
        this._selectedConn = null;
        this.setSliders(this._selectedConn);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setFont(this.defaultFont);
        this._tree.setCellRenderer(renderer);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node != null) {
            this._selectedConn = node.isLeaf() ? (GeneConnector)node.getUserObject() : null;
            this.setSliders(this._selectedConn);
        }
    }

    private void setSliders(GeneConnector conn) {
        if (conn != null) {
            double dRange = conn.getGene().getFinalHighLimit() - conn.getGene().getFinalLowLimit();
            this._minValueSlider.removeChangeListener(this);
            this._minValueSlider.setValue((int)Math.round((conn.getGene().getLowLimit() - conn.getGene().getFinalLowLimit()) / dRange * 100.0));
            Dictionary<Integer, JComponent> labelTable = this.buildLabels(this._minValueSlider, conn.getGene().getFinalLowLimit(), conn.getGene().getFinalHighLimit());
            this._minValueSlider.setLabelTable(labelTable);
            this._minValueLabel.setText(this._nfLabelFormatter.format(conn.getGene().getLowLimit()));
            this._minValueSlider.addChangeListener(this);
            this._maxValueSlider.removeChangeListener(this);
            this._maxValueSlider.setValue((int)Math.round((conn.getGene().getHighLimit() - conn.getGene().getFinalLowLimit()) / dRange * 100.0));
            this._maxValueSlider.setLabelTable(labelTable);
            this._maxValueLabel.setText(this._nfLabelFormatter.format(conn.getGene().getHighLimit()));
            this._maxValueSlider.addChangeListener(this);
            this._valueSlider.removeChangeListener(this);
            this._valueSlider.setValue((int)Math.round((conn.getGene().getValue() - conn.getGene().getFinalLowLimit()) / dRange * 100.0));
            this._valueSlider.setLabelTable(labelTable);
            this._valueLabel.setText(this._nfLabelFormatter.format(conn.getGene().getValue()));
            this._valueSlider.addChangeListener(this);
        }
        this._minValueSlider.setEnabled(conn != null && conn.isActive());
        this._valueSlider.setEnabled(conn != null && conn.isActive());
        this._maxValueSlider.setEnabled(conn != null && conn.isActive());
        this._activeCB.setEnabled(conn != null);
        this._activeCB.setSelected(conn != null && conn.isActive());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (((JSlider)e.getSource()).getValueIsAdjusting()) {
            return;
        }
        double dNewMinValue = (double)this._minValueSlider.getValue() / 100.0 * (this._selectedConn.getGene().getFinalHighLimit() - this._selectedConn.getGene().getFinalLowLimit()) + this._selectedConn.getGene().getFinalLowLimit();
        this._minValueLabel.setText(this._nfLabelFormatter.format(dNewMinValue));
        double dNewGeneValue = (double)this._valueSlider.getValue() / 100.0 * (this._selectedConn.getGene().getFinalHighLimit() - this._selectedConn.getGene().getFinalLowLimit()) + this._selectedConn.getGene().getFinalLowLimit();
        this._valueLabel.setText(this._nfLabelFormatter.format(dNewGeneValue));
        double dNewMaxValue = (double)this._maxValueSlider.getValue() / 100.0 * (this._selectedConn.getGene().getFinalHighLimit() - this._selectedConn.getGene().getFinalLowLimit()) + this._selectedConn.getGene().getFinalLowLimit();
        this._maxValueLabel.setText(this._nfLabelFormatter.format(dNewMaxValue));
        if (this._minValueSlider.getValue() >= this._maxValueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "Low limit must be less than high limit", "wrong values", 0);
        } else if (this._minValueSlider.getValue() > this._valueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "Low limit cannot be higher than default", "wrong values", 0);
        } else if (this._valueSlider.getValue() < this._minValueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "Default cannot be lower than low limit", "wrong values", 0);
        } else if (this._valueSlider.getValue() > this._maxValueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "Default cannot be higher than high limit", "wrong values", 0);
        } else if (this._maxValueSlider.getValue() <= this._minValueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "High limit must be more than low limit", "wrong values", 0);
        } else if (this._maxValueSlider.getValue() < this._valueSlider.getValue()) {
            JOptionPane.showMessageDialog(this._owner.frame, "High limit cannot be lower than default", "wrong values", 0);
        } else {
            this._selectedConn.getGene().setLimits(dNewMinValue, dNewMaxValue);
            this._selectedConn.getGene().setValue(dNewGeneValue);
            if (this._adjustedPattern != null) {
                this.updatePattern();
            }
        }
        this.updateOrderingLabel(this._probab);
    }

    private void updatePattern() {
        boolean bProbabOK = this._adjustedPattern.calcProbabilities();
        if (this._owner.getProbabilityDialog().isVisible()) {
            this._owner.getProbabilityDialog().updateMatrixContent(false);
        }
        if (bProbabOK) {
            this.setCursor(WAIT_CURSOR);
            this._adjustedPattern.calcIntensities();
            this.setCursor(DEFAULT_CURSOR);
            this._owner.patternModified();
        } else {
            JOptionPane.showMessageDialog(this._owner.frame, "Probability matrix failed", "Probability failed", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.okAction();
        } else if (e.getSource() == this._submitButton) {
            this.submitAction();
        } else if (e.getSource() == this._cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this._probabButton) {
            this.probabAction();
        } else if (e.getSource() == this._restrictButton) {
            this.restrictAction();
        } else if (e.getSource() == this._activeCB) {
            this._selectedConn.setActive(this._activeCB.isSelected());
            this._minValueSlider.setEnabled(this._selectedConn != null && this._activeCB.isSelected());
            this._valueSlider.setEnabled(this._selectedConn != null && this._activeCB.isSelected());
            this._maxValueSlider.setEnabled(this._selectedConn != null && this._activeCB.isSelected());
        } else if (e.getSource() == this._owner.getProbabilityDialog()) {
            if (e.getActionCommand().equals("The matrix is invalid")) {
                JOptionPane.showMessageDialog(this._owner.frame, "Illegal matrix has been ignored.", "incorrect matrix", 0);
            } else {
                assert (e.getActionCommand().equals("The matrix has been modified and is valid"));
                this.probabMatrixRecreated();
            }
        } else {
            System.err.println("Caught unknown event: " + e.toString());
        }
    }

    private void probabMatrixRecreated() {
        this.updatePattern();
        ArrayList alMatrixGenes = new ArrayList();
        ((AbstractProbabCondition)this._probab).addConnectors(alMatrixGenes, false, true);
        int i = 0;
        while (i < alMatrixGenes.size()) {
            if (alMatrixGenes.get(i) == this._selectedConn) {
                this.setSliders(this._selectedConn);
                break;
            }
            ++i;
        }
        this.updateOrderingLabel(this._probab);
    }

    private void okAction() {
        boolean bProbabOK;
        if (this._adjustedPattern != null && !(bProbabOK = this._adjustedPattern.calcProbabilities())) {
            JOptionPane.showMessageDialog(this._owner.frame, "Probability matrix is incorrect, reverting to original values.", "Probability failed", 0);
            this.setCursor(WAIT_CURSOR);
            this.attachGenes();
            boolean bOldProbabOK = this._adjustedPattern.calcProbabilities();
            assert (bOldProbabOK);
            this._adjustedPattern.calcIntensities();
            this.setCursor(DEFAULT_CURSOR);
            this._owner.patternModified();
        }
        this._probab = null;
        this._owner.getProbabilityDialog().removeModificationListener(this);
        if (this._menuStatus != -1) {
            this._owner.setItemsEnabled(this._menuStatus);
        }
        this.setVisible(false);
    }

    private void submitAction() {
        if (this._adjustedPattern != null) {
            boolean bProbabOK = this._adjustedPattern.calcProbabilities();
            if (!bProbabOK) {
                JOptionPane.showMessageDialog(this._owner.frame, "Probability matrix is incorrect, cannot accept this state.", "Probability failed", 0);
            } else {
                this.copyGenes();
            }
        }
    }

    private void cancelAction() {
        if (this._adjustedPattern != null) {
            this.setCursor(WAIT_CURSOR);
            this.attachGenes();
            boolean bOldProbabOK = this._adjustedPattern.calcProbabilities();
            assert (bOldProbabOK);
            this._adjustedPattern.calcIntensities();
            this.setCursor(DEFAULT_CURSOR);
            this._owner.patternModified();
        } else {
            this.attachGenes();
        }
        this._probab = null;
        this._owner.getProbabilityDialog().removeModificationListener(this);
        if (this._menuStatus != -1) {
            this._owner.setItemsEnabled(this._menuStatus);
        }
        this.setVisible(false);
    }

    private void detachGenes(DefaultMutableTreeNode root) {
        ArrayList<Object> alConnectors = new ArrayList<Object>(40);
        Enumeration<TreeNode> elements = root.depthFirstEnumeration();
        while (elements.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)elements.nextElement();
            if (!node.isLeaf()) continue;
            alConnectors.add(node.getUserObject());
        }
        this._aConnectors = new GeneConnector[alConnectors.size()];
        this._aConnectors = alConnectors.toArray(this._aConnectors);
        this._aGenes = new ModGene[this._aConnectors.length];
        this._abActive = new boolean[this._aConnectors.length];
        this.copyGenes();
    }

    private void copyGenes() {
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aGenes[i] = (ModGene)this._aConnectors[i].getGene().clone();
            this._abActive[i] = this._aConnectors[i].isActive();
            ++i;
        }
    }

    private void attachGenes() {
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aConnectors[i].getGene().updateTo(this._aGenes[i]);
            this._aConnectors[i].setActive(this._abActive[i]);
            ++i;
        }
    }

    private void probabAction() {
        Phase[] aPhases = this._adjustedPattern.getPhases();
        boolean bMatrixFound = false;
        int i = 0;
        while (i < aPhases.length) {
            if (aPhases[i] instanceof MixedLayerPhase) {
                bMatrixFound = true;
                this._owner.getProbabilityDialog().showUp(-1, ((MixedLayerPhase)aPhases[i]).getProbabMatrix(), this._owner.getXMLSaveDialog(), true);
                this._owner.getProbabilityDialog().addModificationListener(this);
                break;
            }
            ++i;
        }
        if (!bMatrixFound) {
            JOptionPane.showMessageDialog(this._owner.frame, "Found no matrix...", "Probability missing", 0);
        }
    }

    private void restrictAction() {
        double dDelta = 0.05;
        int i = 0;
        while (i < this._aConnectors.length) {
            ModGene gene = this._aConnectors[i].getGene();
            double dFinalRange = gene.getFinalHighLimit() - gene.getFinalLowLimit();
            double dNewLowLimit = Math.max(gene.getValue() - dFinalRange * dDelta, gene.getFinalLowLimit());
            double dNewHighLimit = Math.min(gene.getValue() + dFinalRange * dDelta, gene.getFinalHighLimit());
            gene.setLimits(dNewLowLimit, dNewHighLimit);
            ++i;
        }
        this.setSliders(this._selectedConn);
    }

    private void updateOrderingLabel(Probability matrix) {
        if (matrix == null) {
            this._orderingLabel.setText("D1=?");
            return;
        }
        Probability.Degree degree = matrix.getDegree();
        assert (Double.isNaN(degree.getD()) || Double.isNaN(degree.getS())) : "Both S and D are present";
        StringBuffer sbLabel = new StringBuffer(10);
        if (!Double.isNaN(degree.getD())) {
            sbLabel.append('D').append(String.valueOf(matrix.getR())).append('=');
            sbLabel.append(this._nfLabelFormatter.format(degree.getD()));
        } else if (!Double.isNaN(degree.getS())) {
            sbLabel.append('S').append(String.valueOf(matrix.getR())).append('=');
            sbLabel.append(this._nfLabelFormatter.format(degree.getS()));
        } else {
            sbLabel.append('D').append(String.valueOf(matrix.getR())).append("=?");
        }
        this._orderingLabel.setText(sbLabel.toString());
    }

    private Dictionary<Integer, JComponent> buildLabels(JSlider slider, double dMin, double dMax) {
        int iLabelPrecision = 2;
        double dLabelStepSize = 0.01;
        FontMetrics fontMetrics = slider.getFontMetrics(slider.getFont());
        do {
            this._nfSliderFormatter.setMinimumFractionDigits(iLabelPrecision);
            this._nfSliderFormatter.setMaximumFractionDigits(iLabelPrecision);
            int iLabelSpread = fontMetrics.stringWidth(this._nfSliderFormatter.format(dMax)) * 2;
            int iDeltaX = (int)(dLabelStepSize / (dMax - dMin) * (double)slider.getWidth());
            if (iDeltaX > iLabelSpread || (iDeltaX = (int)((dLabelStepSize *= 2.0) / (dMax - dMin) * (double)slider.getWidth())) > iLabelSpread || (iDeltaX = (int)((dLabelStepSize *= 2.5) / (dMax - dMin) * (double)slider.getWidth())) > iLabelSpread) break;
            dLabelStepSize *= 2.0;
            if (iLabelPrecision <= 0) continue;
            --iLabelPrecision;
        } while (dLabelStepSize < 1000.0);
        Hashtable<Integer, JComponent> htLabels = new Hashtable<Integer, JComponent>();
        int iStep = (int)(dMin / dLabelStepSize);
        if ((double)iStep * dLabelStepSize < dMin) {
            ++iStep;
        }
        this._nfSliderFormatter.setMinimumFractionDigits(iLabelPrecision);
        this._nfSliderFormatter.setMaximumFractionDigits(iLabelPrecision);
        while ((double)iStep * dLabelStepSize - dMax < 1.0E-9) {
            double dValue = (double)iStep * dLabelStepSize;
            int iSliderValue = (int)Math.round((dValue - dMin) / (dMax - dMin) * 100.0);
            htLabels.put(iSliderValue, new JLabel(this._nfSliderFormatter.format(dValue)));
            ++iStep;
        }
        return htLabels;
    }

    public void setAllFonts(Font _f) {
        Component item;
        this.defaultFont = _f;
        Component[] componentArray = this._mainPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = componentArray[n2];
            item.setFont(_f);
            if (item instanceof Container) {
                Component[] componentArray2 = ((Container)item).getComponents();
                int n3 = componentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component item2 = componentArray2[n4];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        Component[] componentArray3 = ((Container)item2).getComponents();
                        int n5 = componentArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Component item3 = componentArray3[n6];
                            item3.setFont(_f);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (this._tree != null) {
            this._tree.setFont(_f);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setFont(this.defaultFont);
            this._tree.setCellRenderer(renderer);
        }
        this._minValueSlider.setFont(_f);
        this._valueSlider.setFont(_f);
        this._maxValueSlider.setFont(_f);
        componentArray = this.buttonPanel.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            item = componentArray[n2];
            item.setFont(_f);
            ++n2;
        }
        this.pack();
        this.repaint();
    }
}

