/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gui.SybillaManual;
import net.ndmystko.xrd.mod.gui.TaskNamesDialog;
import net.ndmystko.xrd.mod.net.ConnectorManual;
import net.ndmystko.xrd.mod.net.Request;

public class DownloadDialog
extends JDialog
implements ActionListener {
    private SybillaManual _owner;
    private int menuStatus = -1;
    private boolean _bFirstShowUp = true;
    private JPanel listsPanel;
    private JPanel hostPanel;
    private JPanel taskActionPanel;
    private JPanel phaseActionPanel = null;
    private static final Cursor _defaultCursor = new Cursor(0);
    private static final Cursor _waitCursor = new Cursor(3);
    private JList _availableTasksList = null;
    private DefaultListModel _availableTasksModel = null;
    private JList _availablePatternsList = null;
    private DefaultListModel _availablePatternsModel = null;
    private JList _availablePhasesList = null;
    private DefaultListModel _availablePhasesModel = null;
    private JList _selectedPhasesList = null;
    private DefaultListModel _selectedPhasesModel = null;
    private JTextField _hostNameTextField = null;
    private JTextField _hostPortTextField = null;
    private JTextField _tresholdTextField = null;
    private JTextField _quickTresholdTextField = null;
    private TitledBorder titledBorder = null;
    private JButton _helloButton = null;
    private JButton _stopButton = null;
    private JButton _downloadButton = null;
    private JButton _deleteButton = null;
    private JButton _startButton = null;
    private JButton _addPhaseButton = null;
    private JButton _removePhaseButton = null;
    private JButton _grabPhasesButton = null;
    private JButton _saveTaskButton = null;
    private JButton _loadTaskButton = null;
    private JButton _clearTasksButton = null;
    private JButton _okButton = null;
    private TaskNamesDialog _taskNamesDialog = null;
    private AbstractDiffractogram _expPattern = null;
    private AbstractDiffractogram _fitPattern = null;
    private Task _phaseSourceTask = null;
    private AbstractDiffractogram _phaseSourceExpPattern = null;
    private Pattern _phaseSourcePattern = null;
    private ConnectorManual _connectorManual = null;
    private ThreadGroup _connThreadGroup = null;
    private Thread _connManualThread = null;
    private JFileChooser _saveDialog = null;
    private JFileChooser _loadDialog = null;
    private Font defaultFont = new Font("sans-serif", 0, 12);
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.gui.DownloadDialog");

    public DownloadDialog(SybillaManual owner, JFileChooser saveDialog, JFileChooser loadDialog) {
        super(owner.frame);
        this._owner = owner;
        this.setTitle("task downloader");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadDialog.this.okAction();
            }
        });
        this._connThreadGroup = new ThreadGroup("download connectors");
        this._saveDialog = saveDialog;
        this._loadDialog = loadDialog;
        this.listsPanel = new JPanel(new GridLayout(1, 4, 5, 0));
        this.listsPanel.setPreferredSize(new Dimension(600, 200));
        this.listsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel availableTasksPanel = new JPanel();
        availableTasksPanel.setLayout(new BorderLayout());
        availableTasksPanel.add((Component)new JLabel("Available tasks:"), "North");
        this._availableTasksModel = new DefaultListModel();
        this._availableTasksList = new JList(this._availableTasksModel);
        this._availableTasksList.getSelectionModel().setSelectionMode(0);
        this._availableTasksList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadDialog.this.availableTaskSelected(e);
            }
        });
        JScrollPane scrollPaneTasksAvailable = new JScrollPane(this._availableTasksList);
        availableTasksPanel.add((Component)scrollPaneTasksAvailable, "Center");
        this.listsPanel.add(availableTasksPanel);
        JPanel availablePatternsPanel = new JPanel();
        availablePatternsPanel.setLayout(new BorderLayout());
        availablePatternsPanel.add((Component)new JLabel("Available patterns:"), "North");
        this._availablePatternsModel = new DefaultListModel();
        this._availablePatternsList = new JList(this._availablePatternsModel);
        this._availablePatternsList.getSelectionModel().setSelectionMode(1);
        this._availablePatternsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadDialog.this.availablePatternSelected(e);
            }
        });
        JScrollPane scrollPaneAvailablePatterns = new JScrollPane(this._availablePatternsList);
        availablePatternsPanel.add((Component)scrollPaneAvailablePatterns, "Center");
        this.listsPanel.add(availablePatternsPanel);
        JPanel availablePhasesPanel = new JPanel();
        availablePhasesPanel.setLayout(new BorderLayout());
        availablePhasesPanel.add((Component)new JLabel("Available phases:"), "North");
        this._availablePhasesModel = new DefaultListModel();
        this._availablePhasesList = new JList(this._availablePhasesModel);
        this._availablePhasesList.getSelectionModel().setSelectionMode(1);
        this._availablePhasesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadDialog.this.setItemsEnabled(false);
            }
        });
        JScrollPane scrollPanePhasesAvailable = new JScrollPane(this._availablePhasesList);
        availablePhasesPanel.add((Component)scrollPanePhasesAvailable, "Center");
        this.listsPanel.add(availablePhasesPanel);
        JPanel selectedPhasesPanel = new JPanel();
        selectedPhasesPanel.setLayout(new BorderLayout());
        selectedPhasesPanel.add((Component)new JLabel("Selected phases:"), "North");
        this._selectedPhasesModel = new DefaultListModel();
        this._selectedPhasesList = new JList(this._selectedPhasesModel);
        this._selectedPhasesList.getSelectionModel().setSelectionMode(1);
        this._selectedPhasesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadDialog.this.setItemsEnabled(false);
            }
        });
        JScrollPane scrollPanePhasesSelected = new JScrollPane(this._selectedPhasesList);
        selectedPhasesPanel.add((Component)scrollPanePhasesSelected, "Center");
        this.listsPanel.add(selectedPhasesPanel);
        this.getContentPane().add((Component)this.listsPanel, "Center");
        this.hostPanel = new JPanel();
        this.hostPanel.setLayout(new BoxLayout(this.hostPanel, 1));
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.titledBorder = BorderFactory.createTitledBorder("remote Sybilla:");
        this.hostPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, this.titledBorder));
        JPanel hostParamsPanel = new JPanel();
        hostParamsPanel.setLayout(new BoxLayout(hostParamsPanel, 0));
        hostParamsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        hostParamsPanel.setAlignmentX(0.0f);
        JLabel hostNameLabel = new JLabel("host name:");
        hostNameLabel.setAlignmentY(1.0f);
        hostParamsPanel.add(hostNameLabel);
        hostParamsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._hostNameTextField = new JTextField("localhost");
        int iTextFieldHeight = (int)((double)this._hostNameTextField.getFontMetrics(this._hostNameTextField.getFont()).getHeight() * 1.5);
        this._hostNameTextField.setAlignmentY(1.0f);
        this._hostNameTextField.setMaximumSize(new Dimension(200, iTextFieldHeight));
        this._hostNameTextField.setMinimumSize(new Dimension(200, iTextFieldHeight));
        this._hostNameTextField.setPreferredSize(new Dimension(200, iTextFieldHeight));
        hostParamsPanel.add(this._hostNameTextField);
        hostParamsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        JLabel hostPortLabel = new JLabel("host port:");
        hostPortLabel.setAlignmentY(1.0f);
        hostParamsPanel.add(hostPortLabel);
        hostParamsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._hostPortTextField = new JTextField(String.valueOf(8222), 5);
        this._hostPortTextField.setAlignmentY(1.0f);
        this._hostPortTextField.setMaximumSize(new Dimension(60, iTextFieldHeight));
        hostParamsPanel.add(this._hostPortTextField);
        hostParamsPanel.add(Box.createHorizontalGlue());
        this.hostPanel.add(hostParamsPanel);
        this.hostPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel tresholdPanel = new JPanel();
        tresholdPanel.setLayout(new BoxLayout(tresholdPanel, 0));
        tresholdPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tresholdPanel.setAlignmentX(0.0f);
        JLabel tresholdLabel = new JLabel("threshold: ");
        tresholdLabel.setAlignmentY(1.0f);
        tresholdPanel.add(tresholdLabel);
        this._tresholdTextField = new JTextField(String.valueOf(10.5));
        this._tresholdTextField.setAlignmentY(1.0f);
        this._tresholdTextField.setMaximumSize(new Dimension(80, iTextFieldHeight));
        tresholdPanel.add(this._tresholdTextField);
        tresholdPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JLabel quickTresholdLabel = new JLabel("quick threshold: ");
        quickTresholdLabel.setAlignmentY(1.0f);
        tresholdPanel.add(quickTresholdLabel);
        this._quickTresholdTextField = new JTextField(String.valueOf(12.0));
        this._quickTresholdTextField.setAlignmentY(1.0f);
        this._quickTresholdTextField.setMaximumSize(new Dimension(80, iTextFieldHeight));
        tresholdPanel.add(this._quickTresholdTextField);
        tresholdPanel.add(Box.createVerticalGlue());
        this.hostPanel.add(tresholdPanel);
        JPanel hostActionPanel = new JPanel();
        hostActionPanel.setLayout(new BoxLayout(hostActionPanel, 0));
        hostActionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        hostActionPanel.setAlignmentX(0.0f);
        this._helloButton = new JButton("say hello");
        this._helloButton.setAlignmentY(1.0f);
        this._helloButton.addActionListener(this);
        hostActionPanel.add(this._helloButton);
        hostActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._downloadButton = new JButton("download");
        this._downloadButton.setAlignmentY(1.0f);
        this._downloadButton.addActionListener(this);
        hostActionPanel.add(this._downloadButton);
        hostActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._deleteButton = new JButton("delete");
        this._deleteButton.setAlignmentY(1.0f);
        this._deleteButton.addActionListener(this);
        hostActionPanel.add(this._deleteButton);
        hostActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._stopButton = new JButton("stop");
        this._stopButton.setAlignmentY(1.0f);
        this._stopButton.addActionListener(this);
        hostActionPanel.add(this._stopButton);
        hostActionPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this._startButton = new JButton("start");
        this._startButton.setAlignmentY(1.0f);
        this._startButton.addActionListener(this);
        hostActionPanel.add(this._startButton);
        hostActionPanel.add(Box.createHorizontalGlue());
        this.hostPanel.add(hostActionPanel);
        this.getContentPane().add((Component)this.hostPanel, "North");
        this.phaseActionPanel = new JPanel();
        this.phaseActionPanel.setLayout(new BoxLayout(this.phaseActionPanel, 1));
        this.phaseActionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.phaseActionPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this._addPhaseButton = new JButton("add phases");
        this._addPhaseButton.setAlignmentY(0.0f);
        this._addPhaseButton.setAlignmentX(0.0f);
        this._addPhaseButton.addActionListener(this);
        this._addPhaseButton.setEnabled(false);
        this.phaseActionPanel.add(this._addPhaseButton);
        this.phaseActionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._removePhaseButton = new JButton("remove phases");
        this._removePhaseButton.setAlignmentY(0.0f);
        this._removePhaseButton.setAlignmentX(0.0f);
        this._removePhaseButton.addActionListener(this);
        this._removePhaseButton.setEnabled(false);
        this.phaseActionPanel.add(this._removePhaseButton);
        this.phaseActionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._grabPhasesButton = new JButton("grab phases");
        this._grabPhasesButton.setAlignmentY(0.0f);
        this._grabPhasesButton.setAlignmentX(0.0f);
        this._grabPhasesButton.addActionListener(this);
        this._grabPhasesButton.setEnabled(false);
        this.phaseActionPanel.add(this._grabPhasesButton);
        this.phaseActionPanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)this.phaseActionPanel, "East");
        this.taskActionPanel = new JPanel();
        this.taskActionPanel.setLayout(new BoxLayout(this.taskActionPanel, 1));
        this.taskActionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.taskActionPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this._saveTaskButton = new JButton("save task");
        this._saveTaskButton.setAlignmentY(0.0f);
        this._saveTaskButton.setAlignmentX(0.0f);
        this._saveTaskButton.addActionListener(this);
        this._saveTaskButton.setEnabled(false);
        this.taskActionPanel.add(this._saveTaskButton);
        this.taskActionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._loadTaskButton = new JButton("load task");
        this._loadTaskButton.setAlignmentY(0.0f);
        this._loadTaskButton.setAlignmentX(0.0f);
        this._loadTaskButton.addActionListener(this);
        this.taskActionPanel.add(this._loadTaskButton);
        this.taskActionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._clearTasksButton = new JButton("clear tasks");
        this._clearTasksButton.setAlignmentY(0.0f);
        this._clearTasksButton.setAlignmentX(0.0f);
        this._clearTasksButton.setEnabled(false);
        this._clearTasksButton.addActionListener(this);
        this.taskActionPanel.add(this._clearTasksButton);
        this.taskActionPanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)this.taskActionPanel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this._okButton = new JButton("OK");
        this._okButton.addActionListener(this);
        buttonPanel.add(this._okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this._taskNamesDialog = new TaskNamesDialog(this);
        this.pack();
    }

    public void showUp(int menuStatus) {
        this.menuStatus = menuStatus;
        if (this._bFirstShowUp) {
            this._saveDialog.setCurrentDirectory(this._loadDialog.getCurrentDirectory());
            this._bFirstShowUp = false;
        }
        this.setVisible(true);
    }

    private void availableTaskSelected(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Task task = (Task)this._availableTasksList.getSelectedValue();
        if (task != null) {
            this._tresholdTextField.setText(String.valueOf(task.getR2Limit()));
            this._quickTresholdTextField.setText(String.valueOf(task.getQuickR2Limit()));
            this.clear();
            Pattern[] aPatterns = task.getFitPatterns();
            if (aPatterns != null && aPatterns.length > 0) {
                int i = 0;
                while (i < aPatterns.length) {
                    this._availablePatternsModel.addElement(aPatterns[i]);
                    ++i;
                }
            }
            this.setItemsEnabled(false);
        }
    }

    private void availablePatternSelected(ListSelectionEvent e) {
        Task task;
        if (e.getValueIsAdjusting()) {
            return;
        }
        Pattern pattern = (Pattern)this._availablePatternsList.getSelectedValue();
        if (pattern != null) {
            this._availablePhasesModel.clear();
            Phase[] aPhases = pattern.getPhases();
            if (aPhases != null && aPhases.length > 0) {
                int i = 0;
                while (i < aPhases.length) {
                    this._availablePhasesModel.addElement(aPhases[i]);
                    ++i;
                }
            }
            this.setItemsEnabled(true);
        }
        if ((task = (Task)this._availableTasksList.getSelectedValue()) != null) {
            this._tresholdTextField.setText(String.valueOf(task.getR2Limit()));
            this._quickTresholdTextField.setText(String.valueOf(task.getQuickR2Limit()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.okAction();
        } else if (e.getSource() == this._helloButton) {
            this.helloAction();
        } else if (e.getSource() == this._stopButton) {
            this.stopAction();
        } else if (e.getSource() == this._downloadButton) {
            this.downloadAction();
        } else if (e.getSource() == this._deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this._startButton) {
            this.startAction();
        } else if (e.getSource() == this._taskNamesDialog) {
            if (e.getActionCommand().equals("delete")) {
                this.deleteSelectedAction();
            } else if (e.getActionCommand().equals("download")) {
                this.downloadSelectedAction();
            }
        } else if (e.getSource() == this._addPhaseButton) {
            this.addPhaseAction();
        } else if (e.getSource() == this._removePhaseButton) {
            this.removePhaseAction();
        } else if (e.getSource() == this._grabPhasesButton) {
            this.grabPhasesAction();
        } else if (e.getSource() == this._saveTaskButton) {
            this.saveTask();
        } else if (e.getSource() == this._loadTaskButton) {
            this.loadTask();
        } else if (e.getSource() == this._clearTasksButton) {
            this._availableTasksModel.clear();
            this.clear();
            this.setItemsEnabled(false);
        } else if (e.getSource() instanceof ConnectorManual) {
            this.answerReceivedAction(e);
        } else {
            System.out.println("Caught unknown event: " + e.toString());
        }
    }

    private void answerReceivedAction(ActionEvent e) {
        ConnectorManual connManual = (ConnectorManual)e.getSource();
        connManual.disconnectListener();
        if (e.getActionCommand().equals("free")) {
            this._taskNamesDialog.showUp(this, connManual, false);
        } else if (e.getActionCommand().equals("busy")) {
            this._taskNamesDialog.showUp(this, connManual, true);
        } else if (e.getActionCommand().equals("Tasks arrived!")) {
            Task[] aTasks = connManual.getTasks();
            int i = 0;
            while (i < aTasks.length) {
                this._availableTasksModel.addElement(aTasks[i]);
                ++i;
            }
            JOptionPane.showMessageDialog(this._owner.frame, e.getActionCommand(), "remote Sybilla's answer", 1);
        } else {
            JOptionPane.showMessageDialog(this._owner.frame, e.getActionCommand(), "remote Sybilla's answer", 1);
        }
    }

    private void helloAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "helloAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(1);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
        this._taskNamesDialog.setTarget(1);
    }

    private void stopAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "stopAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(4);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void startAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "startAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(3);
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void downloadAction() {
        this._availableTasksModel.clear();
        this.clear();
        this.setItemsEnabled(false);
        this.helloAction();
        this._taskNamesDialog.setTarget(3);
    }

    public void downloadSelectedAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "downloadSelectedAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(5);
            request.setTaskIds(this._taskNamesDialog.getTaskIds());
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void deleteAction() {
        this.helloAction();
        this._taskNamesDialog.setTarget(2);
    }

    public void deleteSelectedAction() {
        Socket socket = this.getSocket();
        if (socket != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "deleteSelectedAction", "Trying to connect with another connector running");
                }
            }
            Request request = new Request(6);
            request.setTaskIds(this._taskNamesDialog.getTaskIds());
            this._connectorManual = new ConnectorManual(this, socket, request);
            this._connManualThread = new Thread(this._connThreadGroup, this._connectorManual);
            this._connManualThread.start();
        }
    }

    private void addPhaseAction() {
        Task currentSourceTask = (Task)this._availableTasksList.getSelectedValue();
        if (currentSourceTask == null) {
            JOptionPane.showMessageDialog(this._owner.frame, "Sybilla cannot recognize source task, you cannot add phases...", "unknown source task", 0);
            return;
        }
        if (this._phaseSourceTask == null) {
            this._phaseSourceTask = currentSourceTask;
        } else if (this._phaseSourceTask != currentSourceTask) {
            JOptionPane.showMessageDialog(this._owner.frame, "You cannot mix phases from different tasks", "wrong source task", 0);
            return;
        }
        Pattern currentSourcePattern = (Pattern)this._availablePatternsList.getSelectedValue();
        if (currentSourcePattern == null) {
            JOptionPane.showMessageDialog(this._owner.frame, "Sybilla cannot recognize source pattern, you cannot add phases...", "unknown source task", 0);
            return;
        }
        if (this._phaseSourcePattern != null) {
            JOptionPane.showMessageDialog(this._owner.frame, "You cannot mix phases from different patterns", "wrong source pattern", 0);
            return;
        }
        this._phaseSourcePattern = currentSourcePattern;
        if (this._phaseSourceExpPattern == null) {
            this._phaseSourceExpPattern = currentSourcePattern.getExpPattern();
        } else if (this._phaseSourceExpPattern != currentSourcePattern.getExpPattern()) {
            JOptionPane.showMessageDialog(this._owner.frame, "You cannot mix phases fitted to different experimental patterns", "wrong source pattern", 0);
            return;
        }
        Object[] aPhases = this._availablePhasesList.getSelectedValues();
        int i = 0;
        while (i < aPhases.length) {
            this._selectedPhasesModel.addElement(aPhases[i]);
            ++i;
        }
        this.setItemsEnabled(false);
    }

    private void removePhaseAction() {
        Object[] aPhases = this._selectedPhasesList.getSelectedValues();
        int i = 0;
        while (i < aPhases.length) {
            this._selectedPhasesModel.removeElement(aPhases[i]);
            ++i;
        }
        if (this._selectedPhasesModel.size() == 0) {
            this._phaseSourceTask = null;
            this._phaseSourceExpPattern = null;
            this._phaseSourcePattern = null;
        }
        this.setItemsEnabled(false);
    }

    private void grabPhasesAction() {
        assert (this.menuStatus == 0);
        if (this._phaseSourceTask == null) {
            JOptionPane.showMessageDialog(this._owner.frame, "Sybilla cannot recognize source task, you cannot add phases...", "unknown source task", 0);
            return;
        }
        if (this._phaseSourcePattern == null) {
            JOptionPane.showMessageDialog(this._owner.frame, "Internal error: don't know which is the source pattern", "unknown pattern", 0);
            return;
        }
        if (this._phaseSourceExpPattern == null) {
            JOptionPane.showMessageDialog(this._owner.frame, "Internal error: don't know which is the source experimental pattern", "unknown exp pattern", 0);
            return;
        }
        Object[] aoPhases = this._selectedPhasesModel.toArray();
        if (aoPhases.length == 0) {
            JOptionPane.showMessageDialog(this._owner.frame, "No phases to be grabbed", "no phases", 0);
            return;
        }
        Phase[] aPhases = new Phase[aoPhases.length];
        int i = 0;
        while (i < aPhases.length) {
            aPhases[i] = (Phase)aoPhases[i];
            ++i;
        }
        aPhases = Phase.duplicatePhases(aPhases);
        boolean bGlobalSigmaStarPresent = this._phaseSourcePattern.isSigmaGenePresent();
        GeneConnector globalSigmaStarConn = bGlobalSigmaStarPresent ? this._phaseSourcePattern.duplicateSigmaStarConn() : null;
        int i2 = 0;
        while (i2 < aPhases.length) {
            assert (aPhases[i2].isSigmaStarGenePresent() ^ bGlobalSigmaStarPresent) : "Inconsistence in sigma-star gene...";
            if (!aPhases[i2].isSigmaStarGenePresent()) {
                aPhases[i2].establishSigmaStarGene(globalSigmaStarConn);
            }
            ++i2;
        }
        int iScriptedISIndex = -1;
        int i3 = 0;
        while (i3 < aPhases.length) {
            if (aPhases[i3].getPhaseType() == 0 || aPhases[i3].getPhaseType() == 1) {
                iScriptedISIndex = i3;
                break;
            }
            ++i3;
        }
        if (this._connectorManual != null) {
            this._connectorManual.disconnectListener();
            this._connectorManual = null;
            if (this._connManualThread.isAlive()) {
                _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "grabPhasesAction", "Grabbing phases when another connector running");
            }
        }
        this.okAction();
        this._owner.drawingArea.setRanges(this._phaseSourceTask.getExcludedRanges());
        this._owner.clearPhases();
        boolean bPatternSet = this._owner.setPattern(this._phaseSourceExpPattern);
        if (bPatternSet) {
            this._owner.phasesSelected(aPhases, this._phaseSourceTask.getPatternParams());
            this._owner.getUploadDialog().setScriptParams(this._phaseSourceTask.getScriptParams());
        }
    }

    private void saveTask() {
        int reply;
        File file;
        Task task = (Task)this._availableTasksList.getSelectedValue();
        if (task == null) {
            return;
        }
        this._saveDialog.setFileFilter(this._owner._remSerFilter);
        this._saveDialog.setSelectedFile(new File(task.toString()));
        int returnVal = this._saveDialog.showSaveDialog(this._owner.frame);
        if (returnVal != 0) {
            return;
        }
        File fileToExport = this._saveDialog.getSelectedFile();
        String sFileName = fileToExport.getPath();
        if (!sFileName.toLowerCase().endsWith(SybillaManual.REMOTE_SER_FILETYPE[0])) {
            sFileName = sFileName.concat(String.valueOf('.') + SybillaManual.REMOTE_SER_FILETYPE[0]);
        }
        if ((file = new File(sFileName)).exists() && (reply = JOptionPane.showConfirmDialog(this._owner.frame, "File " + sFileName + " already exists,\ndo you to overwrite it?", "file exists", 0, 3)) == 1) {
            return;
        }
        this.setCursor(_waitCursor);
        ObjectOutputStream oos = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(task);
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            this.setCursor(_defaultCursor);
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot save task\n" + e.getMessage(), "save error", 0);
        }
        this.setCursor(_defaultCursor);
    }

    private void loadTask() {
        this._loadDialog.setFileFilter(this._owner._remSerFilter);
        int returnVal = this._loadDialog.showOpenDialog(this._owner.frame);
        if (returnVal != 0) {
            return;
        }
        this.setCursor(_waitCursor);
        ObjectInputStream ois = null;
        Task task = null;
        try {
            FileInputStream fis = new FileInputStream(this._loadDialog.getSelectedFile());
            ois = new ObjectInputStream(fis);
            task = (Task)ois.readObject();
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        catch (ClassNotFoundException cnfe) {
            this.setCursor(_defaultCursor);
            JOptionPane.showMessageDialog(this._owner.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
        }
        catch (ClassCastException cce) {
            this.setCursor(_defaultCursor);
            JOptionPane.showMessageDialog(this._owner.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
        }
        catch (InvalidClassException ice) {
            this.setCursor(_defaultCursor);
            JOptionPane.showMessageDialog(this._owner.frame, "This file seems to be incompatible with present version of Sybilla", "incompatible file", 0);
        }
        catch (IOException ioe) {
            this.setCursor(_defaultCursor);
            JOptionPane.showMessageDialog(this._owner.frame, "Following error occurred when reading the file:\n" + ioe.getMessage(), "read error", 0);
        }
        this.setCursor(_defaultCursor);
        if (task != null) {
            if (this._connectorManual != null) {
                this._connectorManual.disconnectListener();
                if (this._connManualThread.isAlive()) {
                    _logger.logp(Level.FINE, "net.ndmystko.xrd.mod.gui.DownloadDialog", "loadTask", "Loading task while connector running");
                }
            }
            this._availableTasksModel.clear();
            this.clear();
            this._availableTasksModel.addElement(task);
            this.setItemsEnabled(false);
        }
    }

    private Socket getSocket() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(this._hostNameTextField.getText());
        }
        catch (UnknownHostException uhe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot find specified host\n" + uhe.getMessage(), "unknown host", 0);
            return null;
        }
        Socket socket = null;
        try {
            socket = new Socket(addr, Integer.parseInt(this._hostPortTextField.getText()));
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Cannot connect\n" + ioe.getMessage(), "network error", 0);
            return null;
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this._owner.frame, "Specified port is non-integer", "wrong port", 0);
            return null;
        }
        return socket;
    }

    private void okAction() {
        this._expPattern = null;
        this._fitPattern = null;
        this._owner.drawingArea.removeAllDiffractograms();
        this._owner.drawingArea.removeAllRanges();
        this._owner.drawingArea.repaint();
        this._owner.setMisfit(Double.NaN);
        if (this.menuStatus != -1) {
            this._owner.setItemsEnabled(this.menuStatus);
        }
        this.setVisible(false);
    }

    private void setItemsEnabled(boolean bChangePreview) {
        if (this._availablePatternsList.getSelectedIndex() > -1) {
            Pattern pattern;
            if (this._expPattern == null) {
                pattern = (Pattern)this._availablePatternsList.getSelectedValue();
                this._expPattern = pattern.getExpPattern();
                this._fitPattern = pattern.getFinalDiffr();
                this._fitPattern.setColor(Color.red);
                try {
                    this._owner.drawingArea.addDiffractogram(this._expPattern, true);
                    this._owner.drawingArea.addDiffractogram(this._fitPattern, true);
                }
                catch (XRDException ex) {
                    JOptionPane.showMessageDialog(this._owner.frame, "Internal error: preview unavailable", "preview", 0);
                }
                this._owner.setMisfit(pattern.getFit());
                this._owner.drawingArea.setRanges(pattern.getExcludedRanges());
                this._owner.drawingArea.repaint();
            } else if (bChangePreview) {
                this._owner.drawingArea.removeAllDiffractograms();
                pattern = (Pattern)this._availablePatternsList.getSelectedValue();
                this._expPattern = pattern.getExpPattern();
                this._fitPattern = pattern.getFinalDiffr();
                this._fitPattern.setColor(Color.red);
                try {
                    this._owner.drawingArea.addDiffractogram(this._expPattern, true);
                    this._owner.drawingArea.addDiffractogram(this._fitPattern, true);
                }
                catch (XRDException ex) {
                    JOptionPane.showMessageDialog(this._owner.frame, "Internal error: preview unavailable", "preview", 0);
                }
                this._owner.setMisfit(pattern.getFit());
                this._owner.drawingArea.removeAllRanges();
                this._owner.drawingArea.setRanges(pattern.getExcludedRanges());
                this._owner.drawingArea.repaint();
            }
        } else if (this._expPattern != null) {
            this._owner.drawingArea.removeAllDiffractograms();
            this._fitPattern = null;
            this._expPattern = null;
            this._owner.drawingArea.repaint();
        }
        boolean bNewOrSameTask = this._phaseSourceTask == null || this._phaseSourceTask == this._availableTasksList.getSelectedValue();
        Pattern selectedPattern = (Pattern)this._availablePatternsList.getSelectedValue();
        boolean bNewOrSameExpPattern = this._phaseSourceExpPattern == null || selectedPattern != null && this._phaseSourceExpPattern == selectedPattern.getExpPattern();
        this._addPhaseButton.setEnabled(!this._availablePhasesList.isSelectionEmpty() && bNewOrSameTask && bNewOrSameExpPattern);
        this._removePhaseButton.setEnabled(!this._selectedPhasesList.isSelectionEmpty());
        this._grabPhasesButton.setEnabled(this._selectedPhasesModel.size() > 0);
        this._saveTaskButton.setEnabled(!this._availableTasksList.isSelectionEmpty());
        this._clearTasksButton.setEnabled(this._availableTasksModel.size() > 0);
    }

    public void setHostName(String sHostName) {
        this._hostNameTextField.setText(sHostName);
    }

    public String getHostName() {
        return this._hostNameTextField.getText();
    }

    private void clear() {
        this._availablePatternsModel.clear();
        this._availablePhasesModel.clear();
        this._selectedPhasesModel.clear();
        this._phaseSourceTask = null;
        this._phaseSourceExpPattern = null;
        this._phaseSourcePattern = null;
    }

    public void setAllFonts(Font _f) {
        Component item2;
        int n;
        int n2;
        Component[] componentArray;
        Component item;
        this.defaultFont = _f;
        this.titledBorder.setTitleFont(this.defaultFont);
        Component[] componentArray2 = this.listsPanel.getComponents();
        int n3 = componentArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            item = componentArray2[n4];
            item.setFont(_f);
            if (item instanceof Container) {
                componentArray = ((Container)item).getComponents();
                n2 = componentArray.length;
                n = 0;
                while (n < n2) {
                    item2 = componentArray[n];
                    item2.setFont(_f);
                    ++n;
                }
            }
            ++n4;
        }
        componentArray2 = this.hostPanel.getComponents();
        n3 = componentArray2.length;
        n4 = 0;
        while (n4 < n3) {
            item = componentArray2[n4];
            item.setFont(_f);
            if (item instanceof Container) {
                componentArray = ((Container)item).getComponents();
                n2 = componentArray.length;
                n = 0;
                while (n < n2) {
                    item2 = componentArray[n];
                    item2.setFont(_f);
                    if (item2 instanceof JTextField) {
                        int iTextFieldHeight = (int)((double)this.defaultFont.getSize() * 1.5);
                        item2.setPreferredSize(new Dimension(200, iTextFieldHeight));
                        item2.setMinimumSize(new Dimension(200, iTextFieldHeight));
                        item2.setMaximumSize(new Dimension(200, iTextFieldHeight));
                    }
                    ++n;
                }
            }
            ++n4;
        }
        componentArray2 = this.taskActionPanel.getComponents();
        n3 = componentArray2.length;
        n4 = 0;
        while (n4 < n3) {
            item = componentArray2[n4];
            item.setFont(_f);
            ++n4;
        }
        componentArray2 = this.phaseActionPanel.getComponents();
        n3 = componentArray2.length;
        n4 = 0;
        while (n4 < n3) {
            item = componentArray2[n4];
            item.setFont(_f);
            ++n4;
        }
        this.pack();
        this.repaint();
    }
}

