/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.mod.SybillaDiffractogram;
import net.ndmystko.xrd.mod.gui.CommonSybilla;

public class AdjustDialog
extends JDialog
implements ChangeListener,
ActionListener {
    private static final int FIRST = 0;
    private int _iSelectedIndex = -1;
    private double _dRefScale = 0.0;
    private double _dRefOffset = 0.0;
    private double _dRefMaxIntensity = 0.0;
    private double _dRefAvgIntensity = 0.0;
    private SybillaDiffractogram[] _aLoadedPatterns = null;
    private JLabel[] _aContentLabel = null;
    private AbstractDiffractogram _previewedPattern = null;
    private UserDiffractogram _totalPattern = null;
    private JButton _closeButton;
    private JButton _restoreButton;
    private JButton _fixIntensityButton;
    private JPanel _patternsPanel;
    private JPanel _actionPanel;
    private JPanel _shiftByPanel;
    private JLabel multiplyLabel;
    private JSlider _multiplySlider;
    private ButtonGroup[] _buttonGroup = new ButtonGroup[1];
    private JRadioButton _scaleRadioButton;
    private JRadioButton _shiftRadioButton;
    private JRadioButton _shiftByIntButton;
    private JRadioButton _shiftByBcgButton;
    private NumberFormat _oneDigitNumberFormatter = null;
    private TitledBorder actionNamesPanel;
    private TitledBorder shiftByNamesPanel;
    private TitledBorder availablePatternsPanel;
    private int _iMenuStatus = -1;
    private Font defaultFont = new Font("sans-serif", 0, 12);
    private CommonSybilla _owner;

    public AdjustDialog(CommonSybilla _owner) {
        super(_owner.frame);
        this._owner = _owner;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdjustDialog.this.closeAction();
            }
        });
        this.setTitle("adjust");
        this._oneDigitNumberFormatter = NumberFormat.getInstance();
        this._oneDigitNumberFormatter.setMinimumFractionDigits(0);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(1);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        Border etchedEBorder = BorderFactory.createEtchedBorder();
        Border emptyEBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        sliderPanel.setBorder(BorderFactory.createCompoundBorder(emptyEBorder, etchedEBorder));
        this.multiplyLabel = new JLabel("Multiply:");
        this.multiplyLabel.setAlignmentX(0.5f);
        sliderPanel.add(this.multiplyLabel);
        sliderPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this._multiplySlider = new JSlider(1, 0, 100, 100);
        this._multiplySlider.setPreferredSize(new Dimension(80, 500));
        this._multiplySlider.setMajorTickSpacing(10);
        this._multiplySlider.setPaintTicks(true);
        this._multiplySlider.setAlignmentX(0.5f);
        sliderPanel.add(this._multiplySlider);
        mainPanel.add(sliderPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this._patternsPanel = new JPanel();
        this._patternsPanel.setLayout(new BoxLayout(this._patternsPanel, 1));
        this._patternsPanel.setAlignmentX(0.0f);
        mainPanel.add(this._patternsPanel);
        this._actionPanel = new JPanel(new GridLayout(1, 0));
        this.actionNamesPanel = BorderFactory.createTitledBorder("choose action");
        this._actionPanel.setBorder(this.actionNamesPanel);
        this._actionPanel.setAlignmentX(0.0f);
        ButtonGroup actionGroup = new ButtonGroup();
        this._scaleRadioButton = new JRadioButton("scale", true);
        this._scaleRadioButton.addActionListener(this);
        actionGroup.add(this._scaleRadioButton);
        this._actionPanel.add(this._scaleRadioButton);
        this._shiftRadioButton = new JRadioButton("shift");
        this._shiftRadioButton.addActionListener(this);
        actionGroup.add(this._shiftRadioButton);
        this._actionPanel.add(this._shiftRadioButton);
        this._shiftByPanel = new JPanel(new GridLayout(1, 0));
        this.shiftByNamesPanel = BorderFactory.createTitledBorder("shift by:");
        this._shiftByPanel.setBorder(this.shiftByNamesPanel);
        this._shiftByPanel.setAlignmentX(0.0f);
        ButtonGroup shiftByGroup = new ButtonGroup();
        this._shiftByIntButton = new JRadioButton("intensity", true);
        this._shiftByIntButton.addActionListener(this);
        shiftByGroup.add(this._shiftByIntButton);
        this._shiftByPanel.add(this._shiftByIntButton);
        this._shiftByBcgButton = new JRadioButton("bcgr.");
        this._shiftByBcgButton.addActionListener(this);
        shiftByGroup.add(this._shiftByBcgButton);
        this._shiftByPanel.add(this._shiftByBcgButton);
        this._fixIntensityButton = new JButton("fix intensity");
        this._fixIntensityButton.setAlignmentX(0.0f);
        this._fixIntensityButton.setEnabled(false);
        this._fixIntensityButton.addActionListener(this);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.availablePatternsPanel = BorderFactory.createTitledBorder("available patterns");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this._closeButton = new JButton("accept");
        this._closeButton.addActionListener(this);
        buttonPanel.add(this._closeButton);
        this._restoreButton = new JButton("restore");
        this._restoreButton.addActionListener(this);
        buttonPanel.add(this._restoreButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void updatePatternNames() {
        this._patternsPanel.removeAll();
        this._patternsPanel.add(this.buildPatternsPanel(0));
        this._patternsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._patternsPanel.add(this._actionPanel);
        this._patternsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._patternsPanel.add(this._shiftByPanel);
        this._patternsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this._patternsPanel.add(this._fixIntensityButton);
        this._patternsPanel.add(Box.createVerticalGlue());
        this._patternsPanel.add(Box.createVerticalGlue());
        this._patternsPanel.add(Box.createVerticalGlue());
        this._patternsPanel.add(Box.createVerticalGlue());
        this._patternsPanel.add(Box.createVerticalGlue());
        this.pack();
    }

    public void showUp(int iMenuStatus, SybillaDiffractogram[] loadedPatterns, UserDiffractogram totalPattern) {
        this._iMenuStatus = iMenuStatus;
        this._aLoadedPatterns = loadedPatterns;
        this._totalPattern = totalPattern;
        this.updatePatternNames();
        this.refreshSlider();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._closeButton) {
            this.closeAction();
        } else if (e.getSource() == this._restoreButton) {
            this.restoreAction();
        } else if (e.getSource() == this._fixIntensityButton) {
            this.fixIntensity();
        } else if (e.getSource().getClass().getName().equals("javax.swing.JRadioButton")) {
            this.refreshSlider();
        } else {
            System.out.println("Unknown event caught: " + e.toString());
        }
    }

    private void refreshSlider() {
        this._iSelectedIndex = this.getSelectedIndex(0);
        this._multiplySlider.removeChangeListener(this);
        this._multiplySlider.setValue(50);
        this._multiplySlider.addChangeListener(this);
        this._multiplySlider.setEnabled(this._iSelectedIndex > -1);
        this._fixIntensityButton.setEnabled(this._iSelectedIndex > -1);
        if (this._previewedPattern != null) {
            this._owner.drawingArea.removeDiffractogram(this._previewedPattern, false);
            this._previewedPattern = null;
        }
        if (this._iSelectedIndex > -1) {
            SybillaDiffractogram selectedPattern = this._aLoadedPatterns[this._iSelectedIndex];
            this._dRefScale = selectedPattern.getScale();
            this._dRefOffset = selectedPattern.getAdjustementOffset();
            this._dRefMaxIntensity = selectedPattern.getMaxIntensity() * this._dRefScale;
            this._dRefAvgIntensity = 0.0;
            int i = 0;
            while (i < selectedPattern.getNoOfSteps()) {
                this._dRefAvgIntensity += selectedPattern.getIntensity(i);
                ++i;
            }
            this._dRefAvgIntensity /= (double)selectedPattern.getNoOfSteps();
            this._dRefAvgIntensity *= this._dRefScale;
            this._previewedPattern = selectedPattern;
            try {
                this._owner.drawingArea.addDiffractogram(this._previewedPattern, false);
            }
            catch (XRDException ex) {
                this._previewedPattern = null;
                JOptionPane.showMessageDialog(this._owner.frame, "Internal error occured: selected pattern cannot be previewed", "internal error", 0);
            }
        }
        this._owner.drawingArea.repaint();
    }

    private void fixIntensity() {
        this._iSelectedIndex = this.getSelectedIndex(0);
        if (this._iSelectedIndex < 0) {
            return;
        }
        SybillaDiffractogram selectedPattern = this._aLoadedPatterns[this._iSelectedIndex];
        double dScale = this._totalPattern.getMaxIntensity() / selectedPattern.getMaxIntensity() * 0.25;
        this._multiplySlider.removeChangeListener(this);
        this._multiplySlider.setValue(50);
        this._multiplySlider.addChangeListener(this);
        double dLSScale = selectedPattern.getScale() - selectedPattern.getAdjustementScale();
        selectedPattern.setScale(dScale);
        selectedPattern.setAdjustementScale(dScale - dLSScale);
        this._dRefScale = dScale;
        this._dRefMaxIntensity = selectedPattern.getMaxIntensity() * this._dRefScale;
        this._dRefAvgIntensity = 0.0;
        int i = 0;
        while (i < selectedPattern.getNoOfSteps()) {
            this._dRefAvgIntensity += selectedPattern.getIntensity(i);
            ++i;
        }
        this._dRefAvgIntensity /= (double)selectedPattern.getNoOfSteps();
        this._dRefAvgIntensity *= this._dRefScale;
        this.updateContents();
        this._owner.patternModified();
        this._owner.drawingArea.repaint();
    }

    private void closeAction() {
        if (this._previewedPattern != null) {
            this._owner.drawingArea.removeDiffractogram(this._previewedPattern, false);
            this._owner.drawingArea.repaint();
            this._previewedPattern = null;
        }
        if (this._iMenuStatus != -1) {
            this._owner.setItemsEnabled(this._iMenuStatus);
        }
        this.setVisible(false);
    }

    private void restoreAction() {
        int i = 0;
        while (i < this._aLoadedPatterns.length) {
            this._aLoadedPatterns[i].setAdjustementOffset(0.0);
            this._aLoadedPatterns[i].setAdjustementScale(0.0);
            ++i;
        }
        if (this._previewedPattern != null) {
            this._owner.drawingArea.removeDiffractogram(this._previewedPattern, false);
            this._previewedPattern = null;
        }
        this._owner.patternModified();
        if (this._iMenuStatus != -1) {
            this._owner.setItemsEnabled(this._iMenuStatus);
        }
        this.setVisible(false);
    }

    private JPanel buildPatternsPanel(int target) {
        JPanel pattNamesPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        pattNamesPanel.setLayout(layout);
        pattNamesPanel.setBorder(this.availablePatternsPanel);
        pattNamesPanel.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 17;
        this._buttonGroup[target] = new ButtonGroup();
        this._aContentLabel = new JLabel[this._aLoadedPatterns.length];
        int i = 0;
        while (i < this._aLoadedPatterns.length) {
            c.gridy = i;
            c.gridx = 0;
            c.ipadx = 0;
            SybillaDiffractogram pattern = this._aLoadedPatterns[i];
            JRadioButton newButton = new JRadioButton(pattern.getName());
            newButton.setFont(this.defaultFont);
            newButton.addActionListener(this);
            newButton.setForeground(pattern.getColor());
            this._buttonGroup[target].add(newButton);
            layout.setConstraints(newButton, c);
            pattNamesPanel.add(newButton);
            c.gridx = 1;
            c.ipadx = 3;
            this._aContentLabel[i] = new JLabel("");
            this._aContentLabel[i].setForeground(pattern.getColor());
            this._aContentLabel[i].setFont(this.defaultFont);
            layout.setConstraints(this._aContentLabel[i], c);
            pattNamesPanel.add(this._aContentLabel[i]);
            ++i;
        }
        pattNamesPanel.setMaximumSize(new Dimension(5000, this._aLoadedPatterns.length * 20));
        this.updateContents();
        return pattNamesPanel;
    }

    private void updateContents() {
        double dTotalScale = 0.0;
        int i = 0;
        while (i < this._aLoadedPatterns.length) {
            dTotalScale += this._aLoadedPatterns[i].getScale();
            ++i;
        }
        i = 0;
        while (i < this._aLoadedPatterns.length) {
            this._aContentLabel[i].setText(String.valueOf(this._oneDigitNumberFormatter.format(this._aLoadedPatterns[i].getScale() / dTotalScale * 100.0)) + '%');
            ++i;
        }
    }

    private int getSelectedIndex(int target) {
        int index = -1;
        int count = 0;
        Enumeration<AbstractButton> buttons = this._buttonGroup[target].getElements();
        while (buttons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)buttons.nextElement();
            if (button.isSelected()) {
                index = count;
                break;
            }
            ++count;
        }
        return index;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this._iSelectedIndex < 0) {
            System.out.println("_iSelectedIndex < 0");
            return;
        }
        JSlider source = (JSlider)e.getSource();
        SybillaDiffractogram pattern = this._aLoadedPatterns[this._iSelectedIndex];
        if (this._scaleRadioButton.isSelected()) {
            double factor = this._dRefScale * (double)source.getValue() / 50.0;
            double dLSScale = pattern.getScale() - pattern.getAdjustementScale();
            pattern.setAdjustementScale(factor - dLSScale);
        } else {
            double slice = 0.0;
            slice = this._shiftByIntButton.isSelected() ? this._dRefOffset + this._dRefMaxIntensity * ((double)source.getValue() - 50.0) / 200.0 : this._dRefOffset + this._dRefAvgIntensity * ((double)source.getValue() - 50.0) / 50.0;
            pattern.setAdjustementOffset(slice);
        }
        this.updateContents();
        this._owner.patternModified();
        this._owner.drawingArea.repaint();
    }

    public void setAllFonts(Font _f) {
        Component item3;
        int n;
        int n2;
        Component[] componentArray;
        Component item2;
        int n3;
        int n4;
        Component[] componentArray2;
        Component item;
        this.defaultFont = _f;
        this.actionNamesPanel.setTitleFont(_f);
        this.shiftByNamesPanel.setTitleFont(_f);
        this.availablePatternsPanel.setTitleFont(_f);
        this.multiplyLabel.setFont(_f);
        Component[] componentArray3 = this._patternsPanel.getComponents();
        int n5 = componentArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            item = componentArray3[n6];
            item.setFont(_f);
            if (item instanceof Container) {
                componentArray2 = ((Container)item).getComponents();
                n4 = componentArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    item2 = componentArray2[n3];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        componentArray = ((Container)item2).getComponents();
                        n2 = componentArray.length;
                        n = 0;
                        while (n < n2) {
                            item3 = componentArray[n];
                            item3.setFont(_f);
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        componentArray3 = this._actionPanel.getComponents();
        n5 = componentArray3.length;
        n6 = 0;
        while (n6 < n5) {
            item = componentArray3[n6];
            item.setFont(_f);
            if (item instanceof Container) {
                componentArray2 = ((Container)item).getComponents();
                n4 = componentArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    item2 = componentArray2[n3];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        componentArray = ((Container)item2).getComponents();
                        n2 = componentArray.length;
                        n = 0;
                        while (n < n2) {
                            item3 = componentArray[n];
                            item3.setFont(_f);
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        componentArray3 = this._shiftByPanel.getComponents();
        n5 = componentArray3.length;
        n6 = 0;
        while (n6 < n5) {
            item = componentArray3[n6];
            item.setFont(_f);
            if (item instanceof Container) {
                componentArray2 = ((Container)item).getComponents();
                n4 = componentArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    item2 = componentArray2[n3];
                    item2.setFont(_f);
                    if (item2 instanceof Container) {
                        componentArray = ((Container)item2).getComponents();
                        n2 = componentArray.length;
                        n = 0;
                        while (n < n2) {
                            item3 = componentArray[n];
                            item3.setFont(_f);
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        this._closeButton.setFont(_f);
        this._restoreButton.setFont(_f);
        this._fixIntensityButton.setFont(_f);
        this.pack();
        this.repaint();
    }
}

