/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class TotalContentGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = -8085014244566005618L;
    private DoubleValue _targetMain = null;
    private DoubleValue _targetSubst = null;

    public TotalContentGene(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue targetMain, DoubleValue targetSubst) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        this._targetMain = targetMain;
        this._targetMain.setGene(true);
        this._targetSubst = targetSubst;
        this._targetSubst.setGene(true);
    }

    @Override
    public void computeVariables() {
        double dTotal = this._targetMain.getValue() + this._targetSubst.getValue();
        double dRatio = this._targetMain.getValue() / dTotal;
        this._targetMain.setValue(this.getGeneValue() * dRatio);
        this._targetSubst.setValue(this.getGeneValue() * (1.0 - dRatio));
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this._targetMain.setGene(bActive || this._targetMain.isGene());
        this._targetSubst.setGene(bActive || this._targetSubst.isGene());
    }
}

