/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelativeContentGeneInterlayerChlorite
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 318574260997761935L;
    private DoubleValue[] _aTargets = null;
    private double[] _adOrigValues = null;
    private double dTotal = 0.0;
    private double interlayerMetalTotal = 6.0;
    private double ohGroupContent = 6.0;

    public RelativeContentGeneInterlayerChlorite(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue[] aTargets, double[] adOrigValues) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        assert (aTargets.length == adOrigValues.length);
        this._aTargets = aTargets;
        this._adOrigValues = new double[aTargets.length];
        int i = 0;
        while (i < aTargets.length) {
            aTargets[i].setGene(true);
            this._adOrigValues[i] = adOrigValues[i] / dDefaultValue;
            this.dTotal += this._adOrigValues[i];
            ++i;
        }
        this.ohGroupContent = this._adOrigValues[0];
        this.interlayerMetalTotal = this._adOrigValues[1] + this._adOrigValues[2];
    }

    @Override
    public void computeVariables() {
        double actualMetalTotal = this.interlayerMetalTotal * this.getGeneValue();
        double metalRatio = this._aTargets[1].getValue() / this.interlayerMetalTotal;
        this._aTargets[1].setValue(actualMetalTotal * metalRatio);
        this._aTargets[2].setValue(actualMetalTotal * (1.0 - metalRatio));
        this._aTargets[0].setValue(this.ohGroupContent * this.getGeneValue());
        this._aTargets[3].setValue(this.ohGroupContent * this.getGeneValue());
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setGene(bActive);
            ++i;
        }
    }
}

