/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.gene.RelativeContentGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelativeContentGeneBasedOnActualContentChloriteInterlayer
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 318574260997761935L;
    private DoubleValue[] _aTargets = null;
    private double[] _adOrigValues = null;
    private RelativeContentGene _relativeContentGene;
    private double dTotal = 0.0;

    public RelativeContentGeneBasedOnActualContentChloriteInterlayer(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue[] aTargets, double[] adOrigValues, RelativeContentGene relativeContentGene) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        this._relativeContentGene = relativeContentGene;
        assert (aTargets.length == adOrigValues.length);
        this._aTargets = aTargets;
        this._adOrigValues = new double[adOrigValues.length];
        int i = 0;
        while (i < aTargets.length) {
            aTargets[i].setGene(true);
            this._adOrigValues[i] = adOrigValues[i];
            this.dTotal += this._adOrigValues[i];
            ++i;
        }
    }

    @Override
    public void computeVariables() {
        double actualTotal = this.dTotal * this.getGeneValue();
        double ratio = this._aTargets[0].getValue() / this.dTotal;
        this._aTargets[0].setValue(actualTotal * ratio * this._relativeContentGene.getGeneValue());
        this._aTargets[1].setValue(actualTotal * (1.0 - ratio) * this._relativeContentGene.getGeneValue());
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setGene(bActive);
            ++i;
        }
    }
}

